<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Produkt StructType
 * Meta information extracted from the WSDL
 * - documentation: Mittlere Ebene der Produkthierarchie gemaess VAA-Modell. Spartenspezifisch abzuleiten.
 * @subpackage Structs
 */
class CT_Produkt extends CT_Produktbaustein
{
    /**
     * The Sparte
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sparte;
    /**
     * The Paket
     * Meta information extracted from the WSDL
     * - documentation: Pakete beschreiben verschiedene Leistungsumfänge. Kalkulatorisch handelt es aber um den gleichen Tarif (z.B. Pauschaldeklarationen Basis, Standard, Plus, usw.).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Paket[]
     */
    public $Paket;
    /**
     * The Kennung
     * Meta information extracted from the WSDL
     * - documentation: Erfolgt die Identifizierung eines Produktes mittels einer technischen Kennung (=technische Bezeichnung des Produkts), MUSS hierfür das Feld Kennung benutzt werden. Erfolgt die Identifizierung durch weiche Merkmale, MUSS die Kennung
     * im Response zurück geliefert werden. Für Tarife, die grundsätzlich über weiche Merkmale ermittelt werden können gilt: ist auf Grund der gelieferten weichen Merkmale keine Identifizierung des Tarifes möglich MUSS eine Fehlermeldung (Meldung
     * 01015) zurückgegeben werden. | Datentyp um die technische Kennung des Produktes als String im Datenmodell abzulegen. Hier dürfen Tarifgenerationen abgelegt werden. Da es sich um einen String handelt werden keine vollständigen Listen von
     * Produktkennungen veröffentlicht.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Kennung;
    /**
     * The Elementarprodukt
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Elementarprodukt[]
     */
    public $Elementarprodukt;
    /**
     * The Dynamik
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Dynamik[]
     */
    public $Dynamik;
    /**
     * The Kuendigungsklausel
     * Meta information extracted from the WSDL
     * - documentation: JA = Explizite Kündigung des Vertrages erforderlichNEIN = Vertrag endet automatisch zum Ablauf (z.B. Bauherrenhaftpflicht). Wird das Attribut nicht geliefert, MUSS es als mit ´Ja` belegt interpretiert werden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Kuendigungsklausel;
    /**
     * The BesondererVerwendungszweck
     * Meta information extracted from the WSDL
     * - documentation: Kennzeichnet Verträge mit einem besonderen Verwendungszweck.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BesondererVerwendungszweck;
    /**
     * The Leistungsausschluss
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Leistungsausschluss[]
     */
    public $Leistungsausschluss;
    /**
     * The VersicherungssummeOderLeistung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_VersicherungssummeOderLeistung[]
     */
    public $VersicherungssummeOderLeistung;
    /**
     * The Selbstbeteiligung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Selbstbeteiligung[]
     */
    public $Selbstbeteiligung;
    /**
     * The Klausel
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Klausel[]
     */
    public $Klausel;
    /**
     * Constructor method for CT_Produkt
     * @uses CT_Produkt::setSparte()
     * @uses CT_Produkt::setPaket()
     * @uses CT_Produkt::setKennung()
     * @uses CT_Produkt::setElementarprodukt()
     * @uses CT_Produkt::setDynamik()
     * @uses CT_Produkt::setKuendigungsklausel()
     * @uses CT_Produkt::setBesondererVerwendungszweck()
     * @uses CT_Produkt::setLeistungsausschluss()
     * @uses CT_Produkt::setVersicherungssummeOderLeistung()
     * @uses CT_Produkt::setSelbstbeteiligung()
     * @uses CT_Produkt::setKlausel()
     * @param string $sparte
     * @param \BiPRO\StructType\STE_Paket[] $paket
     * @param string $kennung
     * @param \BiPRO\StructType\CT_Elementarprodukt[] $elementarprodukt
     * @param \BiPRO\StructType\CT_Dynamik[] $dynamik
     * @param bool $kuendigungsklausel
     * @param string $besondererVerwendungszweck
     * @param \BiPRO\StructType\CT_Leistungsausschluss[] $leistungsausschluss
     * @param \BiPRO\StructType\CT_VersicherungssummeOderLeistung[] $versicherungssummeOderLeistung
     * @param \BiPRO\StructType\CT_Selbstbeteiligung[] $selbstbeteiligung
     * @param \BiPRO\StructType\CT_Klausel[] $klausel
     */
    public function __construct($sparte = null, array $paket = array(), $kennung = null, array $elementarprodukt = array(), array $dynamik = array(), $kuendigungsklausel = null, $besondererVerwendungszweck = null, array $leistungsausschluss = array(), array $versicherungssummeOderLeistung = array(), array $selbstbeteiligung = array(), array $klausel = array())
    {
        $this
            ->setSparte($sparte)
            ->setPaket($paket)
            ->setKennung($kennung)
            ->setElementarprodukt($elementarprodukt)
            ->setDynamik($dynamik)
            ->setKuendigungsklausel($kuendigungsklausel)
            ->setBesondererVerwendungszweck($besondererVerwendungszweck)
            ->setLeistungsausschluss($leistungsausschluss)
            ->setVersicherungssummeOderLeistung($versicherungssummeOderLeistung)
            ->setSelbstbeteiligung($selbstbeteiligung)
            ->setKlausel($klausel);
    }
    /**
     * Get Sparte value
     * @return string|null
     */
    public function getSparte()
    {
        return $this->Sparte;
    }
    /**
     * Set Sparte value
     * @uses \BiPRO\EnumType\ST_Sparte::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Sparte::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sparte
     * @return \BiPRO\StructType\CT_Produkt
     */
    public function setSparte($sparte = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Sparte::valueIsValid($sparte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Sparte', is_array($sparte) ? implode(', ', $sparte) : var_export($sparte, true), implode(', ', \BiPRO\EnumType\ST_Sparte::getValidValues())), __LINE__);
        }
        $this->Sparte = $sparte;
        return $this;
    }
    /**
     * Get Paket value
     * @return \BiPRO\StructType\STE_Paket[]|null
     */
    public function getPaket()
    {
        return $this->Paket;
    }
    /**
     * This method is responsible for validating the values passed to the setPaket method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaket method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaketForArrayConstraintsFromSetPaket(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_ProduktPaketItem) {
            // validation for constraint: itemType
            if (!$cT_ProduktPaketItem instanceof \BiPRO\StructType\STE_Paket) {
                $invalidValues[] = is_object($cT_ProduktPaketItem) ? get_class($cT_ProduktPaketItem) : sprintf('%s(%s)', gettype($cT_ProduktPaketItem), var_export($cT_ProduktPaketItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Paket property can only contain items of type \BiPRO\StructType\STE_Paket, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Paket value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\STE_Paket[] $paket
     * @return \BiPRO\StructType\CT_Produkt
     */
    public function setPaket(array $paket = array())
    {
        // validation for constraint: array
        if ('' !== ($paketArrayErrorMessage = self::validatePaketForArrayConstraintsFromSetPaket($paket))) {
            throw new \InvalidArgumentException($paketArrayErrorMessage, __LINE__);
        }
        $this->Paket = $paket;
        return $this;
    }
    /**
     * Add item to Paket value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\STE_Paket $item
     * @return \BiPRO\StructType\CT_Produkt
     */
    public function addToPaket(\BiPRO\StructType\STE_Paket $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\STE_Paket) {
            throw new \InvalidArgumentException(sprintf('The Paket property can only contain items of type \BiPRO\StructType\STE_Paket, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Paket[] = $item;
        return $this;
    }
    /**
     * Get Kennung value
     * @return string|null
     */
    public function getKennung()
    {
        return $this->Kennung;
    }
    /**
     * Set Kennung value
     * @param string $kennung
     * @return \BiPRO\StructType\CT_Produkt
     */
    public function setKennung($kennung = null)
    {
        // validation for constraint: string
        if (!is_null($kennung) && !is_string($kennung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kennung, true), gettype($kennung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($kennung) && mb_strlen($kennung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($kennung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($kennung) && mb_strlen($kennung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($kennung)), __LINE__);
        }
        $this->Kennung = $kennung;
        return $this;
    }
    /**
     * Get Elementarprodukt value
     * @return \BiPRO\StructType\CT_Elementarprodukt[]|null
     */
    public function getElementarprodukt()
    {
        return $this->Elementarprodukt;
    }
    /**
     * This method is responsible for validating the values passed to the setElementarprodukt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setElementarprodukt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateElementarproduktForArrayConstraintsFromSetElementarprodukt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_ProduktElementarproduktItem) {
            // validation for constraint: itemType
            if (!$cT_ProduktElementarproduktItem instanceof \BiPRO\StructType\CT_Elementarprodukt) {
                $invalidValues[] = is_object($cT_ProduktElementarproduktItem) ? get_class($cT_ProduktElementarproduktItem) : sprintf('%s(%s)', gettype($cT_ProduktElementarproduktItem), var_export($cT_ProduktElementarproduktItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Elementarprodukt property can only contain items of type \BiPRO\StructType\CT_Elementarprodukt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Elementarprodukt value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Elementarprodukt[] $elementarprodukt
     * @return \BiPRO\StructType\CT_Produkt
     */
    public function setElementarprodukt(array $elementarprodukt = array())
    {
        // validation for constraint: array
        if ('' !== ($elementarproduktArrayErrorMessage = self::validateElementarproduktForArrayConstraintsFromSetElementarprodukt($elementarprodukt))) {
            throw new \InvalidArgumentException($elementarproduktArrayErrorMessage, __LINE__);
        }
        $this->Elementarprodukt = $elementarprodukt;
        return $this;
    }
    /**
     * Add item to Elementarprodukt value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Elementarprodukt $item
     * @return \BiPRO\StructType\CT_Produkt
     */
    public function addToElementarprodukt(\BiPRO\StructType\CT_Elementarprodukt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Elementarprodukt) {
            throw new \InvalidArgumentException(sprintf('The Elementarprodukt property can only contain items of type \BiPRO\StructType\CT_Elementarprodukt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Elementarprodukt[] = $item;
        return $this;
    }
    /**
     * Get Dynamik value
     * @return \BiPRO\StructType\CT_Dynamik[]|null
     */
    public function getDynamik()
    {
        return $this->Dynamik;
    }
    /**
     * This method is responsible for validating the values passed to the setDynamik method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDynamik method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDynamikForArrayConstraintsFromSetDynamik(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_ProduktDynamikItem) {
            // validation for constraint: itemType
            if (!$cT_ProduktDynamikItem instanceof \BiPRO\StructType\CT_Dynamik) {
                $invalidValues[] = is_object($cT_ProduktDynamikItem) ? get_class($cT_ProduktDynamikItem) : sprintf('%s(%s)', gettype($cT_ProduktDynamikItem), var_export($cT_ProduktDynamikItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Dynamik property can only contain items of type \BiPRO\StructType\CT_Dynamik, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Dynamik value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Dynamik[] $dynamik
     * @return \BiPRO\StructType\CT_Produkt
     */
    public function setDynamik(array $dynamik = array())
    {
        // validation for constraint: array
        if ('' !== ($dynamikArrayErrorMessage = self::validateDynamikForArrayConstraintsFromSetDynamik($dynamik))) {
            throw new \InvalidArgumentException($dynamikArrayErrorMessage, __LINE__);
        }
        $this->Dynamik = $dynamik;
        return $this;
    }
    /**
     * Add item to Dynamik value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Dynamik $item
     * @return \BiPRO\StructType\CT_Produkt
     */
    public function addToDynamik(\BiPRO\StructType\CT_Dynamik $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Dynamik) {
            throw new \InvalidArgumentException(sprintf('The Dynamik property can only contain items of type \BiPRO\StructType\CT_Dynamik, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Dynamik[] = $item;
        return $this;
    }
    /**
     * Get Kuendigungsklausel value
     * @return bool|null
     */
    public function getKuendigungsklausel()
    {
        return $this->Kuendigungsklausel;
    }
    /**
     * Set Kuendigungsklausel value
     * @param bool $kuendigungsklausel
     * @return \BiPRO\StructType\CT_Produkt
     */
    public function setKuendigungsklausel($kuendigungsklausel = null)
    {
        // validation for constraint: boolean
        if (!is_null($kuendigungsklausel) && !is_bool($kuendigungsklausel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kuendigungsklausel, true), gettype($kuendigungsklausel)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($kuendigungsklausel) && !preg_match('/true|false/', $kuendigungsklausel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($kuendigungsklausel, true)), __LINE__);
        }
        $this->Kuendigungsklausel = $kuendigungsklausel;
        return $this;
    }
    /**
     * Get BesondererVerwendungszweck value
     * @return string|null
     */
    public function getBesondererVerwendungszweck()
    {
        return $this->BesondererVerwendungszweck;
    }
    /**
     * Set BesondererVerwendungszweck value
     * @uses \BiPRO\EnumType\ST_BesondererVerwendungszweck::valueIsValid()
     * @uses \BiPRO\EnumType\ST_BesondererVerwendungszweck::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $besondererVerwendungszweck
     * @return \BiPRO\StructType\CT_Produkt
     */
    public function setBesondererVerwendungszweck($besondererVerwendungszweck = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_BesondererVerwendungszweck::valueIsValid($besondererVerwendungszweck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_BesondererVerwendungszweck', is_array($besondererVerwendungszweck) ? implode(', ', $besondererVerwendungszweck) : var_export($besondererVerwendungszweck, true), implode(', ', \BiPRO\EnumType\ST_BesondererVerwendungszweck::getValidValues())), __LINE__);
        }
        $this->BesondererVerwendungszweck = $besondererVerwendungszweck;
        return $this;
    }
    /**
     * Get Leistungsausschluss value
     * @return \BiPRO\StructType\CT_Leistungsausschluss[]|null
     */
    public function getLeistungsausschluss()
    {
        return $this->Leistungsausschluss;
    }
    /**
     * This method is responsible for validating the values passed to the setLeistungsausschluss method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLeistungsausschluss method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLeistungsausschlussForArrayConstraintsFromSetLeistungsausschluss(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_ProduktLeistungsausschlussItem) {
            // validation for constraint: itemType
            if (!$cT_ProduktLeistungsausschlussItem instanceof \BiPRO\StructType\CT_Leistungsausschluss) {
                $invalidValues[] = is_object($cT_ProduktLeistungsausschlussItem) ? get_class($cT_ProduktLeistungsausschlussItem) : sprintf('%s(%s)', gettype($cT_ProduktLeistungsausschlussItem), var_export($cT_ProduktLeistungsausschlussItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Leistungsausschluss property can only contain items of type \BiPRO\StructType\CT_Leistungsausschluss, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Leistungsausschluss value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Leistungsausschluss[] $leistungsausschluss
     * @return \BiPRO\StructType\CT_Produkt
     */
    public function setLeistungsausschluss(array $leistungsausschluss = array())
    {
        // validation for constraint: array
        if ('' !== ($leistungsausschlussArrayErrorMessage = self::validateLeistungsausschlussForArrayConstraintsFromSetLeistungsausschluss($leistungsausschluss))) {
            throw new \InvalidArgumentException($leistungsausschlussArrayErrorMessage, __LINE__);
        }
        $this->Leistungsausschluss = $leistungsausschluss;
        return $this;
    }
    /**
     * Add item to Leistungsausschluss value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Leistungsausschluss $item
     * @return \BiPRO\StructType\CT_Produkt
     */
    public function addToLeistungsausschluss(\BiPRO\StructType\CT_Leistungsausschluss $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Leistungsausschluss) {
            throw new \InvalidArgumentException(sprintf('The Leistungsausschluss property can only contain items of type \BiPRO\StructType\CT_Leistungsausschluss, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Leistungsausschluss[] = $item;
        return $this;
    }
    /**
     * Get VersicherungssummeOderLeistung value
     * @return \BiPRO\StructType\CT_VersicherungssummeOderLeistung[]|null
     */
    public function getVersicherungssummeOderLeistung()
    {
        return $this->VersicherungssummeOderLeistung;
    }
    /**
     * This method is responsible for validating the values passed to the setVersicherungssummeOderLeistung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVersicherungssummeOderLeistung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVersicherungssummeOderLeistungForArrayConstraintsFromSetVersicherungssummeOderLeistung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_ProduktVersicherungssummeOderLeistungItem) {
            // validation for constraint: itemType
            if (!$cT_ProduktVersicherungssummeOderLeistungItem instanceof \BiPRO\StructType\CT_VersicherungssummeOderLeistung) {
                $invalidValues[] = is_object($cT_ProduktVersicherungssummeOderLeistungItem) ? get_class($cT_ProduktVersicherungssummeOderLeistungItem) : sprintf('%s(%s)', gettype($cT_ProduktVersicherungssummeOderLeistungItem), var_export($cT_ProduktVersicherungssummeOderLeistungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VersicherungssummeOderLeistung property can only contain items of type \BiPRO\StructType\CT_VersicherungssummeOderLeistung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VersicherungssummeOderLeistung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_VersicherungssummeOderLeistung[] $versicherungssummeOderLeistung
     * @return \BiPRO\StructType\CT_Produkt
     */
    public function setVersicherungssummeOderLeistung(array $versicherungssummeOderLeistung = array())
    {
        // validation for constraint: array
        if ('' !== ($versicherungssummeOderLeistungArrayErrorMessage = self::validateVersicherungssummeOderLeistungForArrayConstraintsFromSetVersicherungssummeOderLeistung($versicherungssummeOderLeistung))) {
            throw new \InvalidArgumentException($versicherungssummeOderLeistungArrayErrorMessage, __LINE__);
        }
        $this->VersicherungssummeOderLeistung = $versicherungssummeOderLeistung;
        return $this;
    }
    /**
     * Add item to VersicherungssummeOderLeistung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_VersicherungssummeOderLeistung $item
     * @return \BiPRO\StructType\CT_Produkt
     */
    public function addToVersicherungssummeOderLeistung(\BiPRO\StructType\CT_VersicherungssummeOderLeistung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_VersicherungssummeOderLeistung) {
            throw new \InvalidArgumentException(sprintf('The VersicherungssummeOderLeistung property can only contain items of type \BiPRO\StructType\CT_VersicherungssummeOderLeistung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VersicherungssummeOderLeistung[] = $item;
        return $this;
    }
    /**
     * Get Selbstbeteiligung value
     * @return \BiPRO\StructType\CT_Selbstbeteiligung[]|null
     */
    public function getSelbstbeteiligung()
    {
        return $this->Selbstbeteiligung;
    }
    /**
     * This method is responsible for validating the values passed to the setSelbstbeteiligung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelbstbeteiligung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelbstbeteiligungForArrayConstraintsFromSetSelbstbeteiligung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_ProduktSelbstbeteiligungItem) {
            // validation for constraint: itemType
            if (!$cT_ProduktSelbstbeteiligungItem instanceof \BiPRO\StructType\CT_Selbstbeteiligung) {
                $invalidValues[] = is_object($cT_ProduktSelbstbeteiligungItem) ? get_class($cT_ProduktSelbstbeteiligungItem) : sprintf('%s(%s)', gettype($cT_ProduktSelbstbeteiligungItem), var_export($cT_ProduktSelbstbeteiligungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Selbstbeteiligung property can only contain items of type \BiPRO\StructType\CT_Selbstbeteiligung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Selbstbeteiligung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Selbstbeteiligung[] $selbstbeteiligung
     * @return \BiPRO\StructType\CT_Produkt
     */
    public function setSelbstbeteiligung(array $selbstbeteiligung = array())
    {
        // validation for constraint: array
        if ('' !== ($selbstbeteiligungArrayErrorMessage = self::validateSelbstbeteiligungForArrayConstraintsFromSetSelbstbeteiligung($selbstbeteiligung))) {
            throw new \InvalidArgumentException($selbstbeteiligungArrayErrorMessage, __LINE__);
        }
        $this->Selbstbeteiligung = $selbstbeteiligung;
        return $this;
    }
    /**
     * Add item to Selbstbeteiligung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Selbstbeteiligung $item
     * @return \BiPRO\StructType\CT_Produkt
     */
    public function addToSelbstbeteiligung(\BiPRO\StructType\CT_Selbstbeteiligung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Selbstbeteiligung) {
            throw new \InvalidArgumentException(sprintf('The Selbstbeteiligung property can only contain items of type \BiPRO\StructType\CT_Selbstbeteiligung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Selbstbeteiligung[] = $item;
        return $this;
    }
    /**
     * Get Klausel value
     * @return \BiPRO\StructType\CT_Klausel[]|null
     */
    public function getKlausel()
    {
        return $this->Klausel;
    }
    /**
     * This method is responsible for validating the values passed to the setKlausel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKlausel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKlauselForArrayConstraintsFromSetKlausel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_ProduktKlauselItem) {
            // validation for constraint: itemType
            if (!$cT_ProduktKlauselItem instanceof \BiPRO\StructType\CT_Klausel) {
                $invalidValues[] = is_object($cT_ProduktKlauselItem) ? get_class($cT_ProduktKlauselItem) : sprintf('%s(%s)', gettype($cT_ProduktKlauselItem), var_export($cT_ProduktKlauselItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Klausel property can only contain items of type \BiPRO\StructType\CT_Klausel, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Klausel value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Klausel[] $klausel
     * @return \BiPRO\StructType\CT_Produkt
     */
    public function setKlausel(array $klausel = array())
    {
        // validation for constraint: array
        if ('' !== ($klauselArrayErrorMessage = self::validateKlauselForArrayConstraintsFromSetKlausel($klausel))) {
            throw new \InvalidArgumentException($klauselArrayErrorMessage, __LINE__);
        }
        $this->Klausel = $klausel;
        return $this;
    }
    /**
     * Add item to Klausel value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Klausel $item
     * @return \BiPRO\StructType\CT_Produkt
     */
    public function addToKlausel(\BiPRO\StructType\CT_Klausel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Klausel) {
            throw new \InvalidArgumentException(sprintf('The Klausel property can only contain items of type \BiPRO\StructType\CT_Klausel, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Klausel[] = $item;
        return $this;
    }
}
