<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Polizeibericht StructType
 * Meta information extracted from the WSDL
 * - documentation: Informationen zu einem polizeilich erfassten Sachverhalt.
 * @subpackage Structs
 */
class CT_Polizeibericht extends CT_Objekt
{
    /**
     * The Tagebuchnummer
     * Meta information extracted from the WSDL
     * - documentation: Identifizierende Tagebuchnummer des Polizeiberichts.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Tagebuchnummer;
    /**
     * The RauschmitteluntersuchungDurchgefuehrt
     * Meta information extracted from the WSDL
     * - documentation: JA = Es wurde eine Rauschmitteluntersuchung (Alkohol, Drogen) durchgeführt.NEIN = Es wurde keine Rauschmitteluntersuchung durchgeführt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $RauschmitteluntersuchungDurchgefuehrt;
    /**
     * The BussgeldVerwarnungVerhaengt
     * Meta information extracted from the WSDL
     * - documentation: JA = Es wurde ein Bußgeld und/oder eine Verwarnung verhängt.NEIN = Es wurde kein Bußgeld und keine Verwarnung verhängt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $BussgeldVerwarnungVerhaengt;
    /**
     * The Unfallflucht
     * Meta information extracted from the WSDL
     * - documentation: JA = Es wurde eine Unfallflucht festgestellt.NEIN = Es wurde keine Unfallflucht festgestellt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Unfallflucht;
    /**
     * The Polizeidienststelle
     * Meta information extracted from the WSDL
     * - documentation: Dienststelle der Polizei, die den Polizeibericht erstellt hat.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Polizeidienststelle
     */
    public $Polizeidienststelle;
    /**
     * Constructor method for CT_Polizeibericht
     * @uses CT_Polizeibericht::setTagebuchnummer()
     * @uses CT_Polizeibericht::setRauschmitteluntersuchungDurchgefuehrt()
     * @uses CT_Polizeibericht::setBussgeldVerwarnungVerhaengt()
     * @uses CT_Polizeibericht::setUnfallflucht()
     * @uses CT_Polizeibericht::setPolizeidienststelle()
     * @param string $tagebuchnummer
     * @param bool $rauschmitteluntersuchungDurchgefuehrt
     * @param bool $bussgeldVerwarnungVerhaengt
     * @param bool $unfallflucht
     * @param \BiPRO\StructType\CT_Polizeidienststelle $polizeidienststelle
     */
    public function __construct($tagebuchnummer = null, $rauschmitteluntersuchungDurchgefuehrt = null, $bussgeldVerwarnungVerhaengt = null, $unfallflucht = null, \BiPRO\StructType\CT_Polizeidienststelle $polizeidienststelle = null)
    {
        $this
            ->setTagebuchnummer($tagebuchnummer)
            ->setRauschmitteluntersuchungDurchgefuehrt($rauschmitteluntersuchungDurchgefuehrt)
            ->setBussgeldVerwarnungVerhaengt($bussgeldVerwarnungVerhaengt)
            ->setUnfallflucht($unfallflucht)
            ->setPolizeidienststelle($polizeidienststelle);
    }
    /**
     * Get Tagebuchnummer value
     * @return string|null
     */
    public function getTagebuchnummer()
    {
        return $this->Tagebuchnummer;
    }
    /**
     * Set Tagebuchnummer value
     * @param string $tagebuchnummer
     * @return \BiPRO\StructType\CT_Polizeibericht
     */
    public function setTagebuchnummer($tagebuchnummer = null)
    {
        // validation for constraint: string
        if (!is_null($tagebuchnummer) && !is_string($tagebuchnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tagebuchnummer, true), gettype($tagebuchnummer)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($tagebuchnummer) && mb_strlen($tagebuchnummer) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($tagebuchnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($tagebuchnummer) && mb_strlen($tagebuchnummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($tagebuchnummer)), __LINE__);
        }
        $this->Tagebuchnummer = $tagebuchnummer;
        return $this;
    }
    /**
     * Get RauschmitteluntersuchungDurchgefuehrt value
     * @return bool|null
     */
    public function getRauschmitteluntersuchungDurchgefuehrt()
    {
        return $this->RauschmitteluntersuchungDurchgefuehrt;
    }
    /**
     * Set RauschmitteluntersuchungDurchgefuehrt value
     * @param bool $rauschmitteluntersuchungDurchgefuehrt
     * @return \BiPRO\StructType\CT_Polizeibericht
     */
    public function setRauschmitteluntersuchungDurchgefuehrt($rauschmitteluntersuchungDurchgefuehrt = null)
    {
        // validation for constraint: boolean
        if (!is_null($rauschmitteluntersuchungDurchgefuehrt) && !is_bool($rauschmitteluntersuchungDurchgefuehrt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rauschmitteluntersuchungDurchgefuehrt, true), gettype($rauschmitteluntersuchungDurchgefuehrt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($rauschmitteluntersuchungDurchgefuehrt) && !preg_match('/true|false/', $rauschmitteluntersuchungDurchgefuehrt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($rauschmitteluntersuchungDurchgefuehrt, true)), __LINE__);
        }
        $this->RauschmitteluntersuchungDurchgefuehrt = $rauschmitteluntersuchungDurchgefuehrt;
        return $this;
    }
    /**
     * Get BussgeldVerwarnungVerhaengt value
     * @return bool|null
     */
    public function getBussgeldVerwarnungVerhaengt()
    {
        return $this->BussgeldVerwarnungVerhaengt;
    }
    /**
     * Set BussgeldVerwarnungVerhaengt value
     * @param bool $bussgeldVerwarnungVerhaengt
     * @return \BiPRO\StructType\CT_Polizeibericht
     */
    public function setBussgeldVerwarnungVerhaengt($bussgeldVerwarnungVerhaengt = null)
    {
        // validation for constraint: boolean
        if (!is_null($bussgeldVerwarnungVerhaengt) && !is_bool($bussgeldVerwarnungVerhaengt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bussgeldVerwarnungVerhaengt, true), gettype($bussgeldVerwarnungVerhaengt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($bussgeldVerwarnungVerhaengt) && !preg_match('/true|false/', $bussgeldVerwarnungVerhaengt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($bussgeldVerwarnungVerhaengt, true)), __LINE__);
        }
        $this->BussgeldVerwarnungVerhaengt = $bussgeldVerwarnungVerhaengt;
        return $this;
    }
    /**
     * Get Unfallflucht value
     * @return bool|null
     */
    public function getUnfallflucht()
    {
        return $this->Unfallflucht;
    }
    /**
     * Set Unfallflucht value
     * @param bool $unfallflucht
     * @return \BiPRO\StructType\CT_Polizeibericht
     */
    public function setUnfallflucht($unfallflucht = null)
    {
        // validation for constraint: boolean
        if (!is_null($unfallflucht) && !is_bool($unfallflucht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unfallflucht, true), gettype($unfallflucht)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($unfallflucht) && !preg_match('/true|false/', $unfallflucht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($unfallflucht, true)), __LINE__);
        }
        $this->Unfallflucht = $unfallflucht;
        return $this;
    }
    /**
     * Get Polizeidienststelle value
     * @return \BiPRO\StructType\CT_Polizeidienststelle|null
     */
    public function getPolizeidienststelle()
    {
        return $this->Polizeidienststelle;
    }
    /**
     * Set Polizeidienststelle value
     * @param \BiPRO\StructType\CT_Polizeidienststelle $polizeidienststelle
     * @return \BiPRO\StructType\CT_Polizeibericht
     */
    public function setPolizeidienststelle(\BiPRO\StructType\CT_Polizeidienststelle $polizeidienststelle = null)
    {
        $this->Polizeidienststelle = $polizeidienststelle;
        return $this;
    }
}
