<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Personengruppenrolle StructType
 * Meta information extracted from the WSDL
 * - documentation: Die Rolle der Personengruppe innerhalb eines konkreten Kontexts innerhalb der Nachricht. Alle Personengruppen werden innerhalb einer Liste unterhalb des Wurzelelements der Nachricht (i.d.R. abgeleitet von Geschaeftsvorgang)
 * uebertragen und aus dem jeweiligen Kontext, aus dem sie benoetigt werden, mit Hilfe einer von diesem Datentypen abgeleiteten Rolle referenziert.Hierfuer enthaelt Partnerrolle ein Attribut von Typ ST_ID, dessen Wert mit dem Wert des Attributs
 * PersonengruppenID (ebenfalls vom Typ ST_ID) einer in der oben angesprochenen Liste enthaltenen Personengruppe uebereinstimmen muss.
 * @subpackage Structs
 */
abstract class CT_Personengruppenrolle extends CT_Objekt
{
    /**
     * The PersonengruppenID
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige Referenz auf eine Personengruppe in der Personengruppenliste. | Typ fuer alle IDs.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $PersonengruppenID;
    /**
     * Constructor method for CT_Personengruppenrolle
     * @uses CT_Personengruppenrolle::setPersonengruppenID()
     * @param string $personengruppenID
     */
    public function __construct($personengruppenID = null)
    {
        $this
            ->setPersonengruppenID($personengruppenID);
    }
    /**
     * Get PersonengruppenID value
     * @return string
     */
    public function getPersonengruppenID()
    {
        return $this->PersonengruppenID;
    }
    /**
     * Set PersonengruppenID value
     * @param string $personengruppenID
     * @return \BiPRO\StructType\CT_Personengruppenrolle
     */
    public function setPersonengruppenID($personengruppenID = null)
    {
        // validation for constraint: string
        if (!is_null($personengruppenID) && !is_string($personengruppenID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personengruppenID, true), gettype($personengruppenID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($personengruppenID) && mb_strlen($personengruppenID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($personengruppenID)), __LINE__);
        }
        $this->PersonengruppenID = $personengruppenID;
        return $this;
    }
}
