<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Personengruppe StructType
 * Meta information extracted from the WSDL
 * - documentation: Gruppe von natürlichen und/oder juristischen Personen. Die Mitglieder der Personengruppe können individuell über die Klasse PersonengruppenMitglied identifiziert werden. Alternativ kann mit dem Attribut Bezeichnung eine Gruppe
 * nicht namentlich genannter Personen beschrieben werden.
 * @subpackage Structs
 */
class CT_Personengruppe extends CT_Objekt
{
    /**
     * The Bezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Bezeichnung der Personengruppe
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Bezeichnung;
    /**
     * The AnzahlPersonen
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der Personen in der Personengruppe.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlPersonen;
    /**
     * The NamentlicheNennung
     * Meta information extracted from the WSDL
     * - documentation: Ja = Mit namentlicher Nennung der MitgliederNein = Keine namentliche Nennung der Mitglieder
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $NamentlicheNennung;
    /**
     * The PersonengruppenID
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige ID der Personengruppe innerhalb eines Datenaustauschs. Diese ID dient zur Referenzierung aus einem fachlichen Kontext mit Hilfe der Klasse Personengruppenrolle. | Typ fuer alle IDs.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonengruppenID;
    /**
     * The Mitglied
     * Meta information extracted from the WSDL
     * - documentation: Mitglieder der Personengruppe.DARF NICHT verwendet werden, WENN NamentlicheNennung = falseWenn NamentlicheNennung = true, MÜSSEN alle relevanten Personen referenziert werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_PersonengruppenMitglied[]
     */
    public $Mitglied;
    /**
     * Constructor method for CT_Personengruppe
     * @uses CT_Personengruppe::setBezeichnung()
     * @uses CT_Personengruppe::setAnzahlPersonen()
     * @uses CT_Personengruppe::setNamentlicheNennung()
     * @uses CT_Personengruppe::setPersonengruppenID()
     * @uses CT_Personengruppe::setMitglied()
     * @param string $bezeichnung
     * @param int $anzahlPersonen
     * @param bool $namentlicheNennung
     * @param string $personengruppenID
     * @param \BiPRO\StructType\CT_PersonengruppenMitglied[] $mitglied
     */
    public function __construct($bezeichnung = null, $anzahlPersonen = null, $namentlicheNennung = null, $personengruppenID = null, array $mitglied = array())
    {
        $this
            ->setBezeichnung($bezeichnung)
            ->setAnzahlPersonen($anzahlPersonen)
            ->setNamentlicheNennung($namentlicheNennung)
            ->setPersonengruppenID($personengruppenID)
            ->setMitglied($mitglied);
    }
    /**
     * Get Bezeichnung value
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->Bezeichnung;
    }
    /**
     * Set Bezeichnung value
     * @param string $bezeichnung
     * @return \BiPRO\StructType\CT_Personengruppe
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($bezeichnung) && mb_strlen($bezeichnung) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($bezeichnung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($bezeichnung) && mb_strlen($bezeichnung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($bezeichnung)), __LINE__);
        }
        $this->Bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Get AnzahlPersonen value
     * @return int|null
     */
    public function getAnzahlPersonen()
    {
        return $this->AnzahlPersonen;
    }
    /**
     * Set AnzahlPersonen value
     * @param int $anzahlPersonen
     * @return \BiPRO\StructType\CT_Personengruppe
     */
    public function setAnzahlPersonen($anzahlPersonen = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlPersonen) && !(is_int($anzahlPersonen) || ctype_digit($anzahlPersonen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlPersonen, true), gettype($anzahlPersonen)), __LINE__);
        }
        $this->AnzahlPersonen = $anzahlPersonen;
        return $this;
    }
    /**
     * Get NamentlicheNennung value
     * @return bool|null
     */
    public function getNamentlicheNennung()
    {
        return $this->NamentlicheNennung;
    }
    /**
     * Set NamentlicheNennung value
     * @param bool $namentlicheNennung
     * @return \BiPRO\StructType\CT_Personengruppe
     */
    public function setNamentlicheNennung($namentlicheNennung = null)
    {
        // validation for constraint: boolean
        if (!is_null($namentlicheNennung) && !is_bool($namentlicheNennung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($namentlicheNennung, true), gettype($namentlicheNennung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($namentlicheNennung) && !preg_match('/true|false/', $namentlicheNennung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($namentlicheNennung, true)), __LINE__);
        }
        $this->NamentlicheNennung = $namentlicheNennung;
        return $this;
    }
    /**
     * Get PersonengruppenID value
     * @return string|null
     */
    public function getPersonengruppenID()
    {
        return $this->PersonengruppenID;
    }
    /**
     * Set PersonengruppenID value
     * @param string $personengruppenID
     * @return \BiPRO\StructType\CT_Personengruppe
     */
    public function setPersonengruppenID($personengruppenID = null)
    {
        // validation for constraint: string
        if (!is_null($personengruppenID) && !is_string($personengruppenID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personengruppenID, true), gettype($personengruppenID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($personengruppenID) && mb_strlen($personengruppenID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($personengruppenID)), __LINE__);
        }
        $this->PersonengruppenID = $personengruppenID;
        return $this;
    }
    /**
     * Get Mitglied value
     * @return \BiPRO\StructType\CT_PersonengruppenMitglied[]|null
     */
    public function getMitglied()
    {
        return $this->Mitglied;
    }
    /**
     * This method is responsible for validating the values passed to the setMitglied method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMitglied method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMitgliedForArrayConstraintsFromSetMitglied(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_PersonengruppeMitgliedItem) {
            // validation for constraint: itemType
            if (!$cT_PersonengruppeMitgliedItem instanceof \BiPRO\StructType\CT_PersonengruppenMitglied) {
                $invalidValues[] = is_object($cT_PersonengruppeMitgliedItem) ? get_class($cT_PersonengruppeMitgliedItem) : sprintf('%s(%s)', gettype($cT_PersonengruppeMitgliedItem), var_export($cT_PersonengruppeMitgliedItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Mitglied property can only contain items of type \BiPRO\StructType\CT_PersonengruppenMitglied, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Mitglied value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_PersonengruppenMitglied[] $mitglied
     * @return \BiPRO\StructType\CT_Personengruppe
     */
    public function setMitglied(array $mitglied = array())
    {
        // validation for constraint: array
        if ('' !== ($mitgliedArrayErrorMessage = self::validateMitgliedForArrayConstraintsFromSetMitglied($mitglied))) {
            throw new \InvalidArgumentException($mitgliedArrayErrorMessage, __LINE__);
        }
        $this->Mitglied = $mitglied;
        return $this;
    }
    /**
     * Add item to Mitglied value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_PersonengruppenMitglied $item
     * @return \BiPRO\StructType\CT_Personengruppe
     */
    public function addToMitglied(\BiPRO\StructType\CT_PersonengruppenMitglied $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_PersonengruppenMitglied) {
            throw new \InvalidArgumentException(sprintf('The Mitglied property can only contain items of type \BiPRO\StructType\CT_PersonengruppenMitglied, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Mitglied[] = $item;
        return $this;
    }
}
