<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Person StructType
 * Meta information extracted from the WSDL
 * - documentation: Natuerliche Person. Darf nicht Projekt-spezifisch abgeleitet werden (vgl. Kommentar zu Partner). Kann Vertretungsberechtigter einer juristischen Person sein.
 * @subpackage Structs
 */
class CT_Person extends CT_Partner
{
    /**
     * The Vorname
     * Meta information extracted from the WSDL
     * - documentation: Vorname der PersonHinweis: Es kann eine optionale Rückmeldung an die Datenquelle im Status erfolgen, wenn ein Abschneiden der Feldlänge des Attributes notwendig ist.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Vorname;
    /**
     * The Geburtsdatum
     * Meta information extracted from the WSDL
     * - documentation: nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Geburtsdatum;
    /**
     * The Geschlecht
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Geschlecht;
    /**
     * The Titel
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Titel;
    /**
     * The Geburtsort
     * Meta information extracted from the WSDL
     * - documentation: Geburtsort der PersonHinweis: Es kann eine optionale Rückmeldung an die Datenquelle im Status erfolgen, wenn ein Abschneiden der Feldlänge des Attributes notwendig ist.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Geburtsort;
    /**
     * The Staatsangehoerigkeit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Staatsangehoerigkeit;
    /**
     * The Familienstand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Familienstand;
    /**
     * The Adelspraedikat
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Adelspraedikat;
    /**
     * The Geburtsname
     * Meta information extracted from the WSDL
     * - documentation: Geburtsname der Person.Hinweis: Es kann eine optionale Rückmeldung an die Datenquelle im Status erfolgen, wenn ein Abschneiden der Feldlänge des Attributes notwendig ist.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Geburtsname;
    /**
     * The Geburtsland
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Geburtsland;
    /**
     * The InDeutschlandAnsaessigSeit
     * Meta information extracted from the WSDL
     * - documentation: Zeitpunkt, seit dem die Person in Deutschland ansaessig ist. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $InDeutschlandAnsaessigSeit;
    /**
     * The Steueridentifikationsnummer
     * Meta information extracted from the WSDL
     * - documentation: Steueridentifikationsnummer der Person | nummerisch 11-stelligDie Steuer-Identifikationsnummer (auch TIN für Tax Identification Number) ist eine bundeseinheitliche und dauerhafte Identifikationsnummer von in Deutschland gemeldeten
     * Bürgern für Steuerzwecke.Der Aufbau ist hinterlegt auf www.osci.de (Koordinierungsstelle für IT Standards (KoSIT).
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{11}
     * @var string
     */
    public $Steueridentifikationsnummer;
    /**
     * The Ausweis
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Ausweis[]
     */
    public $Ausweis;
    /**
     * The GesetzlicheKrankenversicherung
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_GesetzlicheKrankenversicherung
     */
    public $GesetzlicheKrankenversicherung;
    /**
     * The Einkommenssteuer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Einkommenssteuer
     */
    public $Einkommenssteuer;
    /**
     * The Berufstaetigkeit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Berufstaetigkeit[]
     */
    public $Berufstaetigkeit;
    /**
     * The Einkommen
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Einkommensart[]
     */
    public $Einkommen;
    /**
     * The Haushalt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Haushalt
     */
    public $Haushalt;
    /**
     * The Ausbildung
     * Meta information extracted from the WSDL
     * - documentation: 0...1, da nur der höchste Abschluss berücksichtigt wird.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Ausbildung
     */
    public $Ausbildung;
    /**
     * The Gesundheitsdaten
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Gesundheitsdaten
     */
    public $Gesundheitsdaten;
    /**
     * The KuenstlernameOrdensname
     * Meta information extracted from the WSDL
     * - documentation: Kuenstlername bzw. Ordensname gemäß Personalausweis.Hinweis: Es kann eine optionale Rückmeldung an die Datenquelle im Status erfolgen, wenn ein Abschneiden der Feldlänge des Attributes notwendig ist.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $KuenstlernameOrdensname;
    /**
     * The Sozialversicherungsnummer
     * Meta information extracted from the WSDL
     * - documentation: Sozialversicherungsnummer gemäß Sozialversicherungsausweis.Die Sozialversicherungsnummer wird auch als Zulagenummer im Riester-Zulageverfahren verwendet.Der Aufbau der Nummer inkl. der Prüfziffernberechnung ist in der "Verordnung
     * über die Versicherungsnummer " unter www.gesetze-im-internet.de (Bundesrepublik Deutschland,vertreten durch das Bundesministerium der Justiz und für Verbraucherschutz) beschrieben. | Sozialversicherungsnummer gemäß Sozialversicherungsausweis
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 12
     * - minOccurs: 0
     * @var string
     */
    public $Sozialversicherungsnummer;
    /**
     * The AlteSteuernummer
     * Meta information extracted from the WSDL
     * - documentation: Bisherige Steuernummer, die nur innerhalb des einzelnen Finanzamtes eindeutig ist. | Auspraegungen gemaess GDV-Satzart 0100, Teildatensatz 5, Feld 11.
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $AlteSteuernummer;
    /**
     * The Fuehrerschein
     * Meta information extracted from the WSDL
     * - documentation: Referenz auf eine Fahrerlaubnis zu einer Person.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Fuehrerschein[]
     */
    public $Fuehrerschein;
    /**
     * Constructor method for CT_Person
     * @uses CT_Person::setVorname()
     * @uses CT_Person::setGeburtsdatum()
     * @uses CT_Person::setGeschlecht()
     * @uses CT_Person::setTitel()
     * @uses CT_Person::setGeburtsort()
     * @uses CT_Person::setStaatsangehoerigkeit()
     * @uses CT_Person::setFamilienstand()
     * @uses CT_Person::setAdelspraedikat()
     * @uses CT_Person::setGeburtsname()
     * @uses CT_Person::setGeburtsland()
     * @uses CT_Person::setInDeutschlandAnsaessigSeit()
     * @uses CT_Person::setSteueridentifikationsnummer()
     * @uses CT_Person::setAusweis()
     * @uses CT_Person::setGesetzlicheKrankenversicherung()
     * @uses CT_Person::setEinkommenssteuer()
     * @uses CT_Person::setBerufstaetigkeit()
     * @uses CT_Person::setEinkommen()
     * @uses CT_Person::setHaushalt()
     * @uses CT_Person::setAusbildung()
     * @uses CT_Person::setGesundheitsdaten()
     * @uses CT_Person::setKuenstlernameOrdensname()
     * @uses CT_Person::setSozialversicherungsnummer()
     * @uses CT_Person::setAlteSteuernummer()
     * @uses CT_Person::setFuehrerschein()
     * @param string $vorname
     * @param string $geburtsdatum
     * @param string $geschlecht
     * @param string $titel
     * @param string $geburtsort
     * @param string $staatsangehoerigkeit
     * @param string $familienstand
     * @param string $adelspraedikat
     * @param string $geburtsname
     * @param string $geburtsland
     * @param string $inDeutschlandAnsaessigSeit
     * @param string $steueridentifikationsnummer
     * @param \BiPRO\StructType\CT_Ausweis[] $ausweis
     * @param \BiPRO\StructType\CT_GesetzlicheKrankenversicherung $gesetzlicheKrankenversicherung
     * @param \BiPRO\StructType\CT_Einkommenssteuer $einkommenssteuer
     * @param \BiPRO\StructType\CT_Berufstaetigkeit[] $berufstaetigkeit
     * @param \BiPRO\StructType\CT_Einkommensart[] $einkommen
     * @param \BiPRO\StructType\CT_Haushalt $haushalt
     * @param \BiPRO\StructType\CT_Ausbildung $ausbildung
     * @param \BiPRO\StructType\CT_Gesundheitsdaten $gesundheitsdaten
     * @param string $kuenstlernameOrdensname
     * @param string $sozialversicherungsnummer
     * @param string $alteSteuernummer
     * @param \BiPRO\StructType\CT_Fuehrerschein[] $fuehrerschein
     */
    public function __construct($vorname = null, $geburtsdatum = null, $geschlecht = null, $titel = null, $geburtsort = null, $staatsangehoerigkeit = null, $familienstand = null, $adelspraedikat = null, $geburtsname = null, $geburtsland = null, $inDeutschlandAnsaessigSeit = null, $steueridentifikationsnummer = null, array $ausweis = array(), \BiPRO\StructType\CT_GesetzlicheKrankenversicherung $gesetzlicheKrankenversicherung = null, \BiPRO\StructType\CT_Einkommenssteuer $einkommenssteuer = null, array $berufstaetigkeit = array(), array $einkommen = array(), \BiPRO\StructType\CT_Haushalt $haushalt = null, \BiPRO\StructType\CT_Ausbildung $ausbildung = null, \BiPRO\StructType\CT_Gesundheitsdaten $gesundheitsdaten = null, $kuenstlernameOrdensname = null, $sozialversicherungsnummer = null, $alteSteuernummer = null, array $fuehrerschein = array())
    {
        $this
            ->setVorname($vorname)
            ->setGeburtsdatum($geburtsdatum)
            ->setGeschlecht($geschlecht)
            ->setTitel($titel)
            ->setGeburtsort($geburtsort)
            ->setStaatsangehoerigkeit($staatsangehoerigkeit)
            ->setFamilienstand($familienstand)
            ->setAdelspraedikat($adelspraedikat)
            ->setGeburtsname($geburtsname)
            ->setGeburtsland($geburtsland)
            ->setInDeutschlandAnsaessigSeit($inDeutschlandAnsaessigSeit)
            ->setSteueridentifikationsnummer($steueridentifikationsnummer)
            ->setAusweis($ausweis)
            ->setGesetzlicheKrankenversicherung($gesetzlicheKrankenversicherung)
            ->setEinkommenssteuer($einkommenssteuer)
            ->setBerufstaetigkeit($berufstaetigkeit)
            ->setEinkommen($einkommen)
            ->setHaushalt($haushalt)
            ->setAusbildung($ausbildung)
            ->setGesundheitsdaten($gesundheitsdaten)
            ->setKuenstlernameOrdensname($kuenstlernameOrdensname)
            ->setSozialversicherungsnummer($sozialversicherungsnummer)
            ->setAlteSteuernummer($alteSteuernummer)
            ->setFuehrerschein($fuehrerschein);
    }
    /**
     * Get Vorname value
     * @return string|null
     */
    public function getVorname()
    {
        return $this->Vorname;
    }
    /**
     * Set Vorname value
     * @param string $vorname
     * @return \BiPRO\StructType\CT_Person
     */
    public function setVorname($vorname = null)
    {
        // validation for constraint: string
        if (!is_null($vorname) && !is_string($vorname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorname, true), gettype($vorname)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($vorname) && mb_strlen($vorname) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($vorname)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vorname) && mb_strlen($vorname) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vorname)), __LINE__);
        }
        $this->Vorname = $vorname;
        return $this;
    }
    /**
     * Get Geburtsdatum value
     * @return string|null
     */
    public function getGeburtsdatum()
    {
        return $this->Geburtsdatum;
    }
    /**
     * Set Geburtsdatum value
     * @param string $geburtsdatum
     * @return \BiPRO\StructType\CT_Person
     */
    public function setGeburtsdatum($geburtsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($geburtsdatum) && !is_string($geburtsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geburtsdatum, true), gettype($geburtsdatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($geburtsdatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $geburtsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($geburtsdatum, true)), __LINE__);
        }
        $this->Geburtsdatum = $geburtsdatum;
        return $this;
    }
    /**
     * Get Geschlecht value
     * @return string|null
     */
    public function getGeschlecht()
    {
        return $this->Geschlecht;
    }
    /**
     * Set Geschlecht value
     * @uses \BiPRO\EnumType\ST_Geschlecht::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Geschlecht::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geschlecht
     * @return \BiPRO\StructType\CT_Person
     */
    public function setGeschlecht($geschlecht = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Geschlecht::valueIsValid($geschlecht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Geschlecht', is_array($geschlecht) ? implode(', ', $geschlecht) : var_export($geschlecht, true), implode(', ', \BiPRO\EnumType\ST_Geschlecht::getValidValues())), __LINE__);
        }
        $this->Geschlecht = $geschlecht;
        return $this;
    }
    /**
     * Get Titel value
     * @return string|null
     */
    public function getTitel()
    {
        return $this->Titel;
    }
    /**
     * Set Titel value
     * @param string $titel
     * @return \BiPRO\StructType\CT_Person
     */
    public function setTitel($titel = null)
    {
        // validation for constraint: string
        if (!is_null($titel) && !is_string($titel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titel, true), gettype($titel)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($titel) && mb_strlen($titel) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($titel)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($titel) && mb_strlen($titel) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($titel)), __LINE__);
        }
        $this->Titel = $titel;
        return $this;
    }
    /**
     * Get Geburtsort value
     * @return string|null
     */
    public function getGeburtsort()
    {
        return $this->Geburtsort;
    }
    /**
     * Set Geburtsort value
     * @param string $geburtsort
     * @return \BiPRO\StructType\CT_Person
     */
    public function setGeburtsort($geburtsort = null)
    {
        // validation for constraint: string
        if (!is_null($geburtsort) && !is_string($geburtsort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geburtsort, true), gettype($geburtsort)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($geburtsort) && mb_strlen($geburtsort) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($geburtsort)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($geburtsort) && mb_strlen($geburtsort) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($geburtsort)), __LINE__);
        }
        $this->Geburtsort = $geburtsort;
        return $this;
    }
    /**
     * Get Staatsangehoerigkeit value
     * @return string|null
     */
    public function getStaatsangehoerigkeit()
    {
        return $this->Staatsangehoerigkeit;
    }
    /**
     * Set Staatsangehoerigkeit value
     * @uses \BiPRO\EnumType\ST_Laenderkennzeichen::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Laenderkennzeichen::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $staatsangehoerigkeit
     * @return \BiPRO\StructType\CT_Person
     */
    public function setStaatsangehoerigkeit($staatsangehoerigkeit = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Laenderkennzeichen::valueIsValid($staatsangehoerigkeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Laenderkennzeichen', is_array($staatsangehoerigkeit) ? implode(', ', $staatsangehoerigkeit) : var_export($staatsangehoerigkeit, true), implode(', ', \BiPRO\EnumType\ST_Laenderkennzeichen::getValidValues())), __LINE__);
        }
        $this->Staatsangehoerigkeit = $staatsangehoerigkeit;
        return $this;
    }
    /**
     * Get Familienstand value
     * @return string|null
     */
    public function getFamilienstand()
    {
        return $this->Familienstand;
    }
    /**
     * Set Familienstand value
     * @uses \BiPRO\EnumType\ST_Familienstand::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Familienstand::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $familienstand
     * @return \BiPRO\StructType\CT_Person
     */
    public function setFamilienstand($familienstand = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Familienstand::valueIsValid($familienstand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Familienstand', is_array($familienstand) ? implode(', ', $familienstand) : var_export($familienstand, true), implode(', ', \BiPRO\EnumType\ST_Familienstand::getValidValues())), __LINE__);
        }
        $this->Familienstand = $familienstand;
        return $this;
    }
    /**
     * Get Adelspraedikat value
     * @return string|null
     */
    public function getAdelspraedikat()
    {
        return $this->Adelspraedikat;
    }
    /**
     * Set Adelspraedikat value
     * @param string $adelspraedikat
     * @return \BiPRO\StructType\CT_Person
     */
    public function setAdelspraedikat($adelspraedikat = null)
    {
        // validation for constraint: string
        if (!is_null($adelspraedikat) && !is_string($adelspraedikat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adelspraedikat, true), gettype($adelspraedikat)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($adelspraedikat) && mb_strlen($adelspraedikat) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($adelspraedikat)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($adelspraedikat) && mb_strlen($adelspraedikat) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($adelspraedikat)), __LINE__);
        }
        $this->Adelspraedikat = $adelspraedikat;
        return $this;
    }
    /**
     * Get Geburtsname value
     * @return string|null
     */
    public function getGeburtsname()
    {
        return $this->Geburtsname;
    }
    /**
     * Set Geburtsname value
     * @param string $geburtsname
     * @return \BiPRO\StructType\CT_Person
     */
    public function setGeburtsname($geburtsname = null)
    {
        // validation for constraint: string
        if (!is_null($geburtsname) && !is_string($geburtsname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geburtsname, true), gettype($geburtsname)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($geburtsname) && mb_strlen($geburtsname) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($geburtsname)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($geburtsname) && mb_strlen($geburtsname) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($geburtsname)), __LINE__);
        }
        $this->Geburtsname = $geburtsname;
        return $this;
    }
    /**
     * Get Geburtsland value
     * @return string|null
     */
    public function getGeburtsland()
    {
        return $this->Geburtsland;
    }
    /**
     * Set Geburtsland value
     * @uses \BiPRO\EnumType\ST_Laenderkennzeichen::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Laenderkennzeichen::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geburtsland
     * @return \BiPRO\StructType\CT_Person
     */
    public function setGeburtsland($geburtsland = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Laenderkennzeichen::valueIsValid($geburtsland)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Laenderkennzeichen', is_array($geburtsland) ? implode(', ', $geburtsland) : var_export($geburtsland, true), implode(', ', \BiPRO\EnumType\ST_Laenderkennzeichen::getValidValues())), __LINE__);
        }
        $this->Geburtsland = $geburtsland;
        return $this;
    }
    /**
     * Get InDeutschlandAnsaessigSeit value
     * @return string|null
     */
    public function getInDeutschlandAnsaessigSeit()
    {
        return $this->InDeutschlandAnsaessigSeit;
    }
    /**
     * Set InDeutschlandAnsaessigSeit value
     * @param string $inDeutschlandAnsaessigSeit
     * @return \BiPRO\StructType\CT_Person
     */
    public function setInDeutschlandAnsaessigSeit($inDeutschlandAnsaessigSeit = null)
    {
        // validation for constraint: string
        if (!is_null($inDeutschlandAnsaessigSeit) && !is_string($inDeutschlandAnsaessigSeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inDeutschlandAnsaessigSeit, true), gettype($inDeutschlandAnsaessigSeit)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($inDeutschlandAnsaessigSeit) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $inDeutschlandAnsaessigSeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($inDeutschlandAnsaessigSeit, true)), __LINE__);
        }
        $this->InDeutschlandAnsaessigSeit = $inDeutschlandAnsaessigSeit;
        return $this;
    }
    /**
     * Get Steueridentifikationsnummer value
     * @return string|null
     */
    public function getSteueridentifikationsnummer()
    {
        return $this->Steueridentifikationsnummer;
    }
    /**
     * Set Steueridentifikationsnummer value
     * @param string $steueridentifikationsnummer
     * @return \BiPRO\StructType\CT_Person
     */
    public function setSteueridentifikationsnummer($steueridentifikationsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($steueridentifikationsnummer) && !is_string($steueridentifikationsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($steueridentifikationsnummer, true), gettype($steueridentifikationsnummer)), __LINE__);
        }
        // validation for constraint: pattern(\d{11})
        if (!is_null($steueridentifikationsnummer) && !preg_match('/\\d{11}/', $steueridentifikationsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{11}', var_export($steueridentifikationsnummer, true)), __LINE__);
        }
        $this->Steueridentifikationsnummer = $steueridentifikationsnummer;
        return $this;
    }
    /**
     * Get Ausweis value
     * @return \BiPRO\StructType\CT_Ausweis[]|null
     */
    public function getAusweis()
    {
        return $this->Ausweis;
    }
    /**
     * This method is responsible for validating the values passed to the setAusweis method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAusweis method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAusweisForArrayConstraintsFromSetAusweis(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_PersonAusweisItem) {
            // validation for constraint: itemType
            if (!$cT_PersonAusweisItem instanceof \BiPRO\StructType\CT_Ausweis) {
                $invalidValues[] = is_object($cT_PersonAusweisItem) ? get_class($cT_PersonAusweisItem) : sprintf('%s(%s)', gettype($cT_PersonAusweisItem), var_export($cT_PersonAusweisItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Ausweis property can only contain items of type \BiPRO\StructType\CT_Ausweis, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Ausweis value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Ausweis[] $ausweis
     * @return \BiPRO\StructType\CT_Person
     */
    public function setAusweis(array $ausweis = array())
    {
        // validation for constraint: array
        if ('' !== ($ausweisArrayErrorMessage = self::validateAusweisForArrayConstraintsFromSetAusweis($ausweis))) {
            throw new \InvalidArgumentException($ausweisArrayErrorMessage, __LINE__);
        }
        $this->Ausweis = $ausweis;
        return $this;
    }
    /**
     * Add item to Ausweis value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Ausweis $item
     * @return \BiPRO\StructType\CT_Person
     */
    public function addToAusweis(\BiPRO\StructType\CT_Ausweis $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Ausweis) {
            throw new \InvalidArgumentException(sprintf('The Ausweis property can only contain items of type \BiPRO\StructType\CT_Ausweis, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Ausweis[] = $item;
        return $this;
    }
    /**
     * Get GesetzlicheKrankenversicherung value
     * @return \BiPRO\StructType\CT_GesetzlicheKrankenversicherung|null
     */
    public function getGesetzlicheKrankenversicherung()
    {
        return $this->GesetzlicheKrankenversicherung;
    }
    /**
     * Set GesetzlicheKrankenversicherung value
     * @param \BiPRO\StructType\CT_GesetzlicheKrankenversicherung $gesetzlicheKrankenversicherung
     * @return \BiPRO\StructType\CT_Person
     */
    public function setGesetzlicheKrankenversicherung(\BiPRO\StructType\CT_GesetzlicheKrankenversicherung $gesetzlicheKrankenversicherung = null)
    {
        $this->GesetzlicheKrankenversicherung = $gesetzlicheKrankenversicherung;
        return $this;
    }
    /**
     * Get Einkommenssteuer value
     * @return \BiPRO\StructType\CT_Einkommenssteuer|null
     */
    public function getEinkommenssteuer()
    {
        return $this->Einkommenssteuer;
    }
    /**
     * Set Einkommenssteuer value
     * @param \BiPRO\StructType\CT_Einkommenssteuer $einkommenssteuer
     * @return \BiPRO\StructType\CT_Person
     */
    public function setEinkommenssteuer(\BiPRO\StructType\CT_Einkommenssteuer $einkommenssteuer = null)
    {
        $this->Einkommenssteuer = $einkommenssteuer;
        return $this;
    }
    /**
     * Get Berufstaetigkeit value
     * @return \BiPRO\StructType\CT_Berufstaetigkeit[]|null
     */
    public function getBerufstaetigkeit()
    {
        return $this->Berufstaetigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setBerufstaetigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBerufstaetigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBerufstaetigkeitForArrayConstraintsFromSetBerufstaetigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_PersonBerufstaetigkeitItem) {
            // validation for constraint: itemType
            if (!$cT_PersonBerufstaetigkeitItem instanceof \BiPRO\StructType\CT_Berufstaetigkeit) {
                $invalidValues[] = is_object($cT_PersonBerufstaetigkeitItem) ? get_class($cT_PersonBerufstaetigkeitItem) : sprintf('%s(%s)', gettype($cT_PersonBerufstaetigkeitItem), var_export($cT_PersonBerufstaetigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Berufstaetigkeit property can only contain items of type \BiPRO\StructType\CT_Berufstaetigkeit, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Berufstaetigkeit value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Berufstaetigkeit[] $berufstaetigkeit
     * @return \BiPRO\StructType\CT_Person
     */
    public function setBerufstaetigkeit(array $berufstaetigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($berufstaetigkeitArrayErrorMessage = self::validateBerufstaetigkeitForArrayConstraintsFromSetBerufstaetigkeit($berufstaetigkeit))) {
            throw new \InvalidArgumentException($berufstaetigkeitArrayErrorMessage, __LINE__);
        }
        $this->Berufstaetigkeit = $berufstaetigkeit;
        return $this;
    }
    /**
     * Add item to Berufstaetigkeit value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Berufstaetigkeit $item
     * @return \BiPRO\StructType\CT_Person
     */
    public function addToBerufstaetigkeit(\BiPRO\StructType\CT_Berufstaetigkeit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Berufstaetigkeit) {
            throw new \InvalidArgumentException(sprintf('The Berufstaetigkeit property can only contain items of type \BiPRO\StructType\CT_Berufstaetigkeit, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Berufstaetigkeit[] = $item;
        return $this;
    }
    /**
     * Get Einkommen value
     * @return \BiPRO\StructType\CT_Einkommensart[]|null
     */
    public function getEinkommen()
    {
        return $this->Einkommen;
    }
    /**
     * This method is responsible for validating the values passed to the setEinkommen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEinkommen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEinkommenForArrayConstraintsFromSetEinkommen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_PersonEinkommenItem) {
            // validation for constraint: itemType
            if (!$cT_PersonEinkommenItem instanceof \BiPRO\StructType\CT_Einkommensart) {
                $invalidValues[] = is_object($cT_PersonEinkommenItem) ? get_class($cT_PersonEinkommenItem) : sprintf('%s(%s)', gettype($cT_PersonEinkommenItem), var_export($cT_PersonEinkommenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Einkommen property can only contain items of type \BiPRO\StructType\CT_Einkommensart, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Einkommen value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Einkommensart[] $einkommen
     * @return \BiPRO\StructType\CT_Person
     */
    public function setEinkommen(array $einkommen = array())
    {
        // validation for constraint: array
        if ('' !== ($einkommenArrayErrorMessage = self::validateEinkommenForArrayConstraintsFromSetEinkommen($einkommen))) {
            throw new \InvalidArgumentException($einkommenArrayErrorMessage, __LINE__);
        }
        $this->Einkommen = $einkommen;
        return $this;
    }
    /**
     * Add item to Einkommen value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Einkommensart $item
     * @return \BiPRO\StructType\CT_Person
     */
    public function addToEinkommen(\BiPRO\StructType\CT_Einkommensart $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Einkommensart) {
            throw new \InvalidArgumentException(sprintf('The Einkommen property can only contain items of type \BiPRO\StructType\CT_Einkommensart, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Einkommen[] = $item;
        return $this;
    }
    /**
     * Get Haushalt value
     * @return \BiPRO\StructType\CT_Haushalt|null
     */
    public function getHaushalt()
    {
        return $this->Haushalt;
    }
    /**
     * Set Haushalt value
     * @param \BiPRO\StructType\CT_Haushalt $haushalt
     * @return \BiPRO\StructType\CT_Person
     */
    public function setHaushalt(\BiPRO\StructType\CT_Haushalt $haushalt = null)
    {
        $this->Haushalt = $haushalt;
        return $this;
    }
    /**
     * Get Ausbildung value
     * @return \BiPRO\StructType\CT_Ausbildung|null
     */
    public function getAusbildung()
    {
        return $this->Ausbildung;
    }
    /**
     * Set Ausbildung value
     * @param \BiPRO\StructType\CT_Ausbildung $ausbildung
     * @return \BiPRO\StructType\CT_Person
     */
    public function setAusbildung(\BiPRO\StructType\CT_Ausbildung $ausbildung = null)
    {
        $this->Ausbildung = $ausbildung;
        return $this;
    }
    /**
     * Get Gesundheitsdaten value
     * @return \BiPRO\StructType\CT_Gesundheitsdaten|null
     */
    public function getGesundheitsdaten()
    {
        return $this->Gesundheitsdaten;
    }
    /**
     * Set Gesundheitsdaten value
     * @param \BiPRO\StructType\CT_Gesundheitsdaten $gesundheitsdaten
     * @return \BiPRO\StructType\CT_Person
     */
    public function setGesundheitsdaten(\BiPRO\StructType\CT_Gesundheitsdaten $gesundheitsdaten = null)
    {
        $this->Gesundheitsdaten = $gesundheitsdaten;
        return $this;
    }
    /**
     * Get KuenstlernameOrdensname value
     * @return string|null
     */
    public function getKuenstlernameOrdensname()
    {
        return $this->KuenstlernameOrdensname;
    }
    /**
     * Set KuenstlernameOrdensname value
     * @param string $kuenstlernameOrdensname
     * @return \BiPRO\StructType\CT_Person
     */
    public function setKuenstlernameOrdensname($kuenstlernameOrdensname = null)
    {
        // validation for constraint: string
        if (!is_null($kuenstlernameOrdensname) && !is_string($kuenstlernameOrdensname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kuenstlernameOrdensname, true), gettype($kuenstlernameOrdensname)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($kuenstlernameOrdensname) && mb_strlen($kuenstlernameOrdensname) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($kuenstlernameOrdensname)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($kuenstlernameOrdensname) && mb_strlen($kuenstlernameOrdensname) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($kuenstlernameOrdensname)), __LINE__);
        }
        $this->KuenstlernameOrdensname = $kuenstlernameOrdensname;
        return $this;
    }
    /**
     * Get Sozialversicherungsnummer value
     * @return string|null
     */
    public function getSozialversicherungsnummer()
    {
        return $this->Sozialversicherungsnummer;
    }
    /**
     * Set Sozialversicherungsnummer value
     * @param string $sozialversicherungsnummer
     * @return \BiPRO\StructType\CT_Person
     */
    public function setSozialversicherungsnummer($sozialversicherungsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($sozialversicherungsnummer) && !is_string($sozialversicherungsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sozialversicherungsnummer, true), gettype($sozialversicherungsnummer)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($sozialversicherungsnummer) && mb_strlen($sozialversicherungsnummer) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($sozialversicherungsnummer)), __LINE__);
        }
        // validation for constraint: minLength(12)
        if (!is_null($sozialversicherungsnummer) && mb_strlen($sozialversicherungsnummer) < 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 12', mb_strlen($sozialversicherungsnummer)), __LINE__);
        }
        $this->Sozialversicherungsnummer = $sozialversicherungsnummer;
        return $this;
    }
    /**
     * Get AlteSteuernummer value
     * @return string|null
     */
    public function getAlteSteuernummer()
    {
        return $this->AlteSteuernummer;
    }
    /**
     * Set AlteSteuernummer value
     * @param string $alteSteuernummer
     * @return \BiPRO\StructType\CT_Person
     */
    public function setAlteSteuernummer($alteSteuernummer = null)
    {
        // validation for constraint: string
        if (!is_null($alteSteuernummer) && !is_string($alteSteuernummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alteSteuernummer, true), gettype($alteSteuernummer)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($alteSteuernummer) && mb_strlen($alteSteuernummer) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($alteSteuernummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($alteSteuernummer) && mb_strlen($alteSteuernummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($alteSteuernummer)), __LINE__);
        }
        $this->AlteSteuernummer = $alteSteuernummer;
        return $this;
    }
    /**
     * Get Fuehrerschein value
     * @return \BiPRO\StructType\CT_Fuehrerschein[]|null
     */
    public function getFuehrerschein()
    {
        return $this->Fuehrerschein;
    }
    /**
     * This method is responsible for validating the values passed to the setFuehrerschein method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFuehrerschein method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFuehrerscheinForArrayConstraintsFromSetFuehrerschein(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_PersonFuehrerscheinItem) {
            // validation for constraint: itemType
            if (!$cT_PersonFuehrerscheinItem instanceof \BiPRO\StructType\CT_Fuehrerschein) {
                $invalidValues[] = is_object($cT_PersonFuehrerscheinItem) ? get_class($cT_PersonFuehrerscheinItem) : sprintf('%s(%s)', gettype($cT_PersonFuehrerscheinItem), var_export($cT_PersonFuehrerscheinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Fuehrerschein property can only contain items of type \BiPRO\StructType\CT_Fuehrerschein, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Fuehrerschein value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Fuehrerschein[] $fuehrerschein
     * @return \BiPRO\StructType\CT_Person
     */
    public function setFuehrerschein(array $fuehrerschein = array())
    {
        // validation for constraint: array
        if ('' !== ($fuehrerscheinArrayErrorMessage = self::validateFuehrerscheinForArrayConstraintsFromSetFuehrerschein($fuehrerschein))) {
            throw new \InvalidArgumentException($fuehrerscheinArrayErrorMessage, __LINE__);
        }
        $this->Fuehrerschein = $fuehrerschein;
        return $this;
    }
    /**
     * Add item to Fuehrerschein value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Fuehrerschein $item
     * @return \BiPRO\StructType\CT_Person
     */
    public function addToFuehrerschein(\BiPRO\StructType\CT_Fuehrerschein $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Fuehrerschein) {
            throw new \InvalidArgumentException(sprintf('The Fuehrerschein property can only contain items of type \BiPRO\StructType\CT_Fuehrerschein, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Fuehrerschein[] = $item;
        return $this;
    }
}
