<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Partnerrolle StructType
 * Meta information extracted from the WSDL
 * - documentation: Die Rolle des Partners innerhalb eines konkreten Kontexts innerhalb der Nachricht. Alle Partner werden innerhalb einer Liste unterhalb des Wurzelelements der Nachricht (i.d.R. abgeleitet von Geschaeftsvorgang) uebertragen und aus dem
 * jeweiligen Kontext, aus dem sie benoetigt werden, mit Hilfe einer von diesem Datentypen abgeleiteten Rolle referenziert.Hierfuer enthaelt Partnerrolle ein Attribut von Typ ST_PartnerID, dessen Wert mit dem Wert des Attributs PartnerID (ebenfalls vom
 * Typ ST_PartnerID) eines in der oben angesprochenen Liste enthaltenen Partners uebereinstimmen muss.Wenn der Partner nicht übertragen werden kann bzw. darf, MUSS im referenzierten Partner-Objekt nur die PartnerID übertragen werden.
 * @subpackage Structs
 */
abstract class CT_Partnerrolle extends CT_Objekt
{
    /**
     * The PartnerID
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige Referenz auf einen Partner in der Partnerliste. | Typ fuer alle IDs.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $PartnerID;
    /**
     * The Gueltigkeit
     * Meta information extracted from the WSDL
     * - documentation: Zeitraum in dem die Partnerrolle gültig ist.Es MÜSSEN konkrete Zeitpunkte geliefert werden sofern dies fachlich möglich ist.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum
     */
    public $Gueltigkeit;
    /**
     * Constructor method for CT_Partnerrolle
     * @uses CT_Partnerrolle::setPartnerID()
     * @uses CT_Partnerrolle::setGueltigkeit()
     * @param string $partnerID
     * @param \BiPRO\StructType\CT_Zeitraum $gueltigkeit
     */
    public function __construct($partnerID = null, \BiPRO\StructType\CT_Zeitraum $gueltigkeit = null)
    {
        $this
            ->setPartnerID($partnerID)
            ->setGueltigkeit($gueltigkeit);
    }
    /**
     * Get PartnerID value
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }
    /**
     * Set PartnerID value
     * @param string $partnerID
     * @return \BiPRO\StructType\CT_Partnerrolle
     */
    public function setPartnerID($partnerID = null)
    {
        // validation for constraint: string
        if (!is_null($partnerID) && !is_string($partnerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerID, true), gettype($partnerID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($partnerID) && mb_strlen($partnerID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($partnerID)), __LINE__);
        }
        $this->PartnerID = $partnerID;
        return $this;
    }
    /**
     * Get Gueltigkeit value
     * @return \BiPRO\StructType\CT_Zeitraum|null
     */
    public function getGueltigkeit()
    {
        return $this->Gueltigkeit;
    }
    /**
     * Set Gueltigkeit value
     * @param \BiPRO\StructType\CT_Zeitraum $gueltigkeit
     * @return \BiPRO\StructType\CT_Partnerrolle
     */
    public function setGueltigkeit(\BiPRO\StructType\CT_Zeitraum $gueltigkeit = null)
    {
        $this->Gueltigkeit = $gueltigkeit;
        return $this;
    }
}
