<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_PartnerdatenKfz StructType
 * @subpackage Structs
 */
class CT_PartnerdatenKfz extends CT_ZusaetzlichePartnerdaten
{
    /**
     * The Tarifgruppe
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Tarifgruppe
     */
    public $Tarifgruppe;
    /**
     * The EintragVerkehrszentralregister
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $EintragVerkehrszentralregister;
    /**
     * The Sicherheitstraining
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Sicherheitstraining;
    /**
     * The ErsterVersicherungsbeginnVN
     * Meta information extracted from the WSDL
     * - documentation: Erster Versicherungsbeginn des Versicherungsnehmers bei dem Versicherer (Treuezeit)
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $ErsterVersicherungsbeginnVN;
    /**
     * The Fragen
     * Meta information extracted from the WSDL
     * - documentation: Abbildung von Fragen zu diesem Partner.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Fragenkomplex[]
     */
    public $Fragen;
    /**
     * Constructor method for CT_PartnerdatenKfz
     * @uses CT_PartnerdatenKfz::setTarifgruppe()
     * @uses CT_PartnerdatenKfz::setEintragVerkehrszentralregister()
     * @uses CT_PartnerdatenKfz::setSicherheitstraining()
     * @uses CT_PartnerdatenKfz::setErsterVersicherungsbeginnVN()
     * @uses CT_PartnerdatenKfz::setFragen()
     * @param \BiPRO\StructType\STE_Tarifgruppe $tarifgruppe
     * @param bool $eintragVerkehrszentralregister
     * @param bool $sicherheitstraining
     * @param int $ersterVersicherungsbeginnVN
     * @param \BiPRO\StructType\CT_Fragenkomplex[] $fragen
     */
    public function __construct(\BiPRO\StructType\STE_Tarifgruppe $tarifgruppe = null, $eintragVerkehrszentralregister = null, $sicherheitstraining = null, $ersterVersicherungsbeginnVN = null, array $fragen = array())
    {
        $this
            ->setTarifgruppe($tarifgruppe)
            ->setEintragVerkehrszentralregister($eintragVerkehrszentralregister)
            ->setSicherheitstraining($sicherheitstraining)
            ->setErsterVersicherungsbeginnVN($ersterVersicherungsbeginnVN)
            ->setFragen($fragen);
    }
    /**
     * Get Tarifgruppe value
     * @return \BiPRO\StructType\STE_Tarifgruppe|null
     */
    public function getTarifgruppe()
    {
        return $this->Tarifgruppe;
    }
    /**
     * Set Tarifgruppe value
     * @param \BiPRO\StructType\STE_Tarifgruppe $tarifgruppe
     * @return \BiPRO\StructType\CT_PartnerdatenKfz
     */
    public function setTarifgruppe(\BiPRO\StructType\STE_Tarifgruppe $tarifgruppe = null)
    {
        $this->Tarifgruppe = $tarifgruppe;
        return $this;
    }
    /**
     * Get EintragVerkehrszentralregister value
     * @return bool|null
     */
    public function getEintragVerkehrszentralregister()
    {
        return $this->EintragVerkehrszentralregister;
    }
    /**
     * Set EintragVerkehrszentralregister value
     * @param bool $eintragVerkehrszentralregister
     * @return \BiPRO\StructType\CT_PartnerdatenKfz
     */
    public function setEintragVerkehrszentralregister($eintragVerkehrszentralregister = null)
    {
        // validation for constraint: boolean
        if (!is_null($eintragVerkehrszentralregister) && !is_bool($eintragVerkehrszentralregister)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eintragVerkehrszentralregister, true), gettype($eintragVerkehrszentralregister)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($eintragVerkehrszentralregister) && !preg_match('/true|false/', $eintragVerkehrszentralregister)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($eintragVerkehrszentralregister, true)), __LINE__);
        }
        $this->EintragVerkehrszentralregister = $eintragVerkehrszentralregister;
        return $this;
    }
    /**
     * Get Sicherheitstraining value
     * @return bool|null
     */
    public function getSicherheitstraining()
    {
        return $this->Sicherheitstraining;
    }
    /**
     * Set Sicherheitstraining value
     * @param bool $sicherheitstraining
     * @return \BiPRO\StructType\CT_PartnerdatenKfz
     */
    public function setSicherheitstraining($sicherheitstraining = null)
    {
        // validation for constraint: boolean
        if (!is_null($sicherheitstraining) && !is_bool($sicherheitstraining)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sicherheitstraining, true), gettype($sicherheitstraining)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($sicherheitstraining) && !preg_match('/true|false/', $sicherheitstraining)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($sicherheitstraining, true)), __LINE__);
        }
        $this->Sicherheitstraining = $sicherheitstraining;
        return $this;
    }
    /**
     * Get ErsterVersicherungsbeginnVN value
     * @return int|null
     */
    public function getErsterVersicherungsbeginnVN()
    {
        return $this->ErsterVersicherungsbeginnVN;
    }
    /**
     * Set ErsterVersicherungsbeginnVN value
     * @param int $ersterVersicherungsbeginnVN
     * @return \BiPRO\StructType\CT_PartnerdatenKfz
     */
    public function setErsterVersicherungsbeginnVN($ersterVersicherungsbeginnVN = null)
    {
        // validation for constraint: int
        if (!is_null($ersterVersicherungsbeginnVN) && !(is_int($ersterVersicherungsbeginnVN) || ctype_digit($ersterVersicherungsbeginnVN))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ersterVersicherungsbeginnVN, true), gettype($ersterVersicherungsbeginnVN)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($ersterVersicherungsbeginnVN) && mb_strlen(preg_replace('/(\D)/', '', $ersterVersicherungsbeginnVN)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($ersterVersicherungsbeginnVN, true), mb_strlen(preg_replace('/(\D)/', '', $ersterVersicherungsbeginnVN))), __LINE__);
        }
        $this->ErsterVersicherungsbeginnVN = $ersterVersicherungsbeginnVN;
        return $this;
    }
    /**
     * Get Fragen value
     * @return \BiPRO\StructType\CT_Fragenkomplex[]|null
     */
    public function getFragen()
    {
        return $this->Fragen;
    }
    /**
     * This method is responsible for validating the values passed to the setFragen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFragen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFragenForArrayConstraintsFromSetFragen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_PartnerdatenKfzFragenItem) {
            // validation for constraint: itemType
            if (!$cT_PartnerdatenKfzFragenItem instanceof \BiPRO\StructType\CT_Fragenkomplex) {
                $invalidValues[] = is_object($cT_PartnerdatenKfzFragenItem) ? get_class($cT_PartnerdatenKfzFragenItem) : sprintf('%s(%s)', gettype($cT_PartnerdatenKfzFragenItem), var_export($cT_PartnerdatenKfzFragenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Fragen property can only contain items of type \BiPRO\StructType\CT_Fragenkomplex, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Fragen value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Fragenkomplex[] $fragen
     * @return \BiPRO\StructType\CT_PartnerdatenKfz
     */
    public function setFragen(array $fragen = array())
    {
        // validation for constraint: array
        if ('' !== ($fragenArrayErrorMessage = self::validateFragenForArrayConstraintsFromSetFragen($fragen))) {
            throw new \InvalidArgumentException($fragenArrayErrorMessage, __LINE__);
        }
        $this->Fragen = $fragen;
        return $this;
    }
    /**
     * Add item to Fragen value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Fragenkomplex $item
     * @return \BiPRO\StructType\CT_PartnerdatenKfz
     */
    public function addToFragen(\BiPRO\StructType\CT_Fragenkomplex $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Fragenkomplex) {
            throw new \InvalidArgumentException(sprintf('The Fragen property can only contain items of type \BiPRO\StructType\CT_Fragenkomplex, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Fragen[] = $item;
        return $this;
    }
}
