<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Partner StructType
 * Meta information extracted from the WSDL
 * - documentation: Basis-Objekt fuer Partnerdaten, das die Gemeinsamkeiten von natuerlichen und juristischen Personen abbildet. Unterklassen duerfen nicht projektspezifisch abgeleitet werden um die Kombination der Ergebnisse verschiedener Projekte der
 * BiPRO innerhalb eines Services und insbesondere die spartenuebergreifende Produktbuendelung in Tarifierungsprojekten nicht zu gefaehrden. Fuer solche Erweiterungen steht - falls notwendig - der Datentyp ZusaetzlichePartnerdaten zur Verfuegung.Partner
 * werden in einer Liste unterhalb des Wurzelelements (i.d.R. abgeleitet von Geschaeftsvorgang) jeder Nachricht uebertragen. Die Referenzierung aus dem jeweiligen lokalen Kontext erfolgt ueber die Partnerrolle in Kombination mit dem Attribut PartnerID
 * dieses Datentyps.Die Attribute BezugZuVN (ST_BezugZuVN) und PartnerID (ST_PartnerID) fehlen, da die entsprechenden einfachen Datentypen nicht definiert sind.
 * @subpackage Structs
 */
abstract class CT_Partner extends CT_Objekt
{
    /**
     * The Anrede
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Anrede;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Nachname der Person bzw. Firmenname des Unternehmens.Hinweis: Es kann eine optionale Rückmeldung an die Datenquelle im Status erfolgen, wenn ein Abschneiden der Feldlänge des Attributes notwendig ist.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Namenszusatz1
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Namenszusatz1;
    /**
     * The Namenszusatz2
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Namenszusatz2;
    /**
     * The PartnernummerVM
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige Identifizierung des Partners beim Vermittler.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $PartnernummerVM;
    /**
     * The Partnernummer
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige Identifizierung des Partners beim produktgebenden Unternehmen.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Partnernummer;
    /**
     * The Vorsteuerabzugsberechtigt
     * Meta information extracted from the WSDL
     * - documentation: Vorsteuerabzugsfähigkeit.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Vorsteuerabzugsberechtigt;
    /**
     * The PartnerID
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige ID des Partners innerhalb eines Datenaustauschs. Diese ID dient zur Referenzierung aus einem fachlichen Kontext. | Typ fuer alle IDs.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerID;
    /**
     * The Anschrift
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Partneranschrift[]
     */
    public $Anschrift;
    /**
     * The ZusaetzlichePartnerdaten
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_ZusaetzlichePartnerdaten[]
     */
    public $ZusaetzlichePartnerdaten;
    /**
     * The Kommunikationsverbindung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Kommunikationsverbindung[]
     */
    public $Kommunikationsverbindung;
    /**
     * The Bankverbindung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_BankverbindungBasis[]
     */
    public $Bankverbindung;
    /**
     * The HandeltAufRechnungVon
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_HandeltAufRechnungVon[]
     */
    public $HandeltAufRechnungVon;
    /**
     * The Gruppenvertragspartner
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Gruppenvertragspartner[]
     */
    public $Gruppenvertragspartner;
    /**
     * The Partnerbeziehung
     * Meta information extracted from the WSDL
     * - documentation: 0..*, da somit Beziehung zu mehreren Partner möglich ist. Damit lassen sich z.B. die Beziehungen eines Vaters zu seiner Ehefrau, mehreren Kindern und seinem Arbeitsgeber abbilden. Die Richtung der Beziehung ist wie folgt: PARTNER
     * ist PARTNERBEZIEHUNG:Art von PARTNERBEZIEHUNG:Id. Bsp: Partner IST Vater von Partner mit der ID 5
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Partnerbeziehung[]
     */
    public $Partnerbeziehung;
    /**
     * The Vertrauensperson
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Vertrauensperson
     */
    public $Vertrauensperson;
    /**
     * The Kreditkarte
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Kreditkarte[]
     */
    public $Kreditkarte;
    /**
     * The UmsatzsteuerIdentifikationsnummer
     * Meta information extracted from the WSDL
     * - documentation: Die Umsatzsteuer-Identifikationsnummer ist eine eindeutige EU-weite Kennzeichnung eines Steuerpflichtigen im umsatzsteuerlichen Sinne.
     * - base: xsd:string
     * - maxLength: 14
     * - maxOccurs: 1
     * - minLength: 14
     * - minOccurs: 0
     * @var string
     */
    public $UmsatzsteuerIdentifikationsnummer;
    /**
     * The AltePartnernummer
     * Meta information extracted from the WSDL
     * - documentation: Bei einer Änderung der Partnernummer beim produktgebenden Unternehmen (Attribut Partnernummer) MUSS die alte Partnernummer in diesem Attribut zumindest bei der ersten Lieferung nach der Nummernänderung übermittelt werden. Dabei
     * MUSS die Gevo-Art 110000002 (Änderung der Partnernummer) verwendet werden.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $AltePartnernummer;
    /**
     * The Besteuerung
     * Meta information extracted from the WSDL
     * - documentation: Informationen zur Besteuerung des Partners.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Besteuerung
     */
    public $Besteuerung;
    /**
     * The Direktmarketing
     * Meta information extracted from the WSDL
     * - documentation: Werbeerlaubnis bzw. Werbeverbot für Direktmarketing.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Werbeerlaubnis[]
     */
    public $Direktmarketing;
    /**
     * The Finanzamt
     * Meta information extracted from the WSDL
     * - documentation: Zuständiges Finanzamt.Grundsätzlich ist das Finanzamt des Wohnorts/ Unternehmenssitzes zuständig, in dem der Steuerpflichtige zum Abgabezeitraum der Steuererklärung wohnt bzw. seinen Unternehmenssitz hat. Die BUFA-Nr. ist die
     * eindeutige bundeseinheitliche Finanzamtsnummer. Es wird damit ein Finanzamt sowohl einem Bundesland als auch einer vorgesetzten Finanzbehörde zugeordnet. | Werteliste aller gültigen Finanzämter in Deutschland. Bezeichnung laut BZSt ist
     * fadatxls.Die Liste steht auf der Webseite des Bundeszentralamtes für Steuern (BZSt; www.bzst.de) und wird stetig aktualisiert (Stand 02.01.2014).
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}
     * @var string
     */
    public $Finanzamt;
    /**
     * The Partneranmerkung
     * Meta information extracted from the WSDL
     * - documentation: Spezifiziert eine Anmerkung zum Partner, z. B. Partner ist VIP.
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Partneranmerkung;
    /**
     * The Briefanrede
     * Meta information extracted from the WSDL
     * - documentation: Definition der Anrede in Briefen.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Briefanrede;
    /**
     * The Kommunikationspartner
     * Meta information extracted from the WSDL
     * - documentation: Referenz von einem Partner zu seinem Kommunikationspartner. Ist ein Kommunikationspartner spezifiziert, DARF die Kommunikation NICHT an den referenzierenden Partner sondern MUSS an den Kommunikationspartner gerichtet werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Kommunikationspartner
     */
    public $Kommunikationspartner;
    /**
     * The PartnernummerExtern
     * Meta information extracted from the WSDL
     * - documentation: Partnernummer, die nicht vom produktgebenden Unternehmen oder vom Vermittler sondern von einem Dritten vergeben wurde, z. B. einem Dienstleister.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Partnernummer[]
     */
    public $PartnernummerExtern;
    /**
     * The Vollmachtgeber
     * Meta information extracted from the WSDL
     * - documentation: Der referenzierte Partner (Partnerrolle) ist der Vollmachtgeber. Der referenzierende Partner (juristische bzw. natürliche Person) handelt in dessen Vollmacht.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Vollmachtgeber
     */
    public $Vollmachtgeber;
    /**
     * Constructor method for CT_Partner
     * @uses CT_Partner::setAnrede()
     * @uses CT_Partner::setName()
     * @uses CT_Partner::setNamenszusatz1()
     * @uses CT_Partner::setNamenszusatz2()
     * @uses CT_Partner::setPartnernummerVM()
     * @uses CT_Partner::setPartnernummer()
     * @uses CT_Partner::setVorsteuerabzugsberechtigt()
     * @uses CT_Partner::setPartnerID()
     * @uses CT_Partner::setAnschrift()
     * @uses CT_Partner::setZusaetzlichePartnerdaten()
     * @uses CT_Partner::setKommunikationsverbindung()
     * @uses CT_Partner::setBankverbindung()
     * @uses CT_Partner::setHandeltAufRechnungVon()
     * @uses CT_Partner::setGruppenvertragspartner()
     * @uses CT_Partner::setPartnerbeziehung()
     * @uses CT_Partner::setVertrauensperson()
     * @uses CT_Partner::setKreditkarte()
     * @uses CT_Partner::setUmsatzsteuerIdentifikationsnummer()
     * @uses CT_Partner::setAltePartnernummer()
     * @uses CT_Partner::setBesteuerung()
     * @uses CT_Partner::setDirektmarketing()
     * @uses CT_Partner::setFinanzamt()
     * @uses CT_Partner::setPartneranmerkung()
     * @uses CT_Partner::setBriefanrede()
     * @uses CT_Partner::setKommunikationspartner()
     * @uses CT_Partner::setPartnernummerExtern()
     * @uses CT_Partner::setVollmachtgeber()
     * @param string $anrede
     * @param string $name
     * @param string $namenszusatz1
     * @param string $namenszusatz2
     * @param string $partnernummerVM
     * @param string $partnernummer
     * @param bool $vorsteuerabzugsberechtigt
     * @param string $partnerID
     * @param \BiPRO\StructType\CT_Partneranschrift[] $anschrift
     * @param \BiPRO\StructType\CT_ZusaetzlichePartnerdaten[] $zusaetzlichePartnerdaten
     * @param \BiPRO\StructType\CT_Kommunikationsverbindung[] $kommunikationsverbindung
     * @param \BiPRO\StructType\CT_BankverbindungBasis[] $bankverbindung
     * @param \BiPRO\StructType\CT_HandeltAufRechnungVon[] $handeltAufRechnungVon
     * @param \BiPRO\StructType\CT_Gruppenvertragspartner[] $gruppenvertragspartner
     * @param \BiPRO\StructType\CT_Partnerbeziehung[] $partnerbeziehung
     * @param \BiPRO\StructType\CT_Vertrauensperson $vertrauensperson
     * @param \BiPRO\StructType\CT_Kreditkarte[] $kreditkarte
     * @param string $umsatzsteuerIdentifikationsnummer
     * @param string $altePartnernummer
     * @param \BiPRO\StructType\CT_Besteuerung $besteuerung
     * @param \BiPRO\StructType\CT_Werbeerlaubnis[] $direktmarketing
     * @param string $finanzamt
     * @param string $partneranmerkung
     * @param string $briefanrede
     * @param \BiPRO\StructType\CT_Kommunikationspartner $kommunikationspartner
     * @param \BiPRO\StructType\CT_Partnernummer[] $partnernummerExtern
     * @param \BiPRO\StructType\CT_Vollmachtgeber $vollmachtgeber
     */
    public function __construct($anrede = null, $name = null, $namenszusatz1 = null, $namenszusatz2 = null, $partnernummerVM = null, $partnernummer = null, $vorsteuerabzugsberechtigt = null, $partnerID = null, array $anschrift = array(), array $zusaetzlichePartnerdaten = array(), array $kommunikationsverbindung = array(), array $bankverbindung = array(), array $handeltAufRechnungVon = array(), array $gruppenvertragspartner = array(), array $partnerbeziehung = array(), \BiPRO\StructType\CT_Vertrauensperson $vertrauensperson = null, array $kreditkarte = array(), $umsatzsteuerIdentifikationsnummer = null, $altePartnernummer = null, \BiPRO\StructType\CT_Besteuerung $besteuerung = null, array $direktmarketing = array(), $finanzamt = null, $partneranmerkung = null, $briefanrede = null, \BiPRO\StructType\CT_Kommunikationspartner $kommunikationspartner = null, array $partnernummerExtern = array(), \BiPRO\StructType\CT_Vollmachtgeber $vollmachtgeber = null)
    {
        $this
            ->setAnrede($anrede)
            ->setName($name)
            ->setNamenszusatz1($namenszusatz1)
            ->setNamenszusatz2($namenszusatz2)
            ->setPartnernummerVM($partnernummerVM)
            ->setPartnernummer($partnernummer)
            ->setVorsteuerabzugsberechtigt($vorsteuerabzugsberechtigt)
            ->setPartnerID($partnerID)
            ->setAnschrift($anschrift)
            ->setZusaetzlichePartnerdaten($zusaetzlichePartnerdaten)
            ->setKommunikationsverbindung($kommunikationsverbindung)
            ->setBankverbindung($bankverbindung)
            ->setHandeltAufRechnungVon($handeltAufRechnungVon)
            ->setGruppenvertragspartner($gruppenvertragspartner)
            ->setPartnerbeziehung($partnerbeziehung)
            ->setVertrauensperson($vertrauensperson)
            ->setKreditkarte($kreditkarte)
            ->setUmsatzsteuerIdentifikationsnummer($umsatzsteuerIdentifikationsnummer)
            ->setAltePartnernummer($altePartnernummer)
            ->setBesteuerung($besteuerung)
            ->setDirektmarketing($direktmarketing)
            ->setFinanzamt($finanzamt)
            ->setPartneranmerkung($partneranmerkung)
            ->setBriefanrede($briefanrede)
            ->setKommunikationspartner($kommunikationspartner)
            ->setPartnernummerExtern($partnernummerExtern)
            ->setVollmachtgeber($vollmachtgeber);
    }
    /**
     * Get Anrede value
     * @return string|null
     */
    public function getAnrede()
    {
        return $this->Anrede;
    }
    /**
     * Set Anrede value
     * @uses \BiPRO\EnumType\ST_Anredeschluessel::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Anredeschluessel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $anrede
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setAnrede($anrede = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Anredeschluessel::valueIsValid($anrede)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Anredeschluessel', is_array($anrede) ? implode(', ', $anrede) : var_export($anrede, true), implode(', ', \BiPRO\EnumType\ST_Anredeschluessel::getValidValues())), __LINE__);
        }
        $this->Anrede = $anrede;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($name) && mb_strlen($name) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Namenszusatz1 value
     * @return string|null
     */
    public function getNamenszusatz1()
    {
        return $this->Namenszusatz1;
    }
    /**
     * Set Namenszusatz1 value
     * @param string $namenszusatz1
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setNamenszusatz1($namenszusatz1 = null)
    {
        // validation for constraint: string
        if (!is_null($namenszusatz1) && !is_string($namenszusatz1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namenszusatz1, true), gettype($namenszusatz1)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($namenszusatz1) && mb_strlen($namenszusatz1) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($namenszusatz1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($namenszusatz1) && mb_strlen($namenszusatz1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($namenszusatz1)), __LINE__);
        }
        $this->Namenszusatz1 = $namenszusatz1;
        return $this;
    }
    /**
     * Get Namenszusatz2 value
     * @return string|null
     */
    public function getNamenszusatz2()
    {
        return $this->Namenszusatz2;
    }
    /**
     * Set Namenszusatz2 value
     * @param string $namenszusatz2
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setNamenszusatz2($namenszusatz2 = null)
    {
        // validation for constraint: string
        if (!is_null($namenszusatz2) && !is_string($namenszusatz2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namenszusatz2, true), gettype($namenszusatz2)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($namenszusatz2) && mb_strlen($namenszusatz2) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($namenszusatz2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($namenszusatz2) && mb_strlen($namenszusatz2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($namenszusatz2)), __LINE__);
        }
        $this->Namenszusatz2 = $namenszusatz2;
        return $this;
    }
    /**
     * Get PartnernummerVM value
     * @return string|null
     */
    public function getPartnernummerVM()
    {
        return $this->PartnernummerVM;
    }
    /**
     * Set PartnernummerVM value
     * @param string $partnernummerVM
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setPartnernummerVM($partnernummerVM = null)
    {
        // validation for constraint: string
        if (!is_null($partnernummerVM) && !is_string($partnernummerVM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnernummerVM, true), gettype($partnernummerVM)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($partnernummerVM) && mb_strlen($partnernummerVM) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($partnernummerVM)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($partnernummerVM) && mb_strlen($partnernummerVM) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($partnernummerVM)), __LINE__);
        }
        $this->PartnernummerVM = $partnernummerVM;
        return $this;
    }
    /**
     * Get Partnernummer value
     * @return string|null
     */
    public function getPartnernummer()
    {
        return $this->Partnernummer;
    }
    /**
     * Set Partnernummer value
     * @param string $partnernummer
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setPartnernummer($partnernummer = null)
    {
        // validation for constraint: string
        if (!is_null($partnernummer) && !is_string($partnernummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnernummer, true), gettype($partnernummer)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($partnernummer) && mb_strlen($partnernummer) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($partnernummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($partnernummer) && mb_strlen($partnernummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($partnernummer)), __LINE__);
        }
        $this->Partnernummer = $partnernummer;
        return $this;
    }
    /**
     * Get Vorsteuerabzugsberechtigt value
     * @return bool|null
     */
    public function getVorsteuerabzugsberechtigt()
    {
        return $this->Vorsteuerabzugsberechtigt;
    }
    /**
     * Set Vorsteuerabzugsberechtigt value
     * @param bool $vorsteuerabzugsberechtigt
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setVorsteuerabzugsberechtigt($vorsteuerabzugsberechtigt = null)
    {
        // validation for constraint: boolean
        if (!is_null($vorsteuerabzugsberechtigt) && !is_bool($vorsteuerabzugsberechtigt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vorsteuerabzugsberechtigt, true), gettype($vorsteuerabzugsberechtigt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($vorsteuerabzugsberechtigt) && !preg_match('/true|false/', $vorsteuerabzugsberechtigt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($vorsteuerabzugsberechtigt, true)), __LINE__);
        }
        $this->Vorsteuerabzugsberechtigt = $vorsteuerabzugsberechtigt;
        return $this;
    }
    /**
     * Get PartnerID value
     * @return string|null
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }
    /**
     * Set PartnerID value
     * @param string $partnerID
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setPartnerID($partnerID = null)
    {
        // validation for constraint: string
        if (!is_null($partnerID) && !is_string($partnerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerID, true), gettype($partnerID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($partnerID) && mb_strlen($partnerID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($partnerID)), __LINE__);
        }
        $this->PartnerID = $partnerID;
        return $this;
    }
    /**
     * Get Anschrift value
     * @return \BiPRO\StructType\CT_Partneranschrift[]|null
     */
    public function getAnschrift()
    {
        return $this->Anschrift;
    }
    /**
     * This method is responsible for validating the values passed to the setAnschrift method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnschrift method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnschriftForArrayConstraintsFromSetAnschrift(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_PartnerAnschriftItem) {
            // validation for constraint: itemType
            if (!$cT_PartnerAnschriftItem instanceof \BiPRO\StructType\CT_Partneranschrift) {
                $invalidValues[] = is_object($cT_PartnerAnschriftItem) ? get_class($cT_PartnerAnschriftItem) : sprintf('%s(%s)', gettype($cT_PartnerAnschriftItem), var_export($cT_PartnerAnschriftItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Anschrift property can only contain items of type \BiPRO\StructType\CT_Partneranschrift, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Anschrift value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Partneranschrift[] $anschrift
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setAnschrift(array $anschrift = array())
    {
        // validation for constraint: array
        if ('' !== ($anschriftArrayErrorMessage = self::validateAnschriftForArrayConstraintsFromSetAnschrift($anschrift))) {
            throw new \InvalidArgumentException($anschriftArrayErrorMessage, __LINE__);
        }
        $this->Anschrift = $anschrift;
        return $this;
    }
    /**
     * Add item to Anschrift value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Partneranschrift $item
     * @return \BiPRO\StructType\CT_Partner
     */
    public function addToAnschrift(\BiPRO\StructType\CT_Partneranschrift $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Partneranschrift) {
            throw new \InvalidArgumentException(sprintf('The Anschrift property can only contain items of type \BiPRO\StructType\CT_Partneranschrift, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Anschrift[] = $item;
        return $this;
    }
    /**
     * Get ZusaetzlichePartnerdaten value
     * @return \BiPRO\StructType\CT_ZusaetzlichePartnerdaten[]|null
     */
    public function getZusaetzlichePartnerdaten()
    {
        return $this->ZusaetzlichePartnerdaten;
    }
    /**
     * This method is responsible for validating the values passed to the setZusaetzlichePartnerdaten method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZusaetzlichePartnerdaten method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZusaetzlichePartnerdatenForArrayConstraintsFromSetZusaetzlichePartnerdaten(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_PartnerZusaetzlichePartnerdatenItem) {
            // validation for constraint: itemType
            if (!$cT_PartnerZusaetzlichePartnerdatenItem instanceof \BiPRO\StructType\CT_ZusaetzlichePartnerdaten) {
                $invalidValues[] = is_object($cT_PartnerZusaetzlichePartnerdatenItem) ? get_class($cT_PartnerZusaetzlichePartnerdatenItem) : sprintf('%s(%s)', gettype($cT_PartnerZusaetzlichePartnerdatenItem), var_export($cT_PartnerZusaetzlichePartnerdatenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ZusaetzlichePartnerdaten property can only contain items of type \BiPRO\StructType\CT_ZusaetzlichePartnerdaten, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ZusaetzlichePartnerdaten value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_ZusaetzlichePartnerdaten[] $zusaetzlichePartnerdaten
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setZusaetzlichePartnerdaten(array $zusaetzlichePartnerdaten = array())
    {
        // validation for constraint: array
        if ('' !== ($zusaetzlichePartnerdatenArrayErrorMessage = self::validateZusaetzlichePartnerdatenForArrayConstraintsFromSetZusaetzlichePartnerdaten($zusaetzlichePartnerdaten))) {
            throw new \InvalidArgumentException($zusaetzlichePartnerdatenArrayErrorMessage, __LINE__);
        }
        $this->ZusaetzlichePartnerdaten = $zusaetzlichePartnerdaten;
        return $this;
    }
    /**
     * Add item to ZusaetzlichePartnerdaten value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_ZusaetzlichePartnerdaten $item
     * @return \BiPRO\StructType\CT_Partner
     */
    public function addToZusaetzlichePartnerdaten(\BiPRO\StructType\CT_ZusaetzlichePartnerdaten $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_ZusaetzlichePartnerdaten) {
            throw new \InvalidArgumentException(sprintf('The ZusaetzlichePartnerdaten property can only contain items of type \BiPRO\StructType\CT_ZusaetzlichePartnerdaten, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ZusaetzlichePartnerdaten[] = $item;
        return $this;
    }
    /**
     * Get Kommunikationsverbindung value
     * @return \BiPRO\StructType\CT_Kommunikationsverbindung[]|null
     */
    public function getKommunikationsverbindung()
    {
        return $this->Kommunikationsverbindung;
    }
    /**
     * This method is responsible for validating the values passed to the setKommunikationsverbindung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKommunikationsverbindung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKommunikationsverbindungForArrayConstraintsFromSetKommunikationsverbindung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_PartnerKommunikationsverbindungItem) {
            // validation for constraint: itemType
            if (!$cT_PartnerKommunikationsverbindungItem instanceof \BiPRO\StructType\CT_Kommunikationsverbindung) {
                $invalidValues[] = is_object($cT_PartnerKommunikationsverbindungItem) ? get_class($cT_PartnerKommunikationsverbindungItem) : sprintf('%s(%s)', gettype($cT_PartnerKommunikationsverbindungItem), var_export($cT_PartnerKommunikationsverbindungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Kommunikationsverbindung property can only contain items of type \BiPRO\StructType\CT_Kommunikationsverbindung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Kommunikationsverbindung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Kommunikationsverbindung[] $kommunikationsverbindung
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setKommunikationsverbindung(array $kommunikationsverbindung = array())
    {
        // validation for constraint: array
        if ('' !== ($kommunikationsverbindungArrayErrorMessage = self::validateKommunikationsverbindungForArrayConstraintsFromSetKommunikationsverbindung($kommunikationsverbindung))) {
            throw new \InvalidArgumentException($kommunikationsverbindungArrayErrorMessage, __LINE__);
        }
        $this->Kommunikationsverbindung = $kommunikationsverbindung;
        return $this;
    }
    /**
     * Add item to Kommunikationsverbindung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Kommunikationsverbindung $item
     * @return \BiPRO\StructType\CT_Partner
     */
    public function addToKommunikationsverbindung(\BiPRO\StructType\CT_Kommunikationsverbindung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Kommunikationsverbindung) {
            throw new \InvalidArgumentException(sprintf('The Kommunikationsverbindung property can only contain items of type \BiPRO\StructType\CT_Kommunikationsverbindung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Kommunikationsverbindung[] = $item;
        return $this;
    }
    /**
     * Get Bankverbindung value
     * @return \BiPRO\StructType\CT_BankverbindungBasis[]|null
     */
    public function getBankverbindung()
    {
        return $this->Bankverbindung;
    }
    /**
     * This method is responsible for validating the values passed to the setBankverbindung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBankverbindung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBankverbindungForArrayConstraintsFromSetBankverbindung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_PartnerBankverbindungItem) {
            // validation for constraint: itemType
            if (!$cT_PartnerBankverbindungItem instanceof \BiPRO\StructType\CT_BankverbindungBasis) {
                $invalidValues[] = is_object($cT_PartnerBankverbindungItem) ? get_class($cT_PartnerBankverbindungItem) : sprintf('%s(%s)', gettype($cT_PartnerBankverbindungItem), var_export($cT_PartnerBankverbindungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Bankverbindung property can only contain items of type \BiPRO\StructType\CT_BankverbindungBasis, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Bankverbindung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_BankverbindungBasis[] $bankverbindung
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setBankverbindung(array $bankverbindung = array())
    {
        // validation for constraint: array
        if ('' !== ($bankverbindungArrayErrorMessage = self::validateBankverbindungForArrayConstraintsFromSetBankverbindung($bankverbindung))) {
            throw new \InvalidArgumentException($bankverbindungArrayErrorMessage, __LINE__);
        }
        $this->Bankverbindung = $bankverbindung;
        return $this;
    }
    /**
     * Add item to Bankverbindung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_BankverbindungBasis $item
     * @return \BiPRO\StructType\CT_Partner
     */
    public function addToBankverbindung(\BiPRO\StructType\CT_BankverbindungBasis $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_BankverbindungBasis) {
            throw new \InvalidArgumentException(sprintf('The Bankverbindung property can only contain items of type \BiPRO\StructType\CT_BankverbindungBasis, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Bankverbindung[] = $item;
        return $this;
    }
    /**
     * Get HandeltAufRechnungVon value
     * @return \BiPRO\StructType\CT_HandeltAufRechnungVon[]|null
     */
    public function getHandeltAufRechnungVon()
    {
        return $this->HandeltAufRechnungVon;
    }
    /**
     * This method is responsible for validating the values passed to the setHandeltAufRechnungVon method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHandeltAufRechnungVon method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHandeltAufRechnungVonForArrayConstraintsFromSetHandeltAufRechnungVon(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_PartnerHandeltAufRechnungVonItem) {
            // validation for constraint: itemType
            if (!$cT_PartnerHandeltAufRechnungVonItem instanceof \BiPRO\StructType\CT_HandeltAufRechnungVon) {
                $invalidValues[] = is_object($cT_PartnerHandeltAufRechnungVonItem) ? get_class($cT_PartnerHandeltAufRechnungVonItem) : sprintf('%s(%s)', gettype($cT_PartnerHandeltAufRechnungVonItem), var_export($cT_PartnerHandeltAufRechnungVonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HandeltAufRechnungVon property can only contain items of type \BiPRO\StructType\CT_HandeltAufRechnungVon, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HandeltAufRechnungVon value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_HandeltAufRechnungVon[] $handeltAufRechnungVon
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setHandeltAufRechnungVon(array $handeltAufRechnungVon = array())
    {
        // validation for constraint: array
        if ('' !== ($handeltAufRechnungVonArrayErrorMessage = self::validateHandeltAufRechnungVonForArrayConstraintsFromSetHandeltAufRechnungVon($handeltAufRechnungVon))) {
            throw new \InvalidArgumentException($handeltAufRechnungVonArrayErrorMessage, __LINE__);
        }
        $this->HandeltAufRechnungVon = $handeltAufRechnungVon;
        return $this;
    }
    /**
     * Add item to HandeltAufRechnungVon value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_HandeltAufRechnungVon $item
     * @return \BiPRO\StructType\CT_Partner
     */
    public function addToHandeltAufRechnungVon(\BiPRO\StructType\CT_HandeltAufRechnungVon $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_HandeltAufRechnungVon) {
            throw new \InvalidArgumentException(sprintf('The HandeltAufRechnungVon property can only contain items of type \BiPRO\StructType\CT_HandeltAufRechnungVon, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HandeltAufRechnungVon[] = $item;
        return $this;
    }
    /**
     * Get Gruppenvertragspartner value
     * @return \BiPRO\StructType\CT_Gruppenvertragspartner[]|null
     */
    public function getGruppenvertragspartner()
    {
        return $this->Gruppenvertragspartner;
    }
    /**
     * This method is responsible for validating the values passed to the setGruppenvertragspartner method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGruppenvertragspartner method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGruppenvertragspartnerForArrayConstraintsFromSetGruppenvertragspartner(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_PartnerGruppenvertragspartnerItem) {
            // validation for constraint: itemType
            if (!$cT_PartnerGruppenvertragspartnerItem instanceof \BiPRO\StructType\CT_Gruppenvertragspartner) {
                $invalidValues[] = is_object($cT_PartnerGruppenvertragspartnerItem) ? get_class($cT_PartnerGruppenvertragspartnerItem) : sprintf('%s(%s)', gettype($cT_PartnerGruppenvertragspartnerItem), var_export($cT_PartnerGruppenvertragspartnerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Gruppenvertragspartner property can only contain items of type \BiPRO\StructType\CT_Gruppenvertragspartner, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Gruppenvertragspartner value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Gruppenvertragspartner[] $gruppenvertragspartner
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setGruppenvertragspartner(array $gruppenvertragspartner = array())
    {
        // validation for constraint: array
        if ('' !== ($gruppenvertragspartnerArrayErrorMessage = self::validateGruppenvertragspartnerForArrayConstraintsFromSetGruppenvertragspartner($gruppenvertragspartner))) {
            throw new \InvalidArgumentException($gruppenvertragspartnerArrayErrorMessage, __LINE__);
        }
        $this->Gruppenvertragspartner = $gruppenvertragspartner;
        return $this;
    }
    /**
     * Add item to Gruppenvertragspartner value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Gruppenvertragspartner $item
     * @return \BiPRO\StructType\CT_Partner
     */
    public function addToGruppenvertragspartner(\BiPRO\StructType\CT_Gruppenvertragspartner $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Gruppenvertragspartner) {
            throw new \InvalidArgumentException(sprintf('The Gruppenvertragspartner property can only contain items of type \BiPRO\StructType\CT_Gruppenvertragspartner, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Gruppenvertragspartner[] = $item;
        return $this;
    }
    /**
     * Get Partnerbeziehung value
     * @return \BiPRO\StructType\CT_Partnerbeziehung[]|null
     */
    public function getPartnerbeziehung()
    {
        return $this->Partnerbeziehung;
    }
    /**
     * This method is responsible for validating the values passed to the setPartnerbeziehung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartnerbeziehung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartnerbeziehungForArrayConstraintsFromSetPartnerbeziehung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_PartnerPartnerbeziehungItem) {
            // validation for constraint: itemType
            if (!$cT_PartnerPartnerbeziehungItem instanceof \BiPRO\StructType\CT_Partnerbeziehung) {
                $invalidValues[] = is_object($cT_PartnerPartnerbeziehungItem) ? get_class($cT_PartnerPartnerbeziehungItem) : sprintf('%s(%s)', gettype($cT_PartnerPartnerbeziehungItem), var_export($cT_PartnerPartnerbeziehungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Partnerbeziehung property can only contain items of type \BiPRO\StructType\CT_Partnerbeziehung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Partnerbeziehung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Partnerbeziehung[] $partnerbeziehung
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setPartnerbeziehung(array $partnerbeziehung = array())
    {
        // validation for constraint: array
        if ('' !== ($partnerbeziehungArrayErrorMessage = self::validatePartnerbeziehungForArrayConstraintsFromSetPartnerbeziehung($partnerbeziehung))) {
            throw new \InvalidArgumentException($partnerbeziehungArrayErrorMessage, __LINE__);
        }
        $this->Partnerbeziehung = $partnerbeziehung;
        return $this;
    }
    /**
     * Add item to Partnerbeziehung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Partnerbeziehung $item
     * @return \BiPRO\StructType\CT_Partner
     */
    public function addToPartnerbeziehung(\BiPRO\StructType\CT_Partnerbeziehung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Partnerbeziehung) {
            throw new \InvalidArgumentException(sprintf('The Partnerbeziehung property can only contain items of type \BiPRO\StructType\CT_Partnerbeziehung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Partnerbeziehung[] = $item;
        return $this;
    }
    /**
     * Get Vertrauensperson value
     * @return \BiPRO\StructType\CT_Vertrauensperson|null
     */
    public function getVertrauensperson()
    {
        return $this->Vertrauensperson;
    }
    /**
     * Set Vertrauensperson value
     * @param \BiPRO\StructType\CT_Vertrauensperson $vertrauensperson
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setVertrauensperson(\BiPRO\StructType\CT_Vertrauensperson $vertrauensperson = null)
    {
        $this->Vertrauensperson = $vertrauensperson;
        return $this;
    }
    /**
     * Get Kreditkarte value
     * @return \BiPRO\StructType\CT_Kreditkarte[]|null
     */
    public function getKreditkarte()
    {
        return $this->Kreditkarte;
    }
    /**
     * This method is responsible for validating the values passed to the setKreditkarte method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKreditkarte method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKreditkarteForArrayConstraintsFromSetKreditkarte(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_PartnerKreditkarteItem) {
            // validation for constraint: itemType
            if (!$cT_PartnerKreditkarteItem instanceof \BiPRO\StructType\CT_Kreditkarte) {
                $invalidValues[] = is_object($cT_PartnerKreditkarteItem) ? get_class($cT_PartnerKreditkarteItem) : sprintf('%s(%s)', gettype($cT_PartnerKreditkarteItem), var_export($cT_PartnerKreditkarteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Kreditkarte property can only contain items of type \BiPRO\StructType\CT_Kreditkarte, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Kreditkarte value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Kreditkarte[] $kreditkarte
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setKreditkarte(array $kreditkarte = array())
    {
        // validation for constraint: array
        if ('' !== ($kreditkarteArrayErrorMessage = self::validateKreditkarteForArrayConstraintsFromSetKreditkarte($kreditkarte))) {
            throw new \InvalidArgumentException($kreditkarteArrayErrorMessage, __LINE__);
        }
        $this->Kreditkarte = $kreditkarte;
        return $this;
    }
    /**
     * Add item to Kreditkarte value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Kreditkarte $item
     * @return \BiPRO\StructType\CT_Partner
     */
    public function addToKreditkarte(\BiPRO\StructType\CT_Kreditkarte $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Kreditkarte) {
            throw new \InvalidArgumentException(sprintf('The Kreditkarte property can only contain items of type \BiPRO\StructType\CT_Kreditkarte, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Kreditkarte[] = $item;
        return $this;
    }
    /**
     * Get UmsatzsteuerIdentifikationsnummer value
     * @return string|null
     */
    public function getUmsatzsteuerIdentifikationsnummer()
    {
        return $this->UmsatzsteuerIdentifikationsnummer;
    }
    /**
     * Set UmsatzsteuerIdentifikationsnummer value
     * @param string $umsatzsteuerIdentifikationsnummer
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setUmsatzsteuerIdentifikationsnummer($umsatzsteuerIdentifikationsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($umsatzsteuerIdentifikationsnummer) && !is_string($umsatzsteuerIdentifikationsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($umsatzsteuerIdentifikationsnummer, true), gettype($umsatzsteuerIdentifikationsnummer)), __LINE__);
        }
        // validation for constraint: maxLength(14)
        if (!is_null($umsatzsteuerIdentifikationsnummer) && mb_strlen($umsatzsteuerIdentifikationsnummer) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 14', mb_strlen($umsatzsteuerIdentifikationsnummer)), __LINE__);
        }
        // validation for constraint: minLength(14)
        if (!is_null($umsatzsteuerIdentifikationsnummer) && mb_strlen($umsatzsteuerIdentifikationsnummer) < 14) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 14', mb_strlen($umsatzsteuerIdentifikationsnummer)), __LINE__);
        }
        $this->UmsatzsteuerIdentifikationsnummer = $umsatzsteuerIdentifikationsnummer;
        return $this;
    }
    /**
     * Get AltePartnernummer value
     * @return string|null
     */
    public function getAltePartnernummer()
    {
        return $this->AltePartnernummer;
    }
    /**
     * Set AltePartnernummer value
     * @param string $altePartnernummer
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setAltePartnernummer($altePartnernummer = null)
    {
        // validation for constraint: string
        if (!is_null($altePartnernummer) && !is_string($altePartnernummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altePartnernummer, true), gettype($altePartnernummer)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($altePartnernummer) && mb_strlen($altePartnernummer) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($altePartnernummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($altePartnernummer) && mb_strlen($altePartnernummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($altePartnernummer)), __LINE__);
        }
        $this->AltePartnernummer = $altePartnernummer;
        return $this;
    }
    /**
     * Get Besteuerung value
     * @return \BiPRO\StructType\CT_Besteuerung|null
     */
    public function getBesteuerung()
    {
        return $this->Besteuerung;
    }
    /**
     * Set Besteuerung value
     * @param \BiPRO\StructType\CT_Besteuerung $besteuerung
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setBesteuerung(\BiPRO\StructType\CT_Besteuerung $besteuerung = null)
    {
        $this->Besteuerung = $besteuerung;
        return $this;
    }
    /**
     * Get Direktmarketing value
     * @return \BiPRO\StructType\CT_Werbeerlaubnis[]|null
     */
    public function getDirektmarketing()
    {
        return $this->Direktmarketing;
    }
    /**
     * This method is responsible for validating the values passed to the setDirektmarketing method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDirektmarketing method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDirektmarketingForArrayConstraintsFromSetDirektmarketing(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_PartnerDirektmarketingItem) {
            // validation for constraint: itemType
            if (!$cT_PartnerDirektmarketingItem instanceof \BiPRO\StructType\CT_Werbeerlaubnis) {
                $invalidValues[] = is_object($cT_PartnerDirektmarketingItem) ? get_class($cT_PartnerDirektmarketingItem) : sprintf('%s(%s)', gettype($cT_PartnerDirektmarketingItem), var_export($cT_PartnerDirektmarketingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Direktmarketing property can only contain items of type \BiPRO\StructType\CT_Werbeerlaubnis, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Direktmarketing value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Werbeerlaubnis[] $direktmarketing
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setDirektmarketing(array $direktmarketing = array())
    {
        // validation for constraint: array
        if ('' !== ($direktmarketingArrayErrorMessage = self::validateDirektmarketingForArrayConstraintsFromSetDirektmarketing($direktmarketing))) {
            throw new \InvalidArgumentException($direktmarketingArrayErrorMessage, __LINE__);
        }
        $this->Direktmarketing = $direktmarketing;
        return $this;
    }
    /**
     * Add item to Direktmarketing value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Werbeerlaubnis $item
     * @return \BiPRO\StructType\CT_Partner
     */
    public function addToDirektmarketing(\BiPRO\StructType\CT_Werbeerlaubnis $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Werbeerlaubnis) {
            throw new \InvalidArgumentException(sprintf('The Direktmarketing property can only contain items of type \BiPRO\StructType\CT_Werbeerlaubnis, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Direktmarketing[] = $item;
        return $this;
    }
    /**
     * Get Finanzamt value
     * @return string|null
     */
    public function getFinanzamt()
    {
        return $this->Finanzamt;
    }
    /**
     * Set Finanzamt value
     * @param string $finanzamt
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setFinanzamt($finanzamt = null)
    {
        // validation for constraint: string
        if (!is_null($finanzamt) && !is_string($finanzamt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($finanzamt, true), gettype($finanzamt)), __LINE__);
        }
        // validation for constraint: pattern(\d{4})
        if (!is_null($finanzamt) && !preg_match('/\\d{4}/', $finanzamt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}', var_export($finanzamt, true)), __LINE__);
        }
        $this->Finanzamt = $finanzamt;
        return $this;
    }
    /**
     * Get Partneranmerkung value
     * @return string|null
     */
    public function getPartneranmerkung()
    {
        return $this->Partneranmerkung;
    }
    /**
     * Set Partneranmerkung value
     * @param string $partneranmerkung
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setPartneranmerkung($partneranmerkung = null)
    {
        // validation for constraint: string
        if (!is_null($partneranmerkung) && !is_string($partneranmerkung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partneranmerkung, true), gettype($partneranmerkung)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($partneranmerkung) && mb_strlen($partneranmerkung) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($partneranmerkung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($partneranmerkung) && mb_strlen($partneranmerkung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($partneranmerkung)), __LINE__);
        }
        $this->Partneranmerkung = $partneranmerkung;
        return $this;
    }
    /**
     * Get Briefanrede value
     * @return string|null
     */
    public function getBriefanrede()
    {
        return $this->Briefanrede;
    }
    /**
     * Set Briefanrede value
     * @param string $briefanrede
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setBriefanrede($briefanrede = null)
    {
        // validation for constraint: string
        if (!is_null($briefanrede) && !is_string($briefanrede)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($briefanrede, true), gettype($briefanrede)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($briefanrede) && mb_strlen($briefanrede) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($briefanrede)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($briefanrede) && mb_strlen($briefanrede) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($briefanrede)), __LINE__);
        }
        $this->Briefanrede = $briefanrede;
        return $this;
    }
    /**
     * Get Kommunikationspartner value
     * @return \BiPRO\StructType\CT_Kommunikationspartner|null
     */
    public function getKommunikationspartner()
    {
        return $this->Kommunikationspartner;
    }
    /**
     * Set Kommunikationspartner value
     * @param \BiPRO\StructType\CT_Kommunikationspartner $kommunikationspartner
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setKommunikationspartner(\BiPRO\StructType\CT_Kommunikationspartner $kommunikationspartner = null)
    {
        $this->Kommunikationspartner = $kommunikationspartner;
        return $this;
    }
    /**
     * Get PartnernummerExtern value
     * @return \BiPRO\StructType\CT_Partnernummer[]|null
     */
    public function getPartnernummerExtern()
    {
        return $this->PartnernummerExtern;
    }
    /**
     * This method is responsible for validating the values passed to the setPartnernummerExtern method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartnernummerExtern method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartnernummerExternForArrayConstraintsFromSetPartnernummerExtern(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_PartnerPartnernummerExternItem) {
            // validation for constraint: itemType
            if (!$cT_PartnerPartnernummerExternItem instanceof \BiPRO\StructType\CT_Partnernummer) {
                $invalidValues[] = is_object($cT_PartnerPartnernummerExternItem) ? get_class($cT_PartnerPartnernummerExternItem) : sprintf('%s(%s)', gettype($cT_PartnerPartnernummerExternItem), var_export($cT_PartnerPartnernummerExternItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PartnernummerExtern property can only contain items of type \BiPRO\StructType\CT_Partnernummer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PartnernummerExtern value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Partnernummer[] $partnernummerExtern
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setPartnernummerExtern(array $partnernummerExtern = array())
    {
        // validation for constraint: array
        if ('' !== ($partnernummerExternArrayErrorMessage = self::validatePartnernummerExternForArrayConstraintsFromSetPartnernummerExtern($partnernummerExtern))) {
            throw new \InvalidArgumentException($partnernummerExternArrayErrorMessage, __LINE__);
        }
        $this->PartnernummerExtern = $partnernummerExtern;
        return $this;
    }
    /**
     * Add item to PartnernummerExtern value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Partnernummer $item
     * @return \BiPRO\StructType\CT_Partner
     */
    public function addToPartnernummerExtern(\BiPRO\StructType\CT_Partnernummer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Partnernummer) {
            throw new \InvalidArgumentException(sprintf('The PartnernummerExtern property can only contain items of type \BiPRO\StructType\CT_Partnernummer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PartnernummerExtern[] = $item;
        return $this;
    }
    /**
     * Get Vollmachtgeber value
     * @return \BiPRO\StructType\CT_Vollmachtgeber|null
     */
    public function getVollmachtgeber()
    {
        return $this->Vollmachtgeber;
    }
    /**
     * Set Vollmachtgeber value
     * @param \BiPRO\StructType\CT_Vollmachtgeber $vollmachtgeber
     * @return \BiPRO\StructType\CT_Partner
     */
    public function setVollmachtgeber(\BiPRO\StructType\CT_Vollmachtgeber $vollmachtgeber = null)
    {
        $this->Vollmachtgeber = $vollmachtgeber;
        return $this;
    }
}
