<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_PKWNutzung StructType
 * @subpackage Structs
 */
class CT_PKWNutzung extends CT_FahrzeugnutzungErweitert
{
    /**
     * The BegleitetesFahrenVN
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $BegleitetesFahrenVN;
    /**
     * The BegleitetesFahrenNutzer
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $BegleitetesFahrenNutzer;
    /**
     * Constructor method for CT_PKWNutzung
     * @uses CT_PKWNutzung::setBegleitetesFahrenVN()
     * @uses CT_PKWNutzung::setBegleitetesFahrenNutzer()
     * @param bool $begleitetesFahrenVN
     * @param bool $begleitetesFahrenNutzer
     */
    public function __construct($begleitetesFahrenVN = null, $begleitetesFahrenNutzer = null)
    {
        $this
            ->setBegleitetesFahrenVN($begleitetesFahrenVN)
            ->setBegleitetesFahrenNutzer($begleitetesFahrenNutzer);
    }
    /**
     * Get BegleitetesFahrenVN value
     * @return bool|null
     */
    public function getBegleitetesFahrenVN()
    {
        return $this->BegleitetesFahrenVN;
    }
    /**
     * Set BegleitetesFahrenVN value
     * @param bool $begleitetesFahrenVN
     * @return \BiPRO\StructType\CT_PKWNutzung
     */
    public function setBegleitetesFahrenVN($begleitetesFahrenVN = null)
    {
        // validation for constraint: boolean
        if (!is_null($begleitetesFahrenVN) && !is_bool($begleitetesFahrenVN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($begleitetesFahrenVN, true), gettype($begleitetesFahrenVN)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($begleitetesFahrenVN) && !preg_match('/true|false/', $begleitetesFahrenVN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($begleitetesFahrenVN, true)), __LINE__);
        }
        $this->BegleitetesFahrenVN = $begleitetesFahrenVN;
        return $this;
    }
    /**
     * Get BegleitetesFahrenNutzer value
     * @return bool|null
     */
    public function getBegleitetesFahrenNutzer()
    {
        return $this->BegleitetesFahrenNutzer;
    }
    /**
     * Set BegleitetesFahrenNutzer value
     * @param bool $begleitetesFahrenNutzer
     * @return \BiPRO\StructType\CT_PKWNutzung
     */
    public function setBegleitetesFahrenNutzer($begleitetesFahrenNutzer = null)
    {
        // validation for constraint: boolean
        if (!is_null($begleitetesFahrenNutzer) && !is_bool($begleitetesFahrenNutzer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($begleitetesFahrenNutzer, true), gettype($begleitetesFahrenNutzer)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($begleitetesFahrenNutzer) && !preg_match('/true|false/', $begleitetesFahrenNutzer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($begleitetesFahrenNutzer, true)), __LINE__);
        }
        $this->BegleitetesFahrenNutzer = $begleitetesFahrenNutzer;
        return $this;
    }
}
