<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_PKW StructType
 * Meta information extracted from the WSDL
 * - documentation: WKZ 112
 * @subpackage Structs
 */
class CT_PKW extends CT_Fahrzeug
{
    /**
     * The ManuelleTypklasse
     * Meta information extracted from the WSDL
     * - documentation: Typklassen werden nicht maschinell aus Hersteller und Typschluessel ermittelt, sondern manuell erfasst.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $ManuelleTypklasse;
    /**
     * The PKWNutzung
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_PKWNutzung
     */
    public $PKWNutzung;
    /**
     * The ArtDerZulassungBeimVorbesitzer
     * Meta information extracted from the WSDL
     * - documentation: Art der Zulassung beim direkten Vorbesitzer des aktuellen Besitzers.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtDerZulassungBeimVorbesitzer;
    /**
     * Constructor method for CT_PKW
     * @uses CT_PKW::setManuelleTypklasse()
     * @uses CT_PKW::setPKWNutzung()
     * @uses CT_PKW::setArtDerZulassungBeimVorbesitzer()
     * @param bool $manuelleTypklasse
     * @param \BiPRO\StructType\CT_PKWNutzung $pKWNutzung
     * @param string $artDerZulassungBeimVorbesitzer
     */
    public function __construct($manuelleTypklasse = null, \BiPRO\StructType\CT_PKWNutzung $pKWNutzung = null, $artDerZulassungBeimVorbesitzer = null)
    {
        $this
            ->setManuelleTypklasse($manuelleTypklasse)
            ->setPKWNutzung($pKWNutzung)
            ->setArtDerZulassungBeimVorbesitzer($artDerZulassungBeimVorbesitzer);
    }
    /**
     * Get ManuelleTypklasse value
     * @return bool|null
     */
    public function getManuelleTypklasse()
    {
        return $this->ManuelleTypklasse;
    }
    /**
     * Set ManuelleTypklasse value
     * @param bool $manuelleTypklasse
     * @return \BiPRO\StructType\CT_PKW
     */
    public function setManuelleTypklasse($manuelleTypklasse = null)
    {
        // validation for constraint: boolean
        if (!is_null($manuelleTypklasse) && !is_bool($manuelleTypklasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($manuelleTypklasse, true), gettype($manuelleTypklasse)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($manuelleTypklasse) && !preg_match('/true|false/', $manuelleTypklasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($manuelleTypklasse, true)), __LINE__);
        }
        $this->ManuelleTypklasse = $manuelleTypklasse;
        return $this;
    }
    /**
     * Get PKWNutzung value
     * @return \BiPRO\StructType\CT_PKWNutzung|null
     */
    public function getPKWNutzung()
    {
        return $this->PKWNutzung;
    }
    /**
     * Set PKWNutzung value
     * @param \BiPRO\StructType\CT_PKWNutzung $pKWNutzung
     * @return \BiPRO\StructType\CT_PKW
     */
    public function setPKWNutzung(\BiPRO\StructType\CT_PKWNutzung $pKWNutzung = null)
    {
        $this->PKWNutzung = $pKWNutzung;
        return $this;
    }
    /**
     * Get ArtDerZulassungBeimVorbesitzer value
     * @return string|null
     */
    public function getArtDerZulassungBeimVorbesitzer()
    {
        return $this->ArtDerZulassungBeimVorbesitzer;
    }
    /**
     * Set ArtDerZulassungBeimVorbesitzer value
     * @uses \BiPRO\EnumType\ST_ArtDerZulassung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_ArtDerZulassung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artDerZulassungBeimVorbesitzer
     * @return \BiPRO\StructType\CT_PKW
     */
    public function setArtDerZulassungBeimVorbesitzer($artDerZulassungBeimVorbesitzer = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_ArtDerZulassung::valueIsValid($artDerZulassungBeimVorbesitzer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_ArtDerZulassung', is_array($artDerZulassungBeimVorbesitzer) ? implode(', ', $artDerZulassungBeimVorbesitzer) : var_export($artDerZulassungBeimVorbesitzer, true), implode(', ', \BiPRO\EnumType\ST_ArtDerZulassung::getValidValues())), __LINE__);
        }
        $this->ArtDerZulassungBeimVorbesitzer = $artDerZulassungBeimVorbesitzer;
        return $this;
    }
}
