<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Notifikation StructType
 * @subpackage Structs
 */
class CT_Notifikation extends CT_Objekt
{
    /**
     * The Versand
     * Meta information extracted from the WSDL
     * - documentation: Datum des Versands der Notifikation entsprechend Versandart des referenzierten Mandats. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Versand;
    /**
     * The BetroffenerVertrag
     * Meta information extracted from the WSDL
     * - documentation: Als betroffener Vertrag gilt derjenige Vertrag, dessen Beitrag in der von der Notifikation angekündigten Abbuchung(en) enthalten ist.Es MÜSSEN alle betroffenen Verträge angegeben werden.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \BiPRO\StructType\CT_Vertragsnummer[]
     */
    public $BetroffenerVertrag;
    /**
     * The Mandat
     * Meta information extracted from the WSDL
     * - documentation: Das Mandat auf dessen Grundlage die Notifikation erfolgt.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \BiPRO\StructType\CT_Mandat
     */
    public $Mandat;
    /**
     * The Abbuchung
     * Meta information extracted from the WSDL
     * - documentation: Die in der Notifikation angekündigte(n) Abbuchung(en).
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \BiPRO\StructType\CT_Abbuchung[]
     */
    public $Abbuchung;
    /**
     * Constructor method for CT_Notifikation
     * @uses CT_Notifikation::setVersand()
     * @uses CT_Notifikation::setBetroffenerVertrag()
     * @uses CT_Notifikation::setMandat()
     * @uses CT_Notifikation::setAbbuchung()
     * @param string $versand
     * @param \BiPRO\StructType\CT_Vertragsnummer[] $betroffenerVertrag
     * @param \BiPRO\StructType\CT_Mandat $mandat
     * @param \BiPRO\StructType\CT_Abbuchung[] $abbuchung
     */
    public function __construct($versand = null, array $betroffenerVertrag = array(), \BiPRO\StructType\CT_Mandat $mandat = null, array $abbuchung = array())
    {
        $this
            ->setVersand($versand)
            ->setBetroffenerVertrag($betroffenerVertrag)
            ->setMandat($mandat)
            ->setAbbuchung($abbuchung);
    }
    /**
     * Get Versand value
     * @return string
     */
    public function getVersand()
    {
        return $this->Versand;
    }
    /**
     * Set Versand value
     * @param string $versand
     * @return \BiPRO\StructType\CT_Notifikation
     */
    public function setVersand($versand = null)
    {
        // validation for constraint: string
        if (!is_null($versand) && !is_string($versand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versand, true), gettype($versand)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($versand) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $versand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($versand, true)), __LINE__);
        }
        $this->Versand = $versand;
        return $this;
    }
    /**
     * Get BetroffenerVertrag value
     * @return \BiPRO\StructType\CT_Vertragsnummer[]
     */
    public function getBetroffenerVertrag()
    {
        return $this->BetroffenerVertrag;
    }
    /**
     * This method is responsible for validating the values passed to the setBetroffenerVertrag method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBetroffenerVertrag method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBetroffenerVertragForArrayConstraintsFromSetBetroffenerVertrag(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_NotifikationBetroffenerVertragItem) {
            // validation for constraint: itemType
            if (!$cT_NotifikationBetroffenerVertragItem instanceof \BiPRO\StructType\CT_Vertragsnummer) {
                $invalidValues[] = is_object($cT_NotifikationBetroffenerVertragItem) ? get_class($cT_NotifikationBetroffenerVertragItem) : sprintf('%s(%s)', gettype($cT_NotifikationBetroffenerVertragItem), var_export($cT_NotifikationBetroffenerVertragItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BetroffenerVertrag property can only contain items of type \BiPRO\StructType\CT_Vertragsnummer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BetroffenerVertrag value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vertragsnummer[] $betroffenerVertrag
     * @return \BiPRO\StructType\CT_Notifikation
     */
    public function setBetroffenerVertrag(array $betroffenerVertrag = array())
    {
        // validation for constraint: array
        if ('' !== ($betroffenerVertragArrayErrorMessage = self::validateBetroffenerVertragForArrayConstraintsFromSetBetroffenerVertrag($betroffenerVertrag))) {
            throw new \InvalidArgumentException($betroffenerVertragArrayErrorMessage, __LINE__);
        }
        $this->BetroffenerVertrag = $betroffenerVertrag;
        return $this;
    }
    /**
     * Add item to BetroffenerVertrag value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vertragsnummer $item
     * @return \BiPRO\StructType\CT_Notifikation
     */
    public function addToBetroffenerVertrag(\BiPRO\StructType\CT_Vertragsnummer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Vertragsnummer) {
            throw new \InvalidArgumentException(sprintf('The BetroffenerVertrag property can only contain items of type \BiPRO\StructType\CT_Vertragsnummer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BetroffenerVertrag[] = $item;
        return $this;
    }
    /**
     * Get Mandat value
     * @return \BiPRO\StructType\CT_Mandat
     */
    public function getMandat()
    {
        return $this->Mandat;
    }
    /**
     * Set Mandat value
     * @param \BiPRO\StructType\CT_Mandat $mandat
     * @return \BiPRO\StructType\CT_Notifikation
     */
    public function setMandat(\BiPRO\StructType\CT_Mandat $mandat = null)
    {
        $this->Mandat = $mandat;
        return $this;
    }
    /**
     * Get Abbuchung value
     * @return \BiPRO\StructType\CT_Abbuchung[]
     */
    public function getAbbuchung()
    {
        return $this->Abbuchung;
    }
    /**
     * This method is responsible for validating the values passed to the setAbbuchung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAbbuchung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAbbuchungForArrayConstraintsFromSetAbbuchung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_NotifikationAbbuchungItem) {
            // validation for constraint: itemType
            if (!$cT_NotifikationAbbuchungItem instanceof \BiPRO\StructType\CT_Abbuchung) {
                $invalidValues[] = is_object($cT_NotifikationAbbuchungItem) ? get_class($cT_NotifikationAbbuchungItem) : sprintf('%s(%s)', gettype($cT_NotifikationAbbuchungItem), var_export($cT_NotifikationAbbuchungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Abbuchung property can only contain items of type \BiPRO\StructType\CT_Abbuchung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Abbuchung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Abbuchung[] $abbuchung
     * @return \BiPRO\StructType\CT_Notifikation
     */
    public function setAbbuchung(array $abbuchung = array())
    {
        // validation for constraint: array
        if ('' !== ($abbuchungArrayErrorMessage = self::validateAbbuchungForArrayConstraintsFromSetAbbuchung($abbuchung))) {
            throw new \InvalidArgumentException($abbuchungArrayErrorMessage, __LINE__);
        }
        $this->Abbuchung = $abbuchung;
        return $this;
    }
    /**
     * Add item to Abbuchung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Abbuchung $item
     * @return \BiPRO\StructType\CT_Notifikation
     */
    public function addToAbbuchung(\BiPRO\StructType\CT_Abbuchung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Abbuchung) {
            throw new \InvalidArgumentException(sprintf('The Abbuchung property can only contain items of type \BiPRO\StructType\CT_Abbuchung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Abbuchung[] = $item;
        return $this;
    }
}
