<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Luftfahrzeug StructType
 * Meta information extracted from the WSDL
 * - documentation: Ein Luftfahrzeug ist ein Gerät, das innerhalb der Erdatmosphäre fliegt oder fährt.
 * @subpackage Structs
 */
class CT_Luftfahrzeug extends CT_Gegenstand
{
    /**
     * The Fluggewicht
     * Meta information extracted from the WSDL
     * - documentation: Fluggewicht des Luftfahrzeuges
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Fluggewicht;
    /**
     * The Fluggewichteinheit
     * Meta information extracted from the WSDL
     * - documentation: Einheit des Fluggewichts.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fluggewichteinheit;
    /**
     * The Luftfahrzeugtyp
     * Meta information extracted from the WSDL
     * - documentation: Typ des Luftfahrzeugs
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Luftfahrzeugtyp;
    /**
     * Constructor method for CT_Luftfahrzeug
     * @uses CT_Luftfahrzeug::setFluggewicht()
     * @uses CT_Luftfahrzeug::setFluggewichteinheit()
     * @uses CT_Luftfahrzeug::setLuftfahrzeugtyp()
     * @param float $fluggewicht
     * @param string $fluggewichteinheit
     * @param string $luftfahrzeugtyp
     */
    public function __construct($fluggewicht = null, $fluggewichteinheit = null, $luftfahrzeugtyp = null)
    {
        $this
            ->setFluggewicht($fluggewicht)
            ->setFluggewichteinheit($fluggewichteinheit)
            ->setLuftfahrzeugtyp($luftfahrzeugtyp);
    }
    /**
     * Get Fluggewicht value
     * @return float|null
     */
    public function getFluggewicht()
    {
        return $this->Fluggewicht;
    }
    /**
     * Set Fluggewicht value
     * @param float $fluggewicht
     * @return \BiPRO\StructType\CT_Luftfahrzeug
     */
    public function setFluggewicht($fluggewicht = null)
    {
        // validation for constraint: float
        if (!is_null($fluggewicht) && !(is_float($fluggewicht) || is_numeric($fluggewicht))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fluggewicht, true), gettype($fluggewicht)), __LINE__);
        }
        $this->Fluggewicht = $fluggewicht;
        return $this;
    }
    /**
     * Get Fluggewichteinheit value
     * @return string|null
     */
    public function getFluggewichteinheit()
    {
        return $this->Fluggewichteinheit;
    }
    /**
     * Set Fluggewichteinheit value
     * @uses \BiPRO\EnumType\ST_Werteinheit::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Werteinheit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fluggewichteinheit
     * @return \BiPRO\StructType\CT_Luftfahrzeug
     */
    public function setFluggewichteinheit($fluggewichteinheit = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Werteinheit::valueIsValid($fluggewichteinheit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Werteinheit', is_array($fluggewichteinheit) ? implode(', ', $fluggewichteinheit) : var_export($fluggewichteinheit, true), implode(', ', \BiPRO\EnumType\ST_Werteinheit::getValidValues())), __LINE__);
        }
        $this->Fluggewichteinheit = $fluggewichteinheit;
        return $this;
    }
    /**
     * Get Luftfahrzeugtyp value
     * @return string|null
     */
    public function getLuftfahrzeugtyp()
    {
        return $this->Luftfahrzeugtyp;
    }
    /**
     * Set Luftfahrzeugtyp value
     * @uses \BiPRO\EnumType\ST_Luftfahrzeugtyp::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Luftfahrzeugtyp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $luftfahrzeugtyp
     * @return \BiPRO\StructType\CT_Luftfahrzeug
     */
    public function setLuftfahrzeugtyp($luftfahrzeugtyp = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Luftfahrzeugtyp::valueIsValid($luftfahrzeugtyp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Luftfahrzeugtyp', is_array($luftfahrzeugtyp) ? implode(', ', $luftfahrzeugtyp) : var_export($luftfahrzeugtyp, true), implode(', ', \BiPRO\EnumType\ST_Luftfahrzeugtyp::getValidValues())), __LINE__);
        }
        $this->Luftfahrzeugtyp = $luftfahrzeugtyp;
        return $this;
    }
}
