<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Leistungserbringer StructType
 * Meta information extracted from the WSDL
 * - documentation: Partner, der eine Leistung erbringt (z.B. Werkstatt, Handwerker, Mietwagenfirma, Assistance-Dienstleister).
 * @subpackage Structs
 */
class CT_Leistungserbringer extends CT_Partnerrolle
{
    /**
     * The SchadenmanagementPartner
     * Meta information extracted from the WSDL
     * - documentation: JA = Leistungserbringer ist Partner im SchadenmanagementNEIN = Leistungserbringer ist kein Partner im Schadenmanagement
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $SchadenmanagementPartner;
    /**
     * The BewertungFuerNPS
     * Meta information extracted from the WSDL
     * - documentation: Antwort des Leistungsempfängers zur Frage der Weiterempfehlung des Leistungserbringers im Rahmen des Net Promoter Scores (NPS) auf der Skala von 0 (unwahrscheinlich) - 10 (wahrscheinlich).98 = keine Angabe vom Kunden99 = unbekannt
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $BewertungFuerNPS;
    /**
     * Constructor method for CT_Leistungserbringer
     * @uses CT_Leistungserbringer::setSchadenmanagementPartner()
     * @uses CT_Leistungserbringer::setBewertungFuerNPS()
     * @param bool $schadenmanagementPartner
     * @param int $bewertungFuerNPS
     */
    public function __construct($schadenmanagementPartner = null, $bewertungFuerNPS = null)
    {
        $this
            ->setSchadenmanagementPartner($schadenmanagementPartner)
            ->setBewertungFuerNPS($bewertungFuerNPS);
    }
    /**
     * Get SchadenmanagementPartner value
     * @return bool|null
     */
    public function getSchadenmanagementPartner()
    {
        return $this->SchadenmanagementPartner;
    }
    /**
     * Set SchadenmanagementPartner value
     * @param bool $schadenmanagementPartner
     * @return \BiPRO\StructType\CT_Leistungserbringer
     */
    public function setSchadenmanagementPartner($schadenmanagementPartner = null)
    {
        // validation for constraint: boolean
        if (!is_null($schadenmanagementPartner) && !is_bool($schadenmanagementPartner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($schadenmanagementPartner, true), gettype($schadenmanagementPartner)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($schadenmanagementPartner) && !preg_match('/true|false/', $schadenmanagementPartner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($schadenmanagementPartner, true)), __LINE__);
        }
        $this->SchadenmanagementPartner = $schadenmanagementPartner;
        return $this;
    }
    /**
     * Get BewertungFuerNPS value
     * @return int|null
     */
    public function getBewertungFuerNPS()
    {
        return $this->BewertungFuerNPS;
    }
    /**
     * Set BewertungFuerNPS value
     * @param int $bewertungFuerNPS
     * @return \BiPRO\StructType\CT_Leistungserbringer
     */
    public function setBewertungFuerNPS($bewertungFuerNPS = null)
    {
        // validation for constraint: int
        if (!is_null($bewertungFuerNPS) && !(is_int($bewertungFuerNPS) || ctype_digit($bewertungFuerNPS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bewertungFuerNPS, true), gettype($bewertungFuerNPS)), __LINE__);
        }
        $this->BewertungFuerNPS = $bewertungFuerNPS;
        return $this;
    }
}
