<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Leistung StructType
 * Meta information extracted from the WSDL
 * - documentation: Verrichtung, die zumeist durch einen Dritten erbracht wird (durch einen Leistungserbringer), z.B. Reparatur, Mietwagen bereitstellen, Abschleppen, Bergen.
 * @subpackage Structs
 */
class CT_Leistung extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Art der Leistung.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \BiPRO\StructType\STE_Schadenleistungsart
     */
    public $ArtID;
    /**
     * The Leistungsart
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung der Leistungsart, wenn die ArtID = 99 (Sonstige Leistung).
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Leistungsart;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Status zur Durchführung der Leistung.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The Abtretungserklaerung
     * Meta information extracted from the WSDL
     * - documentation: Definition: Die Abtretungserklärung ist ein Anspruchsübergang von dem Geschädigten oder Versicherungsnehmer an den Leistungserbringer.JA = Für den Leistungserbringer liegt eine Abtretungserklärung vom Geschädigten bzw.
     * Versicherungsnehmer vor.NEIN = Für den Leistungserbringer liegt eine Abtretungserklärung vom Geschädigten bzw. Versicherungsnehmer nicht vor.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Abtretungserklaerung;
    /**
     * The Kostenuebernahmeerklaerung
     * Meta information extracted from the WSDL
     * - documentation: Definition: Mit einer Kostenübernahmeerklärung erklärt sich das Versicherungsunternehmen bereit, im Rahmen seiner Eintrittspflicht die Aufwände der Werkstatt oder des Leistungserbringers zu übernehmen.JA =
     * Kostenübernahmeerklärung liegt vor.NEIN = Kostenübernahmeerklärung liegt nicht vor.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Kostenuebernahmeerklaerung;
    /**
     * The Leistungserbringer
     * Meta information extracted from the WSDL
     * - documentation: Partner, der die Leistung erbringt (z.B. Werkstatt, Handwerker, Mietwagenfirma).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Leistungserbringer
     */
    public $Leistungserbringer;
    /**
     * Constructor method for CT_Leistung
     * @uses CT_Leistung::setArtID()
     * @uses CT_Leistung::setLeistungsart()
     * @uses CT_Leistung::setStatus()
     * @uses CT_Leistung::setAbtretungserklaerung()
     * @uses CT_Leistung::setKostenuebernahmeerklaerung()
     * @uses CT_Leistung::setLeistungserbringer()
     * @param \BiPRO\StructType\STE_Schadenleistungsart $artID
     * @param string $leistungsart
     * @param string $status
     * @param bool $abtretungserklaerung
     * @param bool $kostenuebernahmeerklaerung
     * @param \BiPRO\StructType\CT_Leistungserbringer $leistungserbringer
     */
    public function __construct(\BiPRO\StructType\STE_Schadenleistungsart $artID = null, $leistungsart = null, $status = null, $abtretungserklaerung = null, $kostenuebernahmeerklaerung = null, \BiPRO\StructType\CT_Leistungserbringer $leistungserbringer = null)
    {
        $this
            ->setArtID($artID)
            ->setLeistungsart($leistungsart)
            ->setStatus($status)
            ->setAbtretungserklaerung($abtretungserklaerung)
            ->setKostenuebernahmeerklaerung($kostenuebernahmeerklaerung)
            ->setLeistungserbringer($leistungserbringer);
    }
    /**
     * Get ArtID value
     * @return \BiPRO\StructType\STE_Schadenleistungsart
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @param \BiPRO\StructType\STE_Schadenleistungsart $artID
     * @return \BiPRO\StructType\CT_Leistung
     */
    public function setArtID(\BiPRO\StructType\STE_Schadenleistungsart $artID = null)
    {
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Leistungsart value
     * @return string|null
     */
    public function getLeistungsart()
    {
        return $this->Leistungsart;
    }
    /**
     * Set Leistungsart value
     * @param string $leistungsart
     * @return \BiPRO\StructType\CT_Leistung
     */
    public function setLeistungsart($leistungsart = null)
    {
        // validation for constraint: string
        if (!is_null($leistungsart) && !is_string($leistungsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leistungsart, true), gettype($leistungsart)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($leistungsart) && mb_strlen($leistungsart) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($leistungsart)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($leistungsart) && mb_strlen($leistungsart) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($leistungsart)), __LINE__);
        }
        $this->Leistungsart = $leistungsart;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \BiPRO\EnumType\ST_Leistungsstatus::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Leistungsstatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \BiPRO\StructType\CT_Leistung
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Leistungsstatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Leistungsstatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \BiPRO\EnumType\ST_Leistungsstatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Abtretungserklaerung value
     * @return bool|null
     */
    public function getAbtretungserklaerung()
    {
        return $this->Abtretungserklaerung;
    }
    /**
     * Set Abtretungserklaerung value
     * @param bool $abtretungserklaerung
     * @return \BiPRO\StructType\CT_Leistung
     */
    public function setAbtretungserklaerung($abtretungserklaerung = null)
    {
        // validation for constraint: boolean
        if (!is_null($abtretungserklaerung) && !is_bool($abtretungserklaerung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($abtretungserklaerung, true), gettype($abtretungserklaerung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($abtretungserklaerung) && !preg_match('/true|false/', $abtretungserklaerung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($abtretungserklaerung, true)), __LINE__);
        }
        $this->Abtretungserklaerung = $abtretungserklaerung;
        return $this;
    }
    /**
     * Get Kostenuebernahmeerklaerung value
     * @return bool|null
     */
    public function getKostenuebernahmeerklaerung()
    {
        return $this->Kostenuebernahmeerklaerung;
    }
    /**
     * Set Kostenuebernahmeerklaerung value
     * @param bool $kostenuebernahmeerklaerung
     * @return \BiPRO\StructType\CT_Leistung
     */
    public function setKostenuebernahmeerklaerung($kostenuebernahmeerklaerung = null)
    {
        // validation for constraint: boolean
        if (!is_null($kostenuebernahmeerklaerung) && !is_bool($kostenuebernahmeerklaerung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kostenuebernahmeerklaerung, true), gettype($kostenuebernahmeerklaerung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($kostenuebernahmeerklaerung) && !preg_match('/true|false/', $kostenuebernahmeerklaerung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($kostenuebernahmeerklaerung, true)), __LINE__);
        }
        $this->Kostenuebernahmeerklaerung = $kostenuebernahmeerklaerung;
        return $this;
    }
    /**
     * Get Leistungserbringer value
     * @return \BiPRO\StructType\CT_Leistungserbringer|null
     */
    public function getLeistungserbringer()
    {
        return $this->Leistungserbringer;
    }
    /**
     * Set Leistungserbringer value
     * @param \BiPRO\StructType\CT_Leistungserbringer $leistungserbringer
     * @return \BiPRO\StructType\CT_Leistung
     */
    public function setLeistungserbringer(\BiPRO\StructType\CT_Leistungserbringer $leistungserbringer = null)
    {
        $this->Leistungserbringer = $leistungserbringer;
        return $this;
    }
}
