<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_LeichtKradRoller StructType
 * Meta information extracted from the WSDL
 * - documentation: WKZ 003, 030, 031
 * @subpackage Structs
 */
class CT_LeichtKradRoller extends CT_Fahrzeug
{
    /**
     * The Hoechstgeschwindigkeit
     * Meta information extracted from the WSDL
     * - documentation: Höchstgeschwindigkeit in km/h.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Hoechstgeschwindigkeit;
    /**
     * The AnzahlPlaetze
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der Sitzplätze.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlPlaetze;
    /**
     * The Leergewicht
     * Meta information extracted from the WSDL
     * - documentation: Leergewicht in kg.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Leergewicht;
    /**
     * The LeichtKradRollerNutzung
     * Meta information extracted from the WSDL
     * - documentation: Nutzung des LeichtKradRollers.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_LeichtKradRollerNutzung
     */
    public $LeichtKradRollerNutzung;
    /**
     * Constructor method for CT_LeichtKradRoller
     * @uses CT_LeichtKradRoller::setHoechstgeschwindigkeit()
     * @uses CT_LeichtKradRoller::setAnzahlPlaetze()
     * @uses CT_LeichtKradRoller::setLeergewicht()
     * @uses CT_LeichtKradRoller::setLeichtKradRollerNutzung()
     * @param int $hoechstgeschwindigkeit
     * @param int $anzahlPlaetze
     * @param int $leergewicht
     * @param \BiPRO\StructType\CT_LeichtKradRollerNutzung $leichtKradRollerNutzung
     */
    public function __construct($hoechstgeschwindigkeit = null, $anzahlPlaetze = null, $leergewicht = null, \BiPRO\StructType\CT_LeichtKradRollerNutzung $leichtKradRollerNutzung = null)
    {
        $this
            ->setHoechstgeschwindigkeit($hoechstgeschwindigkeit)
            ->setAnzahlPlaetze($anzahlPlaetze)
            ->setLeergewicht($leergewicht)
            ->setLeichtKradRollerNutzung($leichtKradRollerNutzung);
    }
    /**
     * Get Hoechstgeschwindigkeit value
     * @return int|null
     */
    public function getHoechstgeschwindigkeit()
    {
        return $this->Hoechstgeschwindigkeit;
    }
    /**
     * Set Hoechstgeschwindigkeit value
     * @param int $hoechstgeschwindigkeit
     * @return \BiPRO\StructType\CT_LeichtKradRoller
     */
    public function setHoechstgeschwindigkeit($hoechstgeschwindigkeit = null)
    {
        // validation for constraint: int
        if (!is_null($hoechstgeschwindigkeit) && !(is_int($hoechstgeschwindigkeit) || ctype_digit($hoechstgeschwindigkeit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hoechstgeschwindigkeit, true), gettype($hoechstgeschwindigkeit)), __LINE__);
        }
        $this->Hoechstgeschwindigkeit = $hoechstgeschwindigkeit;
        return $this;
    }
    /**
     * Get AnzahlPlaetze value
     * @return int|null
     */
    public function getAnzahlPlaetze()
    {
        return $this->AnzahlPlaetze;
    }
    /**
     * Set AnzahlPlaetze value
     * @param int $anzahlPlaetze
     * @return \BiPRO\StructType\CT_LeichtKradRoller
     */
    public function setAnzahlPlaetze($anzahlPlaetze = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlPlaetze) && !(is_int($anzahlPlaetze) || ctype_digit($anzahlPlaetze))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlPlaetze, true), gettype($anzahlPlaetze)), __LINE__);
        }
        $this->AnzahlPlaetze = $anzahlPlaetze;
        return $this;
    }
    /**
     * Get Leergewicht value
     * @return int|null
     */
    public function getLeergewicht()
    {
        return $this->Leergewicht;
    }
    /**
     * Set Leergewicht value
     * @param int $leergewicht
     * @return \BiPRO\StructType\CT_LeichtKradRoller
     */
    public function setLeergewicht($leergewicht = null)
    {
        // validation for constraint: int
        if (!is_null($leergewicht) && !(is_int($leergewicht) || ctype_digit($leergewicht))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($leergewicht, true), gettype($leergewicht)), __LINE__);
        }
        $this->Leergewicht = $leergewicht;
        return $this;
    }
    /**
     * Get LeichtKradRollerNutzung value
     * @return \BiPRO\StructType\CT_LeichtKradRollerNutzung|null
     */
    public function getLeichtKradRollerNutzung()
    {
        return $this->LeichtKradRollerNutzung;
    }
    /**
     * Set LeichtKradRollerNutzung value
     * @param \BiPRO\StructType\CT_LeichtKradRollerNutzung $leichtKradRollerNutzung
     * @return \BiPRO\StructType\CT_LeichtKradRoller
     */
    public function setLeichtKradRollerNutzung(\BiPRO\StructType\CT_LeichtKradRollerNutzung $leichtKradRollerNutzung = null)
    {
        $this->LeichtKradRollerNutzung = $leichtKradRollerNutzung;
        return $this;
    }
}
