<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_LKWNutzung StructType
 * @subpackage Structs
 */
class CT_LKWNutzung extends CT_Fahrzeugnutzung
{
    /**
     * The Gefahrgut
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Gefahrgut;
    /**
     * The Fahrgebiet
     * Meta information extracted from the WSDL
     * - documentation: Fahrgebiet oder Nutzungsgebiet
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fahrgebiet;
    /**
     * The TransportierteGueter
     * Meta information extracted from the WSDL
     * - documentation: Gibt an ob eigene oder fremde Güter transportiert werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransportierteGueter;
    /**
     * The Gefahrgutklasse
     * Meta information extracted from the WSDL
     * - documentation: Angabe der Gefahrgutklasse.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Gefahrgutklasse;
    /**
     * Constructor method for CT_LKWNutzung
     * @uses CT_LKWNutzung::setGefahrgut()
     * @uses CT_LKWNutzung::setFahrgebiet()
     * @uses CT_LKWNutzung::setTransportierteGueter()
     * @uses CT_LKWNutzung::setGefahrgutklasse()
     * @param string $gefahrgut
     * @param string $fahrgebiet
     * @param string $transportierteGueter
     * @param string $gefahrgutklasse
     */
    public function __construct($gefahrgut = null, $fahrgebiet = null, $transportierteGueter = null, $gefahrgutklasse = null)
    {
        $this
            ->setGefahrgut($gefahrgut)
            ->setFahrgebiet($fahrgebiet)
            ->setTransportierteGueter($transportierteGueter)
            ->setGefahrgutklasse($gefahrgutklasse);
    }
    /**
     * Get Gefahrgut value
     * @return string|null
     */
    public function getGefahrgut()
    {
        return $this->Gefahrgut;
    }
    /**
     * Set Gefahrgut value
     * @uses \BiPRO\EnumType\ST_Gefahrgut::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Gefahrgut::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gefahrgut
     * @return \BiPRO\StructType\CT_LKWNutzung
     */
    public function setGefahrgut($gefahrgut = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Gefahrgut::valueIsValid($gefahrgut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Gefahrgut', is_array($gefahrgut) ? implode(', ', $gefahrgut) : var_export($gefahrgut, true), implode(', ', \BiPRO\EnumType\ST_Gefahrgut::getValidValues())), __LINE__);
        }
        $this->Gefahrgut = $gefahrgut;
        return $this;
    }
    /**
     * Get Fahrgebiet value
     * @return string|null
     */
    public function getFahrgebiet()
    {
        return $this->Fahrgebiet;
    }
    /**
     * Set Fahrgebiet value
     * @uses \BiPRO\EnumType\ST_Fahrgebiet::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Fahrgebiet::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fahrgebiet
     * @return \BiPRO\StructType\CT_LKWNutzung
     */
    public function setFahrgebiet($fahrgebiet = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Fahrgebiet::valueIsValid($fahrgebiet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Fahrgebiet', is_array($fahrgebiet) ? implode(', ', $fahrgebiet) : var_export($fahrgebiet, true), implode(', ', \BiPRO\EnumType\ST_Fahrgebiet::getValidValues())), __LINE__);
        }
        $this->Fahrgebiet = $fahrgebiet;
        return $this;
    }
    /**
     * Get TransportierteGueter value
     * @return string|null
     */
    public function getTransportierteGueter()
    {
        return $this->TransportierteGueter;
    }
    /**
     * Set TransportierteGueter value
     * @uses \BiPRO\EnumType\ST_TransportierteGueter::valueIsValid()
     * @uses \BiPRO\EnumType\ST_TransportierteGueter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transportierteGueter
     * @return \BiPRO\StructType\CT_LKWNutzung
     */
    public function setTransportierteGueter($transportierteGueter = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_TransportierteGueter::valueIsValid($transportierteGueter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_TransportierteGueter', is_array($transportierteGueter) ? implode(', ', $transportierteGueter) : var_export($transportierteGueter, true), implode(', ', \BiPRO\EnumType\ST_TransportierteGueter::getValidValues())), __LINE__);
        }
        $this->TransportierteGueter = $transportierteGueter;
        return $this;
    }
    /**
     * Get Gefahrgutklasse value
     * @return string|null
     */
    public function getGefahrgutklasse()
    {
        return $this->Gefahrgutklasse;
    }
    /**
     * Set Gefahrgutklasse value
     * @uses \BiPRO\EnumType\ST_Gefahrgutklasse::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Gefahrgutklasse::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gefahrgutklasse
     * @return \BiPRO\StructType\CT_LKWNutzung
     */
    public function setGefahrgutklasse($gefahrgutklasse = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Gefahrgutklasse::valueIsValid($gefahrgutklasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Gefahrgutklasse', is_array($gefahrgutklasse) ? implode(', ', $gefahrgutklasse) : var_export($gefahrgutklasse, true), implode(', ', \BiPRO\EnumType\ST_Gefahrgutklasse::getValidValues())), __LINE__);
        }
        $this->Gefahrgutklasse = $gefahrgutklasse;
        return $this;
    }
}
