<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_KradTrikeQuad StructType
 * Meta information extracted from the WSDL
 * - documentation: WKZ 003, 030, 031
 * @subpackage Structs
 */
class CT_KradTrikeQuad extends CT_Fahrzeug
{
    /**
     * The ABS
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $ABS;
    /**
     * The KradTrikeQuadNutzung
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_KradTrikeQuadNutzung
     */
    public $KradTrikeQuadNutzung;
    /**
     * The ArtDerZulassungBeimVorbesitzer
     * Meta information extracted from the WSDL
     * - documentation: Art der Zulassung beim direkten Vorbesitzer des aktuellen Besitzers.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtDerZulassungBeimVorbesitzer;
    /**
     * The Hoechstgeschwindigkeit
     * Meta information extracted from the WSDL
     * - documentation: Höchstgeschwindigkeit in km/h.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Hoechstgeschwindigkeit;
    /**
     * The AnzahlPlaetze
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der Sitzplätze.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlPlaetze;
    /**
     * The Leergewicht
     * Meta information extracted from the WSDL
     * - documentation: Leergewicht in kg.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Leergewicht;
    /**
     * Constructor method for CT_KradTrikeQuad
     * @uses CT_KradTrikeQuad::setABS()
     * @uses CT_KradTrikeQuad::setKradTrikeQuadNutzung()
     * @uses CT_KradTrikeQuad::setArtDerZulassungBeimVorbesitzer()
     * @uses CT_KradTrikeQuad::setHoechstgeschwindigkeit()
     * @uses CT_KradTrikeQuad::setAnzahlPlaetze()
     * @uses CT_KradTrikeQuad::setLeergewicht()
     * @param bool $aBS
     * @param \BiPRO\StructType\CT_KradTrikeQuadNutzung $kradTrikeQuadNutzung
     * @param string $artDerZulassungBeimVorbesitzer
     * @param int $hoechstgeschwindigkeit
     * @param int $anzahlPlaetze
     * @param int $leergewicht
     */
    public function __construct($aBS = null, \BiPRO\StructType\CT_KradTrikeQuadNutzung $kradTrikeQuadNutzung = null, $artDerZulassungBeimVorbesitzer = null, $hoechstgeschwindigkeit = null, $anzahlPlaetze = null, $leergewicht = null)
    {
        $this
            ->setABS($aBS)
            ->setKradTrikeQuadNutzung($kradTrikeQuadNutzung)
            ->setArtDerZulassungBeimVorbesitzer($artDerZulassungBeimVorbesitzer)
            ->setHoechstgeschwindigkeit($hoechstgeschwindigkeit)
            ->setAnzahlPlaetze($anzahlPlaetze)
            ->setLeergewicht($leergewicht);
    }
    /**
     * Get ABS value
     * @return bool|null
     */
    public function getABS()
    {
        return $this->ABS;
    }
    /**
     * Set ABS value
     * @param bool $aBS
     * @return \BiPRO\StructType\CT_KradTrikeQuad
     */
    public function setABS($aBS = null)
    {
        // validation for constraint: boolean
        if (!is_null($aBS) && !is_bool($aBS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aBS, true), gettype($aBS)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($aBS) && !preg_match('/true|false/', $aBS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($aBS, true)), __LINE__);
        }
        $this->ABS = $aBS;
        return $this;
    }
    /**
     * Get KradTrikeQuadNutzung value
     * @return \BiPRO\StructType\CT_KradTrikeQuadNutzung|null
     */
    public function getKradTrikeQuadNutzung()
    {
        return $this->KradTrikeQuadNutzung;
    }
    /**
     * Set KradTrikeQuadNutzung value
     * @param \BiPRO\StructType\CT_KradTrikeQuadNutzung $kradTrikeQuadNutzung
     * @return \BiPRO\StructType\CT_KradTrikeQuad
     */
    public function setKradTrikeQuadNutzung(\BiPRO\StructType\CT_KradTrikeQuadNutzung $kradTrikeQuadNutzung = null)
    {
        $this->KradTrikeQuadNutzung = $kradTrikeQuadNutzung;
        return $this;
    }
    /**
     * Get ArtDerZulassungBeimVorbesitzer value
     * @return string|null
     */
    public function getArtDerZulassungBeimVorbesitzer()
    {
        return $this->ArtDerZulassungBeimVorbesitzer;
    }
    /**
     * Set ArtDerZulassungBeimVorbesitzer value
     * @uses \BiPRO\EnumType\ST_ArtDerZulassung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_ArtDerZulassung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artDerZulassungBeimVorbesitzer
     * @return \BiPRO\StructType\CT_KradTrikeQuad
     */
    public function setArtDerZulassungBeimVorbesitzer($artDerZulassungBeimVorbesitzer = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_ArtDerZulassung::valueIsValid($artDerZulassungBeimVorbesitzer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_ArtDerZulassung', is_array($artDerZulassungBeimVorbesitzer) ? implode(', ', $artDerZulassungBeimVorbesitzer) : var_export($artDerZulassungBeimVorbesitzer, true), implode(', ', \BiPRO\EnumType\ST_ArtDerZulassung::getValidValues())), __LINE__);
        }
        $this->ArtDerZulassungBeimVorbesitzer = $artDerZulassungBeimVorbesitzer;
        return $this;
    }
    /**
     * Get Hoechstgeschwindigkeit value
     * @return int|null
     */
    public function getHoechstgeschwindigkeit()
    {
        return $this->Hoechstgeschwindigkeit;
    }
    /**
     * Set Hoechstgeschwindigkeit value
     * @param int $hoechstgeschwindigkeit
     * @return \BiPRO\StructType\CT_KradTrikeQuad
     */
    public function setHoechstgeschwindigkeit($hoechstgeschwindigkeit = null)
    {
        // validation for constraint: int
        if (!is_null($hoechstgeschwindigkeit) && !(is_int($hoechstgeschwindigkeit) || ctype_digit($hoechstgeschwindigkeit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hoechstgeschwindigkeit, true), gettype($hoechstgeschwindigkeit)), __LINE__);
        }
        $this->Hoechstgeschwindigkeit = $hoechstgeschwindigkeit;
        return $this;
    }
    /**
     * Get AnzahlPlaetze value
     * @return int|null
     */
    public function getAnzahlPlaetze()
    {
        return $this->AnzahlPlaetze;
    }
    /**
     * Set AnzahlPlaetze value
     * @param int $anzahlPlaetze
     * @return \BiPRO\StructType\CT_KradTrikeQuad
     */
    public function setAnzahlPlaetze($anzahlPlaetze = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlPlaetze) && !(is_int($anzahlPlaetze) || ctype_digit($anzahlPlaetze))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlPlaetze, true), gettype($anzahlPlaetze)), __LINE__);
        }
        $this->AnzahlPlaetze = $anzahlPlaetze;
        return $this;
    }
    /**
     * Get Leergewicht value
     * @return int|null
     */
    public function getLeergewicht()
    {
        return $this->Leergewicht;
    }
    /**
     * Set Leergewicht value
     * @param int $leergewicht
     * @return \BiPRO\StructType\CT_KradTrikeQuad
     */
    public function setLeergewicht($leergewicht = null)
    {
        // validation for constraint: int
        if (!is_null($leergewicht) && !(is_int($leergewicht) || ctype_digit($leergewicht))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($leergewicht, true), gettype($leergewicht)), __LINE__);
        }
        $this->Leergewicht = $leergewicht;
        return $this;
    }
}
