<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Kondition StructType
 * Meta information extracted from the WSDL
 * - documentation: Alles was den Preis beeinflusst ist eine Kondition. Wird der Leistungsumfang oder das versicherte Risiko beschrieben, MUSS dies über ein Attribut im Datenmodell abgebildet werden. Konditionen erhalten über die fachliche Ebene ihren
 * Kontext und sind für alle Ebenen relevant. Beispiele: Verkaufsprodukt = Bündelungsnachlass; Produkt = Mehrpersonennachlass in Unfall; Elementarprodukt = BU-Zuschlag in Leben. Konditonen DÜRFEN NICHT auf der nächst höheren Ebene als Summe
 * dargestellt werden.
 * @subpackage Structs
 */
class CT_Kondition extends CT_Objekt
{
    /**
     * The KategorieID
     * Meta information extracted from the WSDL
     * - documentation: Mit der KategorieID wird festgelegt ob es sich bei der Kondition um einen Zuschlag oder Abschlag handelt. Wenn das Attribut Kondition/Wert gefüllt ist, MUSS eine KategorieID angegeben werden. Wenn kein Wert vorhanden ist, DARF die
     * KategorieID ignoriert werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_KategorieID
     */
    public $KategorieID;
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Wertfreier Name der Kondition. Ob es sich bei der Kondition um einen Zu- oder Abschlag handelt MUSS über das Attribut KategorieID festgelegt werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Kondition
     */
    public $ArtID;
    /**
     * The Wert
     * Meta information extracted from the WSDL
     * - documentation: Berechnungsgrundlage gemaess Einheit, z. B. Prozentsatz oder Waehrungsbetrag. Die Ausprägung DARF NICHT mit Vorzeichen geliefert werden. Ob es sich um einen Zu- oder Abschlag handelt wird über das Attribut KategorieID gesteuert.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Wert;
    /**
     * The Werteinheit
     * Meta information extracted from the WSDL
     * - documentation: Einheit der Berechnungsgrundlage.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Werteinheit;
    /**
     * The Grund
     * Meta information extracted from the WSDL
     * - documentation: Textliche Begründung zur vereinbarten Kondition.
     * - base: xsd:string
     * - maxLength: 1000
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Grund;
    /**
     * The Waehrung
     * Meta information extracted from the WSDL
     * - documentation: Waehrungsschluessel. MUSS angegeben werden, wenn für das Attribut Werteinheit der Wert 20 (Währung gem. Währungsschlüssel) gewählt wurde.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Waehrung;
    /**
     * The Gueltigkeit
     * Meta information extracted from the WSDL
     * - documentation: Zeitraum, während dem die Kondition gültig ist.Der Zeitraum MUSS konkret angegeben werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum
     */
    public $Gueltigkeit;
    /**
     * The Bezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Eine für Menschen verständliche Bezeichnung der Kondition. DARF NICHT anstelle einer ArtID genutzt werden.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Bezeichnung;
    /**
     * Constructor method for CT_Kondition
     * @uses CT_Kondition::setKategorieID()
     * @uses CT_Kondition::setArtID()
     * @uses CT_Kondition::setWert()
     * @uses CT_Kondition::setWerteinheit()
     * @uses CT_Kondition::setGrund()
     * @uses CT_Kondition::setWaehrung()
     * @uses CT_Kondition::setGueltigkeit()
     * @uses CT_Kondition::setBezeichnung()
     * @param \BiPRO\StructType\STE_KategorieID $kategorieID
     * @param \BiPRO\StructType\STE_Kondition $artID
     * @param float $wert
     * @param string $werteinheit
     * @param string $grund
     * @param string $waehrung
     * @param \BiPRO\StructType\CT_Zeitraum $gueltigkeit
     * @param string $bezeichnung
     */
    public function __construct(\BiPRO\StructType\STE_KategorieID $kategorieID = null, \BiPRO\StructType\STE_Kondition $artID = null, $wert = null, $werteinheit = null, $grund = null, $waehrung = null, \BiPRO\StructType\CT_Zeitraum $gueltigkeit = null, $bezeichnung = null)
    {
        $this
            ->setKategorieID($kategorieID)
            ->setArtID($artID)
            ->setWert($wert)
            ->setWerteinheit($werteinheit)
            ->setGrund($grund)
            ->setWaehrung($waehrung)
            ->setGueltigkeit($gueltigkeit)
            ->setBezeichnung($bezeichnung);
    }
    /**
     * Get KategorieID value
     * @return \BiPRO\StructType\STE_KategorieID|null
     */
    public function getKategorieID()
    {
        return $this->KategorieID;
    }
    /**
     * Set KategorieID value
     * @param \BiPRO\StructType\STE_KategorieID $kategorieID
     * @return \BiPRO\StructType\CT_Kondition
     */
    public function setKategorieID(\BiPRO\StructType\STE_KategorieID $kategorieID = null)
    {
        $this->KategorieID = $kategorieID;
        return $this;
    }
    /**
     * Get ArtID value
     * @return \BiPRO\StructType\STE_Kondition|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @param \BiPRO\StructType\STE_Kondition $artID
     * @return \BiPRO\StructType\CT_Kondition
     */
    public function setArtID(\BiPRO\StructType\STE_Kondition $artID = null)
    {
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Wert value
     * @return float|null
     */
    public function getWert()
    {
        return $this->Wert;
    }
    /**
     * Set Wert value
     * @param float $wert
     * @return \BiPRO\StructType\CT_Kondition
     */
    public function setWert($wert = null)
    {
        // validation for constraint: float
        if (!is_null($wert) && !(is_float($wert) || is_numeric($wert))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($wert, true), gettype($wert)), __LINE__);
        }
        $this->Wert = $wert;
        return $this;
    }
    /**
     * Get Werteinheit value
     * @return string|null
     */
    public function getWerteinheit()
    {
        return $this->Werteinheit;
    }
    /**
     * Set Werteinheit value
     * @uses \BiPRO\EnumType\ST_Werteinheit::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Werteinheit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $werteinheit
     * @return \BiPRO\StructType\CT_Kondition
     */
    public function setWerteinheit($werteinheit = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Werteinheit::valueIsValid($werteinheit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Werteinheit', is_array($werteinheit) ? implode(', ', $werteinheit) : var_export($werteinheit, true), implode(', ', \BiPRO\EnumType\ST_Werteinheit::getValidValues())), __LINE__);
        }
        $this->Werteinheit = $werteinheit;
        return $this;
    }
    /**
     * Get Grund value
     * @return string|null
     */
    public function getGrund()
    {
        return $this->Grund;
    }
    /**
     * Set Grund value
     * @param string $grund
     * @return \BiPRO\StructType\CT_Kondition
     */
    public function setGrund($grund = null)
    {
        // validation for constraint: string
        if (!is_null($grund) && !is_string($grund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grund, true), gettype($grund)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($grund) && mb_strlen($grund) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($grund)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($grund) && mb_strlen($grund) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($grund)), __LINE__);
        }
        $this->Grund = $grund;
        return $this;
    }
    /**
     * Get Waehrung value
     * @return string|null
     */
    public function getWaehrung()
    {
        return $this->Waehrung;
    }
    /**
     * Set Waehrung value
     * @uses \BiPRO\EnumType\ST_Waehrungsschluessel::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Waehrungsschluessel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $waehrung
     * @return \BiPRO\StructType\CT_Kondition
     */
    public function setWaehrung($waehrung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Waehrungsschluessel::valueIsValid($waehrung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Waehrungsschluessel', is_array($waehrung) ? implode(', ', $waehrung) : var_export($waehrung, true), implode(', ', \BiPRO\EnumType\ST_Waehrungsschluessel::getValidValues())), __LINE__);
        }
        $this->Waehrung = $waehrung;
        return $this;
    }
    /**
     * Get Gueltigkeit value
     * @return \BiPRO\StructType\CT_Zeitraum|null
     */
    public function getGueltigkeit()
    {
        return $this->Gueltigkeit;
    }
    /**
     * Set Gueltigkeit value
     * @param \BiPRO\StructType\CT_Zeitraum $gueltigkeit
     * @return \BiPRO\StructType\CT_Kondition
     */
    public function setGueltigkeit(\BiPRO\StructType\CT_Zeitraum $gueltigkeit = null)
    {
        $this->Gueltigkeit = $gueltigkeit;
        return $this;
    }
    /**
     * Get Bezeichnung value
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->Bezeichnung;
    }
    /**
     * Set Bezeichnung value
     * @param string $bezeichnung
     * @return \BiPRO\StructType\CT_Kondition
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($bezeichnung) && mb_strlen($bezeichnung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($bezeichnung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($bezeichnung) && mb_strlen($bezeichnung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($bezeichnung)), __LINE__);
        }
        $this->Bezeichnung = $bezeichnung;
        return $this;
    }
}
