<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_KomplexeFrage StructType
 * Meta information extracted from the WSDL
 * - documentation: Eine komplexe Frage ist eine inhaltliche Klammer um mehrere einfache Fragen. Z.B. kann ein Provider zwei einfache Fragen &bdquo;Art der Vorerkrankung&ldquo; und &bdquo;Behandelnder Arzt&ldquo; in einer komplexen Frage zusammenfassen.
 * Komplexe Fragen werden deshalb nicht direkt, sondern indirekt über die enthaltenen einfachen Fragen beantwortet.
 * @subpackage Structs
 */
class CT_KomplexeFrage extends CT_Frage
{
    /**
     * The EinfacheFrage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 2
     * @var \BiPRO\StructType\CT_EinfacheFrage[]
     */
    public $EinfacheFrage;
    /**
     * The FachlicheID
     * Meta information extracted from the WSDL
     * - documentation: Mit dieser ID identifiziert der Provider die Semantik der Frage. Es ist KEINE technische ID, die zur Referenzierung innerhalb des Datenmodells verwendet wird, sondern sie dient zur Auswertung der Antworten beim Provider. Sie kann
     * deshalb im Ermessen des Providers auch mehrfach vorkommen. Dies kann z.B. dann sinnvoll sein, wenn der Provider mehrere gleichartige komplexe Fragen liefert, um mehrere Vorerkrankungen abfragen zu können.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FachlicheID;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - documentation: Der Text der Frage, ist vom Consumer wörtlich, ungekürzt und und unverändert im Frontend darzustellen, um die juristisch einwandfreie Beantwortung der Fragen durch den Benutzer sicherzustellen.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * Constructor method for CT_KomplexeFrage
     * @uses CT_KomplexeFrage::setEinfacheFrage()
     * @uses CT_KomplexeFrage::setFachlicheID()
     * @uses CT_KomplexeFrage::setText()
     * @param \BiPRO\StructType\CT_EinfacheFrage[] $einfacheFrage
     * @param string $fachlicheID
     * @param string $text
     */
    public function __construct(array $einfacheFrage = array(), $fachlicheID = null, $text = null)
    {
        $this
            ->setEinfacheFrage($einfacheFrage)
            ->setFachlicheID($fachlicheID)
            ->setText($text);
    }
    /**
     * Get EinfacheFrage value
     * @return \BiPRO\StructType\CT_EinfacheFrage[]
     */
    public function getEinfacheFrage()
    {
        return $this->EinfacheFrage;
    }
    /**
     * This method is responsible for validating the values passed to the setEinfacheFrage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEinfacheFrage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEinfacheFrageForArrayConstraintsFromSetEinfacheFrage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_KomplexeFrageEinfacheFrageItem) {
            // validation for constraint: itemType
            if (!$cT_KomplexeFrageEinfacheFrageItem instanceof \BiPRO\StructType\CT_EinfacheFrage) {
                $invalidValues[] = is_object($cT_KomplexeFrageEinfacheFrageItem) ? get_class($cT_KomplexeFrageEinfacheFrageItem) : sprintf('%s(%s)', gettype($cT_KomplexeFrageEinfacheFrageItem), var_export($cT_KomplexeFrageEinfacheFrageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EinfacheFrage property can only contain items of type \BiPRO\StructType\CT_EinfacheFrage, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EinfacheFrage value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_EinfacheFrage[] $einfacheFrage
     * @return \BiPRO\StructType\CT_KomplexeFrage
     */
    public function setEinfacheFrage(array $einfacheFrage = array())
    {
        // validation for constraint: array
        if ('' !== ($einfacheFrageArrayErrorMessage = self::validateEinfacheFrageForArrayConstraintsFromSetEinfacheFrage($einfacheFrage))) {
            throw new \InvalidArgumentException($einfacheFrageArrayErrorMessage, __LINE__);
        }
        $this->EinfacheFrage = $einfacheFrage;
        return $this;
    }
    /**
     * Add item to EinfacheFrage value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_EinfacheFrage $item
     * @return \BiPRO\StructType\CT_KomplexeFrage
     */
    public function addToEinfacheFrage(\BiPRO\StructType\CT_EinfacheFrage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_EinfacheFrage) {
            throw new \InvalidArgumentException(sprintf('The EinfacheFrage property can only contain items of type \BiPRO\StructType\CT_EinfacheFrage, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EinfacheFrage[] = $item;
        return $this;
    }
    /**
     * Get FachlicheID value
     * @return string|null
     */
    public function getFachlicheID()
    {
        return $this->FachlicheID;
    }
    /**
     * Set FachlicheID value
     * @param string $fachlicheID
     * @return \BiPRO\StructType\CT_KomplexeFrage
     */
    public function setFachlicheID($fachlicheID = null)
    {
        // validation for constraint: string
        if (!is_null($fachlicheID) && !is_string($fachlicheID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fachlicheID, true), gettype($fachlicheID)), __LINE__);
        }
        $this->FachlicheID = $fachlicheID;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \BiPRO\StructType\CT_KomplexeFrage
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
}
