<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Kommunikationsverbindung StructType
 * Meta information extracted from the WSDL
 * - documentation: Angaben zu Telefon, Fax, Email etc.
 * @subpackage Structs
 */
class CT_Kommunikationsverbindung extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArtID;
    /**
     * The Kommunikationsadresse
     * Meta information extracted from the WSDL
     * - documentation: Hinweise, welcher Wert einzutragen ist, wenn der Kommunikationstyp Online-Dienst ist (Kommunikationsverbindung.ArtID ist 70, 71 oder 72), für jeden dann im Attribut Kommunikationsprovider anzugebenden Anbieter.Wert von
     * Kommunikationsprovider: Inhalt von Kommunikationsadresse001: Username (mit @aim.com) oder registrierte E-Mail-Adresse oder Facebook-Anmelde-ID (Telefon oder bei Facebook registrierte E-Mail-Adresse);002: Facebook-Anmelde-ID bzw. angegebene
     * Telefonnummer oder bei Facebook registrierte E-Mail-Adresse;003: im Profil festgelegte Konto-ID, d.i. die E-Mail-Adresse bei Google oder eine andere E-Mail-Adresse, ersatzweise der vergebene Alias-Name;004: (entfällt);005: die bei der Registrierung
     * festgelegte ICQ-Nummer;006: die bei der Registrierung am XMPP-Server erhaltene Jabber-ID;007: die bei der Registrierung verwendete E-Mail-Adresse oder der angezeigte Alias-Name;008: die verwendete Hotmail-E-Mail-Adresse oder der Skype-Name (als
     * Alias-Name);009: die Microsoft-Live-Messenger-ID oder der Skype-Name (als Alias-Name);010: die bei der Registrierung verwendete E-Mail-Adresse oder der angezeigte Alias-Name;011: die Yahoo-ID auf Basis der bei der Registrierung verwendeten
     * E-Mail-Adresse mit einer der Endungen: @yahoo.de, @yahoo.com, @rocketmail.com, @ymail.com.
     * - base: xsd:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Kommunikationsadresse;
    /**
     * The Referenz
     * Meta information extracted from the WSDL
     * - documentation: Vom Provider generierte, eindeutige Referenznummer zur Identifizierung des Objektes über Prozesse hinweg, insbesondere zwischen Auskunfts- und Änderungsprozessen. | Allgemeiner Datentyp für alle externen, statischen Referenzen zur
     * Identifizierung von Objekten. Mit diesem Datentyp können Objekte über unterschiedliche Nachrichten (z.B. Auskunft und Änderung) hinweg identifiziert werden.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Referenz;
    /**
     * The Kommunikationsprovider
     * Meta information extracted from the WSDL
     * - documentation: Kommunikationsprovider eines Online-Dienstes. Dieses Attribut MUSS angegeben werden, wenn im Attribut ArtID 70, 71 oder 72 verwendet wird. | Kommunikations-Provider eines Online-Dienstes.Die gültigen Werte des Kommunikationsprovider
     * MÜSSEN dem Katalog ST_KatalogKommunikationsprovider entnommen werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $Kommunikationsprovider;
    /**
     * The KommunikationsadresseURI
     * Meta information extracted from the WSDL
     * - documentation: Optional anzugebende formale URI zur Kommunikationsadresse, wenn Kommunikationsverbindung.ArtID 70, 71 oder 72 (Online-Dienst) ist, und für den in Kommunikationsprovider angegeben Online-Dienst ein URI-Scheme definiert wurde (wie
     * derzeit bei AIM, GoogleTalk, ICQ, Jabber, MSN, Skype, Yahoo). Wenn mehrere vom jeweiligen Online-Dienst unterstützte Aktionen angegeben werden sollen, MUSS für jede Aktion ein eigenes Element Kommunikationsverbindung vorhanden sein. | URI (Unified
     * Resource Identifier) nach RFC 3986 oder IANA-registrierte RI (Resource Identifier) mit Scheme (dem Namen des Schemas des Bezeichners), Aktion (Query), sowie einer dem Scheme entsprechenden Benutzerkennung. Dabei MUSS eine Aktion verwendet werden, die
     * zur Kontaktaufnahme mit dem Benutzer benutzt werden kann (z.B. Senden einer Textnachricht, Senden einer Datei, Einladung zu einem Text-Chat, Voice-Call, Video-Call). Die URI MUSS mindestens dem Scheme gemäß wohlgeformt sein. Wenn der Aufbau des
     * Bezeichners dies zulässt, kann die Aktion weggelassen werden, wie z.B. bei Skype.Beispiele:(Online-Dienst:) "Scheme" (mögliche Werte für <action>)(AIM:) "aim:<action>?screenname=<screenname>" (goim|SendChatInvite)(GoogleTalk:)
     * "gtalk:<action>?jid=<jid>" (chat)(ICQ:) "icq:<action>?uin=<uin>" (message)(Jabber:) "xmpp:user@host (XMPP Query)(MSN:) "msnim:<action>?contact=<contact>" (chat|voice|video)(Skype:) "skype:<username|phonenumber>[?<action>]"
     * (call|chat|sendfile)(Yahoo:) "ymsgr:<action>?<screenname>" (sendIM)
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KommunikationsadresseURI;
    /**
     * The Erreichbarkeit
     * Meta information extracted from the WSDL
     * - documentation: Anmerkungen zur Erreichbarkeit unter dieser Kommunikationsverbindung (z.B. zeitlich).
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Erreichbarkeit;
    /**
     * The BevorzugteKommunikationsverbindung
     * Meta information extracted from the WSDL
     * - documentation: Die Kommunikation soll bevorzugt über diese Kommunikationsverbindung erfolgen.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $BevorzugteKommunikationsverbindung;
    /**
     * Constructor method for CT_Kommunikationsverbindung
     * @uses CT_Kommunikationsverbindung::setArtID()
     * @uses CT_Kommunikationsverbindung::setKommunikationsadresse()
     * @uses CT_Kommunikationsverbindung::setReferenz()
     * @uses CT_Kommunikationsverbindung::setKommunikationsprovider()
     * @uses CT_Kommunikationsverbindung::setKommunikationsadresseURI()
     * @uses CT_Kommunikationsverbindung::setErreichbarkeit()
     * @uses CT_Kommunikationsverbindung::setBevorzugteKommunikationsverbindung()
     * @param string $artID
     * @param string $kommunikationsadresse
     * @param string $referenz
     * @param string[] $kommunikationsprovider
     * @param string $kommunikationsadresseURI
     * @param string $erreichbarkeit
     * @param bool $bevorzugteKommunikationsverbindung
     */
    public function __construct($artID = null, $kommunikationsadresse = null, $referenz = null, array $kommunikationsprovider = array(), $kommunikationsadresseURI = null, $erreichbarkeit = null, $bevorzugteKommunikationsverbindung = null)
    {
        $this
            ->setArtID($artID)
            ->setKommunikationsadresse($kommunikationsadresse)
            ->setReferenz($referenz)
            ->setKommunikationsprovider($kommunikationsprovider)
            ->setKommunikationsadresseURI($kommunikationsadresseURI)
            ->setErreichbarkeit($erreichbarkeit)
            ->setBevorzugteKommunikationsverbindung($bevorzugteKommunikationsverbindung);
    }
    /**
     * Get ArtID value
     * @return string
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Kommunikationstyp::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Kommunikationstyp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_Kommunikationsverbindung
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Kommunikationstyp::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Kommunikationstyp', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Kommunikationstyp::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Kommunikationsadresse value
     * @return string|null
     */
    public function getKommunikationsadresse()
    {
        return $this->Kommunikationsadresse;
    }
    /**
     * Set Kommunikationsadresse value
     * @param string $kommunikationsadresse
     * @return \BiPRO\StructType\CT_Kommunikationsverbindung
     */
    public function setKommunikationsadresse($kommunikationsadresse = null)
    {
        // validation for constraint: string
        if (!is_null($kommunikationsadresse) && !is_string($kommunikationsadresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kommunikationsadresse, true), gettype($kommunikationsadresse)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($kommunikationsadresse) && mb_strlen($kommunikationsadresse) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($kommunikationsadresse)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($kommunikationsadresse) && mb_strlen($kommunikationsadresse) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($kommunikationsadresse)), __LINE__);
        }
        $this->Kommunikationsadresse = $kommunikationsadresse;
        return $this;
    }
    /**
     * Get Referenz value
     * @return string|null
     */
    public function getReferenz()
    {
        return $this->Referenz;
    }
    /**
     * Set Referenz value
     * @param string $referenz
     * @return \BiPRO\StructType\CT_Kommunikationsverbindung
     */
    public function setReferenz($referenz = null)
    {
        // validation for constraint: string
        if (!is_null($referenz) && !is_string($referenz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenz, true), gettype($referenz)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($referenz) && mb_strlen($referenz) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($referenz)), __LINE__);
        }
        $this->Referenz = $referenz;
        return $this;
    }
    /**
     * Get Kommunikationsprovider value
     * @return string[]|null
     */
    public function getKommunikationsprovider()
    {
        return $this->Kommunikationsprovider;
    }
    /**
     * This method is responsible for validating the values passed to the setKommunikationsprovider method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKommunikationsprovider method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKommunikationsproviderForArrayConstraintsFromSetKommunikationsprovider(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_KommunikationsverbindungKommunikationsproviderItem) {
            // validation for constraint: itemType
            if (!is_string($cT_KommunikationsverbindungKommunikationsproviderItem)) {
                $invalidValues[] = is_object($cT_KommunikationsverbindungKommunikationsproviderItem) ? get_class($cT_KommunikationsverbindungKommunikationsproviderItem) : sprintf('%s(%s)', gettype($cT_KommunikationsverbindungKommunikationsproviderItem), var_export($cT_KommunikationsverbindungKommunikationsproviderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Kommunikationsprovider property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Kommunikationsprovider value
     * @param string[] $kommunikationsprovider
     * @return \BiPRO\StructType\CT_Kommunikationsverbindung
     */
    public function setKommunikationsprovider(array $kommunikationsprovider = array())
    {
        // validation for constraint: list
        if ('' !== ($kommunikationsproviderArrayErrorMessage = self::validateKommunikationsproviderForArrayConstraintsFromSetKommunikationsprovider($kommunikationsprovider))) {
            throw new \InvalidArgumentException($kommunikationsproviderArrayErrorMessage, __LINE__);
        }
        $this->Kommunikationsprovider = is_array($kommunikationsprovider) ? implode(' ', $kommunikationsprovider) : null;
        return $this;
    }
    /**
     * Get KommunikationsadresseURI value
     * @return string|null
     */
    public function getKommunikationsadresseURI()
    {
        return $this->KommunikationsadresseURI;
    }
    /**
     * Set KommunikationsadresseURI value
     * @param string $kommunikationsadresseURI
     * @return \BiPRO\StructType\CT_Kommunikationsverbindung
     */
    public function setKommunikationsadresseURI($kommunikationsadresseURI = null)
    {
        // validation for constraint: string
        if (!is_null($kommunikationsadresseURI) && !is_string($kommunikationsadresseURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kommunikationsadresseURI, true), gettype($kommunikationsadresseURI)), __LINE__);
        }
        $this->KommunikationsadresseURI = $kommunikationsadresseURI;
        return $this;
    }
    /**
     * Get Erreichbarkeit value
     * @return string|null
     */
    public function getErreichbarkeit()
    {
        return $this->Erreichbarkeit;
    }
    /**
     * Set Erreichbarkeit value
     * @param string $erreichbarkeit
     * @return \BiPRO\StructType\CT_Kommunikationsverbindung
     */
    public function setErreichbarkeit($erreichbarkeit = null)
    {
        // validation for constraint: string
        if (!is_null($erreichbarkeit) && !is_string($erreichbarkeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erreichbarkeit, true), gettype($erreichbarkeit)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($erreichbarkeit) && mb_strlen($erreichbarkeit) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($erreichbarkeit)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($erreichbarkeit) && mb_strlen($erreichbarkeit) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($erreichbarkeit)), __LINE__);
        }
        $this->Erreichbarkeit = $erreichbarkeit;
        return $this;
    }
    /**
     * Get BevorzugteKommunikationsverbindung value
     * @return bool|null
     */
    public function getBevorzugteKommunikationsverbindung()
    {
        return $this->BevorzugteKommunikationsverbindung;
    }
    /**
     * Set BevorzugteKommunikationsverbindung value
     * @param bool $bevorzugteKommunikationsverbindung
     * @return \BiPRO\StructType\CT_Kommunikationsverbindung
     */
    public function setBevorzugteKommunikationsverbindung($bevorzugteKommunikationsverbindung = null)
    {
        // validation for constraint: boolean
        if (!is_null($bevorzugteKommunikationsverbindung) && !is_bool($bevorzugteKommunikationsverbindung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bevorzugteKommunikationsverbindung, true), gettype($bevorzugteKommunikationsverbindung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($bevorzugteKommunikationsverbindung) && !preg_match('/true|false/', $bevorzugteKommunikationsverbindung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($bevorzugteKommunikationsverbindung, true)), __LINE__);
        }
        $this->BevorzugteKommunikationsverbindung = $bevorzugteKommunikationsverbindung;
        return $this;
    }
}
