<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_KfzZusatzVersicherung StructType
 * @subpackage Structs
 */
class CT_KfzZusatzVersicherung extends CT_Elementarprodukt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: VU- spezifische Zusatzprodukte oder Deckungserweiterungen zu KH, KFV, KFT, KU wie z.B.: Schutzbrief, Auslandsschadenschutz, Fahrerunfallschutz, GAP-Deckung, Reparaturservice
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \BiPRO\StructType\STE_KfzZusatzVersicherung
     */
    public $ArtID;
    /**
     * The Tarifierungsmerkmal
     * Meta information extracted from the WSDL
     * - documentation: Tarifierungsmerkmal, z. B. Tarifgruppe / Regionalklasse
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Tarifierungsmerkmal;
    /**
     * The Rabattgrundjahr
     * Meta information extracted from the WSDL
     * - documentation: Grundjahr für die SF-Einstufung
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $Rabattgrundjahr;
    /**
     * The SFKlasse
     * Meta information extracted from the WSDL
     * - documentation: Die für die KfzZusatzVersicherung gültigeSchadenfreiheitsklasse oder Schadenklasse
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_SFKlasseKZusatz
     */
    public $SFKlasse;
    /**
     * The Beitragssatz
     * Meta information extracted from the WSDL
     * - documentation: SF-Beitragssatz in Prozent | Prozentanteil ohne Prozentzeichen z.B. 50 = 50% oder 12,5 = 12,5%
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var float
     */
    public $Beitragssatz;
    /**
     * The SchaedenAusRueckstufung
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der Schäden aus Vorjahr relevant für die Rückstufung
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SchaedenAusRueckstufung;
    /**
     * The Typklasse
     * Meta information extracted from the WSDL
     * - documentation: Typklasse für die KfzZusatzVersicherung
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Typklasse;
    /**
     * The ReduzierteSelbstbeteiligungKFV
     * Meta information extracted from the WSDL
     * - documentation: Betrag, auf den der SB in KFV durch die KfzZusatzVersicherung reduziert wird.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $ReduzierteSelbstbeteiligungKFV;
    /**
     * The ReduzierteSelbstbeteiligungKFT
     * Meta information extracted from the WSDL
     * - documentation: Betrag, auf den der SB in KFT durch die KfzZusatzVersicherung reduziert wird.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $ReduzierteSelbstbeteiligungKFT;
    /**
     * Constructor method for CT_KfzZusatzVersicherung
     * @uses CT_KfzZusatzVersicherung::setArtID()
     * @uses CT_KfzZusatzVersicherung::setTarifierungsmerkmal()
     * @uses CT_KfzZusatzVersicherung::setRabattgrundjahr()
     * @uses CT_KfzZusatzVersicherung::setSFKlasse()
     * @uses CT_KfzZusatzVersicherung::setBeitragssatz()
     * @uses CT_KfzZusatzVersicherung::setSchaedenAusRueckstufung()
     * @uses CT_KfzZusatzVersicherung::setTypklasse()
     * @uses CT_KfzZusatzVersicherung::setReduzierteSelbstbeteiligungKFV()
     * @uses CT_KfzZusatzVersicherung::setReduzierteSelbstbeteiligungKFT()
     * @param \BiPRO\StructType\STE_KfzZusatzVersicherung $artID
     * @param string $tarifierungsmerkmal
     * @param int $rabattgrundjahr
     * @param \BiPRO\StructType\STE_SFKlasseKZusatz $sFKlasse
     * @param float $beitragssatz
     * @param int $schaedenAusRueckstufung
     * @param int $typklasse
     * @param float $reduzierteSelbstbeteiligungKFV
     * @param float $reduzierteSelbstbeteiligungKFT
     */
    public function __construct(\BiPRO\StructType\STE_KfzZusatzVersicherung $artID = null, $tarifierungsmerkmal = null, $rabattgrundjahr = null, \BiPRO\StructType\STE_SFKlasseKZusatz $sFKlasse = null, $beitragssatz = null, $schaedenAusRueckstufung = null, $typklasse = null, $reduzierteSelbstbeteiligungKFV = null, $reduzierteSelbstbeteiligungKFT = null)
    {
        $this
            ->setArtID($artID)
            ->setTarifierungsmerkmal($tarifierungsmerkmal)
            ->setRabattgrundjahr($rabattgrundjahr)
            ->setSFKlasse($sFKlasse)
            ->setBeitragssatz($beitragssatz)
            ->setSchaedenAusRueckstufung($schaedenAusRueckstufung)
            ->setTypklasse($typklasse)
            ->setReduzierteSelbstbeteiligungKFV($reduzierteSelbstbeteiligungKFV)
            ->setReduzierteSelbstbeteiligungKFT($reduzierteSelbstbeteiligungKFT);
    }
    /**
     * Get ArtID value
     * @return \BiPRO\StructType\STE_KfzZusatzVersicherung
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @param \BiPRO\StructType\STE_KfzZusatzVersicherung $artID
     * @return \BiPRO\StructType\CT_KfzZusatzVersicherung
     */
    public function setArtID(\BiPRO\StructType\STE_KfzZusatzVersicherung $artID = null)
    {
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Tarifierungsmerkmal value
     * @return string|null
     */
    public function getTarifierungsmerkmal()
    {
        return $this->Tarifierungsmerkmal;
    }
    /**
     * Set Tarifierungsmerkmal value
     * @param string $tarifierungsmerkmal
     * @return \BiPRO\StructType\CT_KfzZusatzVersicherung
     */
    public function setTarifierungsmerkmal($tarifierungsmerkmal = null)
    {
        // validation for constraint: string
        if (!is_null($tarifierungsmerkmal) && !is_string($tarifierungsmerkmal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tarifierungsmerkmal, true), gettype($tarifierungsmerkmal)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($tarifierungsmerkmal) && mb_strlen($tarifierungsmerkmal) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($tarifierungsmerkmal)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($tarifierungsmerkmal) && mb_strlen($tarifierungsmerkmal) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($tarifierungsmerkmal)), __LINE__);
        }
        $this->Tarifierungsmerkmal = $tarifierungsmerkmal;
        return $this;
    }
    /**
     * Get Rabattgrundjahr value
     * @return int|null
     */
    public function getRabattgrundjahr()
    {
        return $this->Rabattgrundjahr;
    }
    /**
     * Set Rabattgrundjahr value
     * @param int $rabattgrundjahr
     * @return \BiPRO\StructType\CT_KfzZusatzVersicherung
     */
    public function setRabattgrundjahr($rabattgrundjahr = null)
    {
        // validation for constraint: int
        if (!is_null($rabattgrundjahr) && !(is_int($rabattgrundjahr) || ctype_digit($rabattgrundjahr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rabattgrundjahr, true), gettype($rabattgrundjahr)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($rabattgrundjahr) && mb_strlen(preg_replace('/(\D)/', '', $rabattgrundjahr)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($rabattgrundjahr, true), mb_strlen(preg_replace('/(\D)/', '', $rabattgrundjahr))), __LINE__);
        }
        $this->Rabattgrundjahr = $rabattgrundjahr;
        return $this;
    }
    /**
     * Get SFKlasse value
     * @return \BiPRO\StructType\STE_SFKlasseKZusatz|null
     */
    public function getSFKlasse()
    {
        return $this->SFKlasse;
    }
    /**
     * Set SFKlasse value
     * @param \BiPRO\StructType\STE_SFKlasseKZusatz $sFKlasse
     * @return \BiPRO\StructType\CT_KfzZusatzVersicherung
     */
    public function setSFKlasse(\BiPRO\StructType\STE_SFKlasseKZusatz $sFKlasse = null)
    {
        $this->SFKlasse = $sFKlasse;
        return $this;
    }
    /**
     * Get Beitragssatz value
     * @return float|null
     */
    public function getBeitragssatz()
    {
        return $this->Beitragssatz;
    }
    /**
     * Set Beitragssatz value
     * @param float $beitragssatz
     * @return \BiPRO\StructType\CT_KfzZusatzVersicherung
     */
    public function setBeitragssatz($beitragssatz = null)
    {
        // validation for constraint: float
        if (!is_null($beitragssatz) && !(is_float($beitragssatz) || is_numeric($beitragssatz))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($beitragssatz, true), gettype($beitragssatz)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($beitragssatz) && $beitragssatz < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($beitragssatz, true)), __LINE__);
        }
        $this->Beitragssatz = $beitragssatz;
        return $this;
    }
    /**
     * Get SchaedenAusRueckstufung value
     * @return int|null
     */
    public function getSchaedenAusRueckstufung()
    {
        return $this->SchaedenAusRueckstufung;
    }
    /**
     * Set SchaedenAusRueckstufung value
     * @param int $schaedenAusRueckstufung
     * @return \BiPRO\StructType\CT_KfzZusatzVersicherung
     */
    public function setSchaedenAusRueckstufung($schaedenAusRueckstufung = null)
    {
        // validation for constraint: int
        if (!is_null($schaedenAusRueckstufung) && !(is_int($schaedenAusRueckstufung) || ctype_digit($schaedenAusRueckstufung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($schaedenAusRueckstufung, true), gettype($schaedenAusRueckstufung)), __LINE__);
        }
        $this->SchaedenAusRueckstufung = $schaedenAusRueckstufung;
        return $this;
    }
    /**
     * Get Typklasse value
     * @return int|null
     */
    public function getTypklasse()
    {
        return $this->Typklasse;
    }
    /**
     * Set Typklasse value
     * @param int $typklasse
     * @return \BiPRO\StructType\CT_KfzZusatzVersicherung
     */
    public function setTypklasse($typklasse = null)
    {
        // validation for constraint: int
        if (!is_null($typklasse) && !(is_int($typklasse) || ctype_digit($typklasse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($typklasse, true), gettype($typklasse)), __LINE__);
        }
        $this->Typklasse = $typklasse;
        return $this;
    }
    /**
     * Get ReduzierteSelbstbeteiligungKFV value
     * @return float|null
     */
    public function getReduzierteSelbstbeteiligungKFV()
    {
        return $this->ReduzierteSelbstbeteiligungKFV;
    }
    /**
     * Set ReduzierteSelbstbeteiligungKFV value
     * @param float $reduzierteSelbstbeteiligungKFV
     * @return \BiPRO\StructType\CT_KfzZusatzVersicherung
     */
    public function setReduzierteSelbstbeteiligungKFV($reduzierteSelbstbeteiligungKFV = null)
    {
        // validation for constraint: float
        if (!is_null($reduzierteSelbstbeteiligungKFV) && !(is_float($reduzierteSelbstbeteiligungKFV) || is_numeric($reduzierteSelbstbeteiligungKFV))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reduzierteSelbstbeteiligungKFV, true), gettype($reduzierteSelbstbeteiligungKFV)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($reduzierteSelbstbeteiligungKFV) && mb_strlen(mb_substr($reduzierteSelbstbeteiligungKFV, false !== mb_strpos($reduzierteSelbstbeteiligungKFV, '.') ? mb_strpos($reduzierteSelbstbeteiligungKFV, '.') + 1 : mb_strlen($reduzierteSelbstbeteiligungKFV))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($reduzierteSelbstbeteiligungKFV, true), mb_strlen(mb_substr($reduzierteSelbstbeteiligungKFV, mb_strpos($reduzierteSelbstbeteiligungKFV, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($reduzierteSelbstbeteiligungKFV) && mb_strlen(preg_replace('/(\D)/', '', $reduzierteSelbstbeteiligungKFV)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($reduzierteSelbstbeteiligungKFV, true), mb_strlen(preg_replace('/(\D)/', '', $reduzierteSelbstbeteiligungKFV))), __LINE__);
        }
        $this->ReduzierteSelbstbeteiligungKFV = $reduzierteSelbstbeteiligungKFV;
        return $this;
    }
    /**
     * Get ReduzierteSelbstbeteiligungKFT value
     * @return float|null
     */
    public function getReduzierteSelbstbeteiligungKFT()
    {
        return $this->ReduzierteSelbstbeteiligungKFT;
    }
    /**
     * Set ReduzierteSelbstbeteiligungKFT value
     * @param float $reduzierteSelbstbeteiligungKFT
     * @return \BiPRO\StructType\CT_KfzZusatzVersicherung
     */
    public function setReduzierteSelbstbeteiligungKFT($reduzierteSelbstbeteiligungKFT = null)
    {
        // validation for constraint: float
        if (!is_null($reduzierteSelbstbeteiligungKFT) && !(is_float($reduzierteSelbstbeteiligungKFT) || is_numeric($reduzierteSelbstbeteiligungKFT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reduzierteSelbstbeteiligungKFT, true), gettype($reduzierteSelbstbeteiligungKFT)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($reduzierteSelbstbeteiligungKFT) && mb_strlen(mb_substr($reduzierteSelbstbeteiligungKFT, false !== mb_strpos($reduzierteSelbstbeteiligungKFT, '.') ? mb_strpos($reduzierteSelbstbeteiligungKFT, '.') + 1 : mb_strlen($reduzierteSelbstbeteiligungKFT))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($reduzierteSelbstbeteiligungKFT, true), mb_strlen(mb_substr($reduzierteSelbstbeteiligungKFT, mb_strpos($reduzierteSelbstbeteiligungKFT, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($reduzierteSelbstbeteiligungKFT) && mb_strlen(preg_replace('/(\D)/', '', $reduzierteSelbstbeteiligungKFT)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($reduzierteSelbstbeteiligungKFT, true), mb_strlen(preg_replace('/(\D)/', '', $reduzierteSelbstbeteiligungKFT))), __LINE__);
        }
        $this->ReduzierteSelbstbeteiligungKFT = $reduzierteSelbstbeteiligungKFT;
        return $this;
    }
}
