<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_KfzVerkehrsservice StructType
 * Meta information extracted from the WSDL
 * - documentation: Klasse für die Kfz-Verkehrrservice-Deckungen
 * @subpackage Structs
 */
class CT_KfzVerkehrsservice extends CT_Elementarprodukt
{
    /**
     * The AnzahlVersicherteFahrzeuge
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der versicherten Fahrzeuge, wenn die Fahrzeuge nicht explizit genannt werden.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlVersicherteFahrzeuge;
    /**
     * The VersichertesFahrzeug
     * Meta information extracted from the WSDL
     * - documentation: Versichertes Fahrzeug zur Kfz-Verkehrrservice-Deckung.Dieses Attribut DARF NUR genutzt werden, WENN die Klasse &sbquo;KfzVerkehrrservice&lsquo; ein Elementarprodukt der Klasse &sbquo;Verkehrsservice&lsquo; ist. Elementarprodukte der
     * Klasse &sbquo;KfzVersicherung&lsquo; erben deren versicherte Fahrzeuge.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_VersichertesFahrzeug[]
     */
    public $VersichertesFahrzeug;
    /**
     * Constructor method for CT_KfzVerkehrsservice
     * @uses CT_KfzVerkehrsservice::setAnzahlVersicherteFahrzeuge()
     * @uses CT_KfzVerkehrsservice::setVersichertesFahrzeug()
     * @param int $anzahlVersicherteFahrzeuge
     * @param \BiPRO\StructType\CT_VersichertesFahrzeug[] $versichertesFahrzeug
     */
    public function __construct($anzahlVersicherteFahrzeuge = null, array $versichertesFahrzeug = array())
    {
        $this
            ->setAnzahlVersicherteFahrzeuge($anzahlVersicherteFahrzeuge)
            ->setVersichertesFahrzeug($versichertesFahrzeug);
    }
    /**
     * Get AnzahlVersicherteFahrzeuge value
     * @return int|null
     */
    public function getAnzahlVersicherteFahrzeuge()
    {
        return $this->AnzahlVersicherteFahrzeuge;
    }
    /**
     * Set AnzahlVersicherteFahrzeuge value
     * @param int $anzahlVersicherteFahrzeuge
     * @return \BiPRO\StructType\CT_KfzVerkehrsservice
     */
    public function setAnzahlVersicherteFahrzeuge($anzahlVersicherteFahrzeuge = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlVersicherteFahrzeuge) && !(is_int($anzahlVersicherteFahrzeuge) || ctype_digit($anzahlVersicherteFahrzeuge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlVersicherteFahrzeuge, true), gettype($anzahlVersicherteFahrzeuge)), __LINE__);
        }
        $this->AnzahlVersicherteFahrzeuge = $anzahlVersicherteFahrzeuge;
        return $this;
    }
    /**
     * Get VersichertesFahrzeug value
     * @return \BiPRO\StructType\CT_VersichertesFahrzeug[]|null
     */
    public function getVersichertesFahrzeug()
    {
        return $this->VersichertesFahrzeug;
    }
    /**
     * This method is responsible for validating the values passed to the setVersichertesFahrzeug method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVersichertesFahrzeug method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVersichertesFahrzeugForArrayConstraintsFromSetVersichertesFahrzeug(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_KfzVerkehrsserviceVersichertesFahrzeugItem) {
            // validation for constraint: itemType
            if (!$cT_KfzVerkehrsserviceVersichertesFahrzeugItem instanceof \BiPRO\StructType\CT_VersichertesFahrzeug) {
                $invalidValues[] = is_object($cT_KfzVerkehrsserviceVersichertesFahrzeugItem) ? get_class($cT_KfzVerkehrsserviceVersichertesFahrzeugItem) : sprintf('%s(%s)', gettype($cT_KfzVerkehrsserviceVersichertesFahrzeugItem), var_export($cT_KfzVerkehrsserviceVersichertesFahrzeugItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VersichertesFahrzeug property can only contain items of type \BiPRO\StructType\CT_VersichertesFahrzeug, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VersichertesFahrzeug value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_VersichertesFahrzeug[] $versichertesFahrzeug
     * @return \BiPRO\StructType\CT_KfzVerkehrsservice
     */
    public function setVersichertesFahrzeug(array $versichertesFahrzeug = array())
    {
        // validation for constraint: array
        if ('' !== ($versichertesFahrzeugArrayErrorMessage = self::validateVersichertesFahrzeugForArrayConstraintsFromSetVersichertesFahrzeug($versichertesFahrzeug))) {
            throw new \InvalidArgumentException($versichertesFahrzeugArrayErrorMessage, __LINE__);
        }
        $this->VersichertesFahrzeug = $versichertesFahrzeug;
        return $this;
    }
    /**
     * Add item to VersichertesFahrzeug value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_VersichertesFahrzeug $item
     * @return \BiPRO\StructType\CT_KfzVerkehrsservice
     */
    public function addToVersichertesFahrzeug(\BiPRO\StructType\CT_VersichertesFahrzeug $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_VersichertesFahrzeug) {
            throw new \InvalidArgumentException(sprintf('The VersichertesFahrzeug property can only contain items of type \BiPRO\StructType\CT_VersichertesFahrzeug, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VersichertesFahrzeug[] = $item;
        return $this;
    }
}
