<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Kennzeichenart StructType
 * @subpackage Structs
 */
class CT_Kennzeichenart extends CT_Objekt
{
    /**
     * The MerkmalKennzeichenart
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerkmalKennzeichenart;
    /**
     * Constructor method for CT_Kennzeichenart
     * @uses CT_Kennzeichenart::setMerkmalKennzeichenart()
     * @param string $merkmalKennzeichenart
     */
    public function __construct($merkmalKennzeichenart = null)
    {
        $this
            ->setMerkmalKennzeichenart($merkmalKennzeichenart);
    }
    /**
     * Get MerkmalKennzeichenart value
     * @return string
     */
    public function getMerkmalKennzeichenart()
    {
        return $this->MerkmalKennzeichenart;
    }
    /**
     * Set MerkmalKennzeichenart value
     * @uses \BiPRO\EnumType\ST_Kennzeichenart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Kennzeichenart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $merkmalKennzeichenart
     * @return \BiPRO\StructType\CT_Kennzeichenart
     */
    public function setMerkmalKennzeichenart($merkmalKennzeichenart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Kennzeichenart::valueIsValid($merkmalKennzeichenart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Kennzeichenart', is_array($merkmalKennzeichenart) ? implode(', ', $merkmalKennzeichenart) : var_export($merkmalKennzeichenart, true), implode(', ', \BiPRO\EnumType\ST_Kennzeichenart::getValidValues())), __LINE__);
        }
        $this->MerkmalKennzeichenart = $merkmalKennzeichenart;
        return $this;
    }
}
