<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_JuristischePerson StructType
 * Meta information extracted from the WSDL
 * - documentation: Juristische Person. Darf nicht Projekt-spezifisch abgeleitet werden (vgl. Kommentar zu Partner). Kann eine natuerliche Person als Vertretungsberechtigten haben.
 * @subpackage Structs
 */
class CT_JuristischePerson extends CT_Partner
{
    /**
     * The Rechtsform
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Rechtsform;
    /**
     * The Steuernummer
     * Meta information extracted from the WSDL
     * - documentation: Auspraegungen gemaess GDV-Satzart 0100, Teildatensatz 5, Feld 11.
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Steuernummer;
    /**
     * The Gruendungsdatum
     * Meta information extracted from the WSDL
     * - documentation: nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Gruendungsdatum;
    /**
     * The Branche
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_BerufsBranche
     */
    public $Branche;
    /**
     * The AnzahlMitglieder
     * Meta information extracted from the WSDL
     * - documentation: Dieses Attribut gibt die Anzahl der Mitglieder einer juristischen Person an.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlMitglieder;
    /**
     * The Vertretungsberechtigter
     * Meta information extracted from the WSDL
     * - documentation: Der ueber die Rolle Vertretungsberechtigter referenzierte Partner muss eine natuerliche Person sein.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Vertretungsberechtigter
     */
    public $Vertretungsberechtigter;
    /**
     * The Umsatz
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Umsatz
     */
    public $Umsatz;
    /**
     * The AnzahlBeschaeftigte
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_AnzahlBeschaeftigte[]
     */
    public $AnzahlBeschaeftigte;
    /**
     * The Lohnsumme
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Lohnsumme
     */
    public $Lohnsumme;
    /**
     * The Handelsregistergericht
     * Meta information extracted from the WSDL
     * - documentation: Gericht, bei dem das Handelsregister bzw. bei Vereinen das Vereinsregister geführt wird.
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Handelsregistergericht;
    /**
     * The Handelsregisteraktenzeichen
     * Meta information extracted from the WSDL
     * - documentation: Aktenzeichen des Handels- bzw. Vereinsregisters, z.B. HRB 8297
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Handelsregisteraktenzeichen;
    /**
     * The Mitarbeitergruppe
     * Meta information extracted from the WSDL
     * - documentation: Referenzierung Mitarbeitergruppen (mit gemeinsamen Merkmalen)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Mitarbeitergruppe[]
     */
    public $Mitarbeitergruppe;
    /**
     * Constructor method for CT_JuristischePerson
     * @uses CT_JuristischePerson::setRechtsform()
     * @uses CT_JuristischePerson::setSteuernummer()
     * @uses CT_JuristischePerson::setGruendungsdatum()
     * @uses CT_JuristischePerson::setBranche()
     * @uses CT_JuristischePerson::setAnzahlMitglieder()
     * @uses CT_JuristischePerson::setVertretungsberechtigter()
     * @uses CT_JuristischePerson::setUmsatz()
     * @uses CT_JuristischePerson::setAnzahlBeschaeftigte()
     * @uses CT_JuristischePerson::setLohnsumme()
     * @uses CT_JuristischePerson::setHandelsregistergericht()
     * @uses CT_JuristischePerson::setHandelsregisteraktenzeichen()
     * @uses CT_JuristischePerson::setMitarbeitergruppe()
     * @param string $rechtsform
     * @param string $steuernummer
     * @param string $gruendungsdatum
     * @param \BiPRO\StructType\STE_BerufsBranche $branche
     * @param int $anzahlMitglieder
     * @param \BiPRO\StructType\CT_Vertretungsberechtigter $vertretungsberechtigter
     * @param \BiPRO\StructType\CT_Umsatz $umsatz
     * @param \BiPRO\StructType\CT_AnzahlBeschaeftigte[] $anzahlBeschaeftigte
     * @param \BiPRO\StructType\CT_Lohnsumme $lohnsumme
     * @param string $handelsregistergericht
     * @param string $handelsregisteraktenzeichen
     * @param \BiPRO\StructType\CT_Mitarbeitergruppe[] $mitarbeitergruppe
     */
    public function __construct($rechtsform = null, $steuernummer = null, $gruendungsdatum = null, \BiPRO\StructType\STE_BerufsBranche $branche = null, $anzahlMitglieder = null, \BiPRO\StructType\CT_Vertretungsberechtigter $vertretungsberechtigter = null, \BiPRO\StructType\CT_Umsatz $umsatz = null, array $anzahlBeschaeftigte = array(), \BiPRO\StructType\CT_Lohnsumme $lohnsumme = null, $handelsregistergericht = null, $handelsregisteraktenzeichen = null, array $mitarbeitergruppe = array())
    {
        $this
            ->setRechtsform($rechtsform)
            ->setSteuernummer($steuernummer)
            ->setGruendungsdatum($gruendungsdatum)
            ->setBranche($branche)
            ->setAnzahlMitglieder($anzahlMitglieder)
            ->setVertretungsberechtigter($vertretungsberechtigter)
            ->setUmsatz($umsatz)
            ->setAnzahlBeschaeftigte($anzahlBeschaeftigte)
            ->setLohnsumme($lohnsumme)
            ->setHandelsregistergericht($handelsregistergericht)
            ->setHandelsregisteraktenzeichen($handelsregisteraktenzeichen)
            ->setMitarbeitergruppe($mitarbeitergruppe);
    }
    /**
     * Get Rechtsform value
     * @return string|null
     */
    public function getRechtsform()
    {
        return $this->Rechtsform;
    }
    /**
     * Set Rechtsform value
     * @uses \BiPRO\EnumType\ST_Rechtsform::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Rechtsform::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rechtsform
     * @return \BiPRO\StructType\CT_JuristischePerson
     */
    public function setRechtsform($rechtsform = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Rechtsform::valueIsValid($rechtsform)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Rechtsform', is_array($rechtsform) ? implode(', ', $rechtsform) : var_export($rechtsform, true), implode(', ', \BiPRO\EnumType\ST_Rechtsform::getValidValues())), __LINE__);
        }
        $this->Rechtsform = $rechtsform;
        return $this;
    }
    /**
     * Get Steuernummer value
     * @return string|null
     */
    public function getSteuernummer()
    {
        return $this->Steuernummer;
    }
    /**
     * Set Steuernummer value
     * @param string $steuernummer
     * @return \BiPRO\StructType\CT_JuristischePerson
     */
    public function setSteuernummer($steuernummer = null)
    {
        // validation for constraint: string
        if (!is_null($steuernummer) && !is_string($steuernummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($steuernummer, true), gettype($steuernummer)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($steuernummer) && mb_strlen($steuernummer) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($steuernummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($steuernummer) && mb_strlen($steuernummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($steuernummer)), __LINE__);
        }
        $this->Steuernummer = $steuernummer;
        return $this;
    }
    /**
     * Get Gruendungsdatum value
     * @return string|null
     */
    public function getGruendungsdatum()
    {
        return $this->Gruendungsdatum;
    }
    /**
     * Set Gruendungsdatum value
     * @param string $gruendungsdatum
     * @return \BiPRO\StructType\CT_JuristischePerson
     */
    public function setGruendungsdatum($gruendungsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($gruendungsdatum) && !is_string($gruendungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gruendungsdatum, true), gettype($gruendungsdatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($gruendungsdatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $gruendungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($gruendungsdatum, true)), __LINE__);
        }
        $this->Gruendungsdatum = $gruendungsdatum;
        return $this;
    }
    /**
     * Get Branche value
     * @return \BiPRO\StructType\STE_BerufsBranche|null
     */
    public function getBranche()
    {
        return $this->Branche;
    }
    /**
     * Set Branche value
     * @param \BiPRO\StructType\STE_BerufsBranche $branche
     * @return \BiPRO\StructType\CT_JuristischePerson
     */
    public function setBranche(\BiPRO\StructType\STE_BerufsBranche $branche = null)
    {
        $this->Branche = $branche;
        return $this;
    }
    /**
     * Get AnzahlMitglieder value
     * @return int|null
     */
    public function getAnzahlMitglieder()
    {
        return $this->AnzahlMitglieder;
    }
    /**
     * Set AnzahlMitglieder value
     * @param int $anzahlMitglieder
     * @return \BiPRO\StructType\CT_JuristischePerson
     */
    public function setAnzahlMitglieder($anzahlMitglieder = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlMitglieder) && !(is_int($anzahlMitglieder) || ctype_digit($anzahlMitglieder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlMitglieder, true), gettype($anzahlMitglieder)), __LINE__);
        }
        $this->AnzahlMitglieder = $anzahlMitglieder;
        return $this;
    }
    /**
     * Get Vertretungsberechtigter value
     * @return \BiPRO\StructType\CT_Vertretungsberechtigter|null
     */
    public function getVertretungsberechtigter()
    {
        return $this->Vertretungsberechtigter;
    }
    /**
     * Set Vertretungsberechtigter value
     * @param \BiPRO\StructType\CT_Vertretungsberechtigter $vertretungsberechtigter
     * @return \BiPRO\StructType\CT_JuristischePerson
     */
    public function setVertretungsberechtigter(\BiPRO\StructType\CT_Vertretungsberechtigter $vertretungsberechtigter = null)
    {
        $this->Vertretungsberechtigter = $vertretungsberechtigter;
        return $this;
    }
    /**
     * Get Umsatz value
     * @return \BiPRO\StructType\CT_Umsatz|null
     */
    public function getUmsatz()
    {
        return $this->Umsatz;
    }
    /**
     * Set Umsatz value
     * @param \BiPRO\StructType\CT_Umsatz $umsatz
     * @return \BiPRO\StructType\CT_JuristischePerson
     */
    public function setUmsatz(\BiPRO\StructType\CT_Umsatz $umsatz = null)
    {
        $this->Umsatz = $umsatz;
        return $this;
    }
    /**
     * Get AnzahlBeschaeftigte value
     * @return \BiPRO\StructType\CT_AnzahlBeschaeftigte[]|null
     */
    public function getAnzahlBeschaeftigte()
    {
        return $this->AnzahlBeschaeftigte;
    }
    /**
     * This method is responsible for validating the values passed to the setAnzahlBeschaeftigte method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnzahlBeschaeftigte method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnzahlBeschaeftigteForArrayConstraintsFromSetAnzahlBeschaeftigte(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_JuristischePersonAnzahlBeschaeftigteItem) {
            // validation for constraint: itemType
            if (!$cT_JuristischePersonAnzahlBeschaeftigteItem instanceof \BiPRO\StructType\CT_AnzahlBeschaeftigte) {
                $invalidValues[] = is_object($cT_JuristischePersonAnzahlBeschaeftigteItem) ? get_class($cT_JuristischePersonAnzahlBeschaeftigteItem) : sprintf('%s(%s)', gettype($cT_JuristischePersonAnzahlBeschaeftigteItem), var_export($cT_JuristischePersonAnzahlBeschaeftigteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AnzahlBeschaeftigte property can only contain items of type \BiPRO\StructType\CT_AnzahlBeschaeftigte, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AnzahlBeschaeftigte value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_AnzahlBeschaeftigte[] $anzahlBeschaeftigte
     * @return \BiPRO\StructType\CT_JuristischePerson
     */
    public function setAnzahlBeschaeftigte(array $anzahlBeschaeftigte = array())
    {
        // validation for constraint: array
        if ('' !== ($anzahlBeschaeftigteArrayErrorMessage = self::validateAnzahlBeschaeftigteForArrayConstraintsFromSetAnzahlBeschaeftigte($anzahlBeschaeftigte))) {
            throw new \InvalidArgumentException($anzahlBeschaeftigteArrayErrorMessage, __LINE__);
        }
        $this->AnzahlBeschaeftigte = $anzahlBeschaeftigte;
        return $this;
    }
    /**
     * Add item to AnzahlBeschaeftigte value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_AnzahlBeschaeftigte $item
     * @return \BiPRO\StructType\CT_JuristischePerson
     */
    public function addToAnzahlBeschaeftigte(\BiPRO\StructType\CT_AnzahlBeschaeftigte $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_AnzahlBeschaeftigte) {
            throw new \InvalidArgumentException(sprintf('The AnzahlBeschaeftigte property can only contain items of type \BiPRO\StructType\CT_AnzahlBeschaeftigte, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AnzahlBeschaeftigte[] = $item;
        return $this;
    }
    /**
     * Get Lohnsumme value
     * @return \BiPRO\StructType\CT_Lohnsumme|null
     */
    public function getLohnsumme()
    {
        return $this->Lohnsumme;
    }
    /**
     * Set Lohnsumme value
     * @param \BiPRO\StructType\CT_Lohnsumme $lohnsumme
     * @return \BiPRO\StructType\CT_JuristischePerson
     */
    public function setLohnsumme(\BiPRO\StructType\CT_Lohnsumme $lohnsumme = null)
    {
        $this->Lohnsumme = $lohnsumme;
        return $this;
    }
    /**
     * Get Handelsregistergericht value
     * @return string|null
     */
    public function getHandelsregistergericht()
    {
        return $this->Handelsregistergericht;
    }
    /**
     * Set Handelsregistergericht value
     * @param string $handelsregistergericht
     * @return \BiPRO\StructType\CT_JuristischePerson
     */
    public function setHandelsregistergericht($handelsregistergericht = null)
    {
        // validation for constraint: string
        if (!is_null($handelsregistergericht) && !is_string($handelsregistergericht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handelsregistergericht, true), gettype($handelsregistergericht)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($handelsregistergericht) && mb_strlen($handelsregistergericht) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($handelsregistergericht)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($handelsregistergericht) && mb_strlen($handelsregistergericht) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($handelsregistergericht)), __LINE__);
        }
        $this->Handelsregistergericht = $handelsregistergericht;
        return $this;
    }
    /**
     * Get Handelsregisteraktenzeichen value
     * @return string|null
     */
    public function getHandelsregisteraktenzeichen()
    {
        return $this->Handelsregisteraktenzeichen;
    }
    /**
     * Set Handelsregisteraktenzeichen value
     * @param string $handelsregisteraktenzeichen
     * @return \BiPRO\StructType\CT_JuristischePerson
     */
    public function setHandelsregisteraktenzeichen($handelsregisteraktenzeichen = null)
    {
        // validation for constraint: string
        if (!is_null($handelsregisteraktenzeichen) && !is_string($handelsregisteraktenzeichen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handelsregisteraktenzeichen, true), gettype($handelsregisteraktenzeichen)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($handelsregisteraktenzeichen) && mb_strlen($handelsregisteraktenzeichen) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($handelsregisteraktenzeichen)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($handelsregisteraktenzeichen) && mb_strlen($handelsregisteraktenzeichen) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($handelsregisteraktenzeichen)), __LINE__);
        }
        $this->Handelsregisteraktenzeichen = $handelsregisteraktenzeichen;
        return $this;
    }
    /**
     * Get Mitarbeitergruppe value
     * @return \BiPRO\StructType\CT_Mitarbeitergruppe[]|null
     */
    public function getMitarbeitergruppe()
    {
        return $this->Mitarbeitergruppe;
    }
    /**
     * This method is responsible for validating the values passed to the setMitarbeitergruppe method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMitarbeitergruppe method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMitarbeitergruppeForArrayConstraintsFromSetMitarbeitergruppe(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_JuristischePersonMitarbeitergruppeItem) {
            // validation for constraint: itemType
            if (!$cT_JuristischePersonMitarbeitergruppeItem instanceof \BiPRO\StructType\CT_Mitarbeitergruppe) {
                $invalidValues[] = is_object($cT_JuristischePersonMitarbeitergruppeItem) ? get_class($cT_JuristischePersonMitarbeitergruppeItem) : sprintf('%s(%s)', gettype($cT_JuristischePersonMitarbeitergruppeItem), var_export($cT_JuristischePersonMitarbeitergruppeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Mitarbeitergruppe property can only contain items of type \BiPRO\StructType\CT_Mitarbeitergruppe, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Mitarbeitergruppe value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Mitarbeitergruppe[] $mitarbeitergruppe
     * @return \BiPRO\StructType\CT_JuristischePerson
     */
    public function setMitarbeitergruppe(array $mitarbeitergruppe = array())
    {
        // validation for constraint: array
        if ('' !== ($mitarbeitergruppeArrayErrorMessage = self::validateMitarbeitergruppeForArrayConstraintsFromSetMitarbeitergruppe($mitarbeitergruppe))) {
            throw new \InvalidArgumentException($mitarbeitergruppeArrayErrorMessage, __LINE__);
        }
        $this->Mitarbeitergruppe = $mitarbeitergruppe;
        return $this;
    }
    /**
     * Add item to Mitarbeitergruppe value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Mitarbeitergruppe $item
     * @return \BiPRO\StructType\CT_JuristischePerson
     */
    public function addToMitarbeitergruppe(\BiPRO\StructType\CT_Mitarbeitergruppe $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Mitarbeitergruppe) {
            throw new \InvalidArgumentException(sprintf('The Mitarbeitergruppe property can only contain items of type \BiPRO\StructType\CT_Mitarbeitergruppe, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Mitarbeitergruppe[] = $item;
        return $this;
    }
}
