<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Investment StructType
 * Meta information extracted from the WSDL
 * - documentation: Informationen zu einem Investment (z.B. Aktie, Fonds, Anleihe).
 * @subpackage Structs
 */
class CT_Investment extends CT_Objekt
{
    /**
     * The ISIN
     * Meta information extracted from the WSDL
     * - documentation: Die International Securities Identification Number (ISIN) ist eine zwölfstellige Buchstaben-Zahlen-Kombination und stellt eine Identifikation für ein Wertpapier dar, das an der Börse gehandelt wird. Der Aufbau der ISIN wird in der
     * ISO 6166 beschrieben.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [A-Z]{2}[A-Za-z0-9]{9}\d{1}
     * @var string
     */
    public $ISIN;
    /**
     * The Wertpapierkennnummer
     * Meta information extracted from the WSDL
     * - documentation: Die Wertpapierkennnummer (WKN abgekürzt) ist eine in Deutschland verwendete sechsstellige Ziffern- und Buchstabenkombination zur Identifizierung von Wertpapieren.
     * - base: xsd:string
     * - maxLength: 6
     * - maxOccurs: 1
     * - minLength: 6
     * - minOccurs: 0
     * @var string
     */
    public $Wertpapierkennnummer;
    /**
     * The Bezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Bezeichnung des Investments, z.B. Fondsname.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Bezeichnung;
    /**
     * The Wertpapierklassifikation
     * Meta information extracted from the WSDL
     * - documentation: Klassifikation des Investments, z.B. Aktien Deutschland, Aktien Europa, Renten Griechenland
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Wertpapierklassifikation;
    /**
     * The Anteile
     * Meta information extracted from the WSDL
     * - documentation: Anteile bzw. Stücke des Investments.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Anteile;
    /**
     * The Waehrung
     * Meta information extracted from the WSDL
     * - documentation: Währung, in der das Investment gehandelt wird.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Waehrung;
    /**
     * The ZusaetzlicheInvestmentDaten
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_ZusaetzlicheInvestmentDaten[]
     */
    public $ZusaetzlicheInvestmentDaten;
    /**
     * The Devisenkurs
     * Meta information extracted from the WSDL
     * - documentation: Kurs, zu dem die Umrechnung des Investmentbestandes aus der Investmentwährung in die Depotwährung erfolgte.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Devisenkurs
     */
    public $Devisenkurs;
    /**
     * The Investmentkurs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Investmentkurs
     */
    public $Investmentkurs;
    /**
     * The BestandInInvestmentwaehrung
     * Meta information extracted from the WSDL
     * - documentation: Bestandswert des Investments zu einem bestimmten Stichtag in Originalwährung des Investments.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Bestand
     */
    public $BestandInInvestmentwaehrung;
    /**
     * The BestandInDepotwaehrung
     * Meta information extracted from the WSDL
     * - documentation: Bestandswert des Investments zu einem bestimmten Stichtag in Währung des Depots, in dem das Investment verwaltet wird.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Bestand
     */
    public $BestandInDepotwaehrung;
    /**
     * Constructor method for CT_Investment
     * @uses CT_Investment::setISIN()
     * @uses CT_Investment::setWertpapierkennnummer()
     * @uses CT_Investment::setBezeichnung()
     * @uses CT_Investment::setWertpapierklassifikation()
     * @uses CT_Investment::setAnteile()
     * @uses CT_Investment::setWaehrung()
     * @uses CT_Investment::setZusaetzlicheInvestmentDaten()
     * @uses CT_Investment::setDevisenkurs()
     * @uses CT_Investment::setInvestmentkurs()
     * @uses CT_Investment::setBestandInInvestmentwaehrung()
     * @uses CT_Investment::setBestandInDepotwaehrung()
     * @param string $iSIN
     * @param string $wertpapierkennnummer
     * @param string $bezeichnung
     * @param string $wertpapierklassifikation
     * @param float $anteile
     * @param string $waehrung
     * @param \BiPRO\StructType\CT_ZusaetzlicheInvestmentDaten[] $zusaetzlicheInvestmentDaten
     * @param \BiPRO\StructType\CT_Devisenkurs $devisenkurs
     * @param \BiPRO\StructType\CT_Investmentkurs $investmentkurs
     * @param \BiPRO\StructType\CT_Bestand $bestandInInvestmentwaehrung
     * @param \BiPRO\StructType\CT_Bestand $bestandInDepotwaehrung
     */
    public function __construct($iSIN = null, $wertpapierkennnummer = null, $bezeichnung = null, $wertpapierklassifikation = null, $anteile = null, $waehrung = null, array $zusaetzlicheInvestmentDaten = array(), \BiPRO\StructType\CT_Devisenkurs $devisenkurs = null, \BiPRO\StructType\CT_Investmentkurs $investmentkurs = null, \BiPRO\StructType\CT_Bestand $bestandInInvestmentwaehrung = null, \BiPRO\StructType\CT_Bestand $bestandInDepotwaehrung = null)
    {
        $this
            ->setISIN($iSIN)
            ->setWertpapierkennnummer($wertpapierkennnummer)
            ->setBezeichnung($bezeichnung)
            ->setWertpapierklassifikation($wertpapierklassifikation)
            ->setAnteile($anteile)
            ->setWaehrung($waehrung)
            ->setZusaetzlicheInvestmentDaten($zusaetzlicheInvestmentDaten)
            ->setDevisenkurs($devisenkurs)
            ->setInvestmentkurs($investmentkurs)
            ->setBestandInInvestmentwaehrung($bestandInInvestmentwaehrung)
            ->setBestandInDepotwaehrung($bestandInDepotwaehrung);
    }
    /**
     * Get ISIN value
     * @return string|null
     */
    public function getISIN()
    {
        return $this->ISIN;
    }
    /**
     * Set ISIN value
     * @param string $iSIN
     * @return \BiPRO\StructType\CT_Investment
     */
    public function setISIN($iSIN = null)
    {
        // validation for constraint: string
        if (!is_null($iSIN) && !is_string($iSIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iSIN, true), gettype($iSIN)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2}[A-Za-z0-9]{9}\d{1})
        if (!is_null($iSIN) && !preg_match('/[A-Z]{2}[A-Za-z0-9]{9}\\d{1}/', $iSIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}[A-Za-z0-9]{9}\d{1}', var_export($iSIN, true)), __LINE__);
        }
        $this->ISIN = $iSIN;
        return $this;
    }
    /**
     * Get Wertpapierkennnummer value
     * @return string|null
     */
    public function getWertpapierkennnummer()
    {
        return $this->Wertpapierkennnummer;
    }
    /**
     * Set Wertpapierkennnummer value
     * @param string $wertpapierkennnummer
     * @return \BiPRO\StructType\CT_Investment
     */
    public function setWertpapierkennnummer($wertpapierkennnummer = null)
    {
        // validation for constraint: string
        if (!is_null($wertpapierkennnummer) && !is_string($wertpapierkennnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wertpapierkennnummer, true), gettype($wertpapierkennnummer)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($wertpapierkennnummer) && mb_strlen($wertpapierkennnummer) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($wertpapierkennnummer)), __LINE__);
        }
        // validation for constraint: minLength(6)
        if (!is_null($wertpapierkennnummer) && mb_strlen($wertpapierkennnummer) < 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 6', mb_strlen($wertpapierkennnummer)), __LINE__);
        }
        $this->Wertpapierkennnummer = $wertpapierkennnummer;
        return $this;
    }
    /**
     * Get Bezeichnung value
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->Bezeichnung;
    }
    /**
     * Set Bezeichnung value
     * @param string $bezeichnung
     * @return \BiPRO\StructType\CT_Investment
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($bezeichnung) && mb_strlen($bezeichnung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($bezeichnung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($bezeichnung) && mb_strlen($bezeichnung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($bezeichnung)), __LINE__);
        }
        $this->Bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Get Wertpapierklassifikation value
     * @return string|null
     */
    public function getWertpapierklassifikation()
    {
        return $this->Wertpapierklassifikation;
    }
    /**
     * Set Wertpapierklassifikation value
     * @param string $wertpapierklassifikation
     * @return \BiPRO\StructType\CT_Investment
     */
    public function setWertpapierklassifikation($wertpapierklassifikation = null)
    {
        // validation for constraint: string
        if (!is_null($wertpapierklassifikation) && !is_string($wertpapierklassifikation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wertpapierklassifikation, true), gettype($wertpapierklassifikation)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($wertpapierklassifikation) && mb_strlen($wertpapierklassifikation) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($wertpapierklassifikation)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($wertpapierklassifikation) && mb_strlen($wertpapierklassifikation) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($wertpapierklassifikation)), __LINE__);
        }
        $this->Wertpapierklassifikation = $wertpapierklassifikation;
        return $this;
    }
    /**
     * Get Anteile value
     * @return float|null
     */
    public function getAnteile()
    {
        return $this->Anteile;
    }
    /**
     * Set Anteile value
     * @param float $anteile
     * @return \BiPRO\StructType\CT_Investment
     */
    public function setAnteile($anteile = null)
    {
        // validation for constraint: float
        if (!is_null($anteile) && !(is_float($anteile) || is_numeric($anteile))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($anteile, true), gettype($anteile)), __LINE__);
        }
        $this->Anteile = $anteile;
        return $this;
    }
    /**
     * Get Waehrung value
     * @return string|null
     */
    public function getWaehrung()
    {
        return $this->Waehrung;
    }
    /**
     * Set Waehrung value
     * @uses \BiPRO\EnumType\ST_Waehrungsschluessel::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Waehrungsschluessel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $waehrung
     * @return \BiPRO\StructType\CT_Investment
     */
    public function setWaehrung($waehrung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Waehrungsschluessel::valueIsValid($waehrung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Waehrungsschluessel', is_array($waehrung) ? implode(', ', $waehrung) : var_export($waehrung, true), implode(', ', \BiPRO\EnumType\ST_Waehrungsschluessel::getValidValues())), __LINE__);
        }
        $this->Waehrung = $waehrung;
        return $this;
    }
    /**
     * Get ZusaetzlicheInvestmentDaten value
     * @return \BiPRO\StructType\CT_ZusaetzlicheInvestmentDaten[]|null
     */
    public function getZusaetzlicheInvestmentDaten()
    {
        return $this->ZusaetzlicheInvestmentDaten;
    }
    /**
     * This method is responsible for validating the values passed to the setZusaetzlicheInvestmentDaten method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZusaetzlicheInvestmentDaten method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZusaetzlicheInvestmentDatenForArrayConstraintsFromSetZusaetzlicheInvestmentDaten(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_InvestmentZusaetzlicheInvestmentDatenItem) {
            // validation for constraint: itemType
            if (!$cT_InvestmentZusaetzlicheInvestmentDatenItem instanceof \BiPRO\StructType\CT_ZusaetzlicheInvestmentDaten) {
                $invalidValues[] = is_object($cT_InvestmentZusaetzlicheInvestmentDatenItem) ? get_class($cT_InvestmentZusaetzlicheInvestmentDatenItem) : sprintf('%s(%s)', gettype($cT_InvestmentZusaetzlicheInvestmentDatenItem), var_export($cT_InvestmentZusaetzlicheInvestmentDatenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ZusaetzlicheInvestmentDaten property can only contain items of type \BiPRO\StructType\CT_ZusaetzlicheInvestmentDaten, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ZusaetzlicheInvestmentDaten value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_ZusaetzlicheInvestmentDaten[] $zusaetzlicheInvestmentDaten
     * @return \BiPRO\StructType\CT_Investment
     */
    public function setZusaetzlicheInvestmentDaten(array $zusaetzlicheInvestmentDaten = array())
    {
        // validation for constraint: array
        if ('' !== ($zusaetzlicheInvestmentDatenArrayErrorMessage = self::validateZusaetzlicheInvestmentDatenForArrayConstraintsFromSetZusaetzlicheInvestmentDaten($zusaetzlicheInvestmentDaten))) {
            throw new \InvalidArgumentException($zusaetzlicheInvestmentDatenArrayErrorMessage, __LINE__);
        }
        $this->ZusaetzlicheInvestmentDaten = $zusaetzlicheInvestmentDaten;
        return $this;
    }
    /**
     * Add item to ZusaetzlicheInvestmentDaten value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_ZusaetzlicheInvestmentDaten $item
     * @return \BiPRO\StructType\CT_Investment
     */
    public function addToZusaetzlicheInvestmentDaten(\BiPRO\StructType\CT_ZusaetzlicheInvestmentDaten $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_ZusaetzlicheInvestmentDaten) {
            throw new \InvalidArgumentException(sprintf('The ZusaetzlicheInvestmentDaten property can only contain items of type \BiPRO\StructType\CT_ZusaetzlicheInvestmentDaten, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ZusaetzlicheInvestmentDaten[] = $item;
        return $this;
    }
    /**
     * Get Devisenkurs value
     * @return \BiPRO\StructType\CT_Devisenkurs|null
     */
    public function getDevisenkurs()
    {
        return $this->Devisenkurs;
    }
    /**
     * Set Devisenkurs value
     * @param \BiPRO\StructType\CT_Devisenkurs $devisenkurs
     * @return \BiPRO\StructType\CT_Investment
     */
    public function setDevisenkurs(\BiPRO\StructType\CT_Devisenkurs $devisenkurs = null)
    {
        $this->Devisenkurs = $devisenkurs;
        return $this;
    }
    /**
     * Get Investmentkurs value
     * @return \BiPRO\StructType\CT_Investmentkurs|null
     */
    public function getInvestmentkurs()
    {
        return $this->Investmentkurs;
    }
    /**
     * Set Investmentkurs value
     * @param \BiPRO\StructType\CT_Investmentkurs $investmentkurs
     * @return \BiPRO\StructType\CT_Investment
     */
    public function setInvestmentkurs(\BiPRO\StructType\CT_Investmentkurs $investmentkurs = null)
    {
        $this->Investmentkurs = $investmentkurs;
        return $this;
    }
    /**
     * Get BestandInInvestmentwaehrung value
     * @return \BiPRO\StructType\CT_Bestand|null
     */
    public function getBestandInInvestmentwaehrung()
    {
        return $this->BestandInInvestmentwaehrung;
    }
    /**
     * Set BestandInInvestmentwaehrung value
     * @param \BiPRO\StructType\CT_Bestand $bestandInInvestmentwaehrung
     * @return \BiPRO\StructType\CT_Investment
     */
    public function setBestandInInvestmentwaehrung(\BiPRO\StructType\CT_Bestand $bestandInInvestmentwaehrung = null)
    {
        $this->BestandInInvestmentwaehrung = $bestandInInvestmentwaehrung;
        return $this;
    }
    /**
     * Get BestandInDepotwaehrung value
     * @return \BiPRO\StructType\CT_Bestand|null
     */
    public function getBestandInDepotwaehrung()
    {
        return $this->BestandInDepotwaehrung;
    }
    /**
     * Set BestandInDepotwaehrung value
     * @param \BiPRO\StructType\CT_Bestand $bestandInDepotwaehrung
     * @return \BiPRO\StructType\CT_Investment
     */
    public function setBestandInDepotwaehrung(\BiPRO\StructType\CT_Bestand $bestandInDepotwaehrung = null)
    {
        $this->BestandInDepotwaehrung = $bestandInDepotwaehrung;
        return $this;
    }
}
