<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_InternationaleBankverbindung StructType
 * Meta information extracted from the WSDL
 * - documentation: Internationale Bankverbindung, die nicht zum SEPA-Bereich gehört.
 * @subpackage Structs
 */
class CT_InternationaleBankverbindung extends CT_BankverbindungBasis
{
    /**
     * The Kontonummer
     * Meta information extracted from the WSDL
     * - documentation: Identifikation des Kontos, falls keine IBAN vorhanden ist. | Datentyp für internationale Kontonummern. Text mit der maximalen Länge von 34 Zeichen.
     * - base: xsd:string
     * - maxLength: 34
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Kontonummer;
    /**
     * The Anschrift
     * Meta information extracted from the WSDL
     * - documentation: Anschrift des Geldinstituts.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Partneranschrift
     */
    public $Anschrift;
    /**
     * Constructor method for CT_InternationaleBankverbindung
     * @uses CT_InternationaleBankverbindung::setKontonummer()
     * @uses CT_InternationaleBankverbindung::setAnschrift()
     * @param string $kontonummer
     * @param \BiPRO\StructType\CT_Partneranschrift $anschrift
     */
    public function __construct($kontonummer = null, \BiPRO\StructType\CT_Partneranschrift $anschrift = null)
    {
        $this
            ->setKontonummer($kontonummer)
            ->setAnschrift($anschrift);
    }
    /**
     * Get Kontonummer value
     * @return string|null
     */
    public function getKontonummer()
    {
        return $this->Kontonummer;
    }
    /**
     * Set Kontonummer value
     * @param string $kontonummer
     * @return \BiPRO\StructType\CT_InternationaleBankverbindung
     */
    public function setKontonummer($kontonummer = null)
    {
        // validation for constraint: string
        if (!is_null($kontonummer) && !is_string($kontonummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kontonummer, true), gettype($kontonummer)), __LINE__);
        }
        // validation for constraint: maxLength(34)
        if (!is_null($kontonummer) && mb_strlen($kontonummer) > 34) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 34', mb_strlen($kontonummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($kontonummer) && mb_strlen($kontonummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($kontonummer)), __LINE__);
        }
        $this->Kontonummer = $kontonummer;
        return $this;
    }
    /**
     * Get Anschrift value
     * @return \BiPRO\StructType\CT_Partneranschrift|null
     */
    public function getAnschrift()
    {
        return $this->Anschrift;
    }
    /**
     * Set Anschrift value
     * @param \BiPRO\StructType\CT_Partneranschrift $anschrift
     * @return \BiPRO\StructType\CT_InternationaleBankverbindung
     */
    public function setAnschrift(\BiPRO\StructType\CT_Partneranschrift $anschrift = null)
    {
        $this->Anschrift = $anschrift;
        return $this;
    }
}
