<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Groesse StructType
 * Meta information extracted from the WSDL
 * - documentation: Die physische Ausdehnung eines Gegenstandes.
 * @subpackage Structs
 */
class CT_Groesse extends CT_Objekt
{
    /**
     * The Laenge
     * Meta information extracted from the WSDL
     * - documentation: Zahlwert der Länge. Die Maßeinheit MUSS in LaengenWerteinheit angegeben werden.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Laenge;
    /**
     * The Breite
     * Meta information extracted from the WSDL
     * - documentation: Zahlwert der Breite. Die Maßeinheit MUSS in LaengenWerteinheit angegeben werden
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Breite;
    /**
     * The Hoehe
     * Meta information extracted from the WSDL
     * - documentation: Zahlwert der Höhe, teilweise auch "Dicke" genannt, z.B. bei Glasplatten. Die Maßeinheit MUSS in LaengenWerteinheit angegeben werden.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Hoehe;
    /**
     * The Umfang
     * Meta information extracted from the WSDL
     * - documentation: Zahlwert des Umfangs. Die Maßeinheit MUSS in LaengenWerteinheit angegeben werden.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Umfang;
    /**
     * The LaengenWerteinheit
     * Meta information extracted from the WSDL
     * - documentation: Werteinheit für die Attribute Laenge, Breite, Hoehe und Umfang.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LaengenWerteinheit;
    /**
     * The Flaeche
     * Meta information extracted from the WSDL
     * - documentation: Zahlwert der Fläche. Die Maßeinheit MUSS in FlaechenWerteinheit angegeben werden.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Flaeche;
    /**
     * The FlaechenWerteinheit
     * Meta information extracted from the WSDL
     * - documentation: Werteinheit für das Attribut Flaeche.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FlaechenWerteinheit;
    /**
     * The Volumen
     * Meta information extracted from the WSDL
     * - documentation: Zahlwert des Volumens. Die Maßeinheit MUSS in VolumenWerteinheit angegeben werden.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Volumen;
    /**
     * The VolumenWerteinheit
     * Meta information extracted from the WSDL
     * - documentation: Werteinheit für das Attribut Volumen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VolumenWerteinheit;
    /**
     * Constructor method for CT_Groesse
     * @uses CT_Groesse::setLaenge()
     * @uses CT_Groesse::setBreite()
     * @uses CT_Groesse::setHoehe()
     * @uses CT_Groesse::setUmfang()
     * @uses CT_Groesse::setLaengenWerteinheit()
     * @uses CT_Groesse::setFlaeche()
     * @uses CT_Groesse::setFlaechenWerteinheit()
     * @uses CT_Groesse::setVolumen()
     * @uses CT_Groesse::setVolumenWerteinheit()
     * @param float $laenge
     * @param float $breite
     * @param float $hoehe
     * @param float $umfang
     * @param string $laengenWerteinheit
     * @param float $flaeche
     * @param string $flaechenWerteinheit
     * @param float $volumen
     * @param string $volumenWerteinheit
     */
    public function __construct($laenge = null, $breite = null, $hoehe = null, $umfang = null, $laengenWerteinheit = null, $flaeche = null, $flaechenWerteinheit = null, $volumen = null, $volumenWerteinheit = null)
    {
        $this
            ->setLaenge($laenge)
            ->setBreite($breite)
            ->setHoehe($hoehe)
            ->setUmfang($umfang)
            ->setLaengenWerteinheit($laengenWerteinheit)
            ->setFlaeche($flaeche)
            ->setFlaechenWerteinheit($flaechenWerteinheit)
            ->setVolumen($volumen)
            ->setVolumenWerteinheit($volumenWerteinheit);
    }
    /**
     * Get Laenge value
     * @return float|null
     */
    public function getLaenge()
    {
        return $this->Laenge;
    }
    /**
     * Set Laenge value
     * @param float $laenge
     * @return \BiPRO\StructType\CT_Groesse
     */
    public function setLaenge($laenge = null)
    {
        // validation for constraint: float
        if (!is_null($laenge) && !(is_float($laenge) || is_numeric($laenge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($laenge, true), gettype($laenge)), __LINE__);
        }
        $this->Laenge = $laenge;
        return $this;
    }
    /**
     * Get Breite value
     * @return float|null
     */
    public function getBreite()
    {
        return $this->Breite;
    }
    /**
     * Set Breite value
     * @param float $breite
     * @return \BiPRO\StructType\CT_Groesse
     */
    public function setBreite($breite = null)
    {
        // validation for constraint: float
        if (!is_null($breite) && !(is_float($breite) || is_numeric($breite))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($breite, true), gettype($breite)), __LINE__);
        }
        $this->Breite = $breite;
        return $this;
    }
    /**
     * Get Hoehe value
     * @return float|null
     */
    public function getHoehe()
    {
        return $this->Hoehe;
    }
    /**
     * Set Hoehe value
     * @param float $hoehe
     * @return \BiPRO\StructType\CT_Groesse
     */
    public function setHoehe($hoehe = null)
    {
        // validation for constraint: float
        if (!is_null($hoehe) && !(is_float($hoehe) || is_numeric($hoehe))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hoehe, true), gettype($hoehe)), __LINE__);
        }
        $this->Hoehe = $hoehe;
        return $this;
    }
    /**
     * Get Umfang value
     * @return float|null
     */
    public function getUmfang()
    {
        return $this->Umfang;
    }
    /**
     * Set Umfang value
     * @param float $umfang
     * @return \BiPRO\StructType\CT_Groesse
     */
    public function setUmfang($umfang = null)
    {
        // validation for constraint: float
        if (!is_null($umfang) && !(is_float($umfang) || is_numeric($umfang))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($umfang, true), gettype($umfang)), __LINE__);
        }
        $this->Umfang = $umfang;
        return $this;
    }
    /**
     * Get LaengenWerteinheit value
     * @return string|null
     */
    public function getLaengenWerteinheit()
    {
        return $this->LaengenWerteinheit;
    }
    /**
     * Set LaengenWerteinheit value
     * @uses \BiPRO\EnumType\ST_Werteinheit::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Werteinheit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $laengenWerteinheit
     * @return \BiPRO\StructType\CT_Groesse
     */
    public function setLaengenWerteinheit($laengenWerteinheit = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Werteinheit::valueIsValid($laengenWerteinheit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Werteinheit', is_array($laengenWerteinheit) ? implode(', ', $laengenWerteinheit) : var_export($laengenWerteinheit, true), implode(', ', \BiPRO\EnumType\ST_Werteinheit::getValidValues())), __LINE__);
        }
        $this->LaengenWerteinheit = $laengenWerteinheit;
        return $this;
    }
    /**
     * Get Flaeche value
     * @return float|null
     */
    public function getFlaeche()
    {
        return $this->Flaeche;
    }
    /**
     * Set Flaeche value
     * @param float $flaeche
     * @return \BiPRO\StructType\CT_Groesse
     */
    public function setFlaeche($flaeche = null)
    {
        // validation for constraint: float
        if (!is_null($flaeche) && !(is_float($flaeche) || is_numeric($flaeche))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($flaeche, true), gettype($flaeche)), __LINE__);
        }
        $this->Flaeche = $flaeche;
        return $this;
    }
    /**
     * Get FlaechenWerteinheit value
     * @return string|null
     */
    public function getFlaechenWerteinheit()
    {
        return $this->FlaechenWerteinheit;
    }
    /**
     * Set FlaechenWerteinheit value
     * @uses \BiPRO\EnumType\ST_Werteinheit::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Werteinheit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $flaechenWerteinheit
     * @return \BiPRO\StructType\CT_Groesse
     */
    public function setFlaechenWerteinheit($flaechenWerteinheit = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Werteinheit::valueIsValid($flaechenWerteinheit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Werteinheit', is_array($flaechenWerteinheit) ? implode(', ', $flaechenWerteinheit) : var_export($flaechenWerteinheit, true), implode(', ', \BiPRO\EnumType\ST_Werteinheit::getValidValues())), __LINE__);
        }
        $this->FlaechenWerteinheit = $flaechenWerteinheit;
        return $this;
    }
    /**
     * Get Volumen value
     * @return float|null
     */
    public function getVolumen()
    {
        return $this->Volumen;
    }
    /**
     * Set Volumen value
     * @param float $volumen
     * @return \BiPRO\StructType\CT_Groesse
     */
    public function setVolumen($volumen = null)
    {
        // validation for constraint: float
        if (!is_null($volumen) && !(is_float($volumen) || is_numeric($volumen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($volumen, true), gettype($volumen)), __LINE__);
        }
        $this->Volumen = $volumen;
        return $this;
    }
    /**
     * Get VolumenWerteinheit value
     * @return string|null
     */
    public function getVolumenWerteinheit()
    {
        return $this->VolumenWerteinheit;
    }
    /**
     * Set VolumenWerteinheit value
     * @uses \BiPRO\EnumType\ST_Werteinheit::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Werteinheit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $volumenWerteinheit
     * @return \BiPRO\StructType\CT_Groesse
     */
    public function setVolumenWerteinheit($volumenWerteinheit = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Werteinheit::valueIsValid($volumenWerteinheit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Werteinheit', is_array($volumenWerteinheit) ? implode(', ', $volumenWerteinheit) : var_export($volumenWerteinheit, true), implode(', ', \BiPRO\EnumType\ST_Werteinheit::getValidValues())), __LINE__);
        }
        $this->VolumenWerteinheit = $volumenWerteinheit;
        return $this;
    }
}
