<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Gliederungspunkt StructType
 * Meta information extracted from the WSDL
 * - documentation: Gliederungspunke ermöglichen die inhaltliche Gliederung eines Fragenkomplexes durch Gruppierung der Elemente in (ggf. auch geschachtelte) Abschnitte mit natürlichsprachigen Überschriften, die der Consumer im Frontend anzeigen
 * kann.
 * @subpackage Structs
 */
class CT_Gliederungspunkt extends CT_Element
{
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Text;
    /**
     * The Element
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \BiPRO\StructType\CT_Element[]
     */
    public $Element;
    /**
     * Constructor method for CT_Gliederungspunkt
     * @uses CT_Gliederungspunkt::setText()
     * @uses CT_Gliederungspunkt::setElement()
     * @param string $text
     * @param \BiPRO\StructType\CT_Element[] $element
     */
    public function __construct($text = null, array $element = array())
    {
        $this
            ->setText($text)
            ->setElement($element);
    }
    /**
     * Get Text value
     * @return string
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \BiPRO\StructType\CT_Gliederungspunkt
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Element value
     * @return \BiPRO\StructType\CT_Element[]
     */
    public function getElement()
    {
        return $this->Element;
    }
    /**
     * This method is responsible for validating the values passed to the setElement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setElement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateElementForArrayConstraintsFromSetElement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GliederungspunktElementItem) {
            // validation for constraint: itemType
            if (!$cT_GliederungspunktElementItem instanceof \BiPRO\StructType\CT_Element) {
                $invalidValues[] = is_object($cT_GliederungspunktElementItem) ? get_class($cT_GliederungspunktElementItem) : sprintf('%s(%s)', gettype($cT_GliederungspunktElementItem), var_export($cT_GliederungspunktElementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Element property can only contain items of type \BiPRO\StructType\CT_Element, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Element value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Element[] $element
     * @return \BiPRO\StructType\CT_Gliederungspunkt
     */
    public function setElement(array $element = array())
    {
        // validation for constraint: array
        if ('' !== ($elementArrayErrorMessage = self::validateElementForArrayConstraintsFromSetElement($element))) {
            throw new \InvalidArgumentException($elementArrayErrorMessage, __LINE__);
        }
        $this->Element = $element;
        return $this;
    }
    /**
     * Add item to Element value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Element $item
     * @return \BiPRO\StructType\CT_Gliederungspunkt
     */
    public function addToElement(\BiPRO\StructType\CT_Element $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Element) {
            throw new \InvalidArgumentException(sprintf('The Element property can only contain items of type \BiPRO\StructType\CT_Element, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Element[] = $item;
        return $this;
    }
}
