<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Glasschaden StructType
 * Meta information extracted from the WSDL
 * - documentation: Bruch oder Beschädigung einer Glasscheibe oder eines Objekts aus Glas.
 * @subpackage Structs
 */
class CT_Glasschaden extends CT_SchadenZuObjekt
{
    /**
     * The NotverglasungErforderlich
     * Meta information extracted from the WSDL
     * - documentation: JA = Notverglasung erforderlich.NEIN = Notverglasung nicht erforderlich.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $NotverglasungErforderlich;
    /**
     * Constructor method for CT_Glasschaden
     * @uses CT_Glasschaden::setNotverglasungErforderlich()
     * @param bool $notverglasungErforderlich
     */
    public function __construct($notverglasungErforderlich = null)
    {
        $this
            ->setNotverglasungErforderlich($notverglasungErforderlich);
    }
    /**
     * Get NotverglasungErforderlich value
     * @return bool|null
     */
    public function getNotverglasungErforderlich()
    {
        return $this->NotverglasungErforderlich;
    }
    /**
     * Set NotverglasungErforderlich value
     * @param bool $notverglasungErforderlich
     * @return \BiPRO\StructType\CT_Glasschaden
     */
    public function setNotverglasungErforderlich($notverglasungErforderlich = null)
    {
        // validation for constraint: boolean
        if (!is_null($notverglasungErforderlich) && !is_bool($notverglasungErforderlich)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notverglasungErforderlich, true), gettype($notverglasungErforderlich)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($notverglasungErforderlich) && !preg_match('/true|false/', $notverglasungErforderlich)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($notverglasungErforderlich, true)), __LINE__);
        }
        $this->NotverglasungErforderlich = $notverglasungErforderlich;
        return $this;
    }
}
