<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Gesundheitsdaten StructType
 * Meta information extracted from the WSDL
 * - documentation: Biometrische Daten einer (natürlichen) versicherten Person
 * @subpackage Structs
 */
class CT_Gesundheitsdaten extends CT_Objekt
{
    /**
     * The Groesse
     * Meta information extracted from the WSDL
     * - documentation: Die Körpergröße der Person in cm.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Groesse;
    /**
     * The Gewicht
     * Meta information extracted from the WSDL
     * - documentation: Das Gewicht der Person in Kg.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Gewicht;
    /**
     * The DioptrienLinks
     * Meta information extracted from the WSDL
     * - documentation: Angabe zur Fehlsichtigkeit des linken Auges der Person Kurzsichtigkeit: negative Zahl; Weitsichtigkeit: positive Zahl. Angabe in Dioptrien gemaess DIN.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $DioptrienLinks;
    /**
     * The DioptrienRechts
     * Meta information extracted from the WSDL
     * - documentation: Angabe zur Fehlsichtigkeit des rechten Auges der Person Kurzsichtigkeit: negative Zahl; Weitsichtigkeit: positive Zahl. Angabe in Dioptrien gemaess DIN.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $DioptrienRechts;
    /**
     * The FehlendeZaehne
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der fehlenden echten Zähne ohne Weisheitszähne
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $FehlendeZaehne;
    /**
     * The VoraussichtlicherEntbindungstermin
     * Meta information extracted from the WSDL
     * - documentation: Hierüber kann auch festgestellt werden ob eine Schwangerschaft zum Zeitpunkt des Antrags vorliegt. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $VoraussichtlicherEntbindungstermin;
    /**
     * The Behinderungsgrad
     * Meta information extracted from the WSDL
     * - documentation: Grad der Behinderung einer Person. | Prozentanteil ohne Prozentzeichen z.B. 50 = 50% oder 12,5 = 12,5%
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var float
     */
    public $Behinderungsgrad;
    /**
     * The ZuZiehendeZaehne
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der bekannten zu ziehenden Zähne.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ZuZiehendeZaehne;
    /**
     * Constructor method for CT_Gesundheitsdaten
     * @uses CT_Gesundheitsdaten::setGroesse()
     * @uses CT_Gesundheitsdaten::setGewicht()
     * @uses CT_Gesundheitsdaten::setDioptrienLinks()
     * @uses CT_Gesundheitsdaten::setDioptrienRechts()
     * @uses CT_Gesundheitsdaten::setFehlendeZaehne()
     * @uses CT_Gesundheitsdaten::setVoraussichtlicherEntbindungstermin()
     * @uses CT_Gesundheitsdaten::setBehinderungsgrad()
     * @uses CT_Gesundheitsdaten::setZuZiehendeZaehne()
     * @param int $groesse
     * @param int $gewicht
     * @param float $dioptrienLinks
     * @param float $dioptrienRechts
     * @param int $fehlendeZaehne
     * @param string $voraussichtlicherEntbindungstermin
     * @param float $behinderungsgrad
     * @param int $zuZiehendeZaehne
     */
    public function __construct($groesse = null, $gewicht = null, $dioptrienLinks = null, $dioptrienRechts = null, $fehlendeZaehne = null, $voraussichtlicherEntbindungstermin = null, $behinderungsgrad = null, $zuZiehendeZaehne = null)
    {
        $this
            ->setGroesse($groesse)
            ->setGewicht($gewicht)
            ->setDioptrienLinks($dioptrienLinks)
            ->setDioptrienRechts($dioptrienRechts)
            ->setFehlendeZaehne($fehlendeZaehne)
            ->setVoraussichtlicherEntbindungstermin($voraussichtlicherEntbindungstermin)
            ->setBehinderungsgrad($behinderungsgrad)
            ->setZuZiehendeZaehne($zuZiehendeZaehne);
    }
    /**
     * Get Groesse value
     * @return int|null
     */
    public function getGroesse()
    {
        return $this->Groesse;
    }
    /**
     * Set Groesse value
     * @param int $groesse
     * @return \BiPRO\StructType\CT_Gesundheitsdaten
     */
    public function setGroesse($groesse = null)
    {
        // validation for constraint: int
        if (!is_null($groesse) && !(is_int($groesse) || ctype_digit($groesse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groesse, true), gettype($groesse)), __LINE__);
        }
        $this->Groesse = $groesse;
        return $this;
    }
    /**
     * Get Gewicht value
     * @return int|null
     */
    public function getGewicht()
    {
        return $this->Gewicht;
    }
    /**
     * Set Gewicht value
     * @param int $gewicht
     * @return \BiPRO\StructType\CT_Gesundheitsdaten
     */
    public function setGewicht($gewicht = null)
    {
        // validation for constraint: int
        if (!is_null($gewicht) && !(is_int($gewicht) || ctype_digit($gewicht))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gewicht, true), gettype($gewicht)), __LINE__);
        }
        $this->Gewicht = $gewicht;
        return $this;
    }
    /**
     * Get DioptrienLinks value
     * @return float|null
     */
    public function getDioptrienLinks()
    {
        return $this->DioptrienLinks;
    }
    /**
     * Set DioptrienLinks value
     * @param float $dioptrienLinks
     * @return \BiPRO\StructType\CT_Gesundheitsdaten
     */
    public function setDioptrienLinks($dioptrienLinks = null)
    {
        // validation for constraint: float
        if (!is_null($dioptrienLinks) && !(is_float($dioptrienLinks) || is_numeric($dioptrienLinks))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dioptrienLinks, true), gettype($dioptrienLinks)), __LINE__);
        }
        $this->DioptrienLinks = $dioptrienLinks;
        return $this;
    }
    /**
     * Get DioptrienRechts value
     * @return float|null
     */
    public function getDioptrienRechts()
    {
        return $this->DioptrienRechts;
    }
    /**
     * Set DioptrienRechts value
     * @param float $dioptrienRechts
     * @return \BiPRO\StructType\CT_Gesundheitsdaten
     */
    public function setDioptrienRechts($dioptrienRechts = null)
    {
        // validation for constraint: float
        if (!is_null($dioptrienRechts) && !(is_float($dioptrienRechts) || is_numeric($dioptrienRechts))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dioptrienRechts, true), gettype($dioptrienRechts)), __LINE__);
        }
        $this->DioptrienRechts = $dioptrienRechts;
        return $this;
    }
    /**
     * Get FehlendeZaehne value
     * @return int|null
     */
    public function getFehlendeZaehne()
    {
        return $this->FehlendeZaehne;
    }
    /**
     * Set FehlendeZaehne value
     * @param int $fehlendeZaehne
     * @return \BiPRO\StructType\CT_Gesundheitsdaten
     */
    public function setFehlendeZaehne($fehlendeZaehne = null)
    {
        // validation for constraint: int
        if (!is_null($fehlendeZaehne) && !(is_int($fehlendeZaehne) || ctype_digit($fehlendeZaehne))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fehlendeZaehne, true), gettype($fehlendeZaehne)), __LINE__);
        }
        $this->FehlendeZaehne = $fehlendeZaehne;
        return $this;
    }
    /**
     * Get VoraussichtlicherEntbindungstermin value
     * @return string|null
     */
    public function getVoraussichtlicherEntbindungstermin()
    {
        return $this->VoraussichtlicherEntbindungstermin;
    }
    /**
     * Set VoraussichtlicherEntbindungstermin value
     * @param string $voraussichtlicherEntbindungstermin
     * @return \BiPRO\StructType\CT_Gesundheitsdaten
     */
    public function setVoraussichtlicherEntbindungstermin($voraussichtlicherEntbindungstermin = null)
    {
        // validation for constraint: string
        if (!is_null($voraussichtlicherEntbindungstermin) && !is_string($voraussichtlicherEntbindungstermin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voraussichtlicherEntbindungstermin, true), gettype($voraussichtlicherEntbindungstermin)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($voraussichtlicherEntbindungstermin) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $voraussichtlicherEntbindungstermin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($voraussichtlicherEntbindungstermin, true)), __LINE__);
        }
        $this->VoraussichtlicherEntbindungstermin = $voraussichtlicherEntbindungstermin;
        return $this;
    }
    /**
     * Get Behinderungsgrad value
     * @return float|null
     */
    public function getBehinderungsgrad()
    {
        return $this->Behinderungsgrad;
    }
    /**
     * Set Behinderungsgrad value
     * @param float $behinderungsgrad
     * @return \BiPRO\StructType\CT_Gesundheitsdaten
     */
    public function setBehinderungsgrad($behinderungsgrad = null)
    {
        // validation for constraint: float
        if (!is_null($behinderungsgrad) && !(is_float($behinderungsgrad) || is_numeric($behinderungsgrad))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($behinderungsgrad, true), gettype($behinderungsgrad)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($behinderungsgrad) && $behinderungsgrad < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($behinderungsgrad, true)), __LINE__);
        }
        $this->Behinderungsgrad = $behinderungsgrad;
        return $this;
    }
    /**
     * Get ZuZiehendeZaehne value
     * @return int|null
     */
    public function getZuZiehendeZaehne()
    {
        return $this->ZuZiehendeZaehne;
    }
    /**
     * Set ZuZiehendeZaehne value
     * @param int $zuZiehendeZaehne
     * @return \BiPRO\StructType\CT_Gesundheitsdaten
     */
    public function setZuZiehendeZaehne($zuZiehendeZaehne = null)
    {
        // validation for constraint: int
        if (!is_null($zuZiehendeZaehne) && !(is_int($zuZiehendeZaehne) || ctype_digit($zuZiehendeZaehne))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zuZiehendeZaehne, true), gettype($zuZiehendeZaehne)), __LINE__);
        }
        $this->ZuZiehendeZaehne = $zuZiehendeZaehne;
        return $this;
    }
}
