<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_GesetzlicheKrankenversicherung StructType
 * Meta information extracted from the WSDL
 * - documentation: Daten zum Versicherungsstatus einer natuerlichen Person in der gesetzlichen Krankenversicherung.Das Attribut Krankenkasse fehlt, da der entsprechende einfache Datentyp (ST_Krankenkasse) nicht definiert ist.
 * @subpackage Structs
 */
class CT_GesetzlicheKrankenversicherung extends CT_Objekt
{
    /**
     * The GesetzlichVersichert
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: true|false
     * @var bool
     */
    public $GesetzlichVersichert;
    /**
     * The Pflichtig
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Pflichtig;
    /**
     * The Beitragssatz
     * Meta information extracted from the WSDL
     * - documentation: Prozentanteil ohne Prozentzeichen z.B. 50 = 50% oder 12,5 = 12,5%
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var float
     */
    public $Beitragssatz;
    /**
     * The Land
     * Meta information extracted from the WSDL
     * - documentation: Land der gesetztlichen Krankenversicherung. MUSS bei versicherten Personen angegeben werden die aufgrund ihres regelmäßigen Grenzübergangs einer ausländischen gesetzlichen Krankenversicherung angehören. Wird das Land nicht
     * angegeben, MUSS die Krankenversicherung als inländische gesetzliche Krankenversicherung interpretiert werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Land;
    /**
     * The BestehtBei
     * Meta information extracted from the WSDL
     * - documentation: Unternehmen, bei dem die gesetzliche Krankenversicherung besteht.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Unternehmen
     */
    public $BestehtBei;
    /**
     * Constructor method for CT_GesetzlicheKrankenversicherung
     * @uses CT_GesetzlicheKrankenversicherung::setGesetzlichVersichert()
     * @uses CT_GesetzlicheKrankenversicherung::setPflichtig()
     * @uses CT_GesetzlicheKrankenversicherung::setBeitragssatz()
     * @uses CT_GesetzlicheKrankenversicherung::setLand()
     * @uses CT_GesetzlicheKrankenversicherung::setBestehtBei()
     * @param bool $gesetzlichVersichert
     * @param bool $pflichtig
     * @param float $beitragssatz
     * @param string $land
     * @param \BiPRO\StructType\CT_Unternehmen $bestehtBei
     */
    public function __construct($gesetzlichVersichert = null, $pflichtig = null, $beitragssatz = null, $land = null, \BiPRO\StructType\CT_Unternehmen $bestehtBei = null)
    {
        $this
            ->setGesetzlichVersichert($gesetzlichVersichert)
            ->setPflichtig($pflichtig)
            ->setBeitragssatz($beitragssatz)
            ->setLand($land)
            ->setBestehtBei($bestehtBei);
    }
    /**
     * Get GesetzlichVersichert value
     * @return bool
     */
    public function getGesetzlichVersichert()
    {
        return $this->GesetzlichVersichert;
    }
    /**
     * Set GesetzlichVersichert value
     * @param bool $gesetzlichVersichert
     * @return \BiPRO\StructType\CT_GesetzlicheKrankenversicherung
     */
    public function setGesetzlichVersichert($gesetzlichVersichert = null)
    {
        // validation for constraint: boolean
        if (!is_null($gesetzlichVersichert) && !is_bool($gesetzlichVersichert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($gesetzlichVersichert, true), gettype($gesetzlichVersichert)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($gesetzlichVersichert) && !preg_match('/true|false/', $gesetzlichVersichert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($gesetzlichVersichert, true)), __LINE__);
        }
        $this->GesetzlichVersichert = $gesetzlichVersichert;
        return $this;
    }
    /**
     * Get Pflichtig value
     * @return bool|null
     */
    public function getPflichtig()
    {
        return $this->Pflichtig;
    }
    /**
     * Set Pflichtig value
     * @param bool $pflichtig
     * @return \BiPRO\StructType\CT_GesetzlicheKrankenversicherung
     */
    public function setPflichtig($pflichtig = null)
    {
        // validation for constraint: boolean
        if (!is_null($pflichtig) && !is_bool($pflichtig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pflichtig, true), gettype($pflichtig)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($pflichtig) && !preg_match('/true|false/', $pflichtig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($pflichtig, true)), __LINE__);
        }
        $this->Pflichtig = $pflichtig;
        return $this;
    }
    /**
     * Get Beitragssatz value
     * @return float|null
     */
    public function getBeitragssatz()
    {
        return $this->Beitragssatz;
    }
    /**
     * Set Beitragssatz value
     * @param float $beitragssatz
     * @return \BiPRO\StructType\CT_GesetzlicheKrankenversicherung
     */
    public function setBeitragssatz($beitragssatz = null)
    {
        // validation for constraint: float
        if (!is_null($beitragssatz) && !(is_float($beitragssatz) || is_numeric($beitragssatz))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($beitragssatz, true), gettype($beitragssatz)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($beitragssatz) && $beitragssatz < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($beitragssatz, true)), __LINE__);
        }
        $this->Beitragssatz = $beitragssatz;
        return $this;
    }
    /**
     * Get Land value
     * @return string|null
     */
    public function getLand()
    {
        return $this->Land;
    }
    /**
     * Set Land value
     * @uses \BiPRO\EnumType\ST_Laenderkennzeichen::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Laenderkennzeichen::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $land
     * @return \BiPRO\StructType\CT_GesetzlicheKrankenversicherung
     */
    public function setLand($land = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Laenderkennzeichen::valueIsValid($land)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Laenderkennzeichen', is_array($land) ? implode(', ', $land) : var_export($land, true), implode(', ', \BiPRO\EnumType\ST_Laenderkennzeichen::getValidValues())), __LINE__);
        }
        $this->Land = $land;
        return $this;
    }
    /**
     * Get BestehtBei value
     * @return \BiPRO\StructType\CT_Unternehmen|null
     */
    public function getBestehtBei()
    {
        return $this->BestehtBei;
    }
    /**
     * Set BestehtBei value
     * @param \BiPRO\StructType\CT_Unternehmen $bestehtBei
     * @return \BiPRO\StructType\CT_GesetzlicheKrankenversicherung
     */
    public function setBestehtBei(\BiPRO\StructType\CT_Unternehmen $bestehtBei = null)
    {
        $this->BestehtBei = $bestehtBei;
        return $this;
    }
}
