<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Geschaeftsvorgang StructType
 * Meta information extracted from the WSDL
 * - documentation: Basis-Objekt aller von der BiPRO definierten Geschaeftsvorgaenge.
 * @subpackage Structs
 */
abstract class CT_Geschaeftsvorgang extends CT_Objekt
{
    /**
     * The Vorgangsnummer
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige Identifizierung des Geschaeftsvorgangs beim produktgebenden Unternehmen. Hinweis: In allen GDV-Releases bis einschließlich 2015 hat dieser Datentyp nur 17 Stellen; ab da erfolgt eine Anpassung auf 35 Stellen. | Datentyp
     * zur Identifizierung von Geschäftsvorgängen.Hinweis: In allen GDV-Releases bis einschließlich 2015 hat dieser Datentyp nur 17 Stellen; ab da erfolgt eine Anpassung auf 35 Stellen.
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Vorgangsnummer;
    /**
     * The VorgangsnummerVM
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige Identifizierung des Geschaeftsvorgangs beim Vermittler. Hinweis: In allen GDV-Releases bis einschließlich 2015 hat dieser Datentyp nur 17 Stellen; ab da erfolgt eine Anpassung auf 35 Stellen. | Datentyp zur
     * Identifizierung von Geschäftsvorgängen.Hinweis: In allen GDV-Releases bis einschließlich 2015 hat dieser Datentyp nur 17 Stellen; ab da erfolgt eine Anpassung auf 35 Stellen.
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $VorgangsnummerVM;
    /**
     * The Erstelldatum
     * Meta information extracted from the WSDL
     * - documentation: Datum der Aufgabe des Geschaeftsvorgangs. | wie ST_DatumZeit ergänzt um Sekunden
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9]
     * @var string
     */
    public $Erstelldatum;
    /**
     * The Freitext
     * Meta information extracted from the WSDL
     * - documentation: Möglichkeit zur Eingabe von Hinweisen zum Geschaeftsvorgang.
     * - base: xsd:string
     * - maxLength: 1000
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Freitext;
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Art des Geschäftsvorganges | Art des Geschäftsvorgang. Konkrete Werte und deren Bedeutung im Kontext der BiPRO-Normen sind in BiPRO allg. Anlage 1 Gesamtliste GeVo-Arten.xlsx definiert.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{9}
     * @var string
     */
    public $ArtID;
    /**
     * The Vermittler
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Vermittler[]
     */
    public $Vermittler;
    /**
     * The Dokumentanforderung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Dokumentanforderung[]
     */
    public $Dokumentanforderung;
    /**
     * The Datei
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Datei[]
     */
    public $Datei;
    /**
     * The Dokumentinformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Dokumentinformation[]
     */
    public $Dokumentinformation;
    /**
     * The Dienstleister
     * Meta information extracted from the WSDL
     * - documentation: Dienstleister, die an der Bearbeitung des Geschäftsvorgangs mitwirken, z. B. Assistancedienstleister, Flottenmanagementdienstleister, Schadenmanagementdienstleister, Kommunikationsdienstleister.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Dienstleister[]
     */
    public $Dienstleister;
    /**
     * The Dokumentversand
     * Meta information extracted from the WSDL
     * - documentation: Informationen zu einem für den Geschäftsvorgang relevantes Dokument, welches alternativ - d. h. nicht innerhalb der BiPRO-Nachricht - versand wird (z.B. postalischer Versand des beantworteten Risikofragebogens).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Dokumentversand[]
     */
    public $Dokumentversand;
    /**
     * Constructor method for CT_Geschaeftsvorgang
     * @uses CT_Geschaeftsvorgang::setVorgangsnummer()
     * @uses CT_Geschaeftsvorgang::setVorgangsnummerVM()
     * @uses CT_Geschaeftsvorgang::setErstelldatum()
     * @uses CT_Geschaeftsvorgang::setFreitext()
     * @uses CT_Geschaeftsvorgang::setArtID()
     * @uses CT_Geschaeftsvorgang::setVermittler()
     * @uses CT_Geschaeftsvorgang::setDokumentanforderung()
     * @uses CT_Geschaeftsvorgang::setDatei()
     * @uses CT_Geschaeftsvorgang::setDokumentinformation()
     * @uses CT_Geschaeftsvorgang::setDienstleister()
     * @uses CT_Geschaeftsvorgang::setDokumentversand()
     * @param string $vorgangsnummer
     * @param string $vorgangsnummerVM
     * @param string $erstelldatum
     * @param string $freitext
     * @param string $artID
     * @param \BiPRO\StructType\CT_Vermittler[] $vermittler
     * @param \BiPRO\StructType\CT_Dokumentanforderung[] $dokumentanforderung
     * @param \BiPRO\StructType\CT_Datei[] $datei
     * @param \BiPRO\StructType\CT_Dokumentinformation[] $dokumentinformation
     * @param \BiPRO\StructType\CT_Dienstleister[] $dienstleister
     * @param \BiPRO\StructType\CT_Dokumentversand[] $dokumentversand
     */
    public function __construct($vorgangsnummer = null, $vorgangsnummerVM = null, $erstelldatum = null, $freitext = null, $artID = null, array $vermittler = array(), array $dokumentanforderung = array(), array $datei = array(), array $dokumentinformation = array(), array $dienstleister = array(), array $dokumentversand = array())
    {
        $this
            ->setVorgangsnummer($vorgangsnummer)
            ->setVorgangsnummerVM($vorgangsnummerVM)
            ->setErstelldatum($erstelldatum)
            ->setFreitext($freitext)
            ->setArtID($artID)
            ->setVermittler($vermittler)
            ->setDokumentanforderung($dokumentanforderung)
            ->setDatei($datei)
            ->setDokumentinformation($dokumentinformation)
            ->setDienstleister($dienstleister)
            ->setDokumentversand($dokumentversand);
    }
    /**
     * Get Vorgangsnummer value
     * @return string|null
     */
    public function getVorgangsnummer()
    {
        return $this->Vorgangsnummer;
    }
    /**
     * Set Vorgangsnummer value
     * @param string $vorgangsnummer
     * @return \BiPRO\StructType\CT_Geschaeftsvorgang
     */
    public function setVorgangsnummer($vorgangsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($vorgangsnummer) && !is_string($vorgangsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorgangsnummer, true), gettype($vorgangsnummer)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($vorgangsnummer) && mb_strlen($vorgangsnummer) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($vorgangsnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vorgangsnummer) && mb_strlen($vorgangsnummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vorgangsnummer)), __LINE__);
        }
        $this->Vorgangsnummer = $vorgangsnummer;
        return $this;
    }
    /**
     * Get VorgangsnummerVM value
     * @return string|null
     */
    public function getVorgangsnummerVM()
    {
        return $this->VorgangsnummerVM;
    }
    /**
     * Set VorgangsnummerVM value
     * @param string $vorgangsnummerVM
     * @return \BiPRO\StructType\CT_Geschaeftsvorgang
     */
    public function setVorgangsnummerVM($vorgangsnummerVM = null)
    {
        // validation for constraint: string
        if (!is_null($vorgangsnummerVM) && !is_string($vorgangsnummerVM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorgangsnummerVM, true), gettype($vorgangsnummerVM)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($vorgangsnummerVM) && mb_strlen($vorgangsnummerVM) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($vorgangsnummerVM)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vorgangsnummerVM) && mb_strlen($vorgangsnummerVM) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vorgangsnummerVM)), __LINE__);
        }
        $this->VorgangsnummerVM = $vorgangsnummerVM;
        return $this;
    }
    /**
     * Get Erstelldatum value
     * @return string|null
     */
    public function getErstelldatum()
    {
        return $this->Erstelldatum;
    }
    /**
     * Set Erstelldatum value
     * @param string $erstelldatum
     * @return \BiPRO\StructType\CT_Geschaeftsvorgang
     */
    public function setErstelldatum($erstelldatum = null)
    {
        // validation for constraint: string
        if (!is_null($erstelldatum) && !is_string($erstelldatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erstelldatum, true), gettype($erstelldatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9])
        if (!is_null($erstelldatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9]/', $erstelldatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9]', var_export($erstelldatum, true)), __LINE__);
        }
        $this->Erstelldatum = $erstelldatum;
        return $this;
    }
    /**
     * Get Freitext value
     * @return string|null
     */
    public function getFreitext()
    {
        return $this->Freitext;
    }
    /**
     * Set Freitext value
     * @param string $freitext
     * @return \BiPRO\StructType\CT_Geschaeftsvorgang
     */
    public function setFreitext($freitext = null)
    {
        // validation for constraint: string
        if (!is_null($freitext) && !is_string($freitext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($freitext, true), gettype($freitext)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($freitext) && mb_strlen($freitext) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($freitext)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($freitext) && mb_strlen($freitext) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($freitext)), __LINE__);
        }
        $this->Freitext = $freitext;
        return $this;
    }
    /**
     * Get ArtID value
     * @return string|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @param string $artID
     * @return \BiPRO\StructType\CT_Geschaeftsvorgang
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: string
        if (!is_null($artID) && !is_string($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artID, true), gettype($artID)), __LINE__);
        }
        // validation for constraint: pattern(\d{9})
        if (!is_null($artID) && !preg_match('/\\d{9}/', $artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{9}', var_export($artID, true)), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Vermittler value
     * @return \BiPRO\StructType\CT_Vermittler[]|null
     */
    public function getVermittler()
    {
        return $this->Vermittler;
    }
    /**
     * This method is responsible for validating the values passed to the setVermittler method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVermittler method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVermittlerForArrayConstraintsFromSetVermittler(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GeschaeftsvorgangVermittlerItem) {
            // validation for constraint: itemType
            if (!$cT_GeschaeftsvorgangVermittlerItem instanceof \BiPRO\StructType\CT_Vermittler) {
                $invalidValues[] = is_object($cT_GeschaeftsvorgangVermittlerItem) ? get_class($cT_GeschaeftsvorgangVermittlerItem) : sprintf('%s(%s)', gettype($cT_GeschaeftsvorgangVermittlerItem), var_export($cT_GeschaeftsvorgangVermittlerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Vermittler property can only contain items of type \BiPRO\StructType\CT_Vermittler, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Vermittler value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vermittler[] $vermittler
     * @return \BiPRO\StructType\CT_Geschaeftsvorgang
     */
    public function setVermittler(array $vermittler = array())
    {
        // validation for constraint: array
        if ('' !== ($vermittlerArrayErrorMessage = self::validateVermittlerForArrayConstraintsFromSetVermittler($vermittler))) {
            throw new \InvalidArgumentException($vermittlerArrayErrorMessage, __LINE__);
        }
        $this->Vermittler = $vermittler;
        return $this;
    }
    /**
     * Add item to Vermittler value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vermittler $item
     * @return \BiPRO\StructType\CT_Geschaeftsvorgang
     */
    public function addToVermittler(\BiPRO\StructType\CT_Vermittler $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Vermittler) {
            throw new \InvalidArgumentException(sprintf('The Vermittler property can only contain items of type \BiPRO\StructType\CT_Vermittler, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Vermittler[] = $item;
        return $this;
    }
    /**
     * Get Dokumentanforderung value
     * @return \BiPRO\StructType\CT_Dokumentanforderung[]|null
     */
    public function getDokumentanforderung()
    {
        return $this->Dokumentanforderung;
    }
    /**
     * This method is responsible for validating the values passed to the setDokumentanforderung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDokumentanforderung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDokumentanforderungForArrayConstraintsFromSetDokumentanforderung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GeschaeftsvorgangDokumentanforderungItem) {
            // validation for constraint: itemType
            if (!$cT_GeschaeftsvorgangDokumentanforderungItem instanceof \BiPRO\StructType\CT_Dokumentanforderung) {
                $invalidValues[] = is_object($cT_GeschaeftsvorgangDokumentanforderungItem) ? get_class($cT_GeschaeftsvorgangDokumentanforderungItem) : sprintf('%s(%s)', gettype($cT_GeschaeftsvorgangDokumentanforderungItem), var_export($cT_GeschaeftsvorgangDokumentanforderungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Dokumentanforderung property can only contain items of type \BiPRO\StructType\CT_Dokumentanforderung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Dokumentanforderung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Dokumentanforderung[] $dokumentanforderung
     * @return \BiPRO\StructType\CT_Geschaeftsvorgang
     */
    public function setDokumentanforderung(array $dokumentanforderung = array())
    {
        // validation for constraint: array
        if ('' !== ($dokumentanforderungArrayErrorMessage = self::validateDokumentanforderungForArrayConstraintsFromSetDokumentanforderung($dokumentanforderung))) {
            throw new \InvalidArgumentException($dokumentanforderungArrayErrorMessage, __LINE__);
        }
        $this->Dokumentanforderung = $dokumentanforderung;
        return $this;
    }
    /**
     * Add item to Dokumentanforderung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Dokumentanforderung $item
     * @return \BiPRO\StructType\CT_Geschaeftsvorgang
     */
    public function addToDokumentanforderung(\BiPRO\StructType\CT_Dokumentanforderung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Dokumentanforderung) {
            throw new \InvalidArgumentException(sprintf('The Dokumentanforderung property can only contain items of type \BiPRO\StructType\CT_Dokumentanforderung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Dokumentanforderung[] = $item;
        return $this;
    }
    /**
     * Get Datei value
     * @return \BiPRO\StructType\CT_Datei[]|null
     */
    public function getDatei()
    {
        return $this->Datei;
    }
    /**
     * This method is responsible for validating the values passed to the setDatei method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatei method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDateiForArrayConstraintsFromSetDatei(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GeschaeftsvorgangDateiItem) {
            // validation for constraint: itemType
            if (!$cT_GeschaeftsvorgangDateiItem instanceof \BiPRO\StructType\CT_Datei) {
                $invalidValues[] = is_object($cT_GeschaeftsvorgangDateiItem) ? get_class($cT_GeschaeftsvorgangDateiItem) : sprintf('%s(%s)', gettype($cT_GeschaeftsvorgangDateiItem), var_export($cT_GeschaeftsvorgangDateiItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Datei property can only contain items of type \BiPRO\StructType\CT_Datei, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Datei value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Datei[] $datei
     * @return \BiPRO\StructType\CT_Geschaeftsvorgang
     */
    public function setDatei(array $datei = array())
    {
        // validation for constraint: array
        if ('' !== ($dateiArrayErrorMessage = self::validateDateiForArrayConstraintsFromSetDatei($datei))) {
            throw new \InvalidArgumentException($dateiArrayErrorMessage, __LINE__);
        }
        $this->Datei = $datei;
        return $this;
    }
    /**
     * Add item to Datei value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Datei $item
     * @return \BiPRO\StructType\CT_Geschaeftsvorgang
     */
    public function addToDatei(\BiPRO\StructType\CT_Datei $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Datei) {
            throw new \InvalidArgumentException(sprintf('The Datei property can only contain items of type \BiPRO\StructType\CT_Datei, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Datei[] = $item;
        return $this;
    }
    /**
     * Get Dokumentinformation value
     * @return \BiPRO\StructType\CT_Dokumentinformation[]|null
     */
    public function getDokumentinformation()
    {
        return $this->Dokumentinformation;
    }
    /**
     * This method is responsible for validating the values passed to the setDokumentinformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDokumentinformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDokumentinformationForArrayConstraintsFromSetDokumentinformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GeschaeftsvorgangDokumentinformationItem) {
            // validation for constraint: itemType
            if (!$cT_GeschaeftsvorgangDokumentinformationItem instanceof \BiPRO\StructType\CT_Dokumentinformation) {
                $invalidValues[] = is_object($cT_GeschaeftsvorgangDokumentinformationItem) ? get_class($cT_GeschaeftsvorgangDokumentinformationItem) : sprintf('%s(%s)', gettype($cT_GeschaeftsvorgangDokumentinformationItem), var_export($cT_GeschaeftsvorgangDokumentinformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Dokumentinformation property can only contain items of type \BiPRO\StructType\CT_Dokumentinformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Dokumentinformation value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Dokumentinformation[] $dokumentinformation
     * @return \BiPRO\StructType\CT_Geschaeftsvorgang
     */
    public function setDokumentinformation(array $dokumentinformation = array())
    {
        // validation for constraint: array
        if ('' !== ($dokumentinformationArrayErrorMessage = self::validateDokumentinformationForArrayConstraintsFromSetDokumentinformation($dokumentinformation))) {
            throw new \InvalidArgumentException($dokumentinformationArrayErrorMessage, __LINE__);
        }
        $this->Dokumentinformation = $dokumentinformation;
        return $this;
    }
    /**
     * Add item to Dokumentinformation value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Dokumentinformation $item
     * @return \BiPRO\StructType\CT_Geschaeftsvorgang
     */
    public function addToDokumentinformation(\BiPRO\StructType\CT_Dokumentinformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Dokumentinformation) {
            throw new \InvalidArgumentException(sprintf('The Dokumentinformation property can only contain items of type \BiPRO\StructType\CT_Dokumentinformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Dokumentinformation[] = $item;
        return $this;
    }
    /**
     * Get Dienstleister value
     * @return \BiPRO\StructType\CT_Dienstleister[]|null
     */
    public function getDienstleister()
    {
        return $this->Dienstleister;
    }
    /**
     * This method is responsible for validating the values passed to the setDienstleister method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDienstleister method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDienstleisterForArrayConstraintsFromSetDienstleister(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GeschaeftsvorgangDienstleisterItem) {
            // validation for constraint: itemType
            if (!$cT_GeschaeftsvorgangDienstleisterItem instanceof \BiPRO\StructType\CT_Dienstleister) {
                $invalidValues[] = is_object($cT_GeschaeftsvorgangDienstleisterItem) ? get_class($cT_GeschaeftsvorgangDienstleisterItem) : sprintf('%s(%s)', gettype($cT_GeschaeftsvorgangDienstleisterItem), var_export($cT_GeschaeftsvorgangDienstleisterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Dienstleister property can only contain items of type \BiPRO\StructType\CT_Dienstleister, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Dienstleister value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Dienstleister[] $dienstleister
     * @return \BiPRO\StructType\CT_Geschaeftsvorgang
     */
    public function setDienstleister(array $dienstleister = array())
    {
        // validation for constraint: array
        if ('' !== ($dienstleisterArrayErrorMessage = self::validateDienstleisterForArrayConstraintsFromSetDienstleister($dienstleister))) {
            throw new \InvalidArgumentException($dienstleisterArrayErrorMessage, __LINE__);
        }
        $this->Dienstleister = $dienstleister;
        return $this;
    }
    /**
     * Add item to Dienstleister value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Dienstleister $item
     * @return \BiPRO\StructType\CT_Geschaeftsvorgang
     */
    public function addToDienstleister(\BiPRO\StructType\CT_Dienstleister $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Dienstleister) {
            throw new \InvalidArgumentException(sprintf('The Dienstleister property can only contain items of type \BiPRO\StructType\CT_Dienstleister, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Dienstleister[] = $item;
        return $this;
    }
    /**
     * Get Dokumentversand value
     * @return \BiPRO\StructType\CT_Dokumentversand[]|null
     */
    public function getDokumentversand()
    {
        return $this->Dokumentversand;
    }
    /**
     * This method is responsible for validating the values passed to the setDokumentversand method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDokumentversand method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDokumentversandForArrayConstraintsFromSetDokumentversand(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GeschaeftsvorgangDokumentversandItem) {
            // validation for constraint: itemType
            if (!$cT_GeschaeftsvorgangDokumentversandItem instanceof \BiPRO\StructType\CT_Dokumentversand) {
                $invalidValues[] = is_object($cT_GeschaeftsvorgangDokumentversandItem) ? get_class($cT_GeschaeftsvorgangDokumentversandItem) : sprintf('%s(%s)', gettype($cT_GeschaeftsvorgangDokumentversandItem), var_export($cT_GeschaeftsvorgangDokumentversandItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Dokumentversand property can only contain items of type \BiPRO\StructType\CT_Dokumentversand, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Dokumentversand value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Dokumentversand[] $dokumentversand
     * @return \BiPRO\StructType\CT_Geschaeftsvorgang
     */
    public function setDokumentversand(array $dokumentversand = array())
    {
        // validation for constraint: array
        if ('' !== ($dokumentversandArrayErrorMessage = self::validateDokumentversandForArrayConstraintsFromSetDokumentversand($dokumentversand))) {
            throw new \InvalidArgumentException($dokumentversandArrayErrorMessage, __LINE__);
        }
        $this->Dokumentversand = $dokumentversand;
        return $this;
    }
    /**
     * Add item to Dokumentversand value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Dokumentversand $item
     * @return \BiPRO\StructType\CT_Geschaeftsvorgang
     */
    public function addToDokumentversand(\BiPRO\StructType\CT_Dokumentversand $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Dokumentversand) {
            throw new \InvalidArgumentException(sprintf('The Dokumentversand property can only contain items of type \BiPRO\StructType\CT_Dokumentversand, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Dokumentversand[] = $item;
        return $this;
    }
}
