<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Geoposition StructType
 * Meta information extracted from the WSDL
 * - documentation: Klasse zur Angabe von geografischen Koordinaten
 * @subpackage Structs
 */
class CT_Geoposition extends CT_Objekt
{
    /**
     * The Breite
     * Meta information extracted from the WSDL
     * - documentation: Geografische Breite in Dezimalgrad (Referenzellipsoid: WGS 84) | Datentyp für geografische Koordinaten, Angabe in Dezimalgrad, bezogen auf das geodätische Referenzsystem WGS 84 (World Geodetic System 1984). Negative Zahlen
     * entsprechen einer Entfernung vom Äquator bzw. vom Meridian des Referenzellipsoids in südlicher bzw. westlicher Richtung. 6 Nachkommastellen entsprechen einer Genauigkeit von etwa 1 bis 2 dm.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxInclusive: 180
     * - maxOccurs: 1
     * - minExclusive: -180
     * - minOccurs: 1
     * @var float
     */
    public $Breite;
    /**
     * The Laenge
     * Meta information extracted from the WSDL
     * - documentation: Geografische Länge in Dezimalgrad (Referenzellipsoid: WGS 84) | Datentyp für geografische Koordinaten, Angabe in Dezimalgrad, bezogen auf das geodätische Referenzsystem WGS 84 (World Geodetic System 1984). Negative Zahlen
     * entsprechen einer Entfernung vom Äquator bzw. vom Meridian des Referenzellipsoids in südlicher bzw. westlicher Richtung. 6 Nachkommastellen entsprechen einer Genauigkeit von etwa 1 bis 2 dm.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxInclusive: 180
     * - maxOccurs: 1
     * - minExclusive: -180
     * - minOccurs: 1
     * @var float
     */
    public $Laenge;
    /**
     * The Hoehe
     * Meta information extracted from the WSDL
     * - documentation: Höhe in Metern über dem Ellipsoid (Referenzellipsoid: WGS 84)
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Hoehe;
    /**
     * Constructor method for CT_Geoposition
     * @uses CT_Geoposition::setBreite()
     * @uses CT_Geoposition::setLaenge()
     * @uses CT_Geoposition::setHoehe()
     * @param float $breite
     * @param float $laenge
     * @param float $hoehe
     */
    public function __construct($breite = null, $laenge = null, $hoehe = null)
    {
        $this
            ->setBreite($breite)
            ->setLaenge($laenge)
            ->setHoehe($hoehe);
    }
    /**
     * Get Breite value
     * @return float
     */
    public function getBreite()
    {
        return $this->Breite;
    }
    /**
     * Set Breite value
     * @param float $breite
     * @return \BiPRO\StructType\CT_Geoposition
     */
    public function setBreite($breite = null)
    {
        // validation for constraint: float
        if (!is_null($breite) && !(is_float($breite) || is_numeric($breite))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($breite, true), gettype($breite)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($breite) && mb_strlen(mb_substr($breite, false !== mb_strpos($breite, '.') ? mb_strpos($breite, '.') + 1 : mb_strlen($breite))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($breite, true), mb_strlen(mb_substr($breite, mb_strpos($breite, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(180)
        if (!is_null($breite) && $breite > 180) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 180', var_export($breite, true)), __LINE__);
        }
        // validation for constraint: minExclusive(-180)
        if (!is_null($breite) && $breite <= -180) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than -180', var_export($breite, true)), __LINE__);
        }
        $this->Breite = $breite;
        return $this;
    }
    /**
     * Get Laenge value
     * @return float
     */
    public function getLaenge()
    {
        return $this->Laenge;
    }
    /**
     * Set Laenge value
     * @param float $laenge
     * @return \BiPRO\StructType\CT_Geoposition
     */
    public function setLaenge($laenge = null)
    {
        // validation for constraint: float
        if (!is_null($laenge) && !(is_float($laenge) || is_numeric($laenge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($laenge, true), gettype($laenge)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($laenge) && mb_strlen(mb_substr($laenge, false !== mb_strpos($laenge, '.') ? mb_strpos($laenge, '.') + 1 : mb_strlen($laenge))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($laenge, true), mb_strlen(mb_substr($laenge, mb_strpos($laenge, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(180)
        if (!is_null($laenge) && $laenge > 180) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 180', var_export($laenge, true)), __LINE__);
        }
        // validation for constraint: minExclusive(-180)
        if (!is_null($laenge) && $laenge <= -180) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than -180', var_export($laenge, true)), __LINE__);
        }
        $this->Laenge = $laenge;
        return $this;
    }
    /**
     * Get Hoehe value
     * @return float|null
     */
    public function getHoehe()
    {
        return $this->Hoehe;
    }
    /**
     * Set Hoehe value
     * @param float $hoehe
     * @return \BiPRO\StructType\CT_Geoposition
     */
    public function setHoehe($hoehe = null)
    {
        // validation for constraint: float
        if (!is_null($hoehe) && !(is_float($hoehe) || is_numeric($hoehe))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hoehe, true), gettype($hoehe)), __LINE__);
        }
        $this->Hoehe = $hoehe;
        return $this;
    }
}
