<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Geldwert StructType
 * Meta information extracted from the WSDL
 * - documentation: Das Objekt Geldwert dient der Beschreibung von Gegenstandswerten mit den Attributen Betrag und Waehrung.Bestehende Attribute zur Wertbeschreibung in Gebaeude und Fahrzeug bleiben erhalten (Abwärtskompatibilität). In diesen Fällen
 * DARF Geldwert NICHT genutzt werden.
 * @subpackage Structs
 */
abstract class CT_Geldwert extends CT_Objekt
{
    /**
     * The Betrag
     * Meta information extracted from the WSDL
     * - documentation: Der Betrag gibt die Höhe des Geldwertes an.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Betrag;
    /**
     * The Waehrung
     * Meta information extracted from the WSDL
     * - documentation: Die Waehrung definiert den Währungsschlüssel für den angegeben Betrag an.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Waehrung;
    /**
     * The Stichtag
     * Meta information extracted from the WSDL
     * - documentation: Zeitpunkt, zu dem der Wert gültig ist. | wie ST_Datum, ergänzt um Stunden und Minuten
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]
     * @var string
     */
    public $Stichtag;
    /**
     * Constructor method for CT_Geldwert
     * @uses CT_Geldwert::setBetrag()
     * @uses CT_Geldwert::setWaehrung()
     * @uses CT_Geldwert::setStichtag()
     * @param float $betrag
     * @param string $waehrung
     * @param string $stichtag
     */
    public function __construct($betrag = null, $waehrung = null, $stichtag = null)
    {
        $this
            ->setBetrag($betrag)
            ->setWaehrung($waehrung)
            ->setStichtag($stichtag);
    }
    /**
     * Get Betrag value
     * @return float|null
     */
    public function getBetrag()
    {
        return $this->Betrag;
    }
    /**
     * Set Betrag value
     * @param float $betrag
     * @return \BiPRO\StructType\CT_Geldwert
     */
    public function setBetrag($betrag = null)
    {
        // validation for constraint: float
        if (!is_null($betrag) && !(is_float($betrag) || is_numeric($betrag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($betrag, true), gettype($betrag)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($betrag) && mb_strlen(mb_substr($betrag, false !== mb_strpos($betrag, '.') ? mb_strpos($betrag, '.') + 1 : mb_strlen($betrag))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($betrag, true), mb_strlen(mb_substr($betrag, mb_strpos($betrag, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($betrag) && mb_strlen(preg_replace('/(\D)/', '', $betrag)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($betrag, true), mb_strlen(preg_replace('/(\D)/', '', $betrag))), __LINE__);
        }
        $this->Betrag = $betrag;
        return $this;
    }
    /**
     * Get Waehrung value
     * @return string|null
     */
    public function getWaehrung()
    {
        return $this->Waehrung;
    }
    /**
     * Set Waehrung value
     * @uses \BiPRO\EnumType\ST_Waehrungsschluessel::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Waehrungsschluessel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $waehrung
     * @return \BiPRO\StructType\CT_Geldwert
     */
    public function setWaehrung($waehrung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Waehrungsschluessel::valueIsValid($waehrung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Waehrungsschluessel', is_array($waehrung) ? implode(', ', $waehrung) : var_export($waehrung, true), implode(', ', \BiPRO\EnumType\ST_Waehrungsschluessel::getValidValues())), __LINE__);
        }
        $this->Waehrung = $waehrung;
        return $this;
    }
    /**
     * Get Stichtag value
     * @return string|null
     */
    public function getStichtag()
    {
        return $this->Stichtag;
    }
    /**
     * Set Stichtag value
     * @param string $stichtag
     * @return \BiPRO\StructType\CT_Geldwert
     */
    public function setStichtag($stichtag = null)
    {
        // validation for constraint: string
        if (!is_null($stichtag) && !is_string($stichtag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stichtag, true), gettype($stichtag)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9])
        if (!is_null($stichtag) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]/', $stichtag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]', var_export($stichtag, true)), __LINE__);
        }
        $this->Stichtag = $stichtag;
        return $this;
    }
}
