<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Gebaeudeteil StructType
 * Meta information extracted from the WSDL
 * - documentation: Teil eines Gebäudes, z. B. eine Wohnung, ein Raum, ein sonstiger Gebäudeteil.
 * @subpackage Structs
 */
class CT_Gebaeudeteil extends CT_Gegenstand
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Art des Gebäudeteils.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \BiPRO\StructType\STE_Gebaeudeteil
     */
    public $ArtID;
    /**
     * The Stockwerk
     * Meta information extracted from the WSDL
     * - documentation: Bezeichnung des Stockwerks.
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Stockwerk;
    /**
     * The Eigentuemer
     * Meta information extracted from the WSDL
     * - documentation: Eigentümer des Gebäudeteils.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Eigentuemer[]
     */
    public $Eigentuemer;
    /**
     * The Mieter
     * Meta information extracted from the WSDL
     * - documentation: Mieter des Gebäudeteils.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Mieter[]
     */
    public $Mieter;
    /**
     * The Vermieter
     * Meta information extracted from the WSDL
     * - documentation: Vermieter des Gebäudeteils.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Vermieter[]
     */
    public $Vermieter;
    /**
     * The Konstruktion
     * Meta information extracted from the WSDL
     * - documentation: Die Konstruktion des Gebäudeteils und das verwendete Material.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Konstruktion[]
     */
    public $Konstruktion;
    /**
     * Constructor method for CT_Gebaeudeteil
     * @uses CT_Gebaeudeteil::setArtID()
     * @uses CT_Gebaeudeteil::setStockwerk()
     * @uses CT_Gebaeudeteil::setEigentuemer()
     * @uses CT_Gebaeudeteil::setMieter()
     * @uses CT_Gebaeudeteil::setVermieter()
     * @uses CT_Gebaeudeteil::setKonstruktion()
     * @param \BiPRO\StructType\STE_Gebaeudeteil $artID
     * @param string $stockwerk
     * @param \BiPRO\StructType\CT_Eigentuemer[] $eigentuemer
     * @param \BiPRO\StructType\CT_Mieter[] $mieter
     * @param \BiPRO\StructType\CT_Vermieter[] $vermieter
     * @param \BiPRO\StructType\CT_Konstruktion[] $konstruktion
     */
    public function __construct(\BiPRO\StructType\STE_Gebaeudeteil $artID = null, $stockwerk = null, array $eigentuemer = array(), array $mieter = array(), array $vermieter = array(), array $konstruktion = array())
    {
        $this
            ->setArtID($artID)
            ->setStockwerk($stockwerk)
            ->setEigentuemer($eigentuemer)
            ->setMieter($mieter)
            ->setVermieter($vermieter)
            ->setKonstruktion($konstruktion);
    }
    /**
     * Get ArtID value
     * @return \BiPRO\StructType\STE_Gebaeudeteil
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @param \BiPRO\StructType\STE_Gebaeudeteil $artID
     * @return \BiPRO\StructType\CT_Gebaeudeteil
     */
    public function setArtID(\BiPRO\StructType\STE_Gebaeudeteil $artID = null)
    {
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Stockwerk value
     * @return string|null
     */
    public function getStockwerk()
    {
        return $this->Stockwerk;
    }
    /**
     * Set Stockwerk value
     * @param string $stockwerk
     * @return \BiPRO\StructType\CT_Gebaeudeteil
     */
    public function setStockwerk($stockwerk = null)
    {
        // validation for constraint: string
        if (!is_null($stockwerk) && !is_string($stockwerk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockwerk, true), gettype($stockwerk)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($stockwerk) && mb_strlen($stockwerk) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($stockwerk)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($stockwerk) && mb_strlen($stockwerk) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($stockwerk)), __LINE__);
        }
        $this->Stockwerk = $stockwerk;
        return $this;
    }
    /**
     * Get Eigentuemer value
     * @return \BiPRO\StructType\CT_Eigentuemer[]|null
     */
    public function getEigentuemer()
    {
        return $this->Eigentuemer;
    }
    /**
     * This method is responsible for validating the values passed to the setEigentuemer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEigentuemer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEigentuemerForArrayConstraintsFromSetEigentuemer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GebaeudeteilEigentuemerItem) {
            // validation for constraint: itemType
            if (!$cT_GebaeudeteilEigentuemerItem instanceof \BiPRO\StructType\CT_Eigentuemer) {
                $invalidValues[] = is_object($cT_GebaeudeteilEigentuemerItem) ? get_class($cT_GebaeudeteilEigentuemerItem) : sprintf('%s(%s)', gettype($cT_GebaeudeteilEigentuemerItem), var_export($cT_GebaeudeteilEigentuemerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Eigentuemer property can only contain items of type \BiPRO\StructType\CT_Eigentuemer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Eigentuemer value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Eigentuemer[] $eigentuemer
     * @return \BiPRO\StructType\CT_Gebaeudeteil
     */
    public function setEigentuemer(array $eigentuemer = array())
    {
        // validation for constraint: array
        if ('' !== ($eigentuemerArrayErrorMessage = self::validateEigentuemerForArrayConstraintsFromSetEigentuemer($eigentuemer))) {
            throw new \InvalidArgumentException($eigentuemerArrayErrorMessage, __LINE__);
        }
        $this->Eigentuemer = $eigentuemer;
        return $this;
    }
    /**
     * Add item to Eigentuemer value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Eigentuemer $item
     * @return \BiPRO\StructType\CT_Gebaeudeteil
     */
    public function addToEigentuemer(\BiPRO\StructType\CT_Eigentuemer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Eigentuemer) {
            throw new \InvalidArgumentException(sprintf('The Eigentuemer property can only contain items of type \BiPRO\StructType\CT_Eigentuemer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Eigentuemer[] = $item;
        return $this;
    }
    /**
     * Get Mieter value
     * @return \BiPRO\StructType\CT_Mieter[]|null
     */
    public function getMieter()
    {
        return $this->Mieter;
    }
    /**
     * This method is responsible for validating the values passed to the setMieter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMieter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMieterForArrayConstraintsFromSetMieter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GebaeudeteilMieterItem) {
            // validation for constraint: itemType
            if (!$cT_GebaeudeteilMieterItem instanceof \BiPRO\StructType\CT_Mieter) {
                $invalidValues[] = is_object($cT_GebaeudeteilMieterItem) ? get_class($cT_GebaeudeteilMieterItem) : sprintf('%s(%s)', gettype($cT_GebaeudeteilMieterItem), var_export($cT_GebaeudeteilMieterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Mieter property can only contain items of type \BiPRO\StructType\CT_Mieter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Mieter value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Mieter[] $mieter
     * @return \BiPRO\StructType\CT_Gebaeudeteil
     */
    public function setMieter(array $mieter = array())
    {
        // validation for constraint: array
        if ('' !== ($mieterArrayErrorMessage = self::validateMieterForArrayConstraintsFromSetMieter($mieter))) {
            throw new \InvalidArgumentException($mieterArrayErrorMessage, __LINE__);
        }
        $this->Mieter = $mieter;
        return $this;
    }
    /**
     * Add item to Mieter value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Mieter $item
     * @return \BiPRO\StructType\CT_Gebaeudeteil
     */
    public function addToMieter(\BiPRO\StructType\CT_Mieter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Mieter) {
            throw new \InvalidArgumentException(sprintf('The Mieter property can only contain items of type \BiPRO\StructType\CT_Mieter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Mieter[] = $item;
        return $this;
    }
    /**
     * Get Vermieter value
     * @return \BiPRO\StructType\CT_Vermieter[]|null
     */
    public function getVermieter()
    {
        return $this->Vermieter;
    }
    /**
     * This method is responsible for validating the values passed to the setVermieter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVermieter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVermieterForArrayConstraintsFromSetVermieter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GebaeudeteilVermieterItem) {
            // validation for constraint: itemType
            if (!$cT_GebaeudeteilVermieterItem instanceof \BiPRO\StructType\CT_Vermieter) {
                $invalidValues[] = is_object($cT_GebaeudeteilVermieterItem) ? get_class($cT_GebaeudeteilVermieterItem) : sprintf('%s(%s)', gettype($cT_GebaeudeteilVermieterItem), var_export($cT_GebaeudeteilVermieterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Vermieter property can only contain items of type \BiPRO\StructType\CT_Vermieter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Vermieter value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vermieter[] $vermieter
     * @return \BiPRO\StructType\CT_Gebaeudeteil
     */
    public function setVermieter(array $vermieter = array())
    {
        // validation for constraint: array
        if ('' !== ($vermieterArrayErrorMessage = self::validateVermieterForArrayConstraintsFromSetVermieter($vermieter))) {
            throw new \InvalidArgumentException($vermieterArrayErrorMessage, __LINE__);
        }
        $this->Vermieter = $vermieter;
        return $this;
    }
    /**
     * Add item to Vermieter value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vermieter $item
     * @return \BiPRO\StructType\CT_Gebaeudeteil
     */
    public function addToVermieter(\BiPRO\StructType\CT_Vermieter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Vermieter) {
            throw new \InvalidArgumentException(sprintf('The Vermieter property can only contain items of type \BiPRO\StructType\CT_Vermieter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Vermieter[] = $item;
        return $this;
    }
    /**
     * Get Konstruktion value
     * @return \BiPRO\StructType\CT_Konstruktion[]|null
     */
    public function getKonstruktion()
    {
        return $this->Konstruktion;
    }
    /**
     * This method is responsible for validating the values passed to the setKonstruktion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKonstruktion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKonstruktionForArrayConstraintsFromSetKonstruktion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GebaeudeteilKonstruktionItem) {
            // validation for constraint: itemType
            if (!$cT_GebaeudeteilKonstruktionItem instanceof \BiPRO\StructType\CT_Konstruktion) {
                $invalidValues[] = is_object($cT_GebaeudeteilKonstruktionItem) ? get_class($cT_GebaeudeteilKonstruktionItem) : sprintf('%s(%s)', gettype($cT_GebaeudeteilKonstruktionItem), var_export($cT_GebaeudeteilKonstruktionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Konstruktion property can only contain items of type \BiPRO\StructType\CT_Konstruktion, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Konstruktion value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Konstruktion[] $konstruktion
     * @return \BiPRO\StructType\CT_Gebaeudeteil
     */
    public function setKonstruktion(array $konstruktion = array())
    {
        // validation for constraint: array
        if ('' !== ($konstruktionArrayErrorMessage = self::validateKonstruktionForArrayConstraintsFromSetKonstruktion($konstruktion))) {
            throw new \InvalidArgumentException($konstruktionArrayErrorMessage, __LINE__);
        }
        $this->Konstruktion = $konstruktion;
        return $this;
    }
    /**
     * Add item to Konstruktion value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Konstruktion $item
     * @return \BiPRO\StructType\CT_Gebaeudeteil
     */
    public function addToKonstruktion(\BiPRO\StructType\CT_Konstruktion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Konstruktion) {
            throw new \InvalidArgumentException(sprintf('The Konstruktion property can only contain items of type \BiPRO\StructType\CT_Konstruktion, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Konstruktion[] = $item;
        return $this;
    }
}
