<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Gebaeude StructType
 * Meta information extracted from the WSDL
 * - documentation: Beschreibung aller unmittelbaren Eigenschaften eines Gebäudes.
 * @subpackage Structs
 */
class CT_Gebaeude extends CT_Gegenstand
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Art des Gebäudes
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtID;
    /**
     * The Bauartklasse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bauartklasse;
    /**
     * The Baujahr
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $Baujahr;
    /**
     * The Kernsanierungsjahr
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $Kernsanierungsjahr;
    /**
     * The Denkmalschutz
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Denkmalschutz;
    /**
     * The AnzahlStockwerke
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlStockwerke;
    /**
     * The AnzahlWohneinheiten
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlWohneinheiten;
    /**
     * The Unterkellert
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Unterkellert;
    /**
     * The Dachart
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Dachart;
    /**
     * The AusgebautesDach
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $AusgebautesDach;
    /**
     * The Bauausfuehrung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Bauausfuehrung[]
     */
    public $Bauausfuehrung;
    /**
     * The AnzahlStellplaetzeImGebaeude
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der Fahrzeugstellplätze im Gebäude.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlStellplaetzeImGebaeude;
    /**
     * The EinliegerwohnungVorhanden
     * Meta information extracted from the WSDL
     * - documentation: Für Rechtsschutz gilt: Dieses Attribut DARF von Rechtsschutz NICHT verwendet werden. Einliegerwohungen MÜSSEN über Gebäudeeinheit.ArtID abgebildet werden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $EinliegerwohnungVorhanden;
    /**
     * The RohbauBeginnDatum
     * Meta information extracted from the WSDL
     * - documentation: nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $RohbauBeginnDatum;
    /**
     * The RohbauEndeDatum
     * Meta information extracted from the WSDL
     * - documentation: Datum der Bezugsfertigkeit | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $RohbauEndeDatum;
    /**
     * The GebaeudeSonderausstattung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_GebaeudeSonderausstattung[]
     */
    public $GebaeudeSonderausstattung;
    /**
     * The Objektanschrift
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Objektanschrift
     */
    public $Objektanschrift;
    /**
     * The MaterialLeitungswassernetz
     * Meta information extracted from the WSDL
     * - documentation: Material des Leitungswassernetzes
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MaterialLeitungswassernetz;
    /**
     * The Fertighaushersteller
     * Meta information extracted from the WSDL
     * - documentation: Falls zur Prüfung der Fertighausgruppe (Bauartklasse) eines Fertighauses der Name der Herstellerfirma benötigt wird.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Fertighaushersteller;
    /**
     * The AnzahlGewerbeeinheiten
     * Meta information extracted from the WSDL
     * - documentation: In Verbindung mit der Anzahl der Wohneinheiten können Schlüsse zur Nutzungsart gezogen werden.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlGewerbeeinheiten;
    /**
     * The Sanierung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Sanierung[]
     */
    public $Sanierung;
    /**
     * The Eigentuemer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Eigentuemer[]
     */
    public $Eigentuemer;
    /**
     * The Vermieter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Vermieter[]
     */
    public $Vermieter;
    /**
     * The Mieter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Mieter[]
     */
    public $Mieter;
    /**
     * The UmbauterRaum
     * Meta information extracted from the WSDL
     * - documentation: Umbauter Raum in Kubikmeter
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $UmbauterRaum;
    /**
     * The Sicherungsglaeubiger
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Sicherungsglaeubiger[]
     */
    public $Sicherungsglaeubiger;
    /**
     * The Kaufpreis
     * Meta information extracted from the WSDL
     * - documentation: Kaufpreis des Gebaedes. Die Stichtagsangabe (Kaufpreis.Stichtag) MUSS dem Zeitpunkt des Kaufs entsprechen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Kaufpreis
     */
    public $Kaufpreis;
    /**
     * The DenkmalschutzUmfang
     * Meta information extracted from the WSDL
     * - documentation: Beschreibt die Teile eines Gebäudes, die unter Denkmalschutz stehen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DenkmalschutzUmfang;
    /**
     * The ArtDerUnterkellerung
     * Meta information extracted from the WSDL
     * - documentation: Angaben zur Unterkellerung eines Gebäudes.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtDerUnterkellerung;
    /**
     * The Konstruktion
     * Meta information extracted from the WSDL
     * - documentation: Die Konstruktion des Gebäudes und das verwendete Material.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Konstruktion[]
     */
    public $Konstruktion;
    /**
     * Constructor method for CT_Gebaeude
     * @uses CT_Gebaeude::setArtID()
     * @uses CT_Gebaeude::setBauartklasse()
     * @uses CT_Gebaeude::setBaujahr()
     * @uses CT_Gebaeude::setKernsanierungsjahr()
     * @uses CT_Gebaeude::setDenkmalschutz()
     * @uses CT_Gebaeude::setAnzahlStockwerke()
     * @uses CT_Gebaeude::setAnzahlWohneinheiten()
     * @uses CT_Gebaeude::setUnterkellert()
     * @uses CT_Gebaeude::setDachart()
     * @uses CT_Gebaeude::setAusgebautesDach()
     * @uses CT_Gebaeude::setBauausfuehrung()
     * @uses CT_Gebaeude::setAnzahlStellplaetzeImGebaeude()
     * @uses CT_Gebaeude::setEinliegerwohnungVorhanden()
     * @uses CT_Gebaeude::setRohbauBeginnDatum()
     * @uses CT_Gebaeude::setRohbauEndeDatum()
     * @uses CT_Gebaeude::setGebaeudeSonderausstattung()
     * @uses CT_Gebaeude::setObjektanschrift()
     * @uses CT_Gebaeude::setMaterialLeitungswassernetz()
     * @uses CT_Gebaeude::setFertighaushersteller()
     * @uses CT_Gebaeude::setAnzahlGewerbeeinheiten()
     * @uses CT_Gebaeude::setSanierung()
     * @uses CT_Gebaeude::setEigentuemer()
     * @uses CT_Gebaeude::setVermieter()
     * @uses CT_Gebaeude::setMieter()
     * @uses CT_Gebaeude::setUmbauterRaum()
     * @uses CT_Gebaeude::setSicherungsglaeubiger()
     * @uses CT_Gebaeude::setKaufpreis()
     * @uses CT_Gebaeude::setDenkmalschutzUmfang()
     * @uses CT_Gebaeude::setArtDerUnterkellerung()
     * @uses CT_Gebaeude::setKonstruktion()
     * @param string $artID
     * @param string $bauartklasse
     * @param int $baujahr
     * @param int $kernsanierungsjahr
     * @param bool $denkmalschutz
     * @param int $anzahlStockwerke
     * @param int $anzahlWohneinheiten
     * @param bool $unterkellert
     * @param string $dachart
     * @param bool $ausgebautesDach
     * @param \BiPRO\StructType\STE_Bauausfuehrung[] $bauausfuehrung
     * @param int $anzahlStellplaetzeImGebaeude
     * @param bool $einliegerwohnungVorhanden
     * @param string $rohbauBeginnDatum
     * @param string $rohbauEndeDatum
     * @param \BiPRO\StructType\CT_GebaeudeSonderausstattung[] $gebaeudeSonderausstattung
     * @param \BiPRO\StructType\CT_Objektanschrift $objektanschrift
     * @param string $materialLeitungswassernetz
     * @param string $fertighaushersteller
     * @param int $anzahlGewerbeeinheiten
     * @param \BiPRO\StructType\CT_Sanierung[] $sanierung
     * @param \BiPRO\StructType\CT_Eigentuemer[] $eigentuemer
     * @param \BiPRO\StructType\CT_Vermieter[] $vermieter
     * @param \BiPRO\StructType\CT_Mieter[] $mieter
     * @param int $umbauterRaum
     * @param \BiPRO\StructType\CT_Sicherungsglaeubiger[] $sicherungsglaeubiger
     * @param \BiPRO\StructType\CT_Kaufpreis $kaufpreis
     * @param string[] $denkmalschutzUmfang
     * @param string $artDerUnterkellerung
     * @param \BiPRO\StructType\CT_Konstruktion[] $konstruktion
     */
    public function __construct($artID = null, $bauartklasse = null, $baujahr = null, $kernsanierungsjahr = null, $denkmalschutz = null, $anzahlStockwerke = null, $anzahlWohneinheiten = null, $unterkellert = null, $dachart = null, $ausgebautesDach = null, array $bauausfuehrung = array(), $anzahlStellplaetzeImGebaeude = null, $einliegerwohnungVorhanden = null, $rohbauBeginnDatum = null, $rohbauEndeDatum = null, array $gebaeudeSonderausstattung = array(), \BiPRO\StructType\CT_Objektanschrift $objektanschrift = null, $materialLeitungswassernetz = null, $fertighaushersteller = null, $anzahlGewerbeeinheiten = null, array $sanierung = array(), array $eigentuemer = array(), array $vermieter = array(), array $mieter = array(), $umbauterRaum = null, array $sicherungsglaeubiger = array(), \BiPRO\StructType\CT_Kaufpreis $kaufpreis = null, array $denkmalschutzUmfang = array(), $artDerUnterkellerung = null, array $konstruktion = array())
    {
        $this
            ->setArtID($artID)
            ->setBauartklasse($bauartklasse)
            ->setBaujahr($baujahr)
            ->setKernsanierungsjahr($kernsanierungsjahr)
            ->setDenkmalschutz($denkmalschutz)
            ->setAnzahlStockwerke($anzahlStockwerke)
            ->setAnzahlWohneinheiten($anzahlWohneinheiten)
            ->setUnterkellert($unterkellert)
            ->setDachart($dachart)
            ->setAusgebautesDach($ausgebautesDach)
            ->setBauausfuehrung($bauausfuehrung)
            ->setAnzahlStellplaetzeImGebaeude($anzahlStellplaetzeImGebaeude)
            ->setEinliegerwohnungVorhanden($einliegerwohnungVorhanden)
            ->setRohbauBeginnDatum($rohbauBeginnDatum)
            ->setRohbauEndeDatum($rohbauEndeDatum)
            ->setGebaeudeSonderausstattung($gebaeudeSonderausstattung)
            ->setObjektanschrift($objektanschrift)
            ->setMaterialLeitungswassernetz($materialLeitungswassernetz)
            ->setFertighaushersteller($fertighaushersteller)
            ->setAnzahlGewerbeeinheiten($anzahlGewerbeeinheiten)
            ->setSanierung($sanierung)
            ->setEigentuemer($eigentuemer)
            ->setVermieter($vermieter)
            ->setMieter($mieter)
            ->setUmbauterRaum($umbauterRaum)
            ->setSicherungsglaeubiger($sicherungsglaeubiger)
            ->setKaufpreis($kaufpreis)
            ->setDenkmalschutzUmfang($denkmalschutzUmfang)
            ->setArtDerUnterkellerung($artDerUnterkellerung)
            ->setKonstruktion($konstruktion);
    }
    /**
     * Get ArtID value
     * @return string|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Gebaeudeart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Gebaeudeart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Gebaeudeart::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Gebaeudeart', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Gebaeudeart::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Bauartklasse value
     * @return string|null
     */
    public function getBauartklasse()
    {
        return $this->Bauartklasse;
    }
    /**
     * Set Bauartklasse value
     * @uses \BiPRO\EnumType\ST_Bauartklasse::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Bauartklasse::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bauartklasse
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setBauartklasse($bauartklasse = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Bauartklasse::valueIsValid($bauartklasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Bauartklasse', is_array($bauartklasse) ? implode(', ', $bauartklasse) : var_export($bauartklasse, true), implode(', ', \BiPRO\EnumType\ST_Bauartklasse::getValidValues())), __LINE__);
        }
        $this->Bauartklasse = $bauartklasse;
        return $this;
    }
    /**
     * Get Baujahr value
     * @return int|null
     */
    public function getBaujahr()
    {
        return $this->Baujahr;
    }
    /**
     * Set Baujahr value
     * @param int $baujahr
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setBaujahr($baujahr = null)
    {
        // validation for constraint: int
        if (!is_null($baujahr) && !(is_int($baujahr) || ctype_digit($baujahr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($baujahr, true), gettype($baujahr)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($baujahr) && mb_strlen(preg_replace('/(\D)/', '', $baujahr)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($baujahr, true), mb_strlen(preg_replace('/(\D)/', '', $baujahr))), __LINE__);
        }
        $this->Baujahr = $baujahr;
        return $this;
    }
    /**
     * Get Kernsanierungsjahr value
     * @return int|null
     */
    public function getKernsanierungsjahr()
    {
        return $this->Kernsanierungsjahr;
    }
    /**
     * Set Kernsanierungsjahr value
     * @param int $kernsanierungsjahr
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setKernsanierungsjahr($kernsanierungsjahr = null)
    {
        // validation for constraint: int
        if (!is_null($kernsanierungsjahr) && !(is_int($kernsanierungsjahr) || ctype_digit($kernsanierungsjahr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kernsanierungsjahr, true), gettype($kernsanierungsjahr)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($kernsanierungsjahr) && mb_strlen(preg_replace('/(\D)/', '', $kernsanierungsjahr)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($kernsanierungsjahr, true), mb_strlen(preg_replace('/(\D)/', '', $kernsanierungsjahr))), __LINE__);
        }
        $this->Kernsanierungsjahr = $kernsanierungsjahr;
        return $this;
    }
    /**
     * Get Denkmalschutz value
     * @return bool|null
     */
    public function getDenkmalschutz()
    {
        return $this->Denkmalschutz;
    }
    /**
     * Set Denkmalschutz value
     * @param bool $denkmalschutz
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setDenkmalschutz($denkmalschutz = null)
    {
        // validation for constraint: boolean
        if (!is_null($denkmalschutz) && !is_bool($denkmalschutz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($denkmalschutz, true), gettype($denkmalschutz)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($denkmalschutz) && !preg_match('/true|false/', $denkmalschutz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($denkmalschutz, true)), __LINE__);
        }
        $this->Denkmalschutz = $denkmalschutz;
        return $this;
    }
    /**
     * Get AnzahlStockwerke value
     * @return int|null
     */
    public function getAnzahlStockwerke()
    {
        return $this->AnzahlStockwerke;
    }
    /**
     * Set AnzahlStockwerke value
     * @param int $anzahlStockwerke
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setAnzahlStockwerke($anzahlStockwerke = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlStockwerke) && !(is_int($anzahlStockwerke) || ctype_digit($anzahlStockwerke))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlStockwerke, true), gettype($anzahlStockwerke)), __LINE__);
        }
        $this->AnzahlStockwerke = $anzahlStockwerke;
        return $this;
    }
    /**
     * Get AnzahlWohneinheiten value
     * @return int|null
     */
    public function getAnzahlWohneinheiten()
    {
        return $this->AnzahlWohneinheiten;
    }
    /**
     * Set AnzahlWohneinheiten value
     * @param int $anzahlWohneinheiten
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setAnzahlWohneinheiten($anzahlWohneinheiten = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlWohneinheiten) && !(is_int($anzahlWohneinheiten) || ctype_digit($anzahlWohneinheiten))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlWohneinheiten, true), gettype($anzahlWohneinheiten)), __LINE__);
        }
        $this->AnzahlWohneinheiten = $anzahlWohneinheiten;
        return $this;
    }
    /**
     * Get Unterkellert value
     * @return bool|null
     */
    public function getUnterkellert()
    {
        return $this->Unterkellert;
    }
    /**
     * Set Unterkellert value
     * @param bool $unterkellert
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setUnterkellert($unterkellert = null)
    {
        // validation for constraint: boolean
        if (!is_null($unterkellert) && !is_bool($unterkellert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unterkellert, true), gettype($unterkellert)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($unterkellert) && !preg_match('/true|false/', $unterkellert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($unterkellert, true)), __LINE__);
        }
        $this->Unterkellert = $unterkellert;
        return $this;
    }
    /**
     * Get Dachart value
     * @return string|null
     */
    public function getDachart()
    {
        return $this->Dachart;
    }
    /**
     * Set Dachart value
     * @uses \BiPRO\EnumType\ST_Dachart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Dachart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dachart
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setDachart($dachart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Dachart::valueIsValid($dachart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Dachart', is_array($dachart) ? implode(', ', $dachart) : var_export($dachart, true), implode(', ', \BiPRO\EnumType\ST_Dachart::getValidValues())), __LINE__);
        }
        $this->Dachart = $dachart;
        return $this;
    }
    /**
     * Get AusgebautesDach value
     * @return bool|null
     */
    public function getAusgebautesDach()
    {
        return $this->AusgebautesDach;
    }
    /**
     * Set AusgebautesDach value
     * @param bool $ausgebautesDach
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setAusgebautesDach($ausgebautesDach = null)
    {
        // validation for constraint: boolean
        if (!is_null($ausgebautesDach) && !is_bool($ausgebautesDach)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ausgebautesDach, true), gettype($ausgebautesDach)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($ausgebautesDach) && !preg_match('/true|false/', $ausgebautesDach)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($ausgebautesDach, true)), __LINE__);
        }
        $this->AusgebautesDach = $ausgebautesDach;
        return $this;
    }
    /**
     * Get Bauausfuehrung value
     * @return \BiPRO\StructType\STE_Bauausfuehrung[]|null
     */
    public function getBauausfuehrung()
    {
        return $this->Bauausfuehrung;
    }
    /**
     * This method is responsible for validating the values passed to the setBauausfuehrung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBauausfuehrung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBauausfuehrungForArrayConstraintsFromSetBauausfuehrung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GebaeudeBauausfuehrungItem) {
            // validation for constraint: itemType
            if (!$cT_GebaeudeBauausfuehrungItem instanceof \BiPRO\StructType\STE_Bauausfuehrung) {
                $invalidValues[] = is_object($cT_GebaeudeBauausfuehrungItem) ? get_class($cT_GebaeudeBauausfuehrungItem) : sprintf('%s(%s)', gettype($cT_GebaeudeBauausfuehrungItem), var_export($cT_GebaeudeBauausfuehrungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Bauausfuehrung property can only contain items of type \BiPRO\StructType\STE_Bauausfuehrung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Bauausfuehrung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\STE_Bauausfuehrung[] $bauausfuehrung
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setBauausfuehrung(array $bauausfuehrung = array())
    {
        // validation for constraint: array
        if ('' !== ($bauausfuehrungArrayErrorMessage = self::validateBauausfuehrungForArrayConstraintsFromSetBauausfuehrung($bauausfuehrung))) {
            throw new \InvalidArgumentException($bauausfuehrungArrayErrorMessage, __LINE__);
        }
        $this->Bauausfuehrung = $bauausfuehrung;
        return $this;
    }
    /**
     * Add item to Bauausfuehrung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\STE_Bauausfuehrung $item
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function addToBauausfuehrung(\BiPRO\StructType\STE_Bauausfuehrung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\STE_Bauausfuehrung) {
            throw new \InvalidArgumentException(sprintf('The Bauausfuehrung property can only contain items of type \BiPRO\StructType\STE_Bauausfuehrung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Bauausfuehrung[] = $item;
        return $this;
    }
    /**
     * Get AnzahlStellplaetzeImGebaeude value
     * @return int|null
     */
    public function getAnzahlStellplaetzeImGebaeude()
    {
        return $this->AnzahlStellplaetzeImGebaeude;
    }
    /**
     * Set AnzahlStellplaetzeImGebaeude value
     * @param int $anzahlStellplaetzeImGebaeude
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setAnzahlStellplaetzeImGebaeude($anzahlStellplaetzeImGebaeude = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlStellplaetzeImGebaeude) && !(is_int($anzahlStellplaetzeImGebaeude) || ctype_digit($anzahlStellplaetzeImGebaeude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlStellplaetzeImGebaeude, true), gettype($anzahlStellplaetzeImGebaeude)), __LINE__);
        }
        $this->AnzahlStellplaetzeImGebaeude = $anzahlStellplaetzeImGebaeude;
        return $this;
    }
    /**
     * Get EinliegerwohnungVorhanden value
     * @return bool|null
     */
    public function getEinliegerwohnungVorhanden()
    {
        return $this->EinliegerwohnungVorhanden;
    }
    /**
     * Set EinliegerwohnungVorhanden value
     * @param bool $einliegerwohnungVorhanden
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setEinliegerwohnungVorhanden($einliegerwohnungVorhanden = null)
    {
        // validation for constraint: boolean
        if (!is_null($einliegerwohnungVorhanden) && !is_bool($einliegerwohnungVorhanden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($einliegerwohnungVorhanden, true), gettype($einliegerwohnungVorhanden)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($einliegerwohnungVorhanden) && !preg_match('/true|false/', $einliegerwohnungVorhanden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($einliegerwohnungVorhanden, true)), __LINE__);
        }
        $this->EinliegerwohnungVorhanden = $einliegerwohnungVorhanden;
        return $this;
    }
    /**
     * Get RohbauBeginnDatum value
     * @return string|null
     */
    public function getRohbauBeginnDatum()
    {
        return $this->RohbauBeginnDatum;
    }
    /**
     * Set RohbauBeginnDatum value
     * @param string $rohbauBeginnDatum
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setRohbauBeginnDatum($rohbauBeginnDatum = null)
    {
        // validation for constraint: string
        if (!is_null($rohbauBeginnDatum) && !is_string($rohbauBeginnDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rohbauBeginnDatum, true), gettype($rohbauBeginnDatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($rohbauBeginnDatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $rohbauBeginnDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($rohbauBeginnDatum, true)), __LINE__);
        }
        $this->RohbauBeginnDatum = $rohbauBeginnDatum;
        return $this;
    }
    /**
     * Get RohbauEndeDatum value
     * @return string|null
     */
    public function getRohbauEndeDatum()
    {
        return $this->RohbauEndeDatum;
    }
    /**
     * Set RohbauEndeDatum value
     * @param string $rohbauEndeDatum
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setRohbauEndeDatum($rohbauEndeDatum = null)
    {
        // validation for constraint: string
        if (!is_null($rohbauEndeDatum) && !is_string($rohbauEndeDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rohbauEndeDatum, true), gettype($rohbauEndeDatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($rohbauEndeDatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $rohbauEndeDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($rohbauEndeDatum, true)), __LINE__);
        }
        $this->RohbauEndeDatum = $rohbauEndeDatum;
        return $this;
    }
    /**
     * Get GebaeudeSonderausstattung value
     * @return \BiPRO\StructType\CT_GebaeudeSonderausstattung[]|null
     */
    public function getGebaeudeSonderausstattung()
    {
        return $this->GebaeudeSonderausstattung;
    }
    /**
     * This method is responsible for validating the values passed to the setGebaeudeSonderausstattung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGebaeudeSonderausstattung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGebaeudeSonderausstattungForArrayConstraintsFromSetGebaeudeSonderausstattung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GebaeudeGebaeudeSonderausstattungItem) {
            // validation for constraint: itemType
            if (!$cT_GebaeudeGebaeudeSonderausstattungItem instanceof \BiPRO\StructType\CT_GebaeudeSonderausstattung) {
                $invalidValues[] = is_object($cT_GebaeudeGebaeudeSonderausstattungItem) ? get_class($cT_GebaeudeGebaeudeSonderausstattungItem) : sprintf('%s(%s)', gettype($cT_GebaeudeGebaeudeSonderausstattungItem), var_export($cT_GebaeudeGebaeudeSonderausstattungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GebaeudeSonderausstattung property can only contain items of type \BiPRO\StructType\CT_GebaeudeSonderausstattung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GebaeudeSonderausstattung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_GebaeudeSonderausstattung[] $gebaeudeSonderausstattung
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setGebaeudeSonderausstattung(array $gebaeudeSonderausstattung = array())
    {
        // validation for constraint: array
        if ('' !== ($gebaeudeSonderausstattungArrayErrorMessage = self::validateGebaeudeSonderausstattungForArrayConstraintsFromSetGebaeudeSonderausstattung($gebaeudeSonderausstattung))) {
            throw new \InvalidArgumentException($gebaeudeSonderausstattungArrayErrorMessage, __LINE__);
        }
        $this->GebaeudeSonderausstattung = $gebaeudeSonderausstattung;
        return $this;
    }
    /**
     * Add item to GebaeudeSonderausstattung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_GebaeudeSonderausstattung $item
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function addToGebaeudeSonderausstattung(\BiPRO\StructType\CT_GebaeudeSonderausstattung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_GebaeudeSonderausstattung) {
            throw new \InvalidArgumentException(sprintf('The GebaeudeSonderausstattung property can only contain items of type \BiPRO\StructType\CT_GebaeudeSonderausstattung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GebaeudeSonderausstattung[] = $item;
        return $this;
    }
    /**
     * Get Objektanschrift value
     * @return \BiPRO\StructType\CT_Objektanschrift|null
     */
    public function getObjektanschrift()
    {
        return $this->Objektanschrift;
    }
    /**
     * Set Objektanschrift value
     * @param \BiPRO\StructType\CT_Objektanschrift $objektanschrift
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setObjektanschrift(\BiPRO\StructType\CT_Objektanschrift $objektanschrift = null)
    {
        $this->Objektanschrift = $objektanschrift;
        return $this;
    }
    /**
     * Get MaterialLeitungswassernetz value
     * @return string|null
     */
    public function getMaterialLeitungswassernetz()
    {
        return $this->MaterialLeitungswassernetz;
    }
    /**
     * Set MaterialLeitungswassernetz value
     * @uses \BiPRO\EnumType\ST_MaterialLeitungswassernetz::valueIsValid()
     * @uses \BiPRO\EnumType\ST_MaterialLeitungswassernetz::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $materialLeitungswassernetz
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setMaterialLeitungswassernetz($materialLeitungswassernetz = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_MaterialLeitungswassernetz::valueIsValid($materialLeitungswassernetz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_MaterialLeitungswassernetz', is_array($materialLeitungswassernetz) ? implode(', ', $materialLeitungswassernetz) : var_export($materialLeitungswassernetz, true), implode(', ', \BiPRO\EnumType\ST_MaterialLeitungswassernetz::getValidValues())), __LINE__);
        }
        $this->MaterialLeitungswassernetz = $materialLeitungswassernetz;
        return $this;
    }
    /**
     * Get Fertighaushersteller value
     * @return string|null
     */
    public function getFertighaushersteller()
    {
        return $this->Fertighaushersteller;
    }
    /**
     * Set Fertighaushersteller value
     * @param string $fertighaushersteller
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setFertighaushersteller($fertighaushersteller = null)
    {
        // validation for constraint: string
        if (!is_null($fertighaushersteller) && !is_string($fertighaushersteller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fertighaushersteller, true), gettype($fertighaushersteller)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($fertighaushersteller) && mb_strlen($fertighaushersteller) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($fertighaushersteller)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($fertighaushersteller) && mb_strlen($fertighaushersteller) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($fertighaushersteller)), __LINE__);
        }
        $this->Fertighaushersteller = $fertighaushersteller;
        return $this;
    }
    /**
     * Get AnzahlGewerbeeinheiten value
     * @return int|null
     */
    public function getAnzahlGewerbeeinheiten()
    {
        return $this->AnzahlGewerbeeinheiten;
    }
    /**
     * Set AnzahlGewerbeeinheiten value
     * @param int $anzahlGewerbeeinheiten
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setAnzahlGewerbeeinheiten($anzahlGewerbeeinheiten = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlGewerbeeinheiten) && !(is_int($anzahlGewerbeeinheiten) || ctype_digit($anzahlGewerbeeinheiten))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlGewerbeeinheiten, true), gettype($anzahlGewerbeeinheiten)), __LINE__);
        }
        $this->AnzahlGewerbeeinheiten = $anzahlGewerbeeinheiten;
        return $this;
    }
    /**
     * Get Sanierung value
     * @return \BiPRO\StructType\CT_Sanierung[]|null
     */
    public function getSanierung()
    {
        return $this->Sanierung;
    }
    /**
     * This method is responsible for validating the values passed to the setSanierung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSanierung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSanierungForArrayConstraintsFromSetSanierung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GebaeudeSanierungItem) {
            // validation for constraint: itemType
            if (!$cT_GebaeudeSanierungItem instanceof \BiPRO\StructType\CT_Sanierung) {
                $invalidValues[] = is_object($cT_GebaeudeSanierungItem) ? get_class($cT_GebaeudeSanierungItem) : sprintf('%s(%s)', gettype($cT_GebaeudeSanierungItem), var_export($cT_GebaeudeSanierungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Sanierung property can only contain items of type \BiPRO\StructType\CT_Sanierung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Sanierung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Sanierung[] $sanierung
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setSanierung(array $sanierung = array())
    {
        // validation for constraint: array
        if ('' !== ($sanierungArrayErrorMessage = self::validateSanierungForArrayConstraintsFromSetSanierung($sanierung))) {
            throw new \InvalidArgumentException($sanierungArrayErrorMessage, __LINE__);
        }
        $this->Sanierung = $sanierung;
        return $this;
    }
    /**
     * Add item to Sanierung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Sanierung $item
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function addToSanierung(\BiPRO\StructType\CT_Sanierung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Sanierung) {
            throw new \InvalidArgumentException(sprintf('The Sanierung property can only contain items of type \BiPRO\StructType\CT_Sanierung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Sanierung[] = $item;
        return $this;
    }
    /**
     * Get Eigentuemer value
     * @return \BiPRO\StructType\CT_Eigentuemer[]|null
     */
    public function getEigentuemer()
    {
        return $this->Eigentuemer;
    }
    /**
     * This method is responsible for validating the values passed to the setEigentuemer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEigentuemer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEigentuemerForArrayConstraintsFromSetEigentuemer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GebaeudeEigentuemerItem) {
            // validation for constraint: itemType
            if (!$cT_GebaeudeEigentuemerItem instanceof \BiPRO\StructType\CT_Eigentuemer) {
                $invalidValues[] = is_object($cT_GebaeudeEigentuemerItem) ? get_class($cT_GebaeudeEigentuemerItem) : sprintf('%s(%s)', gettype($cT_GebaeudeEigentuemerItem), var_export($cT_GebaeudeEigentuemerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Eigentuemer property can only contain items of type \BiPRO\StructType\CT_Eigentuemer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Eigentuemer value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Eigentuemer[] $eigentuemer
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setEigentuemer(array $eigentuemer = array())
    {
        // validation for constraint: array
        if ('' !== ($eigentuemerArrayErrorMessage = self::validateEigentuemerForArrayConstraintsFromSetEigentuemer($eigentuemer))) {
            throw new \InvalidArgumentException($eigentuemerArrayErrorMessage, __LINE__);
        }
        $this->Eigentuemer = $eigentuemer;
        return $this;
    }
    /**
     * Add item to Eigentuemer value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Eigentuemer $item
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function addToEigentuemer(\BiPRO\StructType\CT_Eigentuemer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Eigentuemer) {
            throw new \InvalidArgumentException(sprintf('The Eigentuemer property can only contain items of type \BiPRO\StructType\CT_Eigentuemer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Eigentuemer[] = $item;
        return $this;
    }
    /**
     * Get Vermieter value
     * @return \BiPRO\StructType\CT_Vermieter[]|null
     */
    public function getVermieter()
    {
        return $this->Vermieter;
    }
    /**
     * This method is responsible for validating the values passed to the setVermieter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVermieter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVermieterForArrayConstraintsFromSetVermieter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GebaeudeVermieterItem) {
            // validation for constraint: itemType
            if (!$cT_GebaeudeVermieterItem instanceof \BiPRO\StructType\CT_Vermieter) {
                $invalidValues[] = is_object($cT_GebaeudeVermieterItem) ? get_class($cT_GebaeudeVermieterItem) : sprintf('%s(%s)', gettype($cT_GebaeudeVermieterItem), var_export($cT_GebaeudeVermieterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Vermieter property can only contain items of type \BiPRO\StructType\CT_Vermieter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Vermieter value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vermieter[] $vermieter
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setVermieter(array $vermieter = array())
    {
        // validation for constraint: array
        if ('' !== ($vermieterArrayErrorMessage = self::validateVermieterForArrayConstraintsFromSetVermieter($vermieter))) {
            throw new \InvalidArgumentException($vermieterArrayErrorMessage, __LINE__);
        }
        $this->Vermieter = $vermieter;
        return $this;
    }
    /**
     * Add item to Vermieter value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vermieter $item
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function addToVermieter(\BiPRO\StructType\CT_Vermieter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Vermieter) {
            throw new \InvalidArgumentException(sprintf('The Vermieter property can only contain items of type \BiPRO\StructType\CT_Vermieter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Vermieter[] = $item;
        return $this;
    }
    /**
     * Get Mieter value
     * @return \BiPRO\StructType\CT_Mieter[]|null
     */
    public function getMieter()
    {
        return $this->Mieter;
    }
    /**
     * This method is responsible for validating the values passed to the setMieter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMieter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMieterForArrayConstraintsFromSetMieter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GebaeudeMieterItem) {
            // validation for constraint: itemType
            if (!$cT_GebaeudeMieterItem instanceof \BiPRO\StructType\CT_Mieter) {
                $invalidValues[] = is_object($cT_GebaeudeMieterItem) ? get_class($cT_GebaeudeMieterItem) : sprintf('%s(%s)', gettype($cT_GebaeudeMieterItem), var_export($cT_GebaeudeMieterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Mieter property can only contain items of type \BiPRO\StructType\CT_Mieter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Mieter value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Mieter[] $mieter
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setMieter(array $mieter = array())
    {
        // validation for constraint: array
        if ('' !== ($mieterArrayErrorMessage = self::validateMieterForArrayConstraintsFromSetMieter($mieter))) {
            throw new \InvalidArgumentException($mieterArrayErrorMessage, __LINE__);
        }
        $this->Mieter = $mieter;
        return $this;
    }
    /**
     * Add item to Mieter value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Mieter $item
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function addToMieter(\BiPRO\StructType\CT_Mieter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Mieter) {
            throw new \InvalidArgumentException(sprintf('The Mieter property can only contain items of type \BiPRO\StructType\CT_Mieter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Mieter[] = $item;
        return $this;
    }
    /**
     * Get UmbauterRaum value
     * @return int|null
     */
    public function getUmbauterRaum()
    {
        return $this->UmbauterRaum;
    }
    /**
     * Set UmbauterRaum value
     * @param int $umbauterRaum
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setUmbauterRaum($umbauterRaum = null)
    {
        // validation for constraint: int
        if (!is_null($umbauterRaum) && !(is_int($umbauterRaum) || ctype_digit($umbauterRaum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($umbauterRaum, true), gettype($umbauterRaum)), __LINE__);
        }
        $this->UmbauterRaum = $umbauterRaum;
        return $this;
    }
    /**
     * Get Sicherungsglaeubiger value
     * @return \BiPRO\StructType\CT_Sicherungsglaeubiger[]|null
     */
    public function getSicherungsglaeubiger()
    {
        return $this->Sicherungsglaeubiger;
    }
    /**
     * This method is responsible for validating the values passed to the setSicherungsglaeubiger method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSicherungsglaeubiger method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSicherungsglaeubigerForArrayConstraintsFromSetSicherungsglaeubiger(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GebaeudeSicherungsglaeubigerItem) {
            // validation for constraint: itemType
            if (!$cT_GebaeudeSicherungsglaeubigerItem instanceof \BiPRO\StructType\CT_Sicherungsglaeubiger) {
                $invalidValues[] = is_object($cT_GebaeudeSicherungsglaeubigerItem) ? get_class($cT_GebaeudeSicherungsglaeubigerItem) : sprintf('%s(%s)', gettype($cT_GebaeudeSicherungsglaeubigerItem), var_export($cT_GebaeudeSicherungsglaeubigerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Sicherungsglaeubiger property can only contain items of type \BiPRO\StructType\CT_Sicherungsglaeubiger, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Sicherungsglaeubiger value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Sicherungsglaeubiger[] $sicherungsglaeubiger
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setSicherungsglaeubiger(array $sicherungsglaeubiger = array())
    {
        // validation for constraint: array
        if ('' !== ($sicherungsglaeubigerArrayErrorMessage = self::validateSicherungsglaeubigerForArrayConstraintsFromSetSicherungsglaeubiger($sicherungsglaeubiger))) {
            throw new \InvalidArgumentException($sicherungsglaeubigerArrayErrorMessage, __LINE__);
        }
        $this->Sicherungsglaeubiger = $sicherungsglaeubiger;
        return $this;
    }
    /**
     * Add item to Sicherungsglaeubiger value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Sicherungsglaeubiger $item
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function addToSicherungsglaeubiger(\BiPRO\StructType\CT_Sicherungsglaeubiger $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Sicherungsglaeubiger) {
            throw new \InvalidArgumentException(sprintf('The Sicherungsglaeubiger property can only contain items of type \BiPRO\StructType\CT_Sicherungsglaeubiger, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Sicherungsglaeubiger[] = $item;
        return $this;
    }
    /**
     * Get Kaufpreis value
     * @return \BiPRO\StructType\CT_Kaufpreis|null
     */
    public function getKaufpreis()
    {
        return $this->Kaufpreis;
    }
    /**
     * Set Kaufpreis value
     * @param \BiPRO\StructType\CT_Kaufpreis $kaufpreis
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setKaufpreis(\BiPRO\StructType\CT_Kaufpreis $kaufpreis = null)
    {
        $this->Kaufpreis = $kaufpreis;
        return $this;
    }
    /**
     * Get DenkmalschutzUmfang value
     * @return string[]|null
     */
    public function getDenkmalschutzUmfang()
    {
        return $this->DenkmalschutzUmfang;
    }
    /**
     * This method is responsible for validating the values passed to the setDenkmalschutzUmfang method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDenkmalschutzUmfang method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDenkmalschutzUmfangForArrayConstraintsFromSetDenkmalschutzUmfang(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GebaeudeDenkmalschutzUmfangItem) {
            // validation for constraint: enumeration
            if (!\BiPRO\EnumType\ST_DenkmalschutzUmfang::valueIsValid($cT_GebaeudeDenkmalschutzUmfangItem)) {
                $invalidValues[] = is_object($cT_GebaeudeDenkmalschutzUmfangItem) ? get_class($cT_GebaeudeDenkmalschutzUmfangItem) : sprintf('%s(%s)', gettype($cT_GebaeudeDenkmalschutzUmfangItem), var_export($cT_GebaeudeDenkmalschutzUmfangItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_DenkmalschutzUmfang', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \BiPRO\EnumType\ST_DenkmalschutzUmfang::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DenkmalschutzUmfang value
     * @uses \BiPRO\EnumType\ST_DenkmalschutzUmfang::valueIsValid()
     * @uses \BiPRO\EnumType\ST_DenkmalschutzUmfang::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $denkmalschutzUmfang
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setDenkmalschutzUmfang(array $denkmalschutzUmfang = array())
    {
        // validation for constraint: array
        if ('' !== ($denkmalschutzUmfangArrayErrorMessage = self::validateDenkmalschutzUmfangForArrayConstraintsFromSetDenkmalschutzUmfang($denkmalschutzUmfang))) {
            throw new \InvalidArgumentException($denkmalschutzUmfangArrayErrorMessage, __LINE__);
        }
        $this->DenkmalschutzUmfang = $denkmalschutzUmfang;
        return $this;
    }
    /**
     * Add item to DenkmalschutzUmfang value
     * @uses \BiPRO\EnumType\ST_DenkmalschutzUmfang::valueIsValid()
     * @uses \BiPRO\EnumType\ST_DenkmalschutzUmfang::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function addToDenkmalschutzUmfang($item)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_DenkmalschutzUmfang::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_DenkmalschutzUmfang', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \BiPRO\EnumType\ST_DenkmalschutzUmfang::getValidValues())), __LINE__);
        }
        $this->DenkmalschutzUmfang[] = $item;
        return $this;
    }
    /**
     * Get ArtDerUnterkellerung value
     * @return string|null
     */
    public function getArtDerUnterkellerung()
    {
        return $this->ArtDerUnterkellerung;
    }
    /**
     * Set ArtDerUnterkellerung value
     * @uses \BiPRO\EnumType\ST_Unterkellerung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Unterkellerung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artDerUnterkellerung
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setArtDerUnterkellerung($artDerUnterkellerung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Unterkellerung::valueIsValid($artDerUnterkellerung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Unterkellerung', is_array($artDerUnterkellerung) ? implode(', ', $artDerUnterkellerung) : var_export($artDerUnterkellerung, true), implode(', ', \BiPRO\EnumType\ST_Unterkellerung::getValidValues())), __LINE__);
        }
        $this->ArtDerUnterkellerung = $artDerUnterkellerung;
        return $this;
    }
    /**
     * Get Konstruktion value
     * @return \BiPRO\StructType\CT_Konstruktion[]|null
     */
    public function getKonstruktion()
    {
        return $this->Konstruktion;
    }
    /**
     * This method is responsible for validating the values passed to the setKonstruktion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKonstruktion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKonstruktionForArrayConstraintsFromSetKonstruktion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GebaeudeKonstruktionItem) {
            // validation for constraint: itemType
            if (!$cT_GebaeudeKonstruktionItem instanceof \BiPRO\StructType\CT_Konstruktion) {
                $invalidValues[] = is_object($cT_GebaeudeKonstruktionItem) ? get_class($cT_GebaeudeKonstruktionItem) : sprintf('%s(%s)', gettype($cT_GebaeudeKonstruktionItem), var_export($cT_GebaeudeKonstruktionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Konstruktion property can only contain items of type \BiPRO\StructType\CT_Konstruktion, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Konstruktion value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Konstruktion[] $konstruktion
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function setKonstruktion(array $konstruktion = array())
    {
        // validation for constraint: array
        if ('' !== ($konstruktionArrayErrorMessage = self::validateKonstruktionForArrayConstraintsFromSetKonstruktion($konstruktion))) {
            throw new \InvalidArgumentException($konstruktionArrayErrorMessage, __LINE__);
        }
        $this->Konstruktion = $konstruktion;
        return $this;
    }
    /**
     * Add item to Konstruktion value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Konstruktion $item
     * @return \BiPRO\StructType\CT_Gebaeude
     */
    public function addToKonstruktion(\BiPRO\StructType\CT_Konstruktion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Konstruktion) {
            throw new \InvalidArgumentException(sprintf('The Konstruktion property can only contain items of type \BiPRO\StructType\CT_Konstruktion, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Konstruktion[] = $item;
        return $this;
    }
}
