<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Freitext StructType
 * Meta information extracted from the WSDL
 * - documentation: Freier Text, zum dem der Verfasser als Quelle spezifiziert werden kann.
 * @subpackage Structs
 */
class CT_Freitext extends CT_Objekt
{
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - documentation: Beliebiger Text
     * - base: xsd:string
     * - maxLength: 2000
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $Text;
    /**
     * The Quelle
     * Meta information extracted from the WSDL
     * - documentation: Verfasser des Freitextes.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Quelle
     */
    public $Quelle;
    /**
     * Constructor method for CT_Freitext
     * @uses CT_Freitext::setText()
     * @uses CT_Freitext::setQuelle()
     * @param string $text
     * @param \BiPRO\StructType\CT_Quelle $quelle
     */
    public function __construct($text = null, \BiPRO\StructType\CT_Quelle $quelle = null)
    {
        $this
            ->setText($text)
            ->setQuelle($quelle);
    }
    /**
     * Get Text value
     * @return string
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \BiPRO\StructType\CT_Freitext
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        // validation for constraint: maxLength(2000)
        if (!is_null($text) && mb_strlen($text) > 2000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2000', mb_strlen($text)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($text) && mb_strlen($text) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Quelle value
     * @return \BiPRO\StructType\CT_Quelle|null
     */
    public function getQuelle()
    {
        return $this->Quelle;
    }
    /**
     * Set Quelle value
     * @param \BiPRO\StructType\CT_Quelle $quelle
     * @return \BiPRO\StructType\CT_Freitext
     */
    public function setQuelle(\BiPRO\StructType\CT_Quelle $quelle = null)
    {
        $this->Quelle = $quelle;
        return $this;
    }
}
