<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_FrageText StructType
 * Meta information extracted from the WSDL
 * - documentation: Frage deren Antwort in Form eines Textes zu geben ist.
 * @subpackage Structs
 */
class CT_FrageText extends CT_EinfacheFrage
{
    /**
     * The MaximaleTextlaenge
     * Meta information extracted from the WSDL
     * - documentation: Maximale Anzahl der Zeichen für die zu gebende Antwort.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $MaximaleTextlaenge;
    /**
     * The AntwortText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_AntwortText
     */
    public $AntwortText;
    /**
     * Constructor method for CT_FrageText
     * @uses CT_FrageText::setMaximaleTextlaenge()
     * @uses CT_FrageText::setAntwortText()
     * @param int $maximaleTextlaenge
     * @param \BiPRO\StructType\CT_AntwortText $antwortText
     */
    public function __construct($maximaleTextlaenge = null, \BiPRO\StructType\CT_AntwortText $antwortText = null)
    {
        $this
            ->setMaximaleTextlaenge($maximaleTextlaenge)
            ->setAntwortText($antwortText);
    }
    /**
     * Get MaximaleTextlaenge value
     * @return int|null
     */
    public function getMaximaleTextlaenge()
    {
        return $this->MaximaleTextlaenge;
    }
    /**
     * Set MaximaleTextlaenge value
     * @param int $maximaleTextlaenge
     * @return \BiPRO\StructType\CT_FrageText
     */
    public function setMaximaleTextlaenge($maximaleTextlaenge = null)
    {
        // validation for constraint: int
        if (!is_null($maximaleTextlaenge) && !(is_int($maximaleTextlaenge) || ctype_digit($maximaleTextlaenge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximaleTextlaenge, true), gettype($maximaleTextlaenge)), __LINE__);
        }
        $this->MaximaleTextlaenge = $maximaleTextlaenge;
        return $this;
    }
    /**
     * Get AntwortText value
     * @return \BiPRO\StructType\CT_AntwortText|null
     */
    public function getAntwortText()
    {
        return $this->AntwortText;
    }
    /**
     * Set AntwortText value
     * @param \BiPRO\StructType\CT_AntwortText $antwortText
     * @return \BiPRO\StructType\CT_FrageText
     */
    public function setAntwortText(\BiPRO\StructType\CT_AntwortText $antwortText = null)
    {
        $this->AntwortText = $antwortText;
        return $this;
    }
}
