<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_FondsAnteil StructType
 * Meta information extracted from the WSDL
 * - documentation: Informationen zu den einzelnen Fonds des Portfolios
 * @subpackage Structs
 */
class CT_FondsAnteil extends CT_Investment
{
    /**
     * The Prozentsatz
     * Meta information extracted from the WSDL
     * - documentation: Prozentuale Aufteilung von Zuführungen auf die einzelnen Fonds eines Portfolios ("Beitragsaufteilung" oder auch "Zuführungsaufteilung"). Der Anlagebetrag wird zu diesem Prozentsatz in diesen Fonds investiert. | Prozentanteil ohne
     * Prozentzeichen z.B. 50 = 50% oder 12,5 = 12,5%
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 1
     * @var float
     */
    public $Prozentsatz;
    /**
     * The Garantiefonds
     * Meta information extracted from the WSDL
     * - documentation: Angabe, ob der Fonds am Ende seiner Laufzeit eine (teilweise) Rückzahlung des Anlagebetrags garantiert.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Garantiefonds;
    /**
     * Constructor method for CT_FondsAnteil
     * @uses CT_FondsAnteil::setProzentsatz()
     * @uses CT_FondsAnteil::setGarantiefonds()
     * @param float $prozentsatz
     * @param bool $garantiefonds
     */
    public function __construct($prozentsatz = null, $garantiefonds = null)
    {
        $this
            ->setProzentsatz($prozentsatz)
            ->setGarantiefonds($garantiefonds);
    }
    /**
     * Get Prozentsatz value
     * @return float
     */
    public function getProzentsatz()
    {
        return $this->Prozentsatz;
    }
    /**
     * Set Prozentsatz value
     * @param float $prozentsatz
     * @return \BiPRO\StructType\CT_FondsAnteil
     */
    public function setProzentsatz($prozentsatz = null)
    {
        // validation for constraint: float
        if (!is_null($prozentsatz) && !(is_float($prozentsatz) || is_numeric($prozentsatz))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prozentsatz, true), gettype($prozentsatz)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prozentsatz) && $prozentsatz < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prozentsatz, true)), __LINE__);
        }
        $this->Prozentsatz = $prozentsatz;
        return $this;
    }
    /**
     * Get Garantiefonds value
     * @return bool|null
     */
    public function getGarantiefonds()
    {
        return $this->Garantiefonds;
    }
    /**
     * Set Garantiefonds value
     * @param bool $garantiefonds
     * @return \BiPRO\StructType\CT_FondsAnteil
     */
    public function setGarantiefonds($garantiefonds = null)
    {
        // validation for constraint: boolean
        if (!is_null($garantiefonds) && !is_bool($garantiefonds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($garantiefonds, true), gettype($garantiefonds)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($garantiefonds) && !preg_match('/true|false/', $garantiefonds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($garantiefonds, true)), __LINE__);
        }
        $this->Garantiefonds = $garantiefonds;
        return $this;
    }
}
