<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Feuerschaden StructType
 * Meta information extracted from the WSDL
 * - documentation: Schaden durch Feuer.
 * @subpackage Structs
 */
class CT_Feuerschaden extends CT_SchadenZuObjekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Art des Feuerschadens.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtID;
    /**
     * The Loeschart
     * Meta information extracted from the WSDL
     * - documentation: Art der Löschung.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Loeschart;
    /**
     * The Loeschvorgang
     * Meta information extracted from the WSDL
     * - documentation: Schilderung des Löschvorgangs.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Loeschvorgang;
    /**
     * The BetroffeneFlaeche
     * Meta information extracted from the WSDL
     * - documentation: Die physische Ausdehnung der durch den Feuerschaden betroffenen Fläche.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Groesse
     */
    public $BetroffeneFlaeche;
    /**
     * Constructor method for CT_Feuerschaden
     * @uses CT_Feuerschaden::setArtID()
     * @uses CT_Feuerschaden::setLoeschart()
     * @uses CT_Feuerschaden::setLoeschvorgang()
     * @uses CT_Feuerschaden::setBetroffeneFlaeche()
     * @param string $artID
     * @param string $loeschart
     * @param string $loeschvorgang
     * @param \BiPRO\StructType\CT_Groesse $betroffeneFlaeche
     */
    public function __construct($artID = null, $loeschart = null, $loeschvorgang = null, \BiPRO\StructType\CT_Groesse $betroffeneFlaeche = null)
    {
        $this
            ->setArtID($artID)
            ->setLoeschart($loeschart)
            ->setLoeschvorgang($loeschvorgang)
            ->setBetroffeneFlaeche($betroffeneFlaeche);
    }
    /**
     * Get ArtID value
     * @return string|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Feuerschaden::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Feuerschaden::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_Feuerschaden
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Feuerschaden::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Feuerschaden', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Feuerschaden::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Loeschart value
     * @return string|null
     */
    public function getLoeschart()
    {
        return $this->Loeschart;
    }
    /**
     * Set Loeschart value
     * @uses \BiPRO\EnumType\ST_Brandloeschart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Brandloeschart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $loeschart
     * @return \BiPRO\StructType\CT_Feuerschaden
     */
    public function setLoeschart($loeschart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Brandloeschart::valueIsValid($loeschart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Brandloeschart', is_array($loeschart) ? implode(', ', $loeschart) : var_export($loeschart, true), implode(', ', \BiPRO\EnumType\ST_Brandloeschart::getValidValues())), __LINE__);
        }
        $this->Loeschart = $loeschart;
        return $this;
    }
    /**
     * Get Loeschvorgang value
     * @return string|null
     */
    public function getLoeschvorgang()
    {
        return $this->Loeschvorgang;
    }
    /**
     * Set Loeschvorgang value
     * @param string $loeschvorgang
     * @return \BiPRO\StructType\CT_Feuerschaden
     */
    public function setLoeschvorgang($loeschvorgang = null)
    {
        // validation for constraint: string
        if (!is_null($loeschvorgang) && !is_string($loeschvorgang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loeschvorgang, true), gettype($loeschvorgang)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($loeschvorgang) && mb_strlen($loeschvorgang) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($loeschvorgang)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($loeschvorgang) && mb_strlen($loeschvorgang) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($loeschvorgang)), __LINE__);
        }
        $this->Loeschvorgang = $loeschvorgang;
        return $this;
    }
    /**
     * Get BetroffeneFlaeche value
     * @return \BiPRO\StructType\CT_Groesse|null
     */
    public function getBetroffeneFlaeche()
    {
        return $this->BetroffeneFlaeche;
    }
    /**
     * Set BetroffeneFlaeche value
     * @param \BiPRO\StructType\CT_Groesse $betroffeneFlaeche
     * @return \BiPRO\StructType\CT_Feuerschaden
     */
    public function setBetroffeneFlaeche(\BiPRO\StructType\CT_Groesse $betroffeneFlaeche = null)
    {
        $this->BetroffeneFlaeche = $betroffeneFlaeche;
        return $this;
    }
}
