<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Fahrzeugteilversicherung StructType
 * @subpackage Structs
 */
class CT_Fahrzeugteilversicherung extends CT_Elementarprodukt
{
    /**
     * The SelbstbeteiligungKFT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_SelbstbeteiligungKfz
     */
    public $SelbstbeteiligungKFT;
    /**
     * The Typklasse
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Typklasse;
    /**
     * The Regionalklasse
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 5
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Regionalklasse;
    /**
     * Constructor method for CT_Fahrzeugteilversicherung
     * @uses CT_Fahrzeugteilversicherung::setSelbstbeteiligungKFT()
     * @uses CT_Fahrzeugteilversicherung::setTypklasse()
     * @uses CT_Fahrzeugteilversicherung::setRegionalklasse()
     * @param \BiPRO\StructType\STE_SelbstbeteiligungKfz $selbstbeteiligungKFT
     * @param int $typklasse
     * @param string $regionalklasse
     */
    public function __construct(\BiPRO\StructType\STE_SelbstbeteiligungKfz $selbstbeteiligungKFT = null, $typklasse = null, $regionalklasse = null)
    {
        $this
            ->setSelbstbeteiligungKFT($selbstbeteiligungKFT)
            ->setTypklasse($typklasse)
            ->setRegionalklasse($regionalklasse);
    }
    /**
     * Get SelbstbeteiligungKFT value
     * @return \BiPRO\StructType\STE_SelbstbeteiligungKfz|null
     */
    public function getSelbstbeteiligungKFT()
    {
        return $this->SelbstbeteiligungKFT;
    }
    /**
     * Set SelbstbeteiligungKFT value
     * @param \BiPRO\StructType\STE_SelbstbeteiligungKfz $selbstbeteiligungKFT
     * @return \BiPRO\StructType\CT_Fahrzeugteilversicherung
     */
    public function setSelbstbeteiligungKFT(\BiPRO\StructType\STE_SelbstbeteiligungKfz $selbstbeteiligungKFT = null)
    {
        $this->SelbstbeteiligungKFT = $selbstbeteiligungKFT;
        return $this;
    }
    /**
     * Get Typklasse value
     * @return int|null
     */
    public function getTypklasse()
    {
        return $this->Typklasse;
    }
    /**
     * Set Typklasse value
     * @param int $typklasse
     * @return \BiPRO\StructType\CT_Fahrzeugteilversicherung
     */
    public function setTypklasse($typklasse = null)
    {
        // validation for constraint: int
        if (!is_null($typklasse) && !(is_int($typklasse) || ctype_digit($typklasse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($typklasse, true), gettype($typklasse)), __LINE__);
        }
        $this->Typklasse = $typklasse;
        return $this;
    }
    /**
     * Get Regionalklasse value
     * @return string|null
     */
    public function getRegionalklasse()
    {
        return $this->Regionalklasse;
    }
    /**
     * Set Regionalklasse value
     * @param string $regionalklasse
     * @return \BiPRO\StructType\CT_Fahrzeugteilversicherung
     */
    public function setRegionalklasse($regionalklasse = null)
    {
        // validation for constraint: string
        if (!is_null($regionalklasse) && !is_string($regionalklasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionalklasse, true), gettype($regionalklasse)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($regionalklasse) && mb_strlen($regionalklasse) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($regionalklasse)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($regionalklasse) && mb_strlen($regionalklasse) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($regionalklasse)), __LINE__);
        }
        $this->Regionalklasse = $regionalklasse;
        return $this;
    }
}
