<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_FahrzeugnutzungErweitert StructType
 * @subpackage Structs
 */
abstract class CT_FahrzeugnutzungErweitert extends CT_Fahrzeugnutzung
{
    /**
     * The Nutzerkreis
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Nutzerkreis;
    /**
     * The AlterJuengsterMaennlicherNutzer
     * Meta information extracted from the WSDL
     * - documentation: Bei Unisex-Tarifen DARF dieses Attribut NICHT mehr benutzt werden. Statt dessen MUSS das Attribut AlterJuengsterNutzer verwendt werden.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AlterJuengsterMaennlicherNutzer;
    /**
     * The GeburtsjahrJuengsterMaennlicherNutzer
     * Meta information extracted from the WSDL
     * - documentation: Bei Unisex-Tarifen DARF dieses Attribut NICHT mehr benutzt werden. Statt dessen MUSS das Attribut GeburtsjahrJuengsterNutzer verwendt werden.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $GeburtsjahrJuengsterMaennlicherNutzer;
    /**
     * The AlterJuengsterWeiblicherNutzer
     * Meta information extracted from the WSDL
     * - documentation: Bei Unisex-Tarifen DARF dieses Attribut NICHT mehr benutzt werden. Statt dessen MUSS das Attribut AlterJuengsterNutzer verwendt werden.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AlterJuengsterWeiblicherNutzer;
    /**
     * The GeburtsjahrJuengsterWeiblicherNutzer
     * Meta information extracted from the WSDL
     * - documentation: Bei Unisex-Tarifen DARF dieses Attribut NICHT mehr benutzt werden. Statt dessen MUSS das Attribut GeburtsjahrJuengsterNutzer verwendt werden.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $GeburtsjahrJuengsterWeiblicherNutzer;
    /**
     * The AlterJuengsterNutzerUnbekannt
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $AlterJuengsterNutzerUnbekannt;
    /**
     * The AlterAeltesterNutzer
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AlterAeltesterNutzer;
    /**
     * The GeburtsjahrAeltesterNutzer
     * Meta information extracted from the WSDL
     * - documentation: Geburtsjahr des ältesten Fahrzeugnutzers, unabhängig vom Geschlecht.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $GeburtsjahrAeltesterNutzer;
    /**
     * The AlterAeltesterNutzerUnbekannt
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $AlterAeltesterNutzerUnbekannt;
    /**
     * The AlterJuengsterNutzer
     * Meta information extracted from the WSDL
     * - documentation: Alter des jüngsten Fahrzeugnutzers, unabhängig vom Geschlecht.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AlterJuengsterNutzer;
    /**
     * The GeburtsjahrJuengsterNutzer
     * Meta information extracted from the WSDL
     * - documentation: Geburtsjahr des jüngsten Fahrzeugnutzers, unabhängig vom Geschlecht.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $GeburtsjahrJuengsterNutzer;
    /**
     * The AlleFahrerHabenEUFuehrerschein
     * Meta information extracted from the WSDL
     * - documentation: Angabe, ob alle Fahrer einen in einem EU-Land ausgestellten Führerschein besitzen.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $AlleFahrerHabenEUFuehrerschein;
    /**
     * The GeburtsdatumJuengsterFahrer
     * Meta information extracted from the WSDL
     * - documentation: Geburtsdatum des jüngsten Fahrers. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $GeburtsdatumJuengsterFahrer;
    /**
     * Constructor method for CT_FahrzeugnutzungErweitert
     * @uses CT_FahrzeugnutzungErweitert::setNutzerkreis()
     * @uses CT_FahrzeugnutzungErweitert::setAlterJuengsterMaennlicherNutzer()
     * @uses CT_FahrzeugnutzungErweitert::setGeburtsjahrJuengsterMaennlicherNutzer()
     * @uses CT_FahrzeugnutzungErweitert::setAlterJuengsterWeiblicherNutzer()
     * @uses CT_FahrzeugnutzungErweitert::setGeburtsjahrJuengsterWeiblicherNutzer()
     * @uses CT_FahrzeugnutzungErweitert::setAlterJuengsterNutzerUnbekannt()
     * @uses CT_FahrzeugnutzungErweitert::setAlterAeltesterNutzer()
     * @uses CT_FahrzeugnutzungErweitert::setGeburtsjahrAeltesterNutzer()
     * @uses CT_FahrzeugnutzungErweitert::setAlterAeltesterNutzerUnbekannt()
     * @uses CT_FahrzeugnutzungErweitert::setAlterJuengsterNutzer()
     * @uses CT_FahrzeugnutzungErweitert::setGeburtsjahrJuengsterNutzer()
     * @uses CT_FahrzeugnutzungErweitert::setAlleFahrerHabenEUFuehrerschein()
     * @uses CT_FahrzeugnutzungErweitert::setGeburtsdatumJuengsterFahrer()
     * @param string[] $nutzerkreis
     * @param int $alterJuengsterMaennlicherNutzer
     * @param int $geburtsjahrJuengsterMaennlicherNutzer
     * @param int $alterJuengsterWeiblicherNutzer
     * @param int $geburtsjahrJuengsterWeiblicherNutzer
     * @param bool $alterJuengsterNutzerUnbekannt
     * @param int $alterAeltesterNutzer
     * @param int $geburtsjahrAeltesterNutzer
     * @param bool $alterAeltesterNutzerUnbekannt
     * @param int $alterJuengsterNutzer
     * @param int $geburtsjahrJuengsterNutzer
     * @param bool $alleFahrerHabenEUFuehrerschein
     * @param string $geburtsdatumJuengsterFahrer
     */
    public function __construct(array $nutzerkreis = array(), $alterJuengsterMaennlicherNutzer = null, $geburtsjahrJuengsterMaennlicherNutzer = null, $alterJuengsterWeiblicherNutzer = null, $geburtsjahrJuengsterWeiblicherNutzer = null, $alterJuengsterNutzerUnbekannt = null, $alterAeltesterNutzer = null, $geburtsjahrAeltesterNutzer = null, $alterAeltesterNutzerUnbekannt = null, $alterJuengsterNutzer = null, $geburtsjahrJuengsterNutzer = null, $alleFahrerHabenEUFuehrerschein = null, $geburtsdatumJuengsterFahrer = null)
    {
        $this
            ->setNutzerkreis($nutzerkreis)
            ->setAlterJuengsterMaennlicherNutzer($alterJuengsterMaennlicherNutzer)
            ->setGeburtsjahrJuengsterMaennlicherNutzer($geburtsjahrJuengsterMaennlicherNutzer)
            ->setAlterJuengsterWeiblicherNutzer($alterJuengsterWeiblicherNutzer)
            ->setGeburtsjahrJuengsterWeiblicherNutzer($geburtsjahrJuengsterWeiblicherNutzer)
            ->setAlterJuengsterNutzerUnbekannt($alterJuengsterNutzerUnbekannt)
            ->setAlterAeltesterNutzer($alterAeltesterNutzer)
            ->setGeburtsjahrAeltesterNutzer($geburtsjahrAeltesterNutzer)
            ->setAlterAeltesterNutzerUnbekannt($alterAeltesterNutzerUnbekannt)
            ->setAlterJuengsterNutzer($alterJuengsterNutzer)
            ->setGeburtsjahrJuengsterNutzer($geburtsjahrJuengsterNutzer)
            ->setAlleFahrerHabenEUFuehrerschein($alleFahrerHabenEUFuehrerschein)
            ->setGeburtsdatumJuengsterFahrer($geburtsdatumJuengsterFahrer);
    }
    /**
     * Get Nutzerkreis value
     * @return string[]|null
     */
    public function getNutzerkreis()
    {
        return $this->Nutzerkreis;
    }
    /**
     * This method is responsible for validating the values passed to the setNutzerkreis method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNutzerkreis method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNutzerkreisForArrayConstraintsFromSetNutzerkreis(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_FahrzeugnutzungErweitertNutzerkreisItem) {
            // validation for constraint: enumeration
            if (!\BiPRO\EnumType\ST_Nutzerkreis::valueIsValid($cT_FahrzeugnutzungErweitertNutzerkreisItem)) {
                $invalidValues[] = is_object($cT_FahrzeugnutzungErweitertNutzerkreisItem) ? get_class($cT_FahrzeugnutzungErweitertNutzerkreisItem) : sprintf('%s(%s)', gettype($cT_FahrzeugnutzungErweitertNutzerkreisItem), var_export($cT_FahrzeugnutzungErweitertNutzerkreisItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Nutzerkreis', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \BiPRO\EnumType\ST_Nutzerkreis::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Nutzerkreis value
     * @uses \BiPRO\EnumType\ST_Nutzerkreis::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Nutzerkreis::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $nutzerkreis
     * @return \BiPRO\StructType\CT_FahrzeugnutzungErweitert
     */
    public function setNutzerkreis(array $nutzerkreis = array())
    {
        // validation for constraint: array
        if ('' !== ($nutzerkreisArrayErrorMessage = self::validateNutzerkreisForArrayConstraintsFromSetNutzerkreis($nutzerkreis))) {
            throw new \InvalidArgumentException($nutzerkreisArrayErrorMessage, __LINE__);
        }
        $this->Nutzerkreis = $nutzerkreis;
        return $this;
    }
    /**
     * Add item to Nutzerkreis value
     * @uses \BiPRO\EnumType\ST_Nutzerkreis::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Nutzerkreis::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_FahrzeugnutzungErweitert
     */
    public function addToNutzerkreis($item)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Nutzerkreis::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Nutzerkreis', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \BiPRO\EnumType\ST_Nutzerkreis::getValidValues())), __LINE__);
        }
        $this->Nutzerkreis[] = $item;
        return $this;
    }
    /**
     * Get AlterJuengsterMaennlicherNutzer value
     * @return int|null
     */
    public function getAlterJuengsterMaennlicherNutzer()
    {
        return $this->AlterJuengsterMaennlicherNutzer;
    }
    /**
     * Set AlterJuengsterMaennlicherNutzer value
     * @param int $alterJuengsterMaennlicherNutzer
     * @return \BiPRO\StructType\CT_FahrzeugnutzungErweitert
     */
    public function setAlterJuengsterMaennlicherNutzer($alterJuengsterMaennlicherNutzer = null)
    {
        // validation for constraint: int
        if (!is_null($alterJuengsterMaennlicherNutzer) && !(is_int($alterJuengsterMaennlicherNutzer) || ctype_digit($alterJuengsterMaennlicherNutzer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alterJuengsterMaennlicherNutzer, true), gettype($alterJuengsterMaennlicherNutzer)), __LINE__);
        }
        $this->AlterJuengsterMaennlicherNutzer = $alterJuengsterMaennlicherNutzer;
        return $this;
    }
    /**
     * Get GeburtsjahrJuengsterMaennlicherNutzer value
     * @return int|null
     */
    public function getGeburtsjahrJuengsterMaennlicherNutzer()
    {
        return $this->GeburtsjahrJuengsterMaennlicherNutzer;
    }
    /**
     * Set GeburtsjahrJuengsterMaennlicherNutzer value
     * @param int $geburtsjahrJuengsterMaennlicherNutzer
     * @return \BiPRO\StructType\CT_FahrzeugnutzungErweitert
     */
    public function setGeburtsjahrJuengsterMaennlicherNutzer($geburtsjahrJuengsterMaennlicherNutzer = null)
    {
        // validation for constraint: int
        if (!is_null($geburtsjahrJuengsterMaennlicherNutzer) && !(is_int($geburtsjahrJuengsterMaennlicherNutzer) || ctype_digit($geburtsjahrJuengsterMaennlicherNutzer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($geburtsjahrJuengsterMaennlicherNutzer, true), gettype($geburtsjahrJuengsterMaennlicherNutzer)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($geburtsjahrJuengsterMaennlicherNutzer) && mb_strlen(preg_replace('/(\D)/', '', $geburtsjahrJuengsterMaennlicherNutzer)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($geburtsjahrJuengsterMaennlicherNutzer, true), mb_strlen(preg_replace('/(\D)/', '', $geburtsjahrJuengsterMaennlicherNutzer))), __LINE__);
        }
        $this->GeburtsjahrJuengsterMaennlicherNutzer = $geburtsjahrJuengsterMaennlicherNutzer;
        return $this;
    }
    /**
     * Get AlterJuengsterWeiblicherNutzer value
     * @return int|null
     */
    public function getAlterJuengsterWeiblicherNutzer()
    {
        return $this->AlterJuengsterWeiblicherNutzer;
    }
    /**
     * Set AlterJuengsterWeiblicherNutzer value
     * @param int $alterJuengsterWeiblicherNutzer
     * @return \BiPRO\StructType\CT_FahrzeugnutzungErweitert
     */
    public function setAlterJuengsterWeiblicherNutzer($alterJuengsterWeiblicherNutzer = null)
    {
        // validation for constraint: int
        if (!is_null($alterJuengsterWeiblicherNutzer) && !(is_int($alterJuengsterWeiblicherNutzer) || ctype_digit($alterJuengsterWeiblicherNutzer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alterJuengsterWeiblicherNutzer, true), gettype($alterJuengsterWeiblicherNutzer)), __LINE__);
        }
        $this->AlterJuengsterWeiblicherNutzer = $alterJuengsterWeiblicherNutzer;
        return $this;
    }
    /**
     * Get GeburtsjahrJuengsterWeiblicherNutzer value
     * @return int|null
     */
    public function getGeburtsjahrJuengsterWeiblicherNutzer()
    {
        return $this->GeburtsjahrJuengsterWeiblicherNutzer;
    }
    /**
     * Set GeburtsjahrJuengsterWeiblicherNutzer value
     * @param int $geburtsjahrJuengsterWeiblicherNutzer
     * @return \BiPRO\StructType\CT_FahrzeugnutzungErweitert
     */
    public function setGeburtsjahrJuengsterWeiblicherNutzer($geburtsjahrJuengsterWeiblicherNutzer = null)
    {
        // validation for constraint: int
        if (!is_null($geburtsjahrJuengsterWeiblicherNutzer) && !(is_int($geburtsjahrJuengsterWeiblicherNutzer) || ctype_digit($geburtsjahrJuengsterWeiblicherNutzer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($geburtsjahrJuengsterWeiblicherNutzer, true), gettype($geburtsjahrJuengsterWeiblicherNutzer)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($geburtsjahrJuengsterWeiblicherNutzer) && mb_strlen(preg_replace('/(\D)/', '', $geburtsjahrJuengsterWeiblicherNutzer)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($geburtsjahrJuengsterWeiblicherNutzer, true), mb_strlen(preg_replace('/(\D)/', '', $geburtsjahrJuengsterWeiblicherNutzer))), __LINE__);
        }
        $this->GeburtsjahrJuengsterWeiblicherNutzer = $geburtsjahrJuengsterWeiblicherNutzer;
        return $this;
    }
    /**
     * Get AlterJuengsterNutzerUnbekannt value
     * @return bool|null
     */
    public function getAlterJuengsterNutzerUnbekannt()
    {
        return $this->AlterJuengsterNutzerUnbekannt;
    }
    /**
     * Set AlterJuengsterNutzerUnbekannt value
     * @param bool $alterJuengsterNutzerUnbekannt
     * @return \BiPRO\StructType\CT_FahrzeugnutzungErweitert
     */
    public function setAlterJuengsterNutzerUnbekannt($alterJuengsterNutzerUnbekannt = null)
    {
        // validation for constraint: boolean
        if (!is_null($alterJuengsterNutzerUnbekannt) && !is_bool($alterJuengsterNutzerUnbekannt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($alterJuengsterNutzerUnbekannt, true), gettype($alterJuengsterNutzerUnbekannt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($alterJuengsterNutzerUnbekannt) && !preg_match('/true|false/', $alterJuengsterNutzerUnbekannt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($alterJuengsterNutzerUnbekannt, true)), __LINE__);
        }
        $this->AlterJuengsterNutzerUnbekannt = $alterJuengsterNutzerUnbekannt;
        return $this;
    }
    /**
     * Get AlterAeltesterNutzer value
     * @return int|null
     */
    public function getAlterAeltesterNutzer()
    {
        return $this->AlterAeltesterNutzer;
    }
    /**
     * Set AlterAeltesterNutzer value
     * @param int $alterAeltesterNutzer
     * @return \BiPRO\StructType\CT_FahrzeugnutzungErweitert
     */
    public function setAlterAeltesterNutzer($alterAeltesterNutzer = null)
    {
        // validation for constraint: int
        if (!is_null($alterAeltesterNutzer) && !(is_int($alterAeltesterNutzer) || ctype_digit($alterAeltesterNutzer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alterAeltesterNutzer, true), gettype($alterAeltesterNutzer)), __LINE__);
        }
        $this->AlterAeltesterNutzer = $alterAeltesterNutzer;
        return $this;
    }
    /**
     * Get GeburtsjahrAeltesterNutzer value
     * @return int|null
     */
    public function getGeburtsjahrAeltesterNutzer()
    {
        return $this->GeburtsjahrAeltesterNutzer;
    }
    /**
     * Set GeburtsjahrAeltesterNutzer value
     * @param int $geburtsjahrAeltesterNutzer
     * @return \BiPRO\StructType\CT_FahrzeugnutzungErweitert
     */
    public function setGeburtsjahrAeltesterNutzer($geburtsjahrAeltesterNutzer = null)
    {
        // validation for constraint: int
        if (!is_null($geburtsjahrAeltesterNutzer) && !(is_int($geburtsjahrAeltesterNutzer) || ctype_digit($geburtsjahrAeltesterNutzer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($geburtsjahrAeltesterNutzer, true), gettype($geburtsjahrAeltesterNutzer)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($geburtsjahrAeltesterNutzer) && mb_strlen(preg_replace('/(\D)/', '', $geburtsjahrAeltesterNutzer)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($geburtsjahrAeltesterNutzer, true), mb_strlen(preg_replace('/(\D)/', '', $geburtsjahrAeltesterNutzer))), __LINE__);
        }
        $this->GeburtsjahrAeltesterNutzer = $geburtsjahrAeltesterNutzer;
        return $this;
    }
    /**
     * Get AlterAeltesterNutzerUnbekannt value
     * @return bool|null
     */
    public function getAlterAeltesterNutzerUnbekannt()
    {
        return $this->AlterAeltesterNutzerUnbekannt;
    }
    /**
     * Set AlterAeltesterNutzerUnbekannt value
     * @param bool $alterAeltesterNutzerUnbekannt
     * @return \BiPRO\StructType\CT_FahrzeugnutzungErweitert
     */
    public function setAlterAeltesterNutzerUnbekannt($alterAeltesterNutzerUnbekannt = null)
    {
        // validation for constraint: boolean
        if (!is_null($alterAeltesterNutzerUnbekannt) && !is_bool($alterAeltesterNutzerUnbekannt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($alterAeltesterNutzerUnbekannt, true), gettype($alterAeltesterNutzerUnbekannt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($alterAeltesterNutzerUnbekannt) && !preg_match('/true|false/', $alterAeltesterNutzerUnbekannt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($alterAeltesterNutzerUnbekannt, true)), __LINE__);
        }
        $this->AlterAeltesterNutzerUnbekannt = $alterAeltesterNutzerUnbekannt;
        return $this;
    }
    /**
     * Get AlterJuengsterNutzer value
     * @return int|null
     */
    public function getAlterJuengsterNutzer()
    {
        return $this->AlterJuengsterNutzer;
    }
    /**
     * Set AlterJuengsterNutzer value
     * @param int $alterJuengsterNutzer
     * @return \BiPRO\StructType\CT_FahrzeugnutzungErweitert
     */
    public function setAlterJuengsterNutzer($alterJuengsterNutzer = null)
    {
        // validation for constraint: int
        if (!is_null($alterJuengsterNutzer) && !(is_int($alterJuengsterNutzer) || ctype_digit($alterJuengsterNutzer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alterJuengsterNutzer, true), gettype($alterJuengsterNutzer)), __LINE__);
        }
        $this->AlterJuengsterNutzer = $alterJuengsterNutzer;
        return $this;
    }
    /**
     * Get GeburtsjahrJuengsterNutzer value
     * @return int|null
     */
    public function getGeburtsjahrJuengsterNutzer()
    {
        return $this->GeburtsjahrJuengsterNutzer;
    }
    /**
     * Set GeburtsjahrJuengsterNutzer value
     * @param int $geburtsjahrJuengsterNutzer
     * @return \BiPRO\StructType\CT_FahrzeugnutzungErweitert
     */
    public function setGeburtsjahrJuengsterNutzer($geburtsjahrJuengsterNutzer = null)
    {
        // validation for constraint: int
        if (!is_null($geburtsjahrJuengsterNutzer) && !(is_int($geburtsjahrJuengsterNutzer) || ctype_digit($geburtsjahrJuengsterNutzer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($geburtsjahrJuengsterNutzer, true), gettype($geburtsjahrJuengsterNutzer)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($geburtsjahrJuengsterNutzer) && mb_strlen(preg_replace('/(\D)/', '', $geburtsjahrJuengsterNutzer)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($geburtsjahrJuengsterNutzer, true), mb_strlen(preg_replace('/(\D)/', '', $geburtsjahrJuengsterNutzer))), __LINE__);
        }
        $this->GeburtsjahrJuengsterNutzer = $geburtsjahrJuengsterNutzer;
        return $this;
    }
    /**
     * Get AlleFahrerHabenEUFuehrerschein value
     * @return bool|null
     */
    public function getAlleFahrerHabenEUFuehrerschein()
    {
        return $this->AlleFahrerHabenEUFuehrerschein;
    }
    /**
     * Set AlleFahrerHabenEUFuehrerschein value
     * @param bool $alleFahrerHabenEUFuehrerschein
     * @return \BiPRO\StructType\CT_FahrzeugnutzungErweitert
     */
    public function setAlleFahrerHabenEUFuehrerschein($alleFahrerHabenEUFuehrerschein = null)
    {
        // validation for constraint: boolean
        if (!is_null($alleFahrerHabenEUFuehrerschein) && !is_bool($alleFahrerHabenEUFuehrerschein)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($alleFahrerHabenEUFuehrerschein, true), gettype($alleFahrerHabenEUFuehrerschein)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($alleFahrerHabenEUFuehrerschein) && !preg_match('/true|false/', $alleFahrerHabenEUFuehrerschein)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($alleFahrerHabenEUFuehrerschein, true)), __LINE__);
        }
        $this->AlleFahrerHabenEUFuehrerschein = $alleFahrerHabenEUFuehrerschein;
        return $this;
    }
    /**
     * Get GeburtsdatumJuengsterFahrer value
     * @return string|null
     */
    public function getGeburtsdatumJuengsterFahrer()
    {
        return $this->GeburtsdatumJuengsterFahrer;
    }
    /**
     * Set GeburtsdatumJuengsterFahrer value
     * @param string $geburtsdatumJuengsterFahrer
     * @return \BiPRO\StructType\CT_FahrzeugnutzungErweitert
     */
    public function setGeburtsdatumJuengsterFahrer($geburtsdatumJuengsterFahrer = null)
    {
        // validation for constraint: string
        if (!is_null($geburtsdatumJuengsterFahrer) && !is_string($geburtsdatumJuengsterFahrer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geburtsdatumJuengsterFahrer, true), gettype($geburtsdatumJuengsterFahrer)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($geburtsdatumJuengsterFahrer) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $geburtsdatumJuengsterFahrer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($geburtsdatumJuengsterFahrer, true)), __LINE__);
        }
        $this->GeburtsdatumJuengsterFahrer = $geburtsdatumJuengsterFahrer;
        return $this;
    }
}
