<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Ereignis StructType
 * Meta information extracted from the WSDL
 * - documentation: Ereignis, das einem oder mehreren Schäden vorausgeht.
 * @subpackage Structs
 */
class CT_Ereignis extends CT_Objekt
{
    /**
     * The Schadendatum
     * Meta information extracted from the WSDL
     * - documentation: Datum mit optionaler Zeitangabe des Schadenereignisses. Das Schadendatum MUSS immer ein korrektes Datum sein. Dieses Datum DARF fiktiv sein, falls das Schadendatum (noch) nicht bekannt ist. In diesem Fall MUSS das Attribut
     * FiktivesSchadendatum = JA sein.Bei Rechtsschutz: z.B. Datum der Antragstellung, Rechtslageänderung, Ordnungswidrigkeit, Tat, des Versicherungsfalls, angefochtenen Bescheids, schädigenden Ereignisses.Alternativ DARF ein Schadenzeitraum angegeben
     * werden.Es MUSS mindestens ein Datum übermittelt werden. Wird eine Zeitangabe übermittelt, MUSS diese mit Stunden und Minuten angegeben werden. Eine Zeitzone DARF übermittelt werden. Fehlt die Zeitzone, MUSS die am angegebenen Datum in Deutschland
     * gültige Zeitzone angenommen werden. | Datentyp zur Angabe eines Zeitpunkts mit beliebiger Genauigkeit und optionaler Zeitzone. Vollständig ausgeprägt entspricht die Darstellung ISO 8601 und dem W3C TimeStamp.Diesen Datentyp nutzende Attribute
     * MÜSSEN in ihrer Dokumentation die gewünschte Genauigkeit und die Optionalität der Zeitzone explizit definieren.Angaben zur Zeitzone MÜSSEN wie folgt interpretiert werden:Z = Zeitzone entspricht UTC.+05:00 = Zeitzone entspricht UTC +5
     * Stunden.Gültige Werte sind zum Beispiel:2015-01-192015-01-19T20:152015-01-19T20:15:312015-01-19T20:15:31.3332015-01-19T20:15:31+05:002015-01-19Z2015-01-19+05:002015-01-19T20:15-03:30
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?
     * @var string
     */
    public $Schadendatum;
    /**
     * The Kumulschadennummer
     * Meta information extracted from the WSDL
     * - documentation: Identifikation eines Kumulschadenereignisses (z.B. die Kumulschadennummer des Orkans Kyrill).
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Kumulschadennummer;
    /**
     * The FiktivesSchadendatum
     * Meta information extracted from the WSDL
     * - documentation: JA = Schadendatum ist fiktivNEIN = Schadendatum ist konkretWird das Attribut nicht geliefert, MUSS es als mit Nein belegt interpretiert werden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $FiktivesSchadendatum;
    /**
     * The KenntniserlangungVN
     * Meta information extracted from the WSDL
     * - documentation: Datum mit optionaler Zeitangabe, wann der Versicherungsnehmer oder eine von ihm bevollmächtigte Person Kenntnis von dem Ereignis erlangt hat.Es MUSS mindestens ein Datum übermittelt werden. Wird eine Zeitangabe übermittelt, MUSS
     * diese mit Stunden und Minuten angegeben werden. Eine Zeitzone DARF übermittelt werden. Fehlt die Zeitzone, MUSS die am angegebenen Datum in Deutschland gültige Zeitzone angenommen werden. | Datentyp zur Angabe eines Zeitpunkts mit beliebiger
     * Genauigkeit und optionaler Zeitzone. Vollständig ausgeprägt entspricht die Darstellung ISO 8601 und dem W3C TimeStamp.Diesen Datentyp nutzende Attribute MÜSSEN in ihrer Dokumentation die gewünschte Genauigkeit und die Optionalität der Zeitzone
     * explizit definieren.Angaben zur Zeitzone MÜSSEN wie folgt interpretiert werden:Z = Zeitzone entspricht UTC.+05:00 = Zeitzone entspricht UTC +5 Stunden.Gültige Werte sind zum
     * Beispiel:2015-01-192015-01-19T20:152015-01-19T20:15:312015-01-19T20:15:31.3332015-01-19T20:15:31+05:002015-01-19Z2015-01-19+05:002015-01-19T20:15-03:30
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?
     * @var string
     */
    public $KenntniserlangungVN;
    /**
     * The VNAnwesend
     * Meta information extracted from the WSDL
     * - documentation: JA = VN und/oder bevollmächtigte Personen waren beim Ereignis anwesend.NEIN = VN und/oder bevollmächtigte Personen waren beim Ereignis nicht anwesend.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $VNAnwesend;
    /**
     * The Schadenverursacher
     * Meta information extracted from the WSDL
     * - documentation: Verursacher des Schadenereignisses gemäß GDV-Anlage 147.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Schadenverursacher;
    /**
     * The TaeterPolizeilichErmittelt
     * Meta information extracted from the WSDL
     * - documentation: JA = Der Täter für das Ereignis wurde polizeilich/staatsanwaltlich ermittelt.NEIN = Der Täter für das Ereignis wurde nicht polizeilich/staatsanwaltlich ermittelt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $TaeterPolizeilichErmittelt;
    /**
     * The PolizeilichGemeldet
     * Meta information extracted from the WSDL
     * - documentation: JA = Das Ereignis wurde polizeilich gemeldet.NEIN = Das Ereignis wurde nicht polizeilich gemeldet.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $PolizeilichGemeldet;
    /**
     * The ZeugenVorhanden
     * Meta information extracted from the WSDL
     * - documentation: JA = Für das Ereignis gibt es Zeugen.NEIN = Für das Ereignis gibt es keine Zeugen.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $ZeugenVorhanden;
    /**
     * The AnzahlZeugen
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der Zeugen für das Ereignis.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlZeugen;
    /**
     * The Personenschaden
     * Meta information extracted from the WSDL
     * - documentation: JA = Das Ereignis verursachte einen Personenschaden.NEIN = Das Ereignis verursachte keinen Personenschaden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Personenschaden;
    /**
     * The AnzahlVerletzteErkranktePersonen
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der Personen, die aufgrund des Ereignisses verletzt wurden oder erkrankt sind.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlVerletzteErkranktePersonen;
    /**
     * The AnzahlVerstorbenePersonen
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der Personen, die aufgrund des Ereignisses verstorben sind.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlVerstorbenePersonen;
    /**
     * The VNVerstorben
     * Meta information extracted from the WSDL
     * - documentation: JA = Der Versicherungsnehmer ist aufgrund des Ereignisses verstorben.NEIN = Der Versicherungsnehmer ist aufgrund des Ereignisses nicht verstorben.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $VNVerstorben;
    /**
     * The SchadenminderungsmassnahmenGetroffen
     * Meta information extracted from the WSDL
     * - documentation: JA = Es wurden Schadenminderungsmaßnahmen getroffen.NEIN = Es wurden keine Schadenminderungsmaßnahmen getroffen.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $SchadenminderungsmassnahmenGetroffen;
    /**
     * The Schadenminderungsmassnahmen
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung, welche Schadenminderungsmassnahmen getroffen wurden oder warum keine getroffen wurden (konnten).
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Schadenminderungsmassnahmen;
    /**
     * The Entdecker
     * Meta information extracted from the WSDL
     * - documentation: Partner, der das Ereignis entdeckt hat.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Entdecker
     */
    public $Entdecker;
    /**
     * The Verursacher
     * Meta information extracted from the WSDL
     * - documentation: Partner, der das Ereignis verursacht hat. Z.B. Kfz-Unfall, Haftpflichtschaden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Verursacher[]
     */
    public $Verursacher;
    /**
     * The Zeuge
     * Meta information extracted from the WSDL
     * - documentation: Partner, der bei dem Ereignis zugegen war und darüber aus eigener Anschauung etwas sagen kann.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeuge[]
     */
    public $Zeuge;
    /**
     * The Schadenzeitraum
     * Meta information extracted from the WSDL
     * - documentation: Zeitraum des Schadenereignisses. Der Zeitraum MUSS durch die Attribute Beginn und Ende spezifiziert werden. Beginn und Ende MÜSSEN mindestens als Datum übermittelt werden. Wird eine Zeitangabe übermittelt, MUSS diese mit Stunden
     * und Minuten angegeben werden. Eine Zeitzone DARF übermittelt werden. Fehlt die Zeitzone, MUSS die am angegebenen Datum in Deutschland gültige Zeitzone angenommen werden. Das Beginndatum DARF fiktiv sein, falls das Datum (noch) nicht bekannt ist. In
     * diesem Fall MUSS das Attribut FiktivesSchadendatum = JA sein.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum2
     */
    public $Schadenzeitraum;
    /**
     * The Schadenhergang
     * Meta information extracted from the WSDL
     * - documentation: Hergang des Schadenereignisses.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Schadenhergang[]
     */
    public $Schadenhergang;
    /**
     * The Schaden
     * Meta information extracted from the WSDL
     * - documentation: Schäden, die durch das Schadenereignis verursacht wurden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Schaden[]
     */
    public $Schaden;
    /**
     * The Schadenanschrift
     * Meta information extracted from the WSDL
     * - documentation: Anschrift des Schadenereignisses
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Schadenanschrift
     */
    public $Schadenanschrift;
    /**
     * The Taeter
     * Meta information extracted from the WSDL
     * - documentation: Partner, der die Tat begangen hat, die zu dem Ereignis geführt hat. Z.B. Diebstahl, Einbruch, Beraubung, Brandstifung.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Taeter[]
     */
    public $Taeter;
    /**
     * The Polizeibericht
     * Meta information extracted from the WSDL
     * - documentation: Polizeibericht zu dem Ereignis.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Polizeibericht[]
     */
    public $Polizeibericht;
    /**
     * Constructor method for CT_Ereignis
     * @uses CT_Ereignis::setSchadendatum()
     * @uses CT_Ereignis::setKumulschadennummer()
     * @uses CT_Ereignis::setFiktivesSchadendatum()
     * @uses CT_Ereignis::setKenntniserlangungVN()
     * @uses CT_Ereignis::setVNAnwesend()
     * @uses CT_Ereignis::setSchadenverursacher()
     * @uses CT_Ereignis::setTaeterPolizeilichErmittelt()
     * @uses CT_Ereignis::setPolizeilichGemeldet()
     * @uses CT_Ereignis::setZeugenVorhanden()
     * @uses CT_Ereignis::setAnzahlZeugen()
     * @uses CT_Ereignis::setPersonenschaden()
     * @uses CT_Ereignis::setAnzahlVerletzteErkranktePersonen()
     * @uses CT_Ereignis::setAnzahlVerstorbenePersonen()
     * @uses CT_Ereignis::setVNVerstorben()
     * @uses CT_Ereignis::setSchadenminderungsmassnahmenGetroffen()
     * @uses CT_Ereignis::setSchadenminderungsmassnahmen()
     * @uses CT_Ereignis::setEntdecker()
     * @uses CT_Ereignis::setVerursacher()
     * @uses CT_Ereignis::setZeuge()
     * @uses CT_Ereignis::setSchadenzeitraum()
     * @uses CT_Ereignis::setSchadenhergang()
     * @uses CT_Ereignis::setSchaden()
     * @uses CT_Ereignis::setSchadenanschrift()
     * @uses CT_Ereignis::setTaeter()
     * @uses CT_Ereignis::setPolizeibericht()
     * @param string $schadendatum
     * @param string $kumulschadennummer
     * @param bool $fiktivesSchadendatum
     * @param string $kenntniserlangungVN
     * @param bool $vNAnwesend
     * @param string $schadenverursacher
     * @param bool $taeterPolizeilichErmittelt
     * @param bool $polizeilichGemeldet
     * @param bool $zeugenVorhanden
     * @param int $anzahlZeugen
     * @param bool $personenschaden
     * @param int $anzahlVerletzteErkranktePersonen
     * @param int $anzahlVerstorbenePersonen
     * @param bool $vNVerstorben
     * @param bool $schadenminderungsmassnahmenGetroffen
     * @param string $schadenminderungsmassnahmen
     * @param \BiPRO\StructType\CT_Entdecker $entdecker
     * @param \BiPRO\StructType\CT_Verursacher[] $verursacher
     * @param \BiPRO\StructType\CT_Zeuge[] $zeuge
     * @param \BiPRO\StructType\CT_Zeitraum2 $schadenzeitraum
     * @param \BiPRO\StructType\CT_Schadenhergang[] $schadenhergang
     * @param \BiPRO\StructType\CT_Schaden[] $schaden
     * @param \BiPRO\StructType\CT_Schadenanschrift $schadenanschrift
     * @param \BiPRO\StructType\CT_Taeter[] $taeter
     * @param \BiPRO\StructType\CT_Polizeibericht[] $polizeibericht
     */
    public function __construct($schadendatum = null, $kumulschadennummer = null, $fiktivesSchadendatum = null, $kenntniserlangungVN = null, $vNAnwesend = null, $schadenverursacher = null, $taeterPolizeilichErmittelt = null, $polizeilichGemeldet = null, $zeugenVorhanden = null, $anzahlZeugen = null, $personenschaden = null, $anzahlVerletzteErkranktePersonen = null, $anzahlVerstorbenePersonen = null, $vNVerstorben = null, $schadenminderungsmassnahmenGetroffen = null, $schadenminderungsmassnahmen = null, \BiPRO\StructType\CT_Entdecker $entdecker = null, array $verursacher = array(), array $zeuge = array(), \BiPRO\StructType\CT_Zeitraum2 $schadenzeitraum = null, array $schadenhergang = array(), array $schaden = array(), \BiPRO\StructType\CT_Schadenanschrift $schadenanschrift = null, array $taeter = array(), array $polizeibericht = array())
    {
        $this
            ->setSchadendatum($schadendatum)
            ->setKumulschadennummer($kumulschadennummer)
            ->setFiktivesSchadendatum($fiktivesSchadendatum)
            ->setKenntniserlangungVN($kenntniserlangungVN)
            ->setVNAnwesend($vNAnwesend)
            ->setSchadenverursacher($schadenverursacher)
            ->setTaeterPolizeilichErmittelt($taeterPolizeilichErmittelt)
            ->setPolizeilichGemeldet($polizeilichGemeldet)
            ->setZeugenVorhanden($zeugenVorhanden)
            ->setAnzahlZeugen($anzahlZeugen)
            ->setPersonenschaden($personenschaden)
            ->setAnzahlVerletzteErkranktePersonen($anzahlVerletzteErkranktePersonen)
            ->setAnzahlVerstorbenePersonen($anzahlVerstorbenePersonen)
            ->setVNVerstorben($vNVerstorben)
            ->setSchadenminderungsmassnahmenGetroffen($schadenminderungsmassnahmenGetroffen)
            ->setSchadenminderungsmassnahmen($schadenminderungsmassnahmen)
            ->setEntdecker($entdecker)
            ->setVerursacher($verursacher)
            ->setZeuge($zeuge)
            ->setSchadenzeitraum($schadenzeitraum)
            ->setSchadenhergang($schadenhergang)
            ->setSchaden($schaden)
            ->setSchadenanschrift($schadenanschrift)
            ->setTaeter($taeter)
            ->setPolizeibericht($polizeibericht);
    }
    /**
     * Get Schadendatum value
     * @return string|null
     */
    public function getSchadendatum()
    {
        return $this->Schadendatum;
    }
    /**
     * Set Schadendatum value
     * @param string $schadendatum
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setSchadendatum($schadendatum = null)
    {
        // validation for constraint: string
        if (!is_null($schadendatum) && !is_string($schadendatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schadendatum, true), gettype($schadendatum)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?)
        if (!is_null($schadendatum) && !preg_match('/[0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?/', $schadendatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?', var_export($schadendatum, true)), __LINE__);
        }
        $this->Schadendatum = $schadendatum;
        return $this;
    }
    /**
     * Get Kumulschadennummer value
     * @return string|null
     */
    public function getKumulschadennummer()
    {
        return $this->Kumulschadennummer;
    }
    /**
     * Set Kumulschadennummer value
     * @param string $kumulschadennummer
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setKumulschadennummer($kumulschadennummer = null)
    {
        // validation for constraint: string
        if (!is_null($kumulschadennummer) && !is_string($kumulschadennummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kumulschadennummer, true), gettype($kumulschadennummer)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($kumulschadennummer) && mb_strlen($kumulschadennummer) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($kumulschadennummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($kumulschadennummer) && mb_strlen($kumulschadennummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($kumulschadennummer)), __LINE__);
        }
        $this->Kumulschadennummer = $kumulschadennummer;
        return $this;
    }
    /**
     * Get FiktivesSchadendatum value
     * @return bool|null
     */
    public function getFiktivesSchadendatum()
    {
        return $this->FiktivesSchadendatum;
    }
    /**
     * Set FiktivesSchadendatum value
     * @param bool $fiktivesSchadendatum
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setFiktivesSchadendatum($fiktivesSchadendatum = null)
    {
        // validation for constraint: boolean
        if (!is_null($fiktivesSchadendatum) && !is_bool($fiktivesSchadendatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fiktivesSchadendatum, true), gettype($fiktivesSchadendatum)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($fiktivesSchadendatum) && !preg_match('/true|false/', $fiktivesSchadendatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($fiktivesSchadendatum, true)), __LINE__);
        }
        $this->FiktivesSchadendatum = $fiktivesSchadendatum;
        return $this;
    }
    /**
     * Get KenntniserlangungVN value
     * @return string|null
     */
    public function getKenntniserlangungVN()
    {
        return $this->KenntniserlangungVN;
    }
    /**
     * Set KenntniserlangungVN value
     * @param string $kenntniserlangungVN
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setKenntniserlangungVN($kenntniserlangungVN = null)
    {
        // validation for constraint: string
        if (!is_null($kenntniserlangungVN) && !is_string($kenntniserlangungVN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kenntniserlangungVN, true), gettype($kenntniserlangungVN)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?)
        if (!is_null($kenntniserlangungVN) && !preg_match('/[0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?/', $kenntniserlangungVN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?', var_export($kenntniserlangungVN, true)), __LINE__);
        }
        $this->KenntniserlangungVN = $kenntniserlangungVN;
        return $this;
    }
    /**
     * Get VNAnwesend value
     * @return bool|null
     */
    public function getVNAnwesend()
    {
        return $this->VNAnwesend;
    }
    /**
     * Set VNAnwesend value
     * @param bool $vNAnwesend
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setVNAnwesend($vNAnwesend = null)
    {
        // validation for constraint: boolean
        if (!is_null($vNAnwesend) && !is_bool($vNAnwesend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vNAnwesend, true), gettype($vNAnwesend)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($vNAnwesend) && !preg_match('/true|false/', $vNAnwesend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($vNAnwesend, true)), __LINE__);
        }
        $this->VNAnwesend = $vNAnwesend;
        return $this;
    }
    /**
     * Get Schadenverursacher value
     * @return string|null
     */
    public function getSchadenverursacher()
    {
        return $this->Schadenverursacher;
    }
    /**
     * Set Schadenverursacher value
     * @uses \BiPRO\EnumType\ST_Schadenverursacher::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Schadenverursacher::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $schadenverursacher
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setSchadenverursacher($schadenverursacher = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Schadenverursacher::valueIsValid($schadenverursacher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Schadenverursacher', is_array($schadenverursacher) ? implode(', ', $schadenverursacher) : var_export($schadenverursacher, true), implode(', ', \BiPRO\EnumType\ST_Schadenverursacher::getValidValues())), __LINE__);
        }
        $this->Schadenverursacher = $schadenverursacher;
        return $this;
    }
    /**
     * Get TaeterPolizeilichErmittelt value
     * @return bool|null
     */
    public function getTaeterPolizeilichErmittelt()
    {
        return $this->TaeterPolizeilichErmittelt;
    }
    /**
     * Set TaeterPolizeilichErmittelt value
     * @param bool $taeterPolizeilichErmittelt
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setTaeterPolizeilichErmittelt($taeterPolizeilichErmittelt = null)
    {
        // validation for constraint: boolean
        if (!is_null($taeterPolizeilichErmittelt) && !is_bool($taeterPolizeilichErmittelt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taeterPolizeilichErmittelt, true), gettype($taeterPolizeilichErmittelt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($taeterPolizeilichErmittelt) && !preg_match('/true|false/', $taeterPolizeilichErmittelt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($taeterPolizeilichErmittelt, true)), __LINE__);
        }
        $this->TaeterPolizeilichErmittelt = $taeterPolizeilichErmittelt;
        return $this;
    }
    /**
     * Get PolizeilichGemeldet value
     * @return bool|null
     */
    public function getPolizeilichGemeldet()
    {
        return $this->PolizeilichGemeldet;
    }
    /**
     * Set PolizeilichGemeldet value
     * @param bool $polizeilichGemeldet
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setPolizeilichGemeldet($polizeilichGemeldet = null)
    {
        // validation for constraint: boolean
        if (!is_null($polizeilichGemeldet) && !is_bool($polizeilichGemeldet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($polizeilichGemeldet, true), gettype($polizeilichGemeldet)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($polizeilichGemeldet) && !preg_match('/true|false/', $polizeilichGemeldet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($polizeilichGemeldet, true)), __LINE__);
        }
        $this->PolizeilichGemeldet = $polizeilichGemeldet;
        return $this;
    }
    /**
     * Get ZeugenVorhanden value
     * @return bool|null
     */
    public function getZeugenVorhanden()
    {
        return $this->ZeugenVorhanden;
    }
    /**
     * Set ZeugenVorhanden value
     * @param bool $zeugenVorhanden
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setZeugenVorhanden($zeugenVorhanden = null)
    {
        // validation for constraint: boolean
        if (!is_null($zeugenVorhanden) && !is_bool($zeugenVorhanden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($zeugenVorhanden, true), gettype($zeugenVorhanden)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($zeugenVorhanden) && !preg_match('/true|false/', $zeugenVorhanden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($zeugenVorhanden, true)), __LINE__);
        }
        $this->ZeugenVorhanden = $zeugenVorhanden;
        return $this;
    }
    /**
     * Get AnzahlZeugen value
     * @return int|null
     */
    public function getAnzahlZeugen()
    {
        return $this->AnzahlZeugen;
    }
    /**
     * Set AnzahlZeugen value
     * @param int $anzahlZeugen
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setAnzahlZeugen($anzahlZeugen = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlZeugen) && !(is_int($anzahlZeugen) || ctype_digit($anzahlZeugen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlZeugen, true), gettype($anzahlZeugen)), __LINE__);
        }
        $this->AnzahlZeugen = $anzahlZeugen;
        return $this;
    }
    /**
     * Get Personenschaden value
     * @return bool|null
     */
    public function getPersonenschaden()
    {
        return $this->Personenschaden;
    }
    /**
     * Set Personenschaden value
     * @param bool $personenschaden
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setPersonenschaden($personenschaden = null)
    {
        // validation for constraint: boolean
        if (!is_null($personenschaden) && !is_bool($personenschaden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($personenschaden, true), gettype($personenschaden)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($personenschaden) && !preg_match('/true|false/', $personenschaden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($personenschaden, true)), __LINE__);
        }
        $this->Personenschaden = $personenschaden;
        return $this;
    }
    /**
     * Get AnzahlVerletzteErkranktePersonen value
     * @return int|null
     */
    public function getAnzahlVerletzteErkranktePersonen()
    {
        return $this->AnzahlVerletzteErkranktePersonen;
    }
    /**
     * Set AnzahlVerletzteErkranktePersonen value
     * @param int $anzahlVerletzteErkranktePersonen
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setAnzahlVerletzteErkranktePersonen($anzahlVerletzteErkranktePersonen = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlVerletzteErkranktePersonen) && !(is_int($anzahlVerletzteErkranktePersonen) || ctype_digit($anzahlVerletzteErkranktePersonen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlVerletzteErkranktePersonen, true), gettype($anzahlVerletzteErkranktePersonen)), __LINE__);
        }
        $this->AnzahlVerletzteErkranktePersonen = $anzahlVerletzteErkranktePersonen;
        return $this;
    }
    /**
     * Get AnzahlVerstorbenePersonen value
     * @return int|null
     */
    public function getAnzahlVerstorbenePersonen()
    {
        return $this->AnzahlVerstorbenePersonen;
    }
    /**
     * Set AnzahlVerstorbenePersonen value
     * @param int $anzahlVerstorbenePersonen
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setAnzahlVerstorbenePersonen($anzahlVerstorbenePersonen = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlVerstorbenePersonen) && !(is_int($anzahlVerstorbenePersonen) || ctype_digit($anzahlVerstorbenePersonen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlVerstorbenePersonen, true), gettype($anzahlVerstorbenePersonen)), __LINE__);
        }
        $this->AnzahlVerstorbenePersonen = $anzahlVerstorbenePersonen;
        return $this;
    }
    /**
     * Get VNVerstorben value
     * @return bool|null
     */
    public function getVNVerstorben()
    {
        return $this->VNVerstorben;
    }
    /**
     * Set VNVerstorben value
     * @param bool $vNVerstorben
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setVNVerstorben($vNVerstorben = null)
    {
        // validation for constraint: boolean
        if (!is_null($vNVerstorben) && !is_bool($vNVerstorben)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vNVerstorben, true), gettype($vNVerstorben)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($vNVerstorben) && !preg_match('/true|false/', $vNVerstorben)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($vNVerstorben, true)), __LINE__);
        }
        $this->VNVerstorben = $vNVerstorben;
        return $this;
    }
    /**
     * Get SchadenminderungsmassnahmenGetroffen value
     * @return bool|null
     */
    public function getSchadenminderungsmassnahmenGetroffen()
    {
        return $this->SchadenminderungsmassnahmenGetroffen;
    }
    /**
     * Set SchadenminderungsmassnahmenGetroffen value
     * @param bool $schadenminderungsmassnahmenGetroffen
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setSchadenminderungsmassnahmenGetroffen($schadenminderungsmassnahmenGetroffen = null)
    {
        // validation for constraint: boolean
        if (!is_null($schadenminderungsmassnahmenGetroffen) && !is_bool($schadenminderungsmassnahmenGetroffen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($schadenminderungsmassnahmenGetroffen, true), gettype($schadenminderungsmassnahmenGetroffen)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($schadenminderungsmassnahmenGetroffen) && !preg_match('/true|false/', $schadenminderungsmassnahmenGetroffen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($schadenminderungsmassnahmenGetroffen, true)), __LINE__);
        }
        $this->SchadenminderungsmassnahmenGetroffen = $schadenminderungsmassnahmenGetroffen;
        return $this;
    }
    /**
     * Get Schadenminderungsmassnahmen value
     * @return string|null
     */
    public function getSchadenminderungsmassnahmen()
    {
        return $this->Schadenminderungsmassnahmen;
    }
    /**
     * Set Schadenminderungsmassnahmen value
     * @param string $schadenminderungsmassnahmen
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setSchadenminderungsmassnahmen($schadenminderungsmassnahmen = null)
    {
        // validation for constraint: string
        if (!is_null($schadenminderungsmassnahmen) && !is_string($schadenminderungsmassnahmen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schadenminderungsmassnahmen, true), gettype($schadenminderungsmassnahmen)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($schadenminderungsmassnahmen) && mb_strlen($schadenminderungsmassnahmen) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($schadenminderungsmassnahmen)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($schadenminderungsmassnahmen) && mb_strlen($schadenminderungsmassnahmen) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($schadenminderungsmassnahmen)), __LINE__);
        }
        $this->Schadenminderungsmassnahmen = $schadenminderungsmassnahmen;
        return $this;
    }
    /**
     * Get Entdecker value
     * @return \BiPRO\StructType\CT_Entdecker|null
     */
    public function getEntdecker()
    {
        return $this->Entdecker;
    }
    /**
     * Set Entdecker value
     * @param \BiPRO\StructType\CT_Entdecker $entdecker
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setEntdecker(\BiPRO\StructType\CT_Entdecker $entdecker = null)
    {
        $this->Entdecker = $entdecker;
        return $this;
    }
    /**
     * Get Verursacher value
     * @return \BiPRO\StructType\CT_Verursacher[]|null
     */
    public function getVerursacher()
    {
        return $this->Verursacher;
    }
    /**
     * This method is responsible for validating the values passed to the setVerursacher method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVerursacher method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVerursacherForArrayConstraintsFromSetVerursacher(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_EreignisVerursacherItem) {
            // validation for constraint: itemType
            if (!$cT_EreignisVerursacherItem instanceof \BiPRO\StructType\CT_Verursacher) {
                $invalidValues[] = is_object($cT_EreignisVerursacherItem) ? get_class($cT_EreignisVerursacherItem) : sprintf('%s(%s)', gettype($cT_EreignisVerursacherItem), var_export($cT_EreignisVerursacherItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Verursacher property can only contain items of type \BiPRO\StructType\CT_Verursacher, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Verursacher value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Verursacher[] $verursacher
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setVerursacher(array $verursacher = array())
    {
        // validation for constraint: array
        if ('' !== ($verursacherArrayErrorMessage = self::validateVerursacherForArrayConstraintsFromSetVerursacher($verursacher))) {
            throw new \InvalidArgumentException($verursacherArrayErrorMessage, __LINE__);
        }
        $this->Verursacher = $verursacher;
        return $this;
    }
    /**
     * Add item to Verursacher value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Verursacher $item
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function addToVerursacher(\BiPRO\StructType\CT_Verursacher $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Verursacher) {
            throw new \InvalidArgumentException(sprintf('The Verursacher property can only contain items of type \BiPRO\StructType\CT_Verursacher, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Verursacher[] = $item;
        return $this;
    }
    /**
     * Get Zeuge value
     * @return \BiPRO\StructType\CT_Zeuge[]|null
     */
    public function getZeuge()
    {
        return $this->Zeuge;
    }
    /**
     * This method is responsible for validating the values passed to the setZeuge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZeuge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZeugeForArrayConstraintsFromSetZeuge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_EreignisZeugeItem) {
            // validation for constraint: itemType
            if (!$cT_EreignisZeugeItem instanceof \BiPRO\StructType\CT_Zeuge) {
                $invalidValues[] = is_object($cT_EreignisZeugeItem) ? get_class($cT_EreignisZeugeItem) : sprintf('%s(%s)', gettype($cT_EreignisZeugeItem), var_export($cT_EreignisZeugeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Zeuge property can only contain items of type \BiPRO\StructType\CT_Zeuge, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Zeuge value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Zeuge[] $zeuge
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setZeuge(array $zeuge = array())
    {
        // validation for constraint: array
        if ('' !== ($zeugeArrayErrorMessage = self::validateZeugeForArrayConstraintsFromSetZeuge($zeuge))) {
            throw new \InvalidArgumentException($zeugeArrayErrorMessage, __LINE__);
        }
        $this->Zeuge = $zeuge;
        return $this;
    }
    /**
     * Add item to Zeuge value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Zeuge $item
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function addToZeuge(\BiPRO\StructType\CT_Zeuge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Zeuge) {
            throw new \InvalidArgumentException(sprintf('The Zeuge property can only contain items of type \BiPRO\StructType\CT_Zeuge, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Zeuge[] = $item;
        return $this;
    }
    /**
     * Get Schadenzeitraum value
     * @return \BiPRO\StructType\CT_Zeitraum2|null
     */
    public function getSchadenzeitraum()
    {
        return $this->Schadenzeitraum;
    }
    /**
     * Set Schadenzeitraum value
     * @param \BiPRO\StructType\CT_Zeitraum2 $schadenzeitraum
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setSchadenzeitraum(\BiPRO\StructType\CT_Zeitraum2 $schadenzeitraum = null)
    {
        $this->Schadenzeitraum = $schadenzeitraum;
        return $this;
    }
    /**
     * Get Schadenhergang value
     * @return \BiPRO\StructType\CT_Schadenhergang[]|null
     */
    public function getSchadenhergang()
    {
        return $this->Schadenhergang;
    }
    /**
     * This method is responsible for validating the values passed to the setSchadenhergang method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSchadenhergang method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSchadenhergangForArrayConstraintsFromSetSchadenhergang(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_EreignisSchadenhergangItem) {
            // validation for constraint: itemType
            if (!$cT_EreignisSchadenhergangItem instanceof \BiPRO\StructType\CT_Schadenhergang) {
                $invalidValues[] = is_object($cT_EreignisSchadenhergangItem) ? get_class($cT_EreignisSchadenhergangItem) : sprintf('%s(%s)', gettype($cT_EreignisSchadenhergangItem), var_export($cT_EreignisSchadenhergangItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Schadenhergang property can only contain items of type \BiPRO\StructType\CT_Schadenhergang, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Schadenhergang value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Schadenhergang[] $schadenhergang
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setSchadenhergang(array $schadenhergang = array())
    {
        // validation for constraint: array
        if ('' !== ($schadenhergangArrayErrorMessage = self::validateSchadenhergangForArrayConstraintsFromSetSchadenhergang($schadenhergang))) {
            throw new \InvalidArgumentException($schadenhergangArrayErrorMessage, __LINE__);
        }
        $this->Schadenhergang = $schadenhergang;
        return $this;
    }
    /**
     * Add item to Schadenhergang value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Schadenhergang $item
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function addToSchadenhergang(\BiPRO\StructType\CT_Schadenhergang $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Schadenhergang) {
            throw new \InvalidArgumentException(sprintf('The Schadenhergang property can only contain items of type \BiPRO\StructType\CT_Schadenhergang, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Schadenhergang[] = $item;
        return $this;
    }
    /**
     * Get Schaden value
     * @return \BiPRO\StructType\CT_Schaden[]|null
     */
    public function getSchaden()
    {
        return $this->Schaden;
    }
    /**
     * This method is responsible for validating the values passed to the setSchaden method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSchaden method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSchadenForArrayConstraintsFromSetSchaden(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_EreignisSchadenItem) {
            // validation for constraint: itemType
            if (!$cT_EreignisSchadenItem instanceof \BiPRO\StructType\CT_Schaden) {
                $invalidValues[] = is_object($cT_EreignisSchadenItem) ? get_class($cT_EreignisSchadenItem) : sprintf('%s(%s)', gettype($cT_EreignisSchadenItem), var_export($cT_EreignisSchadenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Schaden property can only contain items of type \BiPRO\StructType\CT_Schaden, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Schaden value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Schaden[] $schaden
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setSchaden(array $schaden = array())
    {
        // validation for constraint: array
        if ('' !== ($schadenArrayErrorMessage = self::validateSchadenForArrayConstraintsFromSetSchaden($schaden))) {
            throw new \InvalidArgumentException($schadenArrayErrorMessage, __LINE__);
        }
        $this->Schaden = $schaden;
        return $this;
    }
    /**
     * Add item to Schaden value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Schaden $item
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function addToSchaden(\BiPRO\StructType\CT_Schaden $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Schaden) {
            throw new \InvalidArgumentException(sprintf('The Schaden property can only contain items of type \BiPRO\StructType\CT_Schaden, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Schaden[] = $item;
        return $this;
    }
    /**
     * Get Schadenanschrift value
     * @return \BiPRO\StructType\CT_Schadenanschrift|null
     */
    public function getSchadenanschrift()
    {
        return $this->Schadenanschrift;
    }
    /**
     * Set Schadenanschrift value
     * @param \BiPRO\StructType\CT_Schadenanschrift $schadenanschrift
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setSchadenanschrift(\BiPRO\StructType\CT_Schadenanschrift $schadenanschrift = null)
    {
        $this->Schadenanschrift = $schadenanschrift;
        return $this;
    }
    /**
     * Get Taeter value
     * @return \BiPRO\StructType\CT_Taeter[]|null
     */
    public function getTaeter()
    {
        return $this->Taeter;
    }
    /**
     * This method is responsible for validating the values passed to the setTaeter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaeter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaeterForArrayConstraintsFromSetTaeter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_EreignisTaeterItem) {
            // validation for constraint: itemType
            if (!$cT_EreignisTaeterItem instanceof \BiPRO\StructType\CT_Taeter) {
                $invalidValues[] = is_object($cT_EreignisTaeterItem) ? get_class($cT_EreignisTaeterItem) : sprintf('%s(%s)', gettype($cT_EreignisTaeterItem), var_export($cT_EreignisTaeterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Taeter property can only contain items of type \BiPRO\StructType\CT_Taeter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Taeter value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Taeter[] $taeter
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setTaeter(array $taeter = array())
    {
        // validation for constraint: array
        if ('' !== ($taeterArrayErrorMessage = self::validateTaeterForArrayConstraintsFromSetTaeter($taeter))) {
            throw new \InvalidArgumentException($taeterArrayErrorMessage, __LINE__);
        }
        $this->Taeter = $taeter;
        return $this;
    }
    /**
     * Add item to Taeter value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Taeter $item
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function addToTaeter(\BiPRO\StructType\CT_Taeter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Taeter) {
            throw new \InvalidArgumentException(sprintf('The Taeter property can only contain items of type \BiPRO\StructType\CT_Taeter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Taeter[] = $item;
        return $this;
    }
    /**
     * Get Polizeibericht value
     * @return \BiPRO\StructType\CT_Polizeibericht[]|null
     */
    public function getPolizeibericht()
    {
        return $this->Polizeibericht;
    }
    /**
     * This method is responsible for validating the values passed to the setPolizeibericht method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolizeibericht method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePolizeiberichtForArrayConstraintsFromSetPolizeibericht(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_EreignisPolizeiberichtItem) {
            // validation for constraint: itemType
            if (!$cT_EreignisPolizeiberichtItem instanceof \BiPRO\StructType\CT_Polizeibericht) {
                $invalidValues[] = is_object($cT_EreignisPolizeiberichtItem) ? get_class($cT_EreignisPolizeiberichtItem) : sprintf('%s(%s)', gettype($cT_EreignisPolizeiberichtItem), var_export($cT_EreignisPolizeiberichtItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Polizeibericht property can only contain items of type \BiPRO\StructType\CT_Polizeibericht, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Polizeibericht value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Polizeibericht[] $polizeibericht
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function setPolizeibericht(array $polizeibericht = array())
    {
        // validation for constraint: array
        if ('' !== ($polizeiberichtArrayErrorMessage = self::validatePolizeiberichtForArrayConstraintsFromSetPolizeibericht($polizeibericht))) {
            throw new \InvalidArgumentException($polizeiberichtArrayErrorMessage, __LINE__);
        }
        $this->Polizeibericht = $polizeibericht;
        return $this;
    }
    /**
     * Add item to Polizeibericht value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Polizeibericht $item
     * @return \BiPRO\StructType\CT_Ereignis
     */
    public function addToPolizeibericht(\BiPRO\StructType\CT_Polizeibericht $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Polizeibericht) {
            throw new \InvalidArgumentException(sprintf('The Polizeibericht property can only contain items of type \BiPRO\StructType\CT_Polizeibericht, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Polizeibericht[] = $item;
        return $this;
    }
}
