<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Element StructType
 * Meta information extracted from the WSDL
 * - documentation: Fragenkomplexe bestehen aus Elementen. Es gibt verschiedene Arten von Elementen, die sich in ihren Eigenschaften unterscheiden. Daher ist diese Klasse abstrakt modelliert. Die tatsächlich möglichen Arten von Elementen ergeben sich
 * aus den abgeleiteten Klassen. Erläuterung siehe dort.
 * @subpackage Structs
 */
abstract class CT_Element extends CT_Objekt
{
    /**
     * The Ordnungsnummer
     * Meta information extracted from the WSDL
     * - documentation: Bestimmt die Reihenfolge der Elemente innerhalb eines Fragenkomplexes. Die Elemente werden nach aufsteigender Sortierung angeordnet. Eine lückenlose Nummerierung ist NICHT erforderlich. Z.B. führt die Ordnungsnummerfolge 1, 2, 4
     * zur gleichen Anzeigereihenfolge wie die Ordnungsnummernfolge 5, 67, 144
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Ordnungsnummer;
    /**
     * The Anzeigenummer
     * Meta information extracted from the WSDL
     * - documentation: Text mit der Anzeigenummer der Frage oder Überschrift innherhalb eine Gruppe von Elementen.z.B. "3." oder "b)"
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Anzeigenummer;
    /**
     * Constructor method for CT_Element
     * @uses CT_Element::setOrdnungsnummer()
     * @uses CT_Element::setAnzeigenummer()
     * @param int $ordnungsnummer
     * @param string $anzeigenummer
     */
    public function __construct($ordnungsnummer = null, $anzeigenummer = null)
    {
        $this
            ->setOrdnungsnummer($ordnungsnummer)
            ->setAnzeigenummer($anzeigenummer);
    }
    /**
     * Get Ordnungsnummer value
     * @return int|null
     */
    public function getOrdnungsnummer()
    {
        return $this->Ordnungsnummer;
    }
    /**
     * Set Ordnungsnummer value
     * @param int $ordnungsnummer
     * @return \BiPRO\StructType\CT_Element
     */
    public function setOrdnungsnummer($ordnungsnummer = null)
    {
        // validation for constraint: int
        if (!is_null($ordnungsnummer) && !(is_int($ordnungsnummer) || ctype_digit($ordnungsnummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordnungsnummer, true), gettype($ordnungsnummer)), __LINE__);
        }
        $this->Ordnungsnummer = $ordnungsnummer;
        return $this;
    }
    /**
     * Get Anzeigenummer value
     * @return string|null
     */
    public function getAnzeigenummer()
    {
        return $this->Anzeigenummer;
    }
    /**
     * Set Anzeigenummer value
     * @param string $anzeigenummer
     * @return \BiPRO\StructType\CT_Element
     */
    public function setAnzeigenummer($anzeigenummer = null)
    {
        // validation for constraint: string
        if (!is_null($anzeigenummer) && !is_string($anzeigenummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anzeigenummer, true), gettype($anzeigenummer)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($anzeigenummer) && mb_strlen($anzeigenummer) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($anzeigenummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($anzeigenummer) && mb_strlen($anzeigenummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($anzeigenummer)), __LINE__);
        }
        $this->Anzeigenummer = $anzeigenummer;
        return $this;
    }
}
