<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Einkommenssteuer StructType
 * Meta information extracted from the WSDL
 * - documentation: Angaben zur Einkommenssteuer.Das Attribut Veranlagung (ST_Veranlagung) fehlt, da der entsprechende einfache Datentyp nicht definiert ist.
 * @subpackage Structs
 */
class CT_Einkommenssteuer extends CT_Objekt
{
    /**
     * The Grenzsteuersatz
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Grenzsteuersatz;
    /**
     * The Freibetrag
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Freibetrag;
    /**
     * The Kirchensteuer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Kirchensteuer
     */
    public $Kirchensteuer;
    /**
     * Constructor method for CT_Einkommenssteuer
     * @uses CT_Einkommenssteuer::setGrenzsteuersatz()
     * @uses CT_Einkommenssteuer::setFreibetrag()
     * @uses CT_Einkommenssteuer::setKirchensteuer()
     * @param float $grenzsteuersatz
     * @param float $freibetrag
     * @param \BiPRO\StructType\CT_Kirchensteuer $kirchensteuer
     */
    public function __construct($grenzsteuersatz = null, $freibetrag = null, \BiPRO\StructType\CT_Kirchensteuer $kirchensteuer = null)
    {
        $this
            ->setGrenzsteuersatz($grenzsteuersatz)
            ->setFreibetrag($freibetrag)
            ->setKirchensteuer($kirchensteuer);
    }
    /**
     * Get Grenzsteuersatz value
     * @return float|null
     */
    public function getGrenzsteuersatz()
    {
        return $this->Grenzsteuersatz;
    }
    /**
     * Set Grenzsteuersatz value
     * @param float $grenzsteuersatz
     * @return \BiPRO\StructType\CT_Einkommenssteuer
     */
    public function setGrenzsteuersatz($grenzsteuersatz = null)
    {
        // validation for constraint: float
        if (!is_null($grenzsteuersatz) && !(is_float($grenzsteuersatz) || is_numeric($grenzsteuersatz))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grenzsteuersatz, true), gettype($grenzsteuersatz)), __LINE__);
        }
        $this->Grenzsteuersatz = $grenzsteuersatz;
        return $this;
    }
    /**
     * Get Freibetrag value
     * @return float|null
     */
    public function getFreibetrag()
    {
        return $this->Freibetrag;
    }
    /**
     * Set Freibetrag value
     * @param float $freibetrag
     * @return \BiPRO\StructType\CT_Einkommenssteuer
     */
    public function setFreibetrag($freibetrag = null)
    {
        // validation for constraint: float
        if (!is_null($freibetrag) && !(is_float($freibetrag) || is_numeric($freibetrag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($freibetrag, true), gettype($freibetrag)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($freibetrag) && mb_strlen(mb_substr($freibetrag, false !== mb_strpos($freibetrag, '.') ? mb_strpos($freibetrag, '.') + 1 : mb_strlen($freibetrag))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($freibetrag, true), mb_strlen(mb_substr($freibetrag, mb_strpos($freibetrag, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($freibetrag) && mb_strlen(preg_replace('/(\D)/', '', $freibetrag)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($freibetrag, true), mb_strlen(preg_replace('/(\D)/', '', $freibetrag))), __LINE__);
        }
        $this->Freibetrag = $freibetrag;
        return $this;
    }
    /**
     * Get Kirchensteuer value
     * @return \BiPRO\StructType\CT_Kirchensteuer|null
     */
    public function getKirchensteuer()
    {
        return $this->Kirchensteuer;
    }
    /**
     * Set Kirchensteuer value
     * @param \BiPRO\StructType\CT_Kirchensteuer $kirchensteuer
     * @return \BiPRO\StructType\CT_Einkommenssteuer
     */
    public function setKirchensteuer(\BiPRO\StructType\CT_Kirchensteuer $kirchensteuer = null)
    {
        $this->Kirchensteuer = $kirchensteuer;
        return $this;
    }
}
