<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Einkommensart StructType
 * Meta information extracted from the WSDL
 * - documentation: Art des Einkommens.
 * @subpackage Structs
 */
class CT_Einkommensart extends CT_Objekt
{
    /**
     * The AnzahlGehaelterProJahr
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $AnzahlGehaelterProJahr;
    /**
     * The Einkommensart
     * Meta information extracted from the WSDL
     * - documentation: Art des EInkommens. Zu unterscheiden sind hierbei das allgemeine Einkommen (= Gesamteinkommen) und berufsbezogenes Einkommen (Unterscheidung selbstständige und angestellter Tätigkeit), wie es z.B. in der Rechtsschutzverischerung
     * benötigt wird.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Einkommensart;
    /**
     * The VermoegenswirksameLeistung
     * Meta information extracted from the WSDL
     * - documentation: Anteile des Arbeitgebers und Arbeitnehmers an einem Beitrag, der zu einem Produkt mit vermögenswirksamer Leistung gezahlt wird.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_VermoegenswirksameLeistung
     */
    public $VermoegenswirksameLeistung;
    /**
     * The Einkommen
     * Meta information extracted from the WSDL
     * - documentation: Konkrete Einkommen dieser Einkommensart.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Einkommen[]
     */
    public $Einkommen;
    /**
     * Constructor method for CT_Einkommensart
     * @uses CT_Einkommensart::setAnzahlGehaelterProJahr()
     * @uses CT_Einkommensart::setEinkommensart()
     * @uses CT_Einkommensart::setVermoegenswirksameLeistung()
     * @uses CT_Einkommensart::setEinkommen()
     * @param float $anzahlGehaelterProJahr
     * @param string $einkommensart
     * @param \BiPRO\StructType\CT_VermoegenswirksameLeistung $vermoegenswirksameLeistung
     * @param \BiPRO\StructType\CT_Einkommen[] $einkommen
     */
    public function __construct($anzahlGehaelterProJahr = null, $einkommensart = null, \BiPRO\StructType\CT_VermoegenswirksameLeistung $vermoegenswirksameLeistung = null, array $einkommen = array())
    {
        $this
            ->setAnzahlGehaelterProJahr($anzahlGehaelterProJahr)
            ->setEinkommensart($einkommensart)
            ->setVermoegenswirksameLeistung($vermoegenswirksameLeistung)
            ->setEinkommen($einkommen);
    }
    /**
     * Get AnzahlGehaelterProJahr value
     * @return float|null
     */
    public function getAnzahlGehaelterProJahr()
    {
        return $this->AnzahlGehaelterProJahr;
    }
    /**
     * Set AnzahlGehaelterProJahr value
     * @param float $anzahlGehaelterProJahr
     * @return \BiPRO\StructType\CT_Einkommensart
     */
    public function setAnzahlGehaelterProJahr($anzahlGehaelterProJahr = null)
    {
        // validation for constraint: float
        if (!is_null($anzahlGehaelterProJahr) && !(is_float($anzahlGehaelterProJahr) || is_numeric($anzahlGehaelterProJahr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($anzahlGehaelterProJahr, true), gettype($anzahlGehaelterProJahr)), __LINE__);
        }
        $this->AnzahlGehaelterProJahr = $anzahlGehaelterProJahr;
        return $this;
    }
    /**
     * Get Einkommensart value
     * @return string|null
     */
    public function getEinkommensart()
    {
        return $this->Einkommensart;
    }
    /**
     * Set Einkommensart value
     * @uses \BiPRO\EnumType\ST_Einkommensart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Einkommensart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $einkommensart
     * @return \BiPRO\StructType\CT_Einkommensart
     */
    public function setEinkommensart($einkommensart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Einkommensart::valueIsValid($einkommensart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Einkommensart', is_array($einkommensart) ? implode(', ', $einkommensart) : var_export($einkommensart, true), implode(', ', \BiPRO\EnumType\ST_Einkommensart::getValidValues())), __LINE__);
        }
        $this->Einkommensart = $einkommensart;
        return $this;
    }
    /**
     * Get VermoegenswirksameLeistung value
     * @return \BiPRO\StructType\CT_VermoegenswirksameLeistung|null
     */
    public function getVermoegenswirksameLeistung()
    {
        return $this->VermoegenswirksameLeistung;
    }
    /**
     * Set VermoegenswirksameLeistung value
     * @param \BiPRO\StructType\CT_VermoegenswirksameLeistung $vermoegenswirksameLeistung
     * @return \BiPRO\StructType\CT_Einkommensart
     */
    public function setVermoegenswirksameLeistung(\BiPRO\StructType\CT_VermoegenswirksameLeistung $vermoegenswirksameLeistung = null)
    {
        $this->VermoegenswirksameLeistung = $vermoegenswirksameLeistung;
        return $this;
    }
    /**
     * Get Einkommen value
     * @return \BiPRO\StructType\CT_Einkommen[]|null
     */
    public function getEinkommen()
    {
        return $this->Einkommen;
    }
    /**
     * This method is responsible for validating the values passed to the setEinkommen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEinkommen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEinkommenForArrayConstraintsFromSetEinkommen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_EinkommensartEinkommenItem) {
            // validation for constraint: itemType
            if (!$cT_EinkommensartEinkommenItem instanceof \BiPRO\StructType\CT_Einkommen) {
                $invalidValues[] = is_object($cT_EinkommensartEinkommenItem) ? get_class($cT_EinkommensartEinkommenItem) : sprintf('%s(%s)', gettype($cT_EinkommensartEinkommenItem), var_export($cT_EinkommensartEinkommenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Einkommen property can only contain items of type \BiPRO\StructType\CT_Einkommen, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Einkommen value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Einkommen[] $einkommen
     * @return \BiPRO\StructType\CT_Einkommensart
     */
    public function setEinkommen(array $einkommen = array())
    {
        // validation for constraint: array
        if ('' !== ($einkommenArrayErrorMessage = self::validateEinkommenForArrayConstraintsFromSetEinkommen($einkommen))) {
            throw new \InvalidArgumentException($einkommenArrayErrorMessage, __LINE__);
        }
        $this->Einkommen = $einkommen;
        return $this;
    }
    /**
     * Add item to Einkommen value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Einkommen $item
     * @return \BiPRO\StructType\CT_Einkommensart
     */
    public function addToEinkommen(\BiPRO\StructType\CT_Einkommen $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Einkommen) {
            throw new \InvalidArgumentException(sprintf('The Einkommen property can only contain items of type \BiPRO\StructType\CT_Einkommen, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Einkommen[] = $item;
        return $this;
    }
}
