<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Einkommen StructType
 * Meta information extracted from the WSDL
 * - documentation: Information zum konkreten Einkommen der Einkommensart
 * @subpackage Structs
 */
class CT_Einkommen extends CT_Geldwert
{
    /**
     * The Zahlungsweise
     * Meta information extracted from the WSDL
     * - documentation: Die Angabe von Zahlungsweise dient zur Unterscheidung ob es sich z. B. um ein Monats- oder Jahresgehalt handelt (Zahlungsweise = 1 bzw 8)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zahlungsweise;
    /**
     * The Art
     * Meta information extracted from the WSDL
     * - documentation: Art des konkreten Einkommens (Brutto/Netto).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Art;
    /**
     * Constructor method for CT_Einkommen
     * @uses CT_Einkommen::setZahlungsweise()
     * @uses CT_Einkommen::setArt()
     * @param string $zahlungsweise
     * @param string $art
     */
    public function __construct($zahlungsweise = null, $art = null)
    {
        $this
            ->setZahlungsweise($zahlungsweise)
            ->setArt($art);
    }
    /**
     * Get Zahlungsweise value
     * @return string|null
     */
    public function getZahlungsweise()
    {
        return $this->Zahlungsweise;
    }
    /**
     * Set Zahlungsweise value
     * @uses \BiPRO\EnumType\ST_Zahlungsweise::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Zahlungsweise::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zahlungsweise
     * @return \BiPRO\StructType\CT_Einkommen
     */
    public function setZahlungsweise($zahlungsweise = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Zahlungsweise::valueIsValid($zahlungsweise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Zahlungsweise', is_array($zahlungsweise) ? implode(', ', $zahlungsweise) : var_export($zahlungsweise, true), implode(', ', \BiPRO\EnumType\ST_Zahlungsweise::getValidValues())), __LINE__);
        }
        $this->Zahlungsweise = $zahlungsweise;
        return $this;
    }
    /**
     * Get Art value
     * @return string|null
     */
    public function getArt()
    {
        return $this->Art;
    }
    /**
     * Set Art value
     * @uses \BiPRO\EnumType\ST_BruttoNetto::valueIsValid()
     * @uses \BiPRO\EnumType\ST_BruttoNetto::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $art
     * @return \BiPRO\StructType\CT_Einkommen
     */
    public function setArt($art = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_BruttoNetto::valueIsValid($art)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_BruttoNetto', is_array($art) ? implode(', ', $art) : var_export($art, true), implode(', ', \BiPRO\EnumType\ST_BruttoNetto::getValidValues())), __LINE__);
        }
        $this->Art = $art;
        return $this;
    }
}
