<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_EinfacheFrage StructType
 * Meta information extracted from the WSDL
 * - documentation: Eine einfache Frage ist eine direkt zu beantwortende Frage. Es gibt mehrere Arten von einfachen Fragen, daher ist diese Klasse abstrakt modelliert. Die tatsächlich möglichen Arten von einfachen Fragen ergeben sich aus den
 * abgeleiteten Klassen. Erläuterung siehe dort.Wichtig: Jede Art von Fragen erfordert eine eigene Implementierung im Client. Daher darf das Objekt Frage NICHT providerspezifisch erweitert werden. Erweiterungen sind nur im Rahmen eines
 * Spartenspezifischen Datenmodells als Bestandteil der Norm zulässig!Fragen können auch bereits in der getQuestions-Response mit Antwortobjekten ausgeliefert werden. Dadurch kann der Provider Vorbelegungswerte für die Antworten mitliefern, die der
 * Consumer verwenden darf aber nicht muss.
 * @subpackage Structs
 */
abstract class CT_EinfacheFrage extends CT_Frage
{
    /**
     * The TechnischeID
     * Meta information extracted from the WSDL
     * - documentation: In diesem Attribut wird eine innerhalb der Metadaten eindeutige ID angegeben. Diese technische ID wird benötigt, um in der Klasse Abhängigkeit die Frage anzugeben, auf die sich die in der Abhängigkeit auszuwertende Antwort
     * bezieht. Wichtig ist dabei, dass die technische ID für jede Frage innerhalb der BiPRO-Nachricht eindeutig sein MUSS. | Typ fuer alle IDs.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $TechnischeID;
    /**
     * The FachlicheID
     * Meta information extracted from the WSDL
     * - documentation: Mit dieser ID identifiziert der Provider die Semantik der Frage. Es ist KEINE technische ID, die zur Referenzierung innerhalb des Datenmodells verwendet wird, sondern sie dient zur Auswertung der Antworten beim Provider. Sie kann
     * deshalb im Ermessen des Providers auch mehrfach vorkommen. Dies kann z.B. dann sinnvoll sein, wenn der Provider mehrere gleichartige komplexe Fragen liefert, um mehrere Vorerkrankungen abfragen zu können.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FachlicheID;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - documentation: Der Text der Frage, ist vom Consumer wörtlich, ungekürzt und und unverändert im Frontend darzustellen, um die juristisch einwandfreie Beantwortung der Fragen durch den Benutzer sicherzustellen.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The FreitextErlaubt
     * Meta information extracted from the WSDL
     * - documentation: Wenn dieses Attribut mit &bdquo;Ja&ldquo; gesetzt ist, kann die Antwort durch einen untypisierten Freitext ergänzt werden. Bei Übermittlung einer Frage vom Typ FrageText ist dieses Attribut immer &bdquo;true&ldquo;.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $FreitextErlaubt;
    /**
     * Constructor method for CT_EinfacheFrage
     * @uses CT_EinfacheFrage::setTechnischeID()
     * @uses CT_EinfacheFrage::setFachlicheID()
     * @uses CT_EinfacheFrage::setText()
     * @uses CT_EinfacheFrage::setFreitextErlaubt()
     * @param string $technischeID
     * @param string $fachlicheID
     * @param string $text
     * @param bool $freitextErlaubt
     */
    public function __construct($technischeID = null, $fachlicheID = null, $text = null, $freitextErlaubt = null)
    {
        $this
            ->setTechnischeID($technischeID)
            ->setFachlicheID($fachlicheID)
            ->setText($text)
            ->setFreitextErlaubt($freitextErlaubt);
    }
    /**
     * Get TechnischeID value
     * @return string
     */
    public function getTechnischeID()
    {
        return $this->TechnischeID;
    }
    /**
     * Set TechnischeID value
     * @param string $technischeID
     * @return \BiPRO\StructType\CT_EinfacheFrage
     */
    public function setTechnischeID($technischeID = null)
    {
        // validation for constraint: string
        if (!is_null($technischeID) && !is_string($technischeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($technischeID, true), gettype($technischeID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($technischeID) && mb_strlen($technischeID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($technischeID)), __LINE__);
        }
        $this->TechnischeID = $technischeID;
        return $this;
    }
    /**
     * Get FachlicheID value
     * @return string|null
     */
    public function getFachlicheID()
    {
        return $this->FachlicheID;
    }
    /**
     * Set FachlicheID value
     * @param string $fachlicheID
     * @return \BiPRO\StructType\CT_EinfacheFrage
     */
    public function setFachlicheID($fachlicheID = null)
    {
        // validation for constraint: string
        if (!is_null($fachlicheID) && !is_string($fachlicheID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fachlicheID, true), gettype($fachlicheID)), __LINE__);
        }
        $this->FachlicheID = $fachlicheID;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \BiPRO\StructType\CT_EinfacheFrage
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get FreitextErlaubt value
     * @return bool|null
     */
    public function getFreitextErlaubt()
    {
        return $this->FreitextErlaubt;
    }
    /**
     * Set FreitextErlaubt value
     * @param bool $freitextErlaubt
     * @return \BiPRO\StructType\CT_EinfacheFrage
     */
    public function setFreitextErlaubt($freitextErlaubt = null)
    {
        // validation for constraint: boolean
        if (!is_null($freitextErlaubt) && !is_bool($freitextErlaubt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($freitextErlaubt, true), gettype($freitextErlaubt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($freitextErlaubt) && !preg_match('/true|false/', $freitextErlaubt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($freitextErlaubt, true)), __LINE__);
        }
        $this->FreitextErlaubt = $freitextErlaubt;
        return $this;
    }
}
