<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Dynamik StructType
 * Meta information extracted from the WSDL
 * - documentation: Rechtlich vereinbarte Dynamik auf Beitraege oder Leistungen.
 * @subpackage Structs
 */
class CT_Dynamik extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Dynamik
     */
    public $ArtID;
    /**
     * The Frequenz
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Frequenz
     */
    public $Frequenz;
    /**
     * The Wert
     * Meta information extracted from the WSDL
     * - documentation: Hier wird der Prozentanteil ohne Prozentzeichen eingetragen.z.B. 5 = 5% oder 2.5 = 2,5% | Prozentanteil ohne Prozentzeichen z.B. 50 = 50% oder 12,5 = 12,5%
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var float
     */
    public $Wert;
    /**
     * The KategorieID
     * Meta information extracted from the WSDL
     * - documentation: Unterscheidet, ob es sich bei der beschriebenen Dynamik um eine Beitrags- oder Leistungsdynamik handelt. MUSS geliefert werden WENN Dynamik.ArtID nicht "00" ist.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KategorieID;
    /**
     * The Hochrechnung
     * Meta information extracted from the WSDL
     * - documentation: Dynamik fließt nicht in die Beitrags- bzw Leistungsverläufe ein
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Hochrechnung;
    /**
     * The LetzteAnpassung
     * Meta information extracted from the WSDL
     * - documentation: Datum der letzten Dynamik. In der Lebensversicherung: Datum der letzten Dynamik, die nicht abgelehnt wurde. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $LetzteAnpassung;
    /**
     * The DynamikStopp
     * Meta information extracted from the WSDL
     * - documentation: Datum, ab dem keine Dynamikerhöhung mehr stattfindet. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $DynamikStopp;
    /**
     * The NaechsteAnpassung
     * Meta information extracted from the WSDL
     * - documentation: Datum der nächsten Dynamik | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $NaechsteAnpassung;
    /**
     * The VerbleibendeWidersprueche
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der verbleibendenDynamikwidersprüche, ohne das Recht auf Dynamikerhöhung zu verlieren.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $VerbleibendeWidersprueche;
    /**
     * The Zeitraum
     * Meta information extracted from the WSDL
     * - documentation: Zeitraum der Dynamik.Es MÜSSEN konkrete Werte angegeben werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum
     */
    public $Zeitraum;
    /**
     * The Erhoehungsbetrag
     * Meta information extracted from the WSDL
     * - documentation: Gibt den Betrag einer Dynamik mit absolutem Erhöhungsbetrag an.MUSS angegeben werden wenn ArtID = 11.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Geldwert
     */
    public $Erhoehungsbetrag;
    /**
     * Constructor method for CT_Dynamik
     * @uses CT_Dynamik::setArtID()
     * @uses CT_Dynamik::setFrequenz()
     * @uses CT_Dynamik::setWert()
     * @uses CT_Dynamik::setKategorieID()
     * @uses CT_Dynamik::setHochrechnung()
     * @uses CT_Dynamik::setLetzteAnpassung()
     * @uses CT_Dynamik::setDynamikStopp()
     * @uses CT_Dynamik::setNaechsteAnpassung()
     * @uses CT_Dynamik::setVerbleibendeWidersprueche()
     * @uses CT_Dynamik::setZeitraum()
     * @uses CT_Dynamik::setErhoehungsbetrag()
     * @param \BiPRO\StructType\STE_Dynamik $artID
     * @param \BiPRO\StructType\STE_Frequenz $frequenz
     * @param float $wert
     * @param string $kategorieID
     * @param bool $hochrechnung
     * @param string $letzteAnpassung
     * @param string $dynamikStopp
     * @param string $naechsteAnpassung
     * @param int $verbleibendeWidersprueche
     * @param \BiPRO\StructType\CT_Zeitraum $zeitraum
     * @param \BiPRO\StructType\CT_Geldwert $erhoehungsbetrag
     */
    public function __construct(\BiPRO\StructType\STE_Dynamik $artID = null, \BiPRO\StructType\STE_Frequenz $frequenz = null, $wert = null, $kategorieID = null, $hochrechnung = null, $letzteAnpassung = null, $dynamikStopp = null, $naechsteAnpassung = null, $verbleibendeWidersprueche = null, \BiPRO\StructType\CT_Zeitraum $zeitraum = null, \BiPRO\StructType\CT_Geldwert $erhoehungsbetrag = null)
    {
        $this
            ->setArtID($artID)
            ->setFrequenz($frequenz)
            ->setWert($wert)
            ->setKategorieID($kategorieID)
            ->setHochrechnung($hochrechnung)
            ->setLetzteAnpassung($letzteAnpassung)
            ->setDynamikStopp($dynamikStopp)
            ->setNaechsteAnpassung($naechsteAnpassung)
            ->setVerbleibendeWidersprueche($verbleibendeWidersprueche)
            ->setZeitraum($zeitraum)
            ->setErhoehungsbetrag($erhoehungsbetrag);
    }
    /**
     * Get ArtID value
     * @return \BiPRO\StructType\STE_Dynamik|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @param \BiPRO\StructType\STE_Dynamik $artID
     * @return \BiPRO\StructType\CT_Dynamik
     */
    public function setArtID(\BiPRO\StructType\STE_Dynamik $artID = null)
    {
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Frequenz value
     * @return \BiPRO\StructType\STE_Frequenz|null
     */
    public function getFrequenz()
    {
        return $this->Frequenz;
    }
    /**
     * Set Frequenz value
     * @param \BiPRO\StructType\STE_Frequenz $frequenz
     * @return \BiPRO\StructType\CT_Dynamik
     */
    public function setFrequenz(\BiPRO\StructType\STE_Frequenz $frequenz = null)
    {
        $this->Frequenz = $frequenz;
        return $this;
    }
    /**
     * Get Wert value
     * @return float|null
     */
    public function getWert()
    {
        return $this->Wert;
    }
    /**
     * Set Wert value
     * @param float $wert
     * @return \BiPRO\StructType\CT_Dynamik
     */
    public function setWert($wert = null)
    {
        // validation for constraint: float
        if (!is_null($wert) && !(is_float($wert) || is_numeric($wert))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($wert, true), gettype($wert)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($wert) && $wert < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($wert, true)), __LINE__);
        }
        $this->Wert = $wert;
        return $this;
    }
    /**
     * Get KategorieID value
     * @return string|null
     */
    public function getKategorieID()
    {
        return $this->KategorieID;
    }
    /**
     * Set KategorieID value
     * @uses \BiPRO\EnumType\ST_DynamikKategorieID::valueIsValid()
     * @uses \BiPRO\EnumType\ST_DynamikKategorieID::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kategorieID
     * @return \BiPRO\StructType\CT_Dynamik
     */
    public function setKategorieID($kategorieID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_DynamikKategorieID::valueIsValid($kategorieID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_DynamikKategorieID', is_array($kategorieID) ? implode(', ', $kategorieID) : var_export($kategorieID, true), implode(', ', \BiPRO\EnumType\ST_DynamikKategorieID::getValidValues())), __LINE__);
        }
        $this->KategorieID = $kategorieID;
        return $this;
    }
    /**
     * Get Hochrechnung value
     * @return bool|null
     */
    public function getHochrechnung()
    {
        return $this->Hochrechnung;
    }
    /**
     * Set Hochrechnung value
     * @param bool $hochrechnung
     * @return \BiPRO\StructType\CT_Dynamik
     */
    public function setHochrechnung($hochrechnung = null)
    {
        // validation for constraint: boolean
        if (!is_null($hochrechnung) && !is_bool($hochrechnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hochrechnung, true), gettype($hochrechnung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($hochrechnung) && !preg_match('/true|false/', $hochrechnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($hochrechnung, true)), __LINE__);
        }
        $this->Hochrechnung = $hochrechnung;
        return $this;
    }
    /**
     * Get LetzteAnpassung value
     * @return string|null
     */
    public function getLetzteAnpassung()
    {
        return $this->LetzteAnpassung;
    }
    /**
     * Set LetzteAnpassung value
     * @param string $letzteAnpassung
     * @return \BiPRO\StructType\CT_Dynamik
     */
    public function setLetzteAnpassung($letzteAnpassung = null)
    {
        // validation for constraint: string
        if (!is_null($letzteAnpassung) && !is_string($letzteAnpassung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($letzteAnpassung, true), gettype($letzteAnpassung)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($letzteAnpassung) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $letzteAnpassung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($letzteAnpassung, true)), __LINE__);
        }
        $this->LetzteAnpassung = $letzteAnpassung;
        return $this;
    }
    /**
     * Get DynamikStopp value
     * @return string|null
     */
    public function getDynamikStopp()
    {
        return $this->DynamikStopp;
    }
    /**
     * Set DynamikStopp value
     * @param string $dynamikStopp
     * @return \BiPRO\StructType\CT_Dynamik
     */
    public function setDynamikStopp($dynamikStopp = null)
    {
        // validation for constraint: string
        if (!is_null($dynamikStopp) && !is_string($dynamikStopp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dynamikStopp, true), gettype($dynamikStopp)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($dynamikStopp) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $dynamikStopp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($dynamikStopp, true)), __LINE__);
        }
        $this->DynamikStopp = $dynamikStopp;
        return $this;
    }
    /**
     * Get NaechsteAnpassung value
     * @return string|null
     */
    public function getNaechsteAnpassung()
    {
        return $this->NaechsteAnpassung;
    }
    /**
     * Set NaechsteAnpassung value
     * @param string $naechsteAnpassung
     * @return \BiPRO\StructType\CT_Dynamik
     */
    public function setNaechsteAnpassung($naechsteAnpassung = null)
    {
        // validation for constraint: string
        if (!is_null($naechsteAnpassung) && !is_string($naechsteAnpassung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naechsteAnpassung, true), gettype($naechsteAnpassung)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($naechsteAnpassung) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $naechsteAnpassung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($naechsteAnpassung, true)), __LINE__);
        }
        $this->NaechsteAnpassung = $naechsteAnpassung;
        return $this;
    }
    /**
     * Get VerbleibendeWidersprueche value
     * @return int|null
     */
    public function getVerbleibendeWidersprueche()
    {
        return $this->VerbleibendeWidersprueche;
    }
    /**
     * Set VerbleibendeWidersprueche value
     * @param int $verbleibendeWidersprueche
     * @return \BiPRO\StructType\CT_Dynamik
     */
    public function setVerbleibendeWidersprueche($verbleibendeWidersprueche = null)
    {
        // validation for constraint: int
        if (!is_null($verbleibendeWidersprueche) && !(is_int($verbleibendeWidersprueche) || ctype_digit($verbleibendeWidersprueche))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($verbleibendeWidersprueche, true), gettype($verbleibendeWidersprueche)), __LINE__);
        }
        $this->VerbleibendeWidersprueche = $verbleibendeWidersprueche;
        return $this;
    }
    /**
     * Get Zeitraum value
     * @return \BiPRO\StructType\CT_Zeitraum|null
     */
    public function getZeitraum()
    {
        return $this->Zeitraum;
    }
    /**
     * Set Zeitraum value
     * @param \BiPRO\StructType\CT_Zeitraum $zeitraum
     * @return \BiPRO\StructType\CT_Dynamik
     */
    public function setZeitraum(\BiPRO\StructType\CT_Zeitraum $zeitraum = null)
    {
        $this->Zeitraum = $zeitraum;
        return $this;
    }
    /**
     * Get Erhoehungsbetrag value
     * @return \BiPRO\StructType\CT_Geldwert|null
     */
    public function getErhoehungsbetrag()
    {
        return $this->Erhoehungsbetrag;
    }
    /**
     * Set Erhoehungsbetrag value
     * @param \BiPRO\StructType\CT_Geldwert $erhoehungsbetrag
     * @return \BiPRO\StructType\CT_Dynamik
     */
    public function setErhoehungsbetrag(\BiPRO\StructType\CT_Geldwert $erhoehungsbetrag = null)
    {
        $this->Erhoehungsbetrag = $erhoehungsbetrag;
        return $this;
    }
}
