<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Dokumentanforderung StructType
 * Meta information extracted from the WSDL
 * - documentation: Dient der Anforderung von Druckstuecken und anderen Dokumenten.
 * @subpackage Structs
 */
class CT_Dokumentanforderung extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $ArtID;
    /**
     * The DateiID
     * Meta information extracted from the WSDL
     * - documentation: Typ fuer alle IDs.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateiID;
    /**
     * The Versandart
     * Meta information extracted from the WSDL
     * - documentation: Steuert, auf welche Art das Dokument versand werden soll. Soll das Dokument von Provider im Response geliefert werden, MUSS der Wert "999" genutzt werden. Alternativ DARF in diesem Fall auch auf das Attribut Versandart verzichtet
     * werden (implizite Steuerung).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Versandart;
    /**
     * The Empfaenger
     * Meta information extracted from the WSDL
     * - documentation: ID des Partners, der referenziert werden soll | Typ fuer alle IDs.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Empfaenger;
    /**
     * The ReferenzEmpfaenger
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $ReferenzEmpfaenger;
    /**
     * The VermittleranschriftAufDokument
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $VermittleranschriftAufDokument;
    /**
     * The VermittlerSpezifischeDokumentenergaenzung
     * Meta information extracted from the WSDL
     * - documentation: Dient der Uebertragung Vermittlerspezifischer Dokumentenergaenzungen wie z.B. Barcodes, Portraits oder Firmenlogos, die in das angeforderte Druckstueck integriert werden sollen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Datei[]
     */
    public $VermittlerSpezifischeDokumentenergaenzung;
    /**
     * The Sprache
     * Meta information extracted from the WSDL
     * - documentation: Angabe in welcher Sprache/Sprachen das angeforderte Dokument geliefert werden soll (z.B. Haftpflichtversicherungsbestätgung in englisch (eng) und deutsch (deu)). | Ausprägungen MÜSSEN ISO639-3 entsprechend.
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: unbounded
     * - minLength: 3
     * - minOccurs: 0
     * @var string[]
     */
    public $Sprache;
    /**
     * Constructor method for CT_Dokumentanforderung
     * @uses CT_Dokumentanforderung::setArtID()
     * @uses CT_Dokumentanforderung::setDateiID()
     * @uses CT_Dokumentanforderung::setVersandart()
     * @uses CT_Dokumentanforderung::setEmpfaenger()
     * @uses CT_Dokumentanforderung::setReferenzEmpfaenger()
     * @uses CT_Dokumentanforderung::setVermittleranschriftAufDokument()
     * @uses CT_Dokumentanforderung::setVermittlerSpezifischeDokumentenergaenzung()
     * @uses CT_Dokumentanforderung::setSprache()
     * @param string[] $artID
     * @param string $dateiID
     * @param string $versandart
     * @param string $empfaenger
     * @param string $referenzEmpfaenger
     * @param bool $vermittleranschriftAufDokument
     * @param \BiPRO\StructType\CT_Datei[] $vermittlerSpezifischeDokumentenergaenzung
     * @param string[] $sprache
     */
    public function __construct(array $artID = array(), $dateiID = null, $versandart = null, $empfaenger = null, $referenzEmpfaenger = null, $vermittleranschriftAufDokument = null, array $vermittlerSpezifischeDokumentenergaenzung = array(), array $sprache = array())
    {
        $this
            ->setArtID($artID)
            ->setDateiID($dateiID)
            ->setVersandart($versandart)
            ->setEmpfaenger($empfaenger)
            ->setReferenzEmpfaenger($referenzEmpfaenger)
            ->setVermittleranschriftAufDokument($vermittleranschriftAufDokument)
            ->setVermittlerSpezifischeDokumentenergaenzung($vermittlerSpezifischeDokumentenergaenzung)
            ->setSprache($sprache);
    }
    /**
     * Get ArtID value
     * @return string[]
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * This method is responsible for validating the values passed to the setArtID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArtID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateArtIDForArrayConstraintsFromSetArtID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_DokumentanforderungArtIDItem) {
            // validation for constraint: enumeration
            if (!\BiPRO\EnumType\ST_DokumentartID::valueIsValid($cT_DokumentanforderungArtIDItem)) {
                $invalidValues[] = is_object($cT_DokumentanforderungArtIDItem) ? get_class($cT_DokumentanforderungArtIDItem) : sprintf('%s(%s)', gettype($cT_DokumentanforderungArtIDItem), var_export($cT_DokumentanforderungArtIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_DokumentartID', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \BiPRO\EnumType\ST_DokumentartID::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_DokumentartID::valueIsValid()
     * @uses \BiPRO\EnumType\ST_DokumentartID::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $artID
     * @return \BiPRO\StructType\CT_Dokumentanforderung
     */
    public function setArtID(array $artID = array())
    {
        // validation for constraint: array
        if ('' !== ($artIDArrayErrorMessage = self::validateArtIDForArrayConstraintsFromSetArtID($artID))) {
            throw new \InvalidArgumentException($artIDArrayErrorMessage, __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Add item to ArtID value
     * @uses \BiPRO\EnumType\ST_DokumentartID::valueIsValid()
     * @uses \BiPRO\EnumType\ST_DokumentartID::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_Dokumentanforderung
     */
    public function addToArtID($item)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_DokumentartID::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_DokumentartID', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \BiPRO\EnumType\ST_DokumentartID::getValidValues())), __LINE__);
        }
        $this->ArtID[] = $item;
        return $this;
    }
    /**
     * Get DateiID value
     * @return string|null
     */
    public function getDateiID()
    {
        return $this->DateiID;
    }
    /**
     * Set DateiID value
     * @param string $dateiID
     * @return \BiPRO\StructType\CT_Dokumentanforderung
     */
    public function setDateiID($dateiID = null)
    {
        // validation for constraint: string
        if (!is_null($dateiID) && !is_string($dateiID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateiID, true), gettype($dateiID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($dateiID) && mb_strlen($dateiID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($dateiID)), __LINE__);
        }
        $this->DateiID = $dateiID;
        return $this;
    }
    /**
     * Get Versandart value
     * @return string|null
     */
    public function getVersandart()
    {
        return $this->Versandart;
    }
    /**
     * Set Versandart value
     * @uses \BiPRO\EnumType\ST_Versandart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Versandart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $versandart
     * @return \BiPRO\StructType\CT_Dokumentanforderung
     */
    public function setVersandart($versandart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Versandart::valueIsValid($versandart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Versandart', is_array($versandart) ? implode(', ', $versandart) : var_export($versandart, true), implode(', ', \BiPRO\EnumType\ST_Versandart::getValidValues())), __LINE__);
        }
        $this->Versandart = $versandart;
        return $this;
    }
    /**
     * Get Empfaenger value
     * @return string|null
     */
    public function getEmpfaenger()
    {
        return $this->Empfaenger;
    }
    /**
     * Set Empfaenger value
     * @param string $empfaenger
     * @return \BiPRO\StructType\CT_Dokumentanforderung
     */
    public function setEmpfaenger($empfaenger = null)
    {
        // validation for constraint: string
        if (!is_null($empfaenger) && !is_string($empfaenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($empfaenger, true), gettype($empfaenger)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($empfaenger) && mb_strlen($empfaenger) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($empfaenger)), __LINE__);
        }
        $this->Empfaenger = $empfaenger;
        return $this;
    }
    /**
     * Get ReferenzEmpfaenger value
     * @return string|null
     */
    public function getReferenzEmpfaenger()
    {
        return $this->ReferenzEmpfaenger;
    }
    /**
     * Set ReferenzEmpfaenger value
     * @param string $referenzEmpfaenger
     * @return \BiPRO\StructType\CT_Dokumentanforderung
     */
    public function setReferenzEmpfaenger($referenzEmpfaenger = null)
    {
        // validation for constraint: string
        if (!is_null($referenzEmpfaenger) && !is_string($referenzEmpfaenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenzEmpfaenger, true), gettype($referenzEmpfaenger)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($referenzEmpfaenger) && mb_strlen($referenzEmpfaenger) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($referenzEmpfaenger)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($referenzEmpfaenger) && mb_strlen($referenzEmpfaenger) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($referenzEmpfaenger)), __LINE__);
        }
        $this->ReferenzEmpfaenger = $referenzEmpfaenger;
        return $this;
    }
    /**
     * Get VermittleranschriftAufDokument value
     * @return bool|null
     */
    public function getVermittleranschriftAufDokument()
    {
        return $this->VermittleranschriftAufDokument;
    }
    /**
     * Set VermittleranschriftAufDokument value
     * @param bool $vermittleranschriftAufDokument
     * @return \BiPRO\StructType\CT_Dokumentanforderung
     */
    public function setVermittleranschriftAufDokument($vermittleranschriftAufDokument = null)
    {
        // validation for constraint: boolean
        if (!is_null($vermittleranschriftAufDokument) && !is_bool($vermittleranschriftAufDokument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vermittleranschriftAufDokument, true), gettype($vermittleranschriftAufDokument)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($vermittleranschriftAufDokument) && !preg_match('/true|false/', $vermittleranschriftAufDokument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($vermittleranschriftAufDokument, true)), __LINE__);
        }
        $this->VermittleranschriftAufDokument = $vermittleranschriftAufDokument;
        return $this;
    }
    /**
     * Get VermittlerSpezifischeDokumentenergaenzung value
     * @return \BiPRO\StructType\CT_Datei[]|null
     */
    public function getVermittlerSpezifischeDokumentenergaenzung()
    {
        return $this->VermittlerSpezifischeDokumentenergaenzung;
    }
    /**
     * This method is responsible for validating the values passed to the setVermittlerSpezifischeDokumentenergaenzung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVermittlerSpezifischeDokumentenergaenzung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVermittlerSpezifischeDokumentenergaenzungForArrayConstraintsFromSetVermittlerSpezifischeDokumentenergaenzung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_DokumentanforderungVermittlerSpezifischeDokumentenergaenzungItem) {
            // validation for constraint: itemType
            if (!$cT_DokumentanforderungVermittlerSpezifischeDokumentenergaenzungItem instanceof \BiPRO\StructType\CT_Datei) {
                $invalidValues[] = is_object($cT_DokumentanforderungVermittlerSpezifischeDokumentenergaenzungItem) ? get_class($cT_DokumentanforderungVermittlerSpezifischeDokumentenergaenzungItem) : sprintf('%s(%s)', gettype($cT_DokumentanforderungVermittlerSpezifischeDokumentenergaenzungItem), var_export($cT_DokumentanforderungVermittlerSpezifischeDokumentenergaenzungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VermittlerSpezifischeDokumentenergaenzung property can only contain items of type \BiPRO\StructType\CT_Datei, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VermittlerSpezifischeDokumentenergaenzung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Datei[] $vermittlerSpezifischeDokumentenergaenzung
     * @return \BiPRO\StructType\CT_Dokumentanforderung
     */
    public function setVermittlerSpezifischeDokumentenergaenzung(array $vermittlerSpezifischeDokumentenergaenzung = array())
    {
        // validation for constraint: array
        if ('' !== ($vermittlerSpezifischeDokumentenergaenzungArrayErrorMessage = self::validateVermittlerSpezifischeDokumentenergaenzungForArrayConstraintsFromSetVermittlerSpezifischeDokumentenergaenzung($vermittlerSpezifischeDokumentenergaenzung))) {
            throw new \InvalidArgumentException($vermittlerSpezifischeDokumentenergaenzungArrayErrorMessage, __LINE__);
        }
        $this->VermittlerSpezifischeDokumentenergaenzung = $vermittlerSpezifischeDokumentenergaenzung;
        return $this;
    }
    /**
     * Add item to VermittlerSpezifischeDokumentenergaenzung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Datei $item
     * @return \BiPRO\StructType\CT_Dokumentanforderung
     */
    public function addToVermittlerSpezifischeDokumentenergaenzung(\BiPRO\StructType\CT_Datei $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Datei) {
            throw new \InvalidArgumentException(sprintf('The VermittlerSpezifischeDokumentenergaenzung property can only contain items of type \BiPRO\StructType\CT_Datei, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VermittlerSpezifischeDokumentenergaenzung[] = $item;
        return $this;
    }
    /**
     * Get Sprache value
     * @return string[]|null
     */
    public function getSprache()
    {
        return $this->Sprache;
    }
    /**
     * This method is responsible for validating the values passed to the setSprache method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSprache method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpracheForArrayConstraintsFromSetSprache(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_DokumentanforderungSpracheItem) {
            // validation for constraint: itemType
            if (!is_string($cT_DokumentanforderungSpracheItem)) {
                $invalidValues[] = is_object($cT_DokumentanforderungSpracheItem) ? get_class($cT_DokumentanforderungSpracheItem) : sprintf('%s(%s)', gettype($cT_DokumentanforderungSpracheItem), var_export($cT_DokumentanforderungSpracheItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Sprache property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setSprache method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSprache method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpracheForMaxLengthConstraintFromSetSprache($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_DokumentanforderungSpracheItem) {
            // validation for constraint: maxLength(3)
            if (mb_strlen($cT_DokumentanforderungSpracheItem) > 3) {
                $invalidValues[] = var_export($cT_DokumentanforderungSpracheItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 3', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setSprache method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSprache method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpracheForMinLengthConstraintFromSetSprache($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_DokumentanforderungSpracheItem) {
            // validation for constraint: minLength(3)
            if (mb_strlen($cT_DokumentanforderungSpracheItem) < 3) {
                $invalidValues[] = var_export($cT_DokumentanforderungSpracheItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 3', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Sprache value
     * @throws \InvalidArgumentException
     * @param string[] $sprache
     * @return \BiPRO\StructType\CT_Dokumentanforderung
     */
    public function setSprache(array $sprache = array())
    {
        // validation for constraint: array
        if ('' !== ($spracheArrayErrorMessage = self::validateSpracheForArrayConstraintsFromSetSprache($sprache))) {
            throw new \InvalidArgumentException($spracheArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(3)
        if ('' !== ($spracheMaxLengthErrorMessage = self::validateSpracheForMaxLengthConstraintFromSetSprache($sprache))) {
            throw new \InvalidArgumentException($spracheMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: minLength(3)
        if ('' !== ($spracheMinLengthErrorMessage = self::validateSpracheForMinLengthConstraintFromSetSprache($sprache))) {
            throw new \InvalidArgumentException($spracheMinLengthErrorMessage, __LINE__);
        }
        $this->Sprache = $sprache;
        return $this;
    }
    /**
     * Add item to Sprache value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_Dokumentanforderung
     */
    public function addToSprache($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Sprache property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (mb_strlen($item) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (mb_strlen($item) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($item)), __LINE__);
        }
        $this->Sprache[] = $item;
        return $this;
    }
}
